/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.windowmanagement;

import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.mdi.ExtendedWindow;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;

public class ExtendWindow
extends ExtendedWindow {
    private ConcurrentHashMap statusMap = null;

    public ExtendWindow() {
    }

    public ExtendWindow(String string) {
        this();
        super.setTitle(string);
    }

    public void refreshStatus(String string, String string2) {
        if (string != null && string2 != null) {
            if (this.statusMap == null) {
                this.statusMap = new ConcurrentHashMap(4);
            }
            this.statusMap.put(string, string2);
            if (super.isActivated()) {
                StatusBarManager statusBarManager = FrameworkUtilities.getStatusBarManager();
                statusBarManager.refreshItem(string, string2);
            }
        }
    }

    private void displayAllStatus() {
        final ToolbarManager toolbarManager = FrameworkUtilities.getToolbarManager();
        if (SwingUtilities.isEventDispatchThread()) {
            toolbarManager.updateToolbars();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    toolbarManager.updateToolbars();
                }
            });
        }
        if (this.statusMap != null) {
            StatusBarManager statusBarManager = FrameworkUtilities.getStatusBarManager();
            for (Map.Entry entry : this.statusMap.entrySet()) {
                statusBarManager.refreshItem((String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private void clearAllStatus() {
        if (this.statusMap != null) {
            StatusBarManager statusBarManager = FrameworkUtilities.getStatusBarManager();
            for (Map.Entry entry : this.statusMap.entrySet()) {
                statusBarManager.refreshItem((String)entry.getKey(), "");
            }
        }
    }

    @Override
    public void windowActivated() {
        super.windowActivated();
        this.displayAllStatus();
    }

    @Override
    public void windowDeactivated() {
        super.windowDeactivated();
        this.clearAllStatus();
    }

    @Override
    public void windowClosed() {
        if (this.statusMap != null) {
            this.statusMap.clear();
            this.statusMap = null;
        }
    }
}

