/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util.serializer;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.ReflectionUtilities;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.startup.StartupClassLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ConfigFileReader {
    private static String configpath = System.getProperty("SerialConfigPath");
    private static final int CONST = 10;
    private static final String LANGUAGE = "language";
    private static final String EN_PATH = "style/defaultstyle/locale/en_US/";
    private static final String ZH_PATH = "style/defaultstyle/locale/zh_CN/";

    public static boolean readSerializeConfig() {
        DebugTracer.trace("Read SerializeConfig started.");
        LinkedHashMap<String, ArrayList<String>> linkedHashMap = ConfigFileReader.readFile(configpath);
        if (null == linkedHashMap) {
            DebugTracer.trace("Config Serialization file is not present or not able to read." + configpath);
            return false;
        }
        ConfigFileReader.initializePlugin();
        ConfigFileReader.executeSerializeMethod(linkedHashMap);
        DebugTracer.trace("Read SerializeConfig finished.");
        return true;
    }

    private static void initializePlugin() {
        StartupClassLoader startupClassLoader = StartupClassLoader.getInstance();
        if (null == startupClassLoader) {
            startupClassLoader = new StartupClassLoader(ConfigFileReader.class.getClassLoader());
        }
        Thread.currentThread().setContextClassLoader((ClassLoader)startupClassLoader);
        Main.loadSubsystemManager();
        PluginManager.getInstance();
    }

    private static void executeSerializeMethod(LinkedHashMap<String, ArrayList<String>> linkedHashMap) {
        DebugTracer.trace("Executing the serialized API's started.");
        Set<Map.Entry<String, ArrayList<String>>> set = linkedHashMap.entrySet();
        int n = 0;
        String string = null;
        ArrayList<String> arrayList = null;
        boolean bl = false;
        for (Map.Entry<String, ArrayList<String>> entry : set) {
            int n2;
            CommStyleManager commStyleManager;
            string = entry.getKey();
            arrayList = entry.getValue();
            if ("ConfigFile.iview".equals(string)) continue;
            if ("DirFileList.iview".equals(string)) {
                DebugTracer.trace("Executing DirFileList.iview started.");
                commStyleManager = CommStyleManager.getInstance();
                n = arrayList.size();
                for (n2 = 0; n2 < n; ++n2) {
                    commStyleManager.getAllFilesFromAllDirectory(arrayList.get(n2));
                }
                DebugTracer.trace("Executing DirFileList.iview finished.");
                continue;
            }
            if ("PathFileList.iview".equals(string)) {
                DebugTracer.trace("Executing PathFileList.iview started.");
                commStyleManager = CommStyleManager.getInstance();
                n = arrayList.size();
                for (n2 = 0; n2 < n; ++n2) {
                    commStyleManager.getAllFilesFromAllPaths(arrayList.get(n2));
                }
                DebugTracer.trace("Executing PathFileList.iview finished.");
                continue;
            }
            if ("ResourceFile.iview".equals(string)) {
                bl = true;
                DebugTracer.trace("Executing ResourceFile.iview started.");
                ConfigFileReader.executeResource(arrayList);
                DebugTracer.trace("Executing ResourceFile.iview finished.");
                continue;
            }
            if ("IconFile.iview".equals(string)) {
                bl = true;
                DebugTracer.trace("Executing IconFile.iview started.");
                ConfigFileReader.executeIcon(arrayList);
                DebugTracer.trace("Executing IconFile.iview finished.");
                continue;
            }
            if ("plugin.IconFile.iview".equals(string)) {
                bl = true;
                ConfigFileReader.executePluginIcon(arrayList);
                continue;
            }
            if (!"plugin.ResourceFile.iview".equals(string)) continue;
            bl = true;
            ConfigFileReader.executePluginResource(arrayList);
        }
        SerializationHandler.getInstance().writeSerializedData();
        ConfigFileReader.clearResetLocale(ResourceMng.getInstance());
        if (bl) {
            ConfigFileReader.executeResource(linkedHashMap.get("ResourceFile.iview"));
            ConfigFileReader.executeIcon(linkedHashMap.get("IconFile.iview"));
            ResourceMng.getInstance().writeSerializedResource(System.getProperty("serFolder", "Default"));
            ConfigFileReader.executePluginIcon(linkedHashMap.get("plugin.IconFile.iview"));
            ConfigFileReader.executePluginResource(linkedHashMap.get("plugin.ResourceFile.iview"));
            PluginSerializationHandler.writeSerializedResource(System.getProperty("serFolder", "Default"));
        }
        DebugTracer.trace("Executing the serialized API's finished.");
    }

    private static void executePluginResource(ArrayList<String> arrayList) {
        DebugTracer.trace("Executing plugin.ResourceFile.iview started.");
        if (arrayList != null) {
            PluginManager pluginManager = PluginManager.getInstance();
            int n = arrayList.size();
            String string = null;
            String[] stringArray = null;
            Plugin plugin = null;
            for (int i = 0; i < n; ++i) {
                string = arrayList.get(i);
                stringArray = string.split(":");
                plugin = pluginManager.getPluginFromFolder(stringArray[0]);
                if (null == plugin) continue;
                plugin.getResource().getResourceBundleFromPropertyFile(string.replaceFirst(stringArray[0] + ':', ""));
            }
        }
        DebugTracer.trace("Executing plugin.ResourceFile.iview finished.");
    }

    private static void executePluginIcon(ArrayList<String> arrayList) {
        if (null != arrayList) {
            DebugTracer.trace("Executing plugin.IconFile.iview started.");
            PluginManager pluginManager = PluginManager.getInstance();
            int n = arrayList.size();
            String string = null;
            String[] stringArray = null;
            Plugin plugin = null;
            for (int i = 0; i < n; ++i) {
                string = arrayList.get(i);
                stringArray = string.split(":");
                plugin = pluginManager.getPluginFromFolder(stringArray[0]);
                if (null == plugin) continue;
                plugin.getResource().getIcon(string.replaceFirst(stringArray[0] + ':', ""));
            }
            DebugTracer.trace("Executing plugin.IconFile.iview finished.");
        }
    }

    private static void executeIcon(ArrayList<String> arrayList) {
        if (null != arrayList) {
            ResourceMng resourceMng = ResourceMng.getInstance();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                resourceMng.getURLFromProOrDefault(arrayList.get(i));
            }
        }
    }

    private static void executeResource(ArrayList<String> arrayList) {
        if (null != arrayList) {
            ResourceMng resourceMng = ResourceMng.getInstance();
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                resourceMng.getResourceBundleFromPropertyFile(arrayList.get(i));
            }
        }
    }

    private static void clearResetLocale(ResourceMng resourceMng) {
        HashMap hashMap = (HashMap)ReflectionUtilities.getFieldByObject(resourceMng, "defaultResBundles");
        if (null != hashMap) {
            hashMap.clear();
        }
        if (null != (hashMap = (HashMap)ReflectionUtilities.getFieldByObject(resourceMng, "iconPathMap"))) {
            hashMap.clear();
        }
        String string = (String)ReflectionUtilities.getFieldByObject(resourceMng, LANGUAGE);
        String string2 = (String)ReflectionUtilities.getFieldByObject(resourceMng, "country");
        if ("en".equals(string) && "US".equals(string2)) {
            ReflectionUtilities.setFieldByObject(resourceMng, LANGUAGE, "zh");
            ReflectionUtilities.setFieldByObject(resourceMng, "country", "CN");
            ReflectionUtilities.setFieldByObject(resourceMng, "RESOURCE_DIR", ZH_PATH);
        } else if ("zh".equals(string) && "CN".equals(string2)) {
            ReflectionUtilities.setFieldByObject(resourceMng, LANGUAGE, "en");
            ReflectionUtilities.setFieldByObject(resourceMng, "country", "US");
            ReflectionUtilities.setFieldByObject(resourceMng, "RESOURCE_DIR", EN_PATH);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static LinkedHashMap<String, ArrayList<String>> readFile(String string) {
        LinkedHashMap linkedHashMap = null;
        File file = CommonUtil.getAbsoluteFile(string);
        if (file.exists()) {
            FileReader fileReader = null;
            BufferedReader bufferedReader = null;
            try {
                fileReader = new FileReader(file);
                bufferedReader = new BufferedReader(fileReader);
                String string2 = bufferedReader.readLine();
                linkedHashMap = new LinkedHashMap();
                ArrayList<String> arrayList = null;
                int n = 0;
                int n2 = 0;
                while (null != string2) {
                    string2 = string2.trim();
                    n = string2.length();
                    n2 = string2.indexOf("=");
                    if (n > 1 && n2 > 0) {
                        String string3 = string2.substring(0, n2);
                        String string4 = string2.substring(n2 + 1);
                        ArrayList arrayList2 = (ArrayList)linkedHashMap.get(string3);
                        if (null == arrayList2) {
                            arrayList = new ArrayList<String>(10);
                            arrayList.add(string4);
                            linkedHashMap.put(string3, arrayList);
                        } else if (string4.length() > 0) {
                            arrayList2.add(string4);
                        }
                    }
                    string2 = bufferedReader.readLine();
                }
            }
            catch (IOException iOException) {
                DebugTracer.trace("Exception while reading the " + string + ". : " + iOException);
            }
            finally {
                if (null != bufferedReader) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        DebugTracer.trace("Exception while Closing the Stream of BufferedReader");
                    }
                }
                if (null != fileReader) {
                    try {
                        fileReader.close();
                    }
                    catch (IOException iOException) {
                        DebugTracer.trace("Exception while Closing the Stream of Reader");
                    }
                }
            }
        }
        return linkedHashMap;
    }
}

