/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util.groupexec;

import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.modulemanagement.PreemtedException;
import com.swimap.iview.framework.util.groupexec.GroupMember;
import com.swimap.iview.util.log.IviewLogger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ThreadPoolExecutor;

public class GroupMemberExecuter {
    private static IviewLogger logger = IviewLogger.getLogger(GroupMemberExecuter.class, "IVIEW");
    Set<GroupMember> groupMembers = new HashSet<GroupMember>();
    volatile int needExecuteCount = -1;
    private ThreadPoolExecutor tpe = null;
    private String appId = "";

    public GroupMemberExecuter(ThreadPoolExecutor threadPoolExecutor) {
        if (threadPoolExecutor == null) {
            throw new IllegalArgumentException();
        }
        this.tpe = threadPoolExecutor;
    }

    public GroupMemberExecuter(ThreadPoolExecutor threadPoolExecutor, String string) {
        this(threadPoolExecutor);
        this.appId = string;
    }

    public void addGroupMember(GroupMember groupMember) {
        this.groupMembers.add(groupMember);
    }

    public void executeGroupMember(GroupMember groupMember) {
        if (!(this.tpe.isShutdown() || this.tpe.isTerminating() || this.tpe.isTerminated())) {
            this.tpe.execute(groupMember);
        }
    }

    public synchronized void execute() throws Exception {
        Iterator<GroupMember> iterator = this.groupMembers.iterator();
        this.needExecuteCount = this.groupMembers.size();
        logger.debug("total members in executor:" + this.needExecuteCount);
        boolean bl = true;
        if (!this.appId.equals("")) {
            bl = ModuleManager.getAppFailedMap().get(this.appId);
        }
        while (ModuleManager.callBackFlag && bl) {
            if (iterator.hasNext()) {
                iterator.next().execute();
                continue;
            }
            if (this.breakCondition()) {
                logger.trace("All group members are finished!!!");
                break;
            }
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
        }
        if (!ModuleManager.callBackFlag) {
            throw new PreemtedException("Logout Directly is called in LoadThread");
        }
    }

    public synchronized void oneGroupMemberFinished(GroupMember groupMember) {
        --this.needExecuteCount;
        logger.debug("GroupMember is finished: and current count:" + this.needExecuteCount);
        if (this.breakCondition()) {
            this.notifyAll();
        }
    }

    private boolean breakCondition() {
        return this.needExecuteCount == 0;
    }

    public String getAppId() {
        return this.appId;
    }
}

