/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util.groupexec;

import com.swimap.iview.framework.util.groupexec.GroupMemberExecuter;
import com.swimap.iview.framework.util.groupexec.GroupTask;
import java.util.HashSet;
import java.util.Set;

public class GroupMember
extends Thread {
    private GroupTask groupTask = null;
    private State state = State.NEW;
    private Object EXECUTE_LOCK = new Object();
    private GroupMemberExecuter gme = null;
    private Set<GroupMember> dependsOnMembers = new HashSet<GroupMember>();
    private Set<GroupMember> dependentMembers = new HashSet<GroupMember>();

    public GroupMember(GroupTask groupTask, GroupMemberExecuter groupMemberExecuter) {
        this.groupTask = groupTask;
        this.gme = groupMemberExecuter;
        groupMemberExecuter.addGroupMember(this);
    }

    public boolean dependsOn(GroupMember groupMember) {
        boolean bl = this.isTargetDependOnSource(this, groupMember);
        if (bl || this == groupMember) {
            return false;
        }
        this.dependsOnMembers.add(groupMember);
        groupMember.addDependent(this);
        return true;
    }

    public boolean isTargetDependOnSource(GroupMember groupMember, GroupMember groupMember2) {
        Set<GroupMember> set = groupMember2.getDependence();
        if (null == set) {
            return false;
        }
        for (GroupMember groupMember3 : set) {
            if (groupMember == groupMember3) {
                return true;
            }
            boolean bl = this.isTargetDependOnSource(groupMember, groupMember3);
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void addDependent(GroupMember groupMember) {
        this.dependentMembers.add(groupMember);
    }

    private synchronized void removeDependsOn(GroupMember groupMember) {
        this.dependsOnMembers.remove(groupMember);
    }

    public Set<GroupMember> getDependence() {
        return this.dependsOnMembers;
    }

    public Set<GroupMember> getInvertedDependence() {
        return this.dependentMembers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String string = Thread.currentThread().getName();
        try {
            Thread.currentThread().setName(this.groupTask.getPrefix());
            this.groupTask.execute();
            if (!this.dependentMembers.isEmpty()) {
                this.notifyDependents();
            }
            this.gme.oneGroupMemberFinished(this);
        }
        finally {
            Thread.currentThread().setName(string);
        }
    }

    private void notifyDependents() {
        for (GroupMember groupMember : this.dependentMembers) {
            groupMember.removeDependsOn(this);
            groupMember.execute();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        if (this.dependsOnMembers.isEmpty()) {
            Object object = this.EXECUTE_LOCK;
            synchronized (object) {
                if (this.state.equals((Object)State.NEW)) {
                    this.state = State.DONE;
                    this.gme.executeGroupMember(this);
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.groupTask.toString();
    }

    public static enum State {
        NEW,
        DONE;

    }
}

