/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTException;
import java.awt.Image;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;

public class TrayUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(TrayUtilities.class, "IVIEW");
    private static TrayIcon trayIcon = null;
    private static boolean isTrayIconAdded = false;
    private static boolean listenToFrameTitle = true;
    private static final String TITLE_PROPERTY = "title";
    private static final PropertyChangeListener frameTitleChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            String string2;
            if (Boolean.getBoolean("enabletrayicon") && TrayUtilities.TITLE_PROPERTY.equals(propertyChangeEvent.getPropertyName()) && !ResourceUtil.areEquals(string2 = (String)propertyChangeEvent.getNewValue(), string = (String)propertyChangeEvent.getOldValue())) {
                TrayUtilities.setTrayTooltip(string2);
            }
        }
    };

    private static void showSystemTrayIcon(Image image, String string) {
        if (SystemTray.isSupported()) {
            if (null == trayIcon) {
                TrayUtilities.initTrayIcon(image, string);
            }
            SystemTray systemTray = SystemTray.getSystemTray();
            try {
                if (!isTrayIconAdded) {
                    systemTray.add(trayIcon);
                    isTrayIconAdded = true;
                }
            }
            catch (AWTException aWTException) {
                logger.trace("TrayIcon could not be added.", aWTException);
            }
        } else {
            logger.trace("System Tray is not supported by the System, it couldnot be added");
        }
    }

    private static void initTrayIcon(Image image, String string) {
        trayIcon = new TrayIcon(image, string, null);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TerminalManager terminalManager = FrameworkUtilities.getTerminalManager();
                if (null == terminalManager) {
                    return;
                }
                if (terminalManager.isLockOrUnLockDialogshown()) {
                    logger.trace("showing lock/unlock dialog");
                    FrameworkUtilities.getMainFrame().setState(0);
                    FrameworkUtilities.getMainFrame().getPeer().setVisible(true);
                    FrameworkUtilities.getMainFrame().toFront();
                    return;
                }
                if (ScreenToolKit.getFullScreenFlg()) {
                    logger.trace("showing fullscreen frame");
                    terminalManager.showOwnedVisibleWindows(ScreenToolKit.getFullFrame());
                } else {
                    logger.trace("showing main frame");
                    terminalManager.showOwnedVisibleWindows(FrameworkUtilities.getMainFrame());
                }
            }
        };
        trayIcon.setImageAutoSize(true);
        trayIcon.addActionListener(actionListener);
    }

    public static void setTrayIcon(Image image) {
        if (null == image) {
            throw new IllegalArgumentException("Null image");
        }
        if (null == trayIcon) {
            TrayUtilities.initTrayIcon(image, null);
        }
        if (null != trayIcon) {
            trayIcon.setImage(image);
        }
    }

    public static void setTrayTooltip(String string) {
        ImageIcon imageIcon;
        if (null == trayIcon && null != (imageIcon = (ImageIcon)ResourceAdapter.getAboutIcon())) {
            TrayUtilities.initTrayIcon(imageIcon.getImage(), string);
        }
        if (null != trayIcon) {
            trayIcon.setToolTip(string);
        }
    }

    public static void showTrayIcon() {
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        if ((null == jFrame || null != trayIcon) && isTrayIconAdded) {
            return;
        }
        if (Boolean.getBoolean("enabletrayicon") && null != jFrame) {
            TrayUtilities.listenToFrameTitleChange(listenToFrameTitle);
            Image image = jFrame.getIconImage();
            if (null == image) {
                URL uRL = TrayUtilities.class.getResource("/javax/swing/plaf/basic/icons/JavaCup16.png");
                if (null == uRL) {
                    return;
                }
                image = new ImageIcon(uRL).getImage();
            }
            TrayUtilities.showSystemTrayIcon(image, jFrame.getTitle());
        }
    }

    public static void remove() {
        if (SystemTray.isSupported() && isTrayIconAdded) {
            SystemTray systemTray = SystemTray.getSystemTray();
            systemTray.remove(trayIcon);
            trayIcon = null;
            isTrayIconAdded = false;
        }
    }

    public static void listenToFrameTitleChange(boolean bl) {
        listenToFrameTitle = bl;
        JFrame jFrame = FrameworkUtilities.getMainFrame();
        if (!listenToFrameTitle) {
            jFrame.removePropertyChangeListener(TITLE_PROPERTY, frameTitleChangeListener);
        } else if (0 == jFrame.getPropertyChangeListeners(TITLE_PROPERTY).length) {
            jFrame.addPropertyChangeListener(TITLE_PROPERTY, frameTitleChangeListener);
        }
    }
}

