/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.util.DefaultLinkStrategy;
import com.swimap.iview.framework.util.ILinkStrategy;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StartupFactory {
    private static IviewLogger logger = IviewLogger.getLogger(StartupFactory.class, "IVIEW");
    private static final String PRODUCTLIB_FOLDER = File.separator + "productlib";
    private static final String PLUGIN_FOLDER = File.separator + "plugins";
    private static List<IStartupElement> allPluginElementList = new ArrayList<IStartupElement>();
    private static List<IStartupElement> allLinkElementList = new ArrayList<IStartupElement>();
    private static ILinkStrategy linkStrategyClass = null;
    private static final Object LOCKPLUGIN = new Object();
    private static final Object LOCKLINK = new Object();
    private static final Object LOCKSTARTUPELEMENTS = new Object();
    private static final Object LOCKCLASSSTARTUPELEMENTS = new Object();
    private static List<IStartupElement> pluginElementList = null;
    private static List<IStartupElement> linkClassLoadingElements = null;
    private static List<IStartupElement> linkElementList = null;
    private static List<String> linkNames = null;
    private static List<IStartupElement> linkBasicElemList = null;

    private static ILinkStrategy getStartupStrategy() {
        String string = System.getProperty("linkstrategy");
        if (null == string || 0 == string.length()) {
            linkStrategyClass = new DefaultLinkStrategy();
        } else {
            try {
                Class<?> clazz = Class.forName(string);
                logger.trace(" Begin invoke className " + string);
                linkStrategyClass = (ILinkStrategy)clazz.newInstance();
            }
            catch (Throwable throwable) {
                logger.trace(throwable.getMessage());
                logger.trace("Loading of StartupStrategy is failed in StartupStrategyFactory class.Hence DefaultLinkStrategy is loaded ");
                linkStrategyClass = new DefaultLinkStrategy();
            }
        }
        return linkStrategyClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IStartupElement> getStartupElements(int n) {
        List<IStartupElement> list = null;
        Object object = LOCKSTARTUPELEMENTS;
        synchronized (object) {
            if (null == linkStrategyClass) {
                linkStrategyClass = StartupFactory.getStartupStrategy();
                list = linkStrategyClass.getStartupElements();
                if (list == null || list.size() == 0) {
                    return null;
                }
                if (linkNames == null) {
                    linkNames = new ArrayList<String>(10);
                }
                if (null == pluginElementList) {
                    pluginElementList = StartupFactory.getElementsType(1, list);
                }
                if (null == linkElementList) {
                    linkElementList = StartupFactory.getElementsType(3, list);
                }
                if (null == linkBasicElemList) {
                    linkBasicElemList = StartupFactory.getElementsType(4, list);
                }
            }
        }
        if (n == 1) {
            return pluginElementList;
        }
        if (n == 3) {
            return linkElementList;
        }
        if (n == 4) {
            return linkBasicElemList;
        }
        return null;
    }

    private static List<IStartupElement> getElementsType(int n, List<IStartupElement> list) {
        ArrayList<IStartupElement> arrayList = new ArrayList<IStartupElement>();
        StringBuilder stringBuilder = new StringBuilder(50);
        for (IStartupElement iStartupElement : list) {
            if (n == iStartupElement.getType()) {
                if (n == 3) {
                    linkNames.add(iStartupElement.getName());
                } else if (n == 4 && linkNames.contains(iStartupElement.getName())) continue;
                arrayList.add(iStartupElement);
                stringBuilder.append(iStartupElement.getName()).append(":").append(iStartupElement.getType()).append(",");
                continue;
            }
            if (n != 3 || iStartupElement.getType() != 4) continue;
            arrayList.add(iStartupElement);
            stringBuilder.append(iStartupElement.getName()).append(":").append(iStartupElement.getType()).append(",");
        }
        logger.trace("Invoke StartupFactory class:StartupElement List of type" + n + ": " + stringBuilder.toString());
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IStartupElement> getAllStartupElements(int n) {
        if (n == 1) {
            Object object = LOCKPLUGIN;
            synchronized (object) {
                if (allPluginElementList.size() == 0) {
                    StartupFactory.populateElementList(n, allPluginElementList);
                }
            }
            return allPluginElementList;
        }
        if (n == 3) {
            Object object = LOCKLINK;
            synchronized (object) {
                if (allLinkElementList.size() == 0) {
                    StartupFactory.populateElementList(n, allLinkElementList);
                }
            }
            return allLinkElementList;
        }
        return null;
    }

    private static void populateElementList(int n, List<IStartupElement> list) {
        String string = null;
        if (n == 1) {
            string = PLUGIN_FOLDER;
        } else if (n == 3) {
            string = PRODUCTLIB_FOLDER;
        }
        File file = new File(PluginUtil.getUserDir(), string);
        if (file.exists()) {
            File[] fileArray;
            for (File file2 : fileArray = file.listFiles()) {
                StartupElement startupElement;
                String string2 = file2.getName();
                if (file2.isDirectory()) {
                    startupElement = new StartupElement(string2, n);
                    list.add(startupElement);
                    continue;
                }
                if (!string2.endsWith(".jar")) continue;
                string2 = string2.substring(0, string2.indexOf(".jar"));
                startupElement = new StartupElement(string2, n);
                list.add(startupElement);
            }
        }
    }

    public static void clear() {
        linkElementList = null;
        pluginElementList = null;
        linkStrategyClass = null;
        linkBasicElemList = null;
        linkNames = null;
        if (linkClassLoadingElements != null) {
            linkClassLoadingElements.clear();
            linkClassLoadingElements = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IStartupElement> getClassLoadingStartupElements(int n) {
        List<IStartupElement> list = null;
        Object object = LOCKCLASSSTARTUPELEMENTS;
        synchronized (object) {
            if (null == linkStrategyClass) {
                linkStrategyClass = StartupFactory.getStartupStrategy();
            }
            if (null == linkClassLoadingElements) {
                list = linkStrategyClass.getClassLoadingElements();
                if (list == null || list.size() == 0) {
                    return null;
                }
                linkClassLoadingElements = StartupFactory.getElementsType(3, list);
            }
        }
        if (n == 3) {
            return linkClassLoadingElements;
        }
        return null;
    }

    private static class StartupElement
    implements IStartupElement {
        private String name;
        private int type;

        StartupElement(String string, int n) {
            this.name = string;
            this.type = n;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public int getType() {
            return this.type;
        }

        public String toString() {
            return "Name: " + this.name + ", Type: " + this.type;
        }
    }
}

