/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.DebugTracer;
import com.swimap.iview.util.log.IviewLogger;
import java.util.Enumeration;
import java.util.Vector;
import org.omg.CORBA.ORB;

public class RemoteModuleLauncher
implements Runnable {
    private static IviewLogger logger = IviewLogger.getLogger(RemoteModuleLauncher.class, "IVIEW");
    protected ORB orb = null;
    protected String terminalId = null;
    protected String instanceId = null;
    protected Vector moduleList = null;
    public static final String TERMINAL_ID_PARAM_NAME = "-terminalid";
    public static final String INSTANCE_ID_PARAM_NAME = "-instanceid";
    public static final String MODULE_LIST_PARAM_NAME = "-modulelist";

    public RemoteModuleLauncher(String[] stringArray) {
        try {
            DebugTracer.identifyDebugParam(stringArray);
            this.identifyRemoteLanuchParam(stringArray);
            if (null == this.terminalId || null == this.instanceId || null == this.moduleList) {
                logger.warn("RemoteModuleLauncher started with insufficient parameters");
                return;
            }
            this.orb = ORB.init((String[])stringArray, null);
            Thread thread = new Thread(this);
            thread.start();
            Enumeration enumeration = this.moduleList.elements();
            Object object = null;
            String string = null;
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (null == object || "".equals(string = object.toString())) continue;
                FrameworkUtilities.loadModule(string, this.orb, this.terminalId, this.instanceId);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void identifyRemoteLanuchParam(String[] stringArray) {
        if (null == stringArray) {
            return;
        }
        int n = stringArray.length;
        String string = null;
        Vector<String> vector = new Vector<String>();
        String string2 = null;
        for (int i = 0; i < n && null != (string2 = stringArray[i]); ++i) {
            if (string2.length() > 0 && string2.charAt(0) == '-') {
                this.processSetting(string, vector);
                string = string2;
                vector.clear();
            } else {
                vector.add(string2);
            }
            if (i != n - 1) continue;
            this.processSetting(string, vector);
        }
    }

    private void processSetting(String string, Vector vector) {
        if (null == string) {
            return;
        }
        if (null == vector) {
            logger.error("Unidentified input : " + string);
            return;
        }
        if (vector.size() <= 0) {
            logger.error("The Value must be set: " + string);
        }
        if (TERMINAL_ID_PARAM_NAME.equalsIgnoreCase(string)) {
            String string2 = vector.firstElement().toString();
            if (null != string2) {
                this.terminalId = string2;
            } else {
                logger.error("The Value must be set: " + string);
            }
        } else if (INSTANCE_ID_PARAM_NAME.equalsIgnoreCase(string)) {
            String string3 = vector.firstElement().toString();
            if (null != string3) {
                this.instanceId = string3;
            } else {
                logger.error("The Value of " + string + " must be set");
            }
        } else if (MODULE_LIST_PARAM_NAME.equalsIgnoreCase(string)) {
            this.moduleList = vector;
        }
    }

    @Override
    public void run() {
        this.orb.run();
    }

    public static void main(String[] stringArray) {
        new RemoteModuleLauncher(stringArray);
    }
}

