/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.licensemanagement.LicenseService;
import com.swimap.iview.framework.licensemanagement.LicenseUtilities;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.LoadModuleFailedException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.outputmanagement.OutputManager;
import com.swimap.iview.framework.statusbarmanagement.StatusBarManager;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.PreferenceManager;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.toolbarmanagement.ToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.windowmanagement.WindowManager;
import com.swimap.iview.framework.windowmanagement.windowtabbed.WindowTabbedManager;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.SyncCommand;
import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.jni.Os;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import javax.swing.JFrame;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.SystemException;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public class FrameworkUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(FrameworkUtilities.class, "IVIEW");
    public static final String IVIEW_NAME_CONTEXT = "iview";
    public static final String PLATFORM_15 = "1.5";
    public static final String PLATFORM_12 = "1.2";
    private static List<SyncCommand> activeSyncCommandList = new ArrayList<SyncCommand>();
    private static JFrame mainFrame = null;
    private static MenuManager menuManager = null;
    private static OutputManager outputManager = null;
    private static StatusBarManager statusbarManager = null;
    private static SystemSettingsManager systemSettingsManager = null;
    private static TerminalManager terminalManager = null;
    private static ToolbarManager toolbarManager = null;
    private static WindowManager windowManager = null;
    private static WindowTabbedManager windowTabbedManager = null;
    private static PreferenceManager preferenceManager = null;
    private static Timer sysTimer = new Timer();
    private static boolean isFullScreenMode = false;
    private static final int _DEFUALT_FLASH_STOP_TIME = 500;
    private static List<IStartupElement> startupElements = null;
    private static Class corbaClass = null;
    private static WindowAdapter iconifyWindowAdapter = null;
    private static StringBuffer buf = new StringBuffer(50);

    public static void setStartupElements(List<IStartupElement> list) {
        if (null != list) {
            startupElements = new ArrayList<IStartupElement>(list);
        }
    }

    public static List<IStartupElement> getStartupElements() {
        return startupElements;
    }

    public static Servant createObject(String string, String string2, java.lang.Object object) {
        Servant servant = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Class.forName(string2)};
            Constructor<?> constructor = clazz.getConstructor(classArray);
            java.lang.Object[] objectArray = new java.lang.Object[]{object};
            servant = (Servant)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return servant;
    }

    public static Object invokeNarrow(String string, Object object) {
        Object object2 = null;
        try {
            Class<?> clazz = Class.forName(string);
            Class[] classArray = new Class[]{Class.forName("org.omg.CORBA.Object")};
            Method method = clazz.getMethod("narrow", classArray);
            java.lang.Object[] objectArray = new Object[]{object};
            object2 = (Object)method.invoke(null, objectArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return object2;
    }

    public static boolean deactivateObject(byte[] byArray, POA pOA) {
        try {
            pOA.deactivate_object(byArray);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public static BaseModule loadModule(String string, ModuleManager moduleManager, ORB oRB, String string2, String string3) {
        BaseModule baseModule = null;
        try {
            Class[] classArray = new Class[4];
            classArray[0] = moduleManager != null ? moduleManager.getClass() : Class.forName("com.swimap.iview.framework.modulemanagement.ModuleManager");
            if (null == corbaClass) {
                corbaClass = Class.forName("org.omg.CORBA.ORB");
            }
            classArray[1] = corbaClass;
            classArray[2] = String.class;
            classArray[3] = String.class;
            java.lang.Object[] objectArray = new java.lang.Object[]{moduleManager, oRB, string2, string3};
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            logger.debug(" Begin invoke className " + string);
            long l = System.currentTimeMillis();
            baseModule = (BaseModule)constructor.newInstance(objectArray);
            long l2 = System.currentTimeMillis();
            logger.debug("LoadModule ORB time for the module:" + string + " = " + (l2 - l));
        }
        catch (Exception exception) {
            LoadModuleFailedException loadModuleFailedException = FrameworkUtilities.getLMFException(exception);
            if (loadModuleFailedException != null) {
                throw loadModuleFailedException;
            }
            logger.error(exception.getMessage(), exception);
        }
        return baseModule;
    }

    public static BaseModule loadModule(String string, ModuleManager moduleManager) {
        BaseModule baseModule;
        block7: {
            baseModule = null;
            Class[] classArray = null;
            java.lang.Object[] objectArray = null;
            try {
                GenericDeclaration genericDeclaration;
                Serializable serializable;
                classArray = new Class[]{moduleManager != null ? moduleManager.getClass() : Class.forName("com.swimap.iview.framework.modulemanagement.ModuleManager")};
                objectArray = new java.lang.Object[]{moduleManager};
                try {
                    serializable = Class.forName(string);
                    genericDeclaration = ((Class)serializable).getConstructor(classArray);
                    logger.debug(" Begin invoke className " + string);
                    long l = System.currentTimeMillis();
                    baseModule = (BaseModule)((Constructor)genericDeclaration).newInstance(objectArray);
                    long l2 = System.currentTimeMillis();
                    logger.debug("LoadModule Non-ORB time for the module:" + string + " = " + (l2 - l));
                }
                catch (Exception exception) {
                    logger.error("problem on loading ", exception);
                }
                if (null != baseModule) break block7;
                serializable = moduleManager.getPluginFromClass(string);
                genericDeclaration = null;
                try {
                    genericDeclaration = serializable.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    logger.error("Class " + string + " may not be loaded. Please check, " + classNotFoundException);
                    throw new ClassNotFoundException();
                }
                Constructor constructor = ((Class)genericDeclaration).getConstructor(classArray);
                logger.debug(" Begin invoke className " + string);
                baseModule = (BaseModule)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                LoadModuleFailedException loadModuleFailedException = FrameworkUtilities.getLMFException(exception);
                if (loadModuleFailedException != null) {
                    throw loadModuleFailedException;
                }
                logger.error(exception.getMessage(), exception);
            }
        }
        return baseModule;
    }

    public static BaseModule loadModule(String string, ORB oRB, String string2, String string3) {
        BaseModule baseModule = null;
        try {
            Class[] classArray = new Class[3];
            if (null == corbaClass) {
                corbaClass = Class.forName("org.omg.CORBA.ORB");
            }
            classArray[0] = corbaClass;
            classArray[1] = string2.getClass();
            classArray[2] = string3.getClass();
            java.lang.Object[] objectArray = new java.lang.Object[]{oRB, string2, string3};
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(classArray);
            logger.debug(" Begin invoke className " + string);
            long l = System.currentTimeMillis();
            baseModule = (BaseModule)constructor.newInstance(objectArray);
            long l2 = System.currentTimeMillis();
            logger.debug("LoadModule ORB time for the module:" + string + " = " + (l2 - l));
        }
        catch (Exception exception) {
            LoadModuleFailedException loadModuleFailedException = FrameworkUtilities.getLMFException(exception);
            if (loadModuleFailedException != null) {
                throw loadModuleFailedException;
            }
            logger.error(exception.getMessage(), exception);
        }
        return baseModule;
    }

    private static LoadModuleFailedException getLMFException(Throwable throwable) {
        if (throwable == null) {
            return null;
        }
        Throwable throwable2 = throwable.getCause();
        if (throwable2 != null) {
            if (throwable2 instanceof LoadModuleFailedException) {
                return (LoadModuleFailedException)throwable2;
            }
            return FrameworkUtilities.getLMFException(throwable2);
        }
        return null;
    }

    public static String getFullyQualifiedName(String string, String string2, String string3) {
        return new StringBuffer(string).append(':').append(string2).append(':').append(string3).toString();
    }

    public static void startProcess(String[] stringArray) {
        try {
            String string = null;
            if (stringArray != null && stringArray.length > 0) {
                StringBuffer stringBuffer = new StringBuffer(30);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringBuffer.append("parameters[").append(i).append("]=").append(stringArray[i]).append(";");
                }
                string = stringBuffer.toString();
            }
            logger.debug(string);
            Runtime.getRuntime().exec(stringArray);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
    }

    public static void startProcess(String string) {
        try {
            Runtime.getRuntime().exec(string);
        }
        catch (IOException iOException) {
            logger.error(iOException.getMessage(), iOException);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
    }

    public static void setMainFrame(JFrame jFrame) {
        mainFrame = jFrame;
        FrameworkHelper.setMainFrame(jFrame);
    }

    public static JFrame getMainFrame() {
        return mainFrame;
    }

    public static boolean provideObjectAsNameServiceInIviewContext(ORB oRB, String string, Object object) {
        if (null == oRB || null == object) {
            logger.error("The Parametor inputed is null.");
            return false;
        }
        NamingContext namingContext = null;
        namingContext = FrameworkUtilities.getNamingServiceReference(oRB);
        if (null == namingContext) {
            logger.error("The Name service is no exist.");
            return false;
        }
        NameComponent[] nameComponentArray = new NameComponent[2];
        NameComponent[] nameComponentArray2 = new NameComponent[]{new NameComponent(IVIEW_NAME_CONTEXT, "")};
        boolean bl = false;
        try {
            namingContext.resolve(nameComponentArray2);
        }
        catch (InvalidName invalidName) {
            bl = true;
        }
        catch (CannotProceed cannotProceed) {
            bl = true;
        }
        catch (NotFound notFound) {
            bl = true;
        }
        catch (SystemException systemException) {
            bl = true;
        }
        if (bl) {
            try {
                namingContext.bind_new_context(nameComponentArray2);
                nameComponentArray[0] = new NameComponent(IVIEW_NAME_CONTEXT, "");
                nameComponentArray[1] = new NameComponent(string, "");
                namingContext.bind(nameComponentArray, object);
            }
            catch (Exception exception) {
                logger.error(exception.getMessage(), exception);
                return false;
            }
        }
        try {
            nameComponentArray[0] = new NameComponent(IVIEW_NAME_CONTEXT, "");
            nameComponentArray[1] = new NameComponent(string, "");
            namingContext.rebind(nameComponentArray, object);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    public static Object getTheObjectByNameInIviewContext(ORB oRB, String string) {
        Object object = null;
        NamingContext namingContext = FrameworkUtilities.getNamingServiceReference(oRB);
        if (null == namingContext) {
            return null;
        }
        NameComponent[] nameComponentArray = new NameComponent[]{new NameComponent(IVIEW_NAME_CONTEXT, ""), new NameComponent(string, "")};
        try {
            object = namingContext.resolve(nameComponentArray);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        return object;
    }

    public static NamingContext getNamingServiceReference(ORB oRB) {
        if (null == oRB) {
            logger.error("The ORB is null.");
            return null;
        }
        NamingContext namingContext = null;
        try {
            Object object = oRB.resolve_initial_references("NameService");
            namingContext = NamingContextHelper.narrow((Object)object);
        }
        catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
        }
        return namingContext;
    }

    public static void setMenuManager(MenuManager menuManager) {
        FrameworkUtilities.menuManager = menuManager;
    }

    public static MenuManager getMenuManager() {
        return menuManager;
    }

    public static boolean isFullScreenMode() {
        return isFullScreenMode;
    }

    public static void setFullScreenMode(boolean bl) {
        isFullScreenMode = bl;
    }

    public static void setOutputManager(OutputManager outputManager) {
        FrameworkUtilities.outputManager = outputManager;
    }

    public static OutputManager getOutputManager() {
        if (outputManager == null) {
            FrameworkUtilities.createInstance();
        }
        return outputManager;
    }

    public static void setStatusBarManager(StatusBarManager statusBarManager) {
        statusbarManager = statusBarManager;
    }

    public static StatusBarManager getStatusBarManager() {
        return statusbarManager;
    }

    public static void setPreferenceManager(PreferenceManager preferenceManager) {
        FrameworkUtilities.preferenceManager = preferenceManager;
    }

    public static PreferenceManager getPreferenceManager() {
        return preferenceManager;
    }

    public static void setSystemSettingsManager(SystemSettingsManager systemSettingsManager) {
        FrameworkUtilities.systemSettingsManager = systemSettingsManager;
    }

    public static SystemSettingsManager getSystemSettingsManager() {
        return systemSettingsManager;
    }

    public static void setTerminalManager(TerminalManager terminalManager) {
        FrameworkUtilities.terminalManager = terminalManager;
    }

    public static TerminalManager getTerminalManager() {
        return terminalManager;
    }

    public static void setToolbarManager(ToolbarManager toolbarManager) {
        FrameworkUtilities.toolbarManager = toolbarManager;
    }

    public static ToolbarManager getToolbarManager() {
        return toolbarManager;
    }

    public static void setWindowManager(WindowManager windowManager) {
        FrameworkUtilities.windowManager = windowManager;
    }

    public static WindowManager getWindowManager() {
        return windowManager;
    }

    public static void setWindowTabbedManager(WindowTabbedManager windowTabbedManager) {
        FrameworkUtilities.windowTabbedManager = windowTabbedManager;
    }

    public static WindowTabbedManager getWindowTabbedManager() {
        return windowTabbedManager;
    }

    public static synchronized void addOperateMessage(String string, String string2, String string3, String string4, String string5) {
        buf.delete(0, buf.length());
        buf.append(string2).append(string3).append(string4);
        if (string5 != null && string5.trim().length() > 0) {
            buf.append(FrameworkCommandProcessor.res.getString("comma")).append(string5);
        }
        buf.append(FrameworkCommandProcessor.res.getString("period"));
        outputManager.addMessage(string, buf.toString());
    }

    public static synchronized void addEventMessage(String string, String string2, String string3, String string4) {
        buf.delete(0, buf.length());
        buf.append(string2).append(string3);
        if (string4 != null && string4.trim().length() > 0) {
            buf.append(FrameworkCommandProcessor.res.getString("comma")).append(string4);
        }
        buf.append(FrameworkCommandProcessor.res.getString("period"));
        outputManager.addMessage(string, buf.toString());
    }

    public static Timer getSystemTimer() {
        return sysTimer;
    }

    public static void close(InputStream inputStream) {
        if (null != inputStream) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean exist(URL uRL) {
        InputStream inputStream;
        boolean bl;
        block9: {
            if (CommonUtil.IS_MENUTOOL) {
                return FrameworkUtilities.existNoCache(uRL);
            }
            if (null == uRL) {
                return false;
            }
            bl = false;
            inputStream = null;
            String string = uRL.toString();
            char c = string.charAt(0);
            if (c == 'j') break block9;
            boolean bl2 = new File(uRL.toURI()).exists();
            FrameworkUtilities.close(inputStream);
            return bl2;
        }
        try {
            block10: {
                break block10;
                catch (Exception exception) {
                    logger.trace(uRL + " error");
                }
            }
            inputStream = uRL.openStream();
        }
        catch (Exception exception) {
            try {
                logger.trace(uRL + " doesn't exist");
            }
            catch (Throwable throwable) {
                FrameworkUtilities.close(inputStream);
                throw throwable;
            }
            FrameworkUtilities.close(inputStream);
        }
        FrameworkUtilities.close(inputStream);
        if (null != inputStream) {
            bl = true;
        }
        return bl;
    }

    public static BaseModule loadModuleByClass(Class clazz, ModuleManager moduleManager, ORB oRB, String string, String string2) {
        BaseModule baseModule = null;
        try {
            Class[] classArray = new Class[4];
            classArray[0] = moduleManager != null ? moduleManager.getClass() : Class.forName("com.swimap.iview.framework.modulemanagement.ModuleManager");
            if (null == corbaClass) {
                corbaClass = Class.forName("org.omg.CORBA.ORB");
            }
            classArray[1] = corbaClass;
            classArray[2] = String.class;
            classArray[3] = String.class;
            java.lang.Object[] objectArray = new java.lang.Object[]{moduleManager, oRB, string, string2};
            Constructor constructor = clazz.getConstructor(classArray);
            logger.debug(" Begin invoke className " + clazz.getName());
            long l = System.currentTimeMillis();
            baseModule = (BaseModule)constructor.newInstance(objectArray);
            long l2 = System.currentTimeMillis();
            logger.debug("LoadModule ORB time for the module:" + clazz.getName() + " = " + (l2 - l));
        }
        catch (Exception exception) {
            LoadModuleFailedException loadModuleFailedException = FrameworkUtilities.getLMFException(exception);
            if (loadModuleFailedException != null) {
                throw loadModuleFailedException;
            }
            logger.error(exception.getMessage(), exception);
        }
        return baseModule;
    }

    public static BaseModule loadModuleByClass(Class clazz, ModuleManager moduleManager) {
        BaseModule baseModule = null;
        try {
            Class[] classArray = new Class[]{moduleManager != null ? moduleManager.getClass() : Class.forName("com.swimap.iview.framework.modulemanagement.ModuleManager")};
            java.lang.Object[] objectArray = new java.lang.Object[]{moduleManager};
            Constructor constructor = clazz.getConstructor(classArray);
            logger.debug(" Begin invoke className " + clazz.getName());
            long l = System.currentTimeMillis();
            baseModule = (BaseModule)constructor.newInstance(objectArray);
            long l2 = System.currentTimeMillis();
            logger.debug("LoadModule Non-ORB time for the module:" + clazz.getName() + " = " + (l2 - l));
        }
        catch (Exception exception) {
            LoadModuleFailedException loadModuleFailedException = FrameworkUtilities.getLMFException(exception);
            if (loadModuleFailedException != null) {
                throw loadModuleFailedException;
            }
            logger.error(exception.getMessage(), exception);
        }
        return baseModule;
    }

    public static String getSubsystemName() {
        String string = System.getProperty("subsystem");
        if (null == string || string.length() == 0) {
            string = "All";
        }
        return string;
    }

    public static void flashTaskBar(int n) {
        FrameworkUtilities.flashTaskBar(FrameworkUtilities.getMainFrame(), n, 500);
    }

    public static void flashTaskBar(final Window window, final int n, final int n2) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                Os.getOs().flashTaskBar(window, n, n2);
            }
        };
        thread.start();
    }

    public static JFrame getCurrentActiveFrame() {
        for (Container container = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow(); null != container; container = container.getParent()) {
            if (!(container instanceof JFrame)) continue;
            return (JFrame)container;
        }
        return FrameworkUtilities.getMainFrame();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean existNoCache(URL uRL) {
        if (null == uRL) {
            return false;
        }
        boolean bl = false;
        URLConnection uRLConnection = null;
        InputStream inputStream = null;
        try {
            uRLConnection = uRL.openConnection();
            uRLConnection.setUseCaches(false);
            inputStream = uRLConnection.getInputStream();
            FrameworkUtilities.close(inputStream);
        }
        catch (IOException iOException) {
            logger.trace(iOException);
        }
        finally {
            FrameworkUtilities.close(inputStream);
        }
        if (null != inputStream) {
            bl = true;
        }
        if (!bl) {
            logger.trace("FrameworkUtilities: " + uRL + " doesn't exist");
        }
        return bl;
    }

    public static LicenseService getLicenseService() {
        return LicenseUtilities.getLicenseService();
    }

    public static void loadLicenseService() {
        LicenseUtilities.loadLicenseService();
    }

    public static boolean isInState(int[] nArray) {
        String string = System.getProperty("SpecificLoadingState");
        if (null == string) {
            return true;
        }
        boolean bl = false;
        if (null == nArray) {
            return false;
        }
        for (int n : nArray) {
            if (!string.equals("" + n)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static WindowAdapter getIconifyWindowListener() {
        if (null == iconifyWindowAdapter) {
            iconifyWindowAdapter = new WindowAdapter(){

                @Override
                public void windowIconified(WindowEvent windowEvent) {
                    JFrame jFrame = (JFrame)windowEvent.getSource();
                    logger.trace("Window Iconified : " + jFrame.getClass());
                    TerminalManager terminalManager = FrameworkUtilities.getTerminalManager();
                    if (null != terminalManager) {
                        if (!terminalManager.isLockOrUnLockDialogshown()) {
                            terminalManager.hideOwnedVisibleWindows(jFrame);
                        }
                        jFrame.getPeer().setVisible(false);
                    }
                }
            };
        }
        return iconifyWindowAdapter;
    }

    public static void addActiveSyncCommand(SyncCommand syncCommand) {
        if (null != syncCommand) {
            activeSyncCommandList.add(syncCommand);
        }
    }

    public static void removeActiveSyncCommand(SyncCommand syncCommand) {
        if (null != syncCommand) {
            activeSyncCommandList.remove(syncCommand);
        }
    }

    public static void stopAllActiveSyncCommands() {
        logger.trace("activeSyncCommandList size :" + activeSyncCommandList.size());
        ArrayList<SyncCommand> arrayList = new ArrayList<SyncCommand>(activeSyncCommandList);
        for (SyncCommand syncCommand : arrayList) {
            logger.debug("SyncID:" + syncCommand.hashCode() + "--stopActiveSyncCommand called.");
            syncCommand.stopActiveSyncCommand();
        }
    }

    private static void createInstance() {
        if (null == Main.instance()) {
            return;
        }
        Thread thread = Main.instance().getLoadAllThread();
        if (null != thread && thread.isAlive()) {
            try {
                Thread thread2 = Thread.currentThread();
                if (thread2 != thread) {
                    logger.trace("Start BM thread" + thread2.getName() + " joined with iview loadAllThread ");
                    thread.join();
                    logger.trace("End BM thread" + thread2.getName() + " joined with iview load thread ");
                }
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
        }
    }
}

