/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.SecondaryStartupXMLReader;
import com.swimap.iview.framework.applicationfavourites.FavouriteStateMgr;
import com.swimap.iview.framework.applicationmanagement.AppPopupMenuManager;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.util.BackGroundLauncherTask;
import com.swimap.iview.util.log.IviewLogger;
import java.util.List;
import javax.swing.SwingUtilities;

public class BackGroundThread
extends Thread {
    private static IviewLogger logger = IviewLogger.getLogger(BackGroundThread.class, "IVIEW");
    private boolean isRequestStop = false;

    @Override
    public void run() {
        try {
            boolean bl;
            logger.debug("plugins:" + SecondaryStartupXMLReader.getNormalPlugins() + "required plugins" + SecondaryStartupXMLReader.getRequiredPlugins() + "portal links:" + SecondaryStartupXMLReader.getPortallinks() + "required Links:" + SecondaryStartupXMLReader.getRequiredlinks());
            BackGroundLauncherTask.getInstance().loadAllPluginsAndLinks();
            logger.debug("loading plugins and links modules are completed....");
            List<String> list = SecondaryStartupXMLReader.getApplicationsFromConfig();
            logger.debug("AppIDs from all configured applications:" + list);
            this.updatePopupMenusOfAllApps();
            this.launchApps(list);
            if (!this.isRequestStop) {
                logger.debug("updating all favouritebuttons are started");
                FavouriteStateMgr.getInstance().updateVisibilityOfFavouriteButtons();
                logger.debug("updating all favouritebuttons are completed");
            }
            if ((bl = SecondaryStartupXMLReader.isFavouriteApplicationsLaunch()) && !this.isRequestStop) {
                List<String> list2 = FavouriteStateMgr.getInstance().getAllAppIdsForEnabledAndVisibleButtons();
                logger.debug("AppIDs from all FavouriteButtons:" + list2);
                this.launchApps(list2);
            }
            logger.debug("Completed BackGroundThread..........");
            Main.instance().getModuleManager().shutDownSingleThreadPoolExecutor();
        }
        catch (Exception exception) {
            logger.debug("Exception occured in BackGround Thread... " + exception);
        }
    }

    private void launchApps(List<String> list) {
        for (String string : list) {
            if (this.isRequestStop) {
                return;
            }
            if (null == ApplicationManager.getInstance().getApplication(string)) continue;
            ApplicationLauncher.getAppLauncher().launchApplicationInBackGround(string);
        }
    }

    public boolean isRequestStop() {
        return this.isRequestStop;
    }

    public void setRequestStop(boolean bl) {
        logger.debug("BackGroundThread is triggered stop event:");
        this.isRequestStop = bl;
    }

    private void updatePopupMenusOfAllApps() {
        logger.debug("updating all APPPopupMenuManager are started");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (Thread.interrupted()) {
                    logger.error("EDT Thread is interrupted, popupmenus updation will  not happen.");
                    return;
                }
                if (ModuleManager.getAfterLoadThread() == null) {
                    logger.debug("Not started initial module loading of startup.xml files so popupmenus updation will not occur");
                    return;
                }
                List<Application> list = ApplicationManager.getInstance().getApplications();
                boolean bl = false;
                for (Application application : list) {
                    if (Thread.interrupted()) {
                        logger.error("EDT Thread is interrupted, popupmenus updation will  not happen.");
                        return;
                    }
                    if (ModuleManager.getAfterLoadThread() == null) {
                        logger.debug("Not started initial module loading of startup.xml files so popupmenus updation will not occur");
                        return;
                    }
                    if (null == application) {
                        return;
                    }
                    try {
                        if (BackGroundThread.this.isRequestStop) continue;
                        AppPopupMenuManager appPopupMenuManager = ApplicationManager.getInstance().getAppPopUpMenuManager(application.getId());
                        bl = false;
                        if (null != appPopupMenuManager.getPopupMenu() && appPopupMenuManager.getPopupMenu().isVisible()) {
                            bl = true;
                            appPopupMenuManager.getPopupMenu().setVisible(false);
                        }
                        appPopupMenuManager.updatePopupMenu();
                        appPopupMenuManager.updateAppPopUP();
                        if (!bl || null == appPopupMenuManager.getPopupMenu()) continue;
                        appPopupMenuManager.getPopupMenu().setVisible(true);
                    }
                    catch (Exception exception) {
                        logger.debug("while updating popupmenu exception occured");
                    }
                    catch (Throwable throwable) {
                        logger.debug("while updating popupmenu error occured for application:" + application.getId());
                    }
                }
            }
        });
        logger.debug("updating all APPPopupMenuManager are completed");
    }

    public void setRequestStop() {
        this.isRequestStop = true;
    }
}

