/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.util;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.SecondaryStartupXMLReader;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.util.BackGroundThread;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class BackGroundLauncherTask {
    private static IviewLogger logger = IviewLogger.getLogger(BackGroundLauncherTask.class, "IVIEW");
    static BackGroundLauncherTask instance = null;
    BackGroundThread backGroundThread = null;

    public static final synchronized BackGroundLauncherTask getInstance() {
        if (null == instance) {
            instance = new BackGroundLauncherTask();
        }
        return instance;
    }

    public void startBackGroundThread() {
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            logger.debug("Starting BackGroundThread..........");
            if (null == this.backGroundThread) {
                this.backGroundThread = new BackGroundThread();
            }
            this.backGroundThread.setName("IVIEW_BACKGROUND_THREAD");
            this.backGroundThread.setPriority(2);
            this.backGroundThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopBackGroundThread() {
        logger.debug("Stopping backGround Thread is started....");
        if (this.backGroundThread != null && this.backGroundThread.isAlive()) {
            this.backGroundThread.setRequestStop(true);
            Main.instance().getModuleManager().shutDownSingleThreadPoolExecutor();
            BackGroundThread backGroundThread = this.backGroundThread;
            synchronized (backGroundThread) {
                this.backGroundThread.notifyAll();
            }
            this.backGroundThread.interrupt();
            try {
                logger.debug("[Joining backGroundThread has started...");
                this.backGroundThread.join();
            }
            catch (InterruptedException interruptedException) {
                logger.debug("Joining backgroundthread Exception occured");
            }
        } else {
            logger.debug("backGround Thread is not Alive");
        }
        this.backGroundThread = null;
    }

    private void loadCommandsFromExtsAndPlugins() {
        String[] stringArray = new String[16];
        stringArray = ApplicationUtilities.getExtsFromPortalLinks();
        for (int i = 0; i < stringArray.length; ++i) {
            CommandManager.getInstance().loadSecurityCommands("conf/" + stringArray[i] + "/commands");
        }
    }

    public void loadAllPluginsAndLinks() {
        this.loadCommandsFromExtsAndPlugins();
        HashSet<String> hashSet = new HashSet<String>(16);
        hashSet.addAll(SecondaryStartupXMLReader.getNormalPlugins());
        hashSet.addAll(SecondaryStartupXMLReader.getRequiredPlugins());
        List<String> list = new ArrayList<String>(hashSet);
        list = this.getPluginsConfiguredInApp(list);
        list = ApplicationUtilities.getFilteredStartupPlugins(list);
        String[] stringArray = FrameworkCommandProcessor.mergeExtPath(ApplicationUtilities.getExtsFromRequiredLinks(), ApplicationUtilities.getExtsFromPortalLinks());
        Main.instance().getModuleManager().loadSecondaryModules(list, stringArray, "");
    }

    private List<String> getPluginsConfiguredInApp(List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list2 = ApplicationUtilities.getPluginNamesOfAllApplications();
        for (String string : list) {
            if (!list2.contains(string)) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public BackGroundThread getBackGroundThread() {
        return this.backGroundThread;
    }
}

