/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.toolbarmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.commstyle.commini.ToolGroupSet;
import com.swimap.iview.corbahelpers.DataShareInterface;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.lookandfeel.UIStyleTool;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.menumanagement.MenuManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.toolbarmanagement.IToolbarManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.toolbar.Toolbar;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.omg.CORBA.ORB;

public class ToolbarManager
extends BaseModule
implements IToolbarManager {
    private static IviewLogger logger = IviewLogger.getLogger(ToolbarManager.class, "IVIEW");
    private static final String MAINTOOL_GROUPSET_NAME = "mainTool";
    protected Toolbar toolbarComponent = null;
    private static final String UNDEFINED_MODULE_NAME = "toolbar module(undefined)";
    protected String moduleName = "toolbar module(undefined)";
    protected MenuManager menuManager = null;

    public ToolbarManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.moduleName = string3;
        this.register(this);
        this.init();
    }

    public ToolbarManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3, String string4) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.moduleName = string3;
        this.register(this);
        this.init(string4);
    }

    public ToolbarManager(ModuleManager moduleManager, String string) throws ModuleManagementException {
        this(moduleManager, null, null, null, string);
    }

    public void init() {
        this.toolbarComponent = new Toolbar(null);
        this.toolbarComponent.setSaveLock("main_toolbar_component");
        this.toolbarComponent.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
        try {
            this.menuManager = (MenuManager)this.getLocalReference("mainmenumanager");
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.error("get MenuManager Exception ");
            logger.warn(moduleManagementException.getMessage(), moduleManagementException);
        }
        if (this.menuManager != null) {
            this.menuManager.addMouseListener(this.toolbarComponent.getPopupMenuListener());
        }
    }

    protected void init(String string) {
    }

    @Override
    public void reinitialize() {
        Object object;
        super.reinitialize();
        this.toolbarComponent.clearSettings();
        this.toolbarComponent.removeAll();
        this.toolbarComponent.enableCurrentSettings(false);
        this.loadToolbarButtonGroups("conf/mainfrm/toolbar", MAINTOOL_GROUPSET_NAME);
        String[] stringArray = new String[16];
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            object = new File(System.getProperty("user.dir") + "/productlib");
            if (!((File)object).exists()) {
                stringArray = FrameworkCommandProcessor.getInstance().getExtPathsFromProductAndDefault();
            }
        } else {
            stringArray = Main.extPaths;
        }
        stringArray = FrameworkCommandProcessor.getInstance().getFilteredExtPaths(stringArray);
        object = "/toolbar";
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            object = "/app/toolbar";
        }
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.loadDynamicToolbarGroupOfExtPath("conf/" + stringArray[i] + (String)object, MAINTOOL_GROUPSET_NAME, stringArray[i]);
            }
        }
        this.loadToolbarGroupFromPlugin();
        if (this.menuManager != null) {
            this.menuManager.addMouseListener(this.toolbarComponent.getPopupMenuListener());
        }
        this.toolbarComponent.updateToolbarSafely();
        this.filterModuleToolbar(FrameworkCommandProcessor.getInstance().getFailedModules());
        try {
            this.toolbarComponent.resetLockInfo();
        }
        catch (Exception exception) {
            logger.warn(exception);
        }
        this.toolbarComponent.setOriginalComponentsPositions();
        this.toolbarComponent.refreshOriginal();
        ((MDIFrame)FrameworkUtilities.getMainFrame()).showToolbar(true);
        this.toolbarComponent.setVisible(true);
        this.toolbarComponent.enableCurrentSettings(true);
    }

    public boolean unloadToolbarButtonGroups(String string) {
        return this.toolbarComponent.unloadToolbarButtonGroups(string);
    }

    public boolean storeToolbarSetting() {
        return this.toolbarComponent.storeToolbarSetting();
    }

    @Override
    public boolean showToolbarButton(boolean bl, String string, String string2, String string3) {
        return this.toolbarComponent.showToolbarButton(bl, string, string2, string3);
    }

    @Override
    public boolean showToolbarButtonGroup(boolean bl, String string, String string2) {
        return this.toolbarComponent.showToolbarButtonGroup(bl, string, string2);
    }

    public void setToolbarAction() {
        this.toolbarComponent.setToolbarAction();
    }

    @Override
    public boolean setToolbarButtonState(String string, String string2, String string3, String string4, String string5) {
        return this.toolbarComponent.setToolbarButtonState(string, string2, string3, string4, string5);
    }

    @Override
    public void launchCustomizeDialog() {
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            String string = ApplicationLauncher.getAppLauncher().getActiveFrameAppId();
            if (null != string) {
                ApplicationManager.getInstance().getAppToolbarManager(string).launchCustomizeDialog();
            } else {
                this.toolbarComponent.launchCustomizeDialog();
            }
        } else {
            this.toolbarComponent.launchCustomizeDialog();
        }
    }

    public JPanel getToolbar() {
        return this.toolbarComponent;
    }

    public ToolGroupSet getToolGroupSet(String string) {
        return this.toolbarComponent.getToolGroupSet(string);
    }

    public ToolGroup getToolGroup(String string, String string2) {
        return this.toolbarComponent.getToolGroup(string, string2);
    }

    public ToolBarButton getToolBarButton(String string, String string2, String string3) {
        return this.toolbarComponent.getToolBarButton(string, string2, string3);
    }

    public JComponent getToolBarComponent(String string, String string2, String string3) {
        return this.toolbarComponent.getToolBarComponent(string, string2, string3);
    }

    public Vector getToolGroupSetVct() {
        return this.toolbarComponent.getToolGroupSetVct();
    }

    public JPopupMenu getPopupMenu() {
        return this.toolbarComponent.getPopupMenu();
    }

    @Override
    public void clear() {
        super.clear();
        if (null != this.toolbarComponent) {
            this.toolbarComponent.clear();
            this.updateToolbars();
        }
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    @Override
    public DataShareInterface getRemoteDataShare(String string) {
        return null;
    }

    protected void loadToolbarGroupFromPlugin() {
        List<Plugin> list = null;
        list = FrameworkCommandProcessor.getInstance().isAppStyle() ? PluginManager.getInstance().getStartupPluginList(null) : PluginManager.getInstance().getStartupPluginList();
        Plugin plugin2 = null;
        CommStyleInfo commStyleInfo = null;
        if (null != list) {
            for (Plugin plugin2 : list) {
                if (!FrameworkUtilities.isInState(plugin2.getModuleInfomation().getStates()) || null == (commStyleInfo = plugin2.getIntegrateCommStyleReader().getUserCommStyleInfo("toolbar"))) continue;
                this.loadDynamicToolbarGroup(commStyleInfo, MAINTOOL_GROUPSET_NAME);
            }
        }
    }

    public boolean loadDynamicToolbarGroup(String string, String string2) {
        return this.toolbarComponent.loadDynamicToolbarGroup(string, string2);
    }

    public boolean loadDynamicToolbarGroupOfExtPath(String string, String string2, String string3) {
        return this.toolbarComponent.loadDynamicToolbarGroupOfExtPath(string, string2, string3);
    }

    public boolean loadToolbarGroupsExt(String string, String string2) {
        return this.toolbarComponent.loadToolbarGroupsExt(string, string2);
    }

    public void addToolbarPanel(JPanel jPanel) {
        if (FrameworkCommandProcessor.getInstance().isAppStyle() && null != jPanel && "AlarmPanel".equals(jPanel.getName())) {
            ApplicationUtilities.setRightPanel(jPanel);
        }
        if (null != jPanel) {
            jPanel.setBackground(UIStyleTool.getTOOLBAR_BACKGROUND());
        }
        this.toolbarComponent.addToRightPanel(jPanel);
    }

    public void removeToolbarPanel(JPanel jPanel) {
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            ApplicationUtilities.setRightPanel(null);
        }
        this.toolbarComponent.removeFromRightPanel(jPanel);
    }

    public void setPopupMenuEnable(boolean bl) {
        this.toolbarComponent.setPopupMenuEnable(bl);
    }

    public void filterModuleToolbar(ArrayList arrayList) {
        this.toolbarComponent.filterModuleToolbar(arrayList);
    }

    public boolean loadDynamicToolbarGroup(CommStyleInfo commStyleInfo, String string) {
        return this.toolbarComponent.loadDynamicToolbarGroup(commStyleInfo, string);
    }

    @Override
    public boolean loadToolbarButtonGroups(String string, String string2) {
        return this.toolbarComponent.loadToolbarButtonGroups(string, string2);
    }

    public boolean unLoadToolbarGroupsExt(String string) {
        return this.toolbarComponent.unLoadToolbarGroupsExt(string);
    }

    public boolean unloadDynamicToolbarGroup(String string, String string2) {
        return this.toolbarComponent.unloadDynamicToolbarGroup(string, string2);
    }

    public boolean unloadDynamicToolbarGroup(CommStyleInfo commStyleInfo, String string) {
        return this.toolbarComponent.unloadDynamicToolbarGroup(commStyleInfo, string);
    }

    public void removeToolbarByCommandID(String string) {
        this.toolbarComponent.removeToolbarByCommandID(string);
    }

    public boolean clearToolGroupButton(ToolGroup toolGroup, ToolGroup toolGroup2) {
        return this.toolbarComponent.clearToolGroupButton(toolGroup, toolGroup2);
    }

    public void validateToolbar() {
        this.toolbarComponent.validateToolbar();
    }

    public boolean storeToolbarSettingToServer() throws Exception {
        return this.toolbarComponent.storeToolbarSettingToServer();
    }

    @Override
    public boolean updateToolbars() {
        return this.toolbarComponent.updateToolbars();
    }

    public void updateToolGroup(ToolGroup toolGroup) {
        this.toolbarComponent.updateToolGroup(toolGroup);
    }

    public Enumeration getAllToolGroup() {
        return this.toolbarComponent.getAllToolGroup();
    }

    public Vector<ToolGroupSet> getAllToolGroupSets() {
        return this.toolbarComponent.getAllToolGroupSets();
    }

    public void updateToolBarItem(JComponent jComponent) {
        this.toolbarComponent.updateToolBarItem(jComponent);
    }

    @Override
    public Object processEvent(InternalLocalMsg internalLocalMsg) {
        if (internalLocalMsg == InternalLocalMsg.MSG_EXIT_TERMINAL || internalLocalMsg == InternalLocalMsg.MSG_LOGOUT) {
            this.toolbarComponent.savePositions();
            this.toolbarComponent.clearSettings();
        }
        return null;
    }

    public boolean setToolbarButtonVisible(boolean bl, String string, String string2, String string3) {
        return this.toolbarComponent.setToolbarButtonVisible(bl, string, string2, string3);
    }
}

