/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.toolbarmanagement;

import com.swimap.iview.commstyle.commini.ToggleButton;
import com.swimap.iview.commstyle.commini.ToolBarButton;
import com.swimap.iview.commstyle.commini.ToolBarHandle;
import com.swimap.iview.commstyle.commini.ToolGroup;
import com.swimap.iview.framework.customizedialog.SelectObject;
import com.swimap.iview.framework.customizedialog.SelectObjectVector;
import com.swimap.iview.framework.toolbarmanagement.JComponentSelectObject;
import com.swimap.iview.framework.toolbarmanagement.ToolBarButtonSelectObject;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JToolBar;

public class ToolGroupSelectObject
extends SelectObject {
    private static IviewLogger logger = IviewLogger.getLogger(ToolGroupSelectObject.class, "IVIEW");
    private ToolGroup theToolGroup = null;

    public ToolGroupSelectObject(ToolGroup toolGroup) {
        this.theToolGroup = toolGroup;
        super.setSelected(toolGroup.isUserSelected());
    }

    @Override
    public void setSelected(boolean bl) {
        if (null != this.theToolGroup) {
            this.theToolGroup.setUserSelected(bl);
        }
        super.setSelected(bl);
    }

    @Override
    public SelectObjectVector getDetailSelectObject() {
        if (null == super.getDetailSelectObject()) {
            super.setDetailSelectObject(this.createDetailSelectObjects());
        }
        return super.getDetailSelectObject();
    }

    private SelectObjectVector createDetailSelectObjects() {
        SelectObjectVector selectObjectVector = new SelectObjectVector();
        int n = this.theToolGroup.getButtonCount();
        Component component = null;
        for (int i = 0; i < n; ++i) {
            JComponent jComponent;
            component = this.theToolGroup.getVisibleButton(i);
            if (null == component) {
                logger.error("The component which get from ToolGroup is null! The toolGroup name: " + this.theToolGroup.getName());
                continue;
            }
            if (component instanceof ToolBarButton) {
                jComponent = (ToolBarButton)component;
                selectObjectVector.add(new ToolBarButtonSelectObject((ToolBarButton)jComponent));
                continue;
            }
            if (component instanceof ToggleButton) {
                jComponent = (ToggleButton)component;
                selectObjectVector.add(new ToolBarButtonSelectObject((ToggleButton)jComponent));
                continue;
            }
            if (component instanceof JToolBar.Separator) {
                logger.error("The component which get from ToolGroup can't cast type to ToolBarButton! The ToolBarButton : " + component.toString());
                continue;
            }
            if (component instanceof JComponent) {
                jComponent = (JComponent)component;
                if (jComponent instanceof ToolBarHandle) continue;
                Object object = jComponent.getClientProperty("iview.component.id");
                if (null == object) {
                    logger.error("Component dynamically added by user, it will not be managed by iView");
                    continue;
                }
                selectObjectVector.add(new JComponentSelectObject(jComponent));
                continue;
            }
            logger.error("The component which get from ToolGroup can't cast type to ToolBarButton! The ToolBarButton : " + component.toString());
        }
        return selectObjectVector;
    }

    @Override
    public String getText() {
        if (null != this.theToolGroup) {
            return this.theToolGroup.getName();
        }
        return super.getText();
    }
}

