/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.imap12.util.InmLengthLimitPasswordField;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.terminalmanagement.ITerminalManager;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSetting;
import com.swimap.iview.framework.terminalmanagement.LockDialog;
import com.swimap.iview.framework.terminalmanagement.MultilineLabel;
import com.swimap.iview.framework.terminalmanagement.ScreenLocker;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.templates.textfield.CharInputTextField;
import com.swimap.iview.templates.textfield.ValidCharDocument;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.SystemTray;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

public class UnlockDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(UnlockDialog.class, "IVIEW");
    protected ITerminalManager terminalManager = null;
    private static final int PRD_LENGTH = 16;
    private static final double DEFAULT_RELATIVE_TIP_POS = 0.7;
    private static int prdLength = 16;
    private String defaultMessage = IdleTimeSetting.res.getString("LockDialog_Terminal_Unlock");
    private MultilineLabel unlockMessageLabel = new MultilineLabel();
    private MultilineLabel lockTipLabel1 = new MultilineLabel(){

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }
    };
    protected JLabel emptyLabel = new JLabel();
    protected CharInputTextField userNameTextField = new CharInputTextField(0, Integer.MAX_VALUE, "");
    protected InmLengthLimitPasswordField passwordField = new InmLengthLimitPasswordField(prdLength);
    protected JButton okButton = new JButton();
    protected JButton cancelButton = new JButton();
    private boolean processingJustNow = false;
    private static final int UNLOCK_DIALOG_WIDTH = 445;
    private static final int UNLOCK_DIALOG_HEIGHT = 310;
    protected static final int USERNAME_LABEL_WIDTH = 81;
    protected static final int LABEL_HEIGHT = 20;
    protected static final int TEXTFIELD_WIDTH = 180;
    protected static final int TEXTFIELD_HEIGHT = 20;
    protected static final int BUTTON_HEIGHT = 21;
    static final int LOCK_ICON_HEIGHT = 65;
    private static String unlockDialogTitle = IdleTimeSetting.res.getString("UnlockDialog_Unlock_Terminal");
    private static boolean capsLockTipEnabled = false;
    private static double relativeCapsTipPos = 0.7;
    protected JPanel unlockPanel = null;

    public UnlockDialog(ITerminalManager iTerminalManager) {
        super((Frame)FrameworkUtilities.getMainFrame(), true);
        this.setName("UnlockDialog");
        if (this.getOwner() == null) {
            logger.error("the main frame is null, lock will not take effect!");
        }
        this.terminalManager = iTerminalManager;
        ValidCharDocument validCharDocument = new ValidCharDocument(prdLength, "");
        this.passwordField.setDocument(validCharDocument);
        this.jbInit();
    }

    private void jbInit() {
        this.initCommonProperties();
        this.initUI();
        ScreenToolKit.centerLocateToScreen(this);
    }

    protected void initUI() {
        this.setSize(new Dimension(445, 310));
        Icon icon = ResourceAdapter.getLockIcon();
        JLabel jLabel = new JLabel(icon);
        int n = icon.getIconHeight();
        n = n > 65 ? 65 : n;
        jLabel.setMaximumSize(new Dimension(445, n));
        jLabel.setMinimumSize(new Dimension(445, n));
        jLabel.setPreferredSize(new Dimension(445, n));
        JLabel jLabel2 = new JLabel(new ImageIcon(this.getClass().getResource("lockTerminal.gif")));
        this.unlockMessageLabel.setLineWrap(true);
        this.unlockMessageLabel.setSize(330, 36);
        this.unlockMessageLabel.setMinimumSize(new Dimension(330, 36));
        this.unlockMessageLabel.setMaximumSize(new Dimension(330, 36));
        this.unlockMessageLabel.setPreferredSize(new Dimension(330, 36));
        this.lockTipLabel1.setLineWrap(false);
        this.lockTipLabel1.setSize(330, 20);
        this.lockTipLabel1.setMaximumSize(new Dimension(330, 20));
        this.lockTipLabel1.setText(IdleTimeSetting.res.getString("LockDialog_Terminal_Is_In_Use"));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText(IdleTimeSetting.res.getString("UnlockDialog_User_Name_"));
        jLabel3.setPreferredSize(new Dimension(81, 20));
        this.userNameTextField.setPreferredSize(new Dimension(180, 20));
        this.userNameTextField.setMinimumSize(new Dimension(180, 20));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText(IdleTimeSetting.res.getString("UnlockDialog_Prd_"));
        jLabel4.setPreferredSize(new Dimension(81, 20));
        this.passwordField.setPreferredSize(new Dimension(180, 20));
        this.passwordField.setMinimumSize(new Dimension(180, 20));
        this.emptyLabel.setPreferredSize(new Dimension(81, 20));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.okButton, "West");
        jPanel.add((Component)this.cancelButton, "East");
        jPanel.setMinimumSize(new Dimension(180, 21));
        jPanel.setPreferredSize(new Dimension(180, 21));
        this.unlockPanel = new JPanel();
        HelpManager.getInstance().enableHelpKey(this.unlockPanel, "topics_getting_start_task_p_unlock_client");
        this.unlockPanel.setSize(new Dimension(445, 310));
        this.unlockPanel.setMaximumSize(new Dimension(445, 280));
        this.unlockPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.unlockPanel, "Center");
        this.unlockPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 20, 0), 0, 0));
        this.unlockPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 4, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 30), 0, 0));
        this.unlockPanel.add((Component)this.lockTipLabel1, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 10, 20), 0, 0));
        this.unlockPanel.add((Component)this.unlockMessageLabel, new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 20, 20), 0, 0));
        this.unlockPanel.add((Component)jLabel3, new GridBagConstraints(1, 3, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 8, 0), 0, 0));
        this.unlockPanel.add((Component)this.userNameTextField, new GridBagConstraints(2, 3, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 8, 20), 0, 0));
        this.unlockPanel.add((Component)jLabel4, new GridBagConstraints(1, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 13, 0), 0, 0));
        this.unlockPanel.add((Component)this.passwordField, new GridBagConstraints(2, 4, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 13, 20), 0, 0));
        this.unlockPanel.add((Component)this.emptyLabel, new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 17, 0, new Insets(0, 0, 13, 0), 0, 0));
        this.unlockPanel.add((Component)jPanel, new GridBagConstraints(2, 5, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 10, 13, 20), 0, 0));
        this.pack();
    }

    private void initCommonProperties() {
        char c;
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.userNameTextField.setText("");
        this.userNameTextField.setTooltipEnabled(false);
        this.userNameTextField.setEnabled(false);
        this.userNameTextField.setName("UnlockDialog_userNameTextField");
        this.passwordField.setText("");
        this.passwordField.setRelativeCapsTipPosition(relativeCapsTipPos);
        this.passwordField.setCapsLockTipEnabled(capsLockTipEnabled);
        this.passwordField.setName("UnlockDialog_prdField");
        if (this.terminalManager instanceof TerminalManager && (c = ((TerminalManager)this.terminalManager).getPasswordEchoChar()) != '\u0000') {
            this.passwordField.setEchoChar(c);
        }
        this.passwordField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                UnlockDialog.this.prdField_focusGained();
                Window window = null;
                if (UnlockDialog.this.userNameTextField.getHeight() < 15) {
                    logger.trace("IV:Correcting an abnormal size for Unlocker.");
                    try {
                        window = UnlockDialog.this.getWindowForComponent(focusEvent.getComponent());
                        if (null != window) {
                            window.pack();
                        }
                    }
                    catch (HeadlessException headlessException) {
                        logger.trace("IV:Exception while Correcting an abnormal size for Unlocker.");
                    }
                }
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                UnlockDialog.this.passwordField.selectAll();
                UnlockDialog.this.passwordField.requestFocus();
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                UnlockDialog.this.passwordField.selectAll();
                UnlockDialog.this.passwordField.requestFocus();
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                UnlockDialog.this.cancelButton_actionPerformed();
            }
        });
        if (Boolean.getBoolean("enabletrayicon") && SystemTray.isSupported()) {
            this.addWindowListener(FrameworkUtilities.getIconifyWindowListener());
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = UnlockDialog.this.getSize();
                if (dimension.width > 445 || dimension.height > 310) {
                    UnlockDialog.this.setSize(445, 310);
                }
                ScreenToolKit.centerLocateToScreen(UnlockDialog.this);
            }
        });
        this.okButton.setText(IdleTimeSetting.res.getString("UnlockDialog_Ok"));
        this.okButton.setName("UnlockDialog_okButton");
        this.okButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (UnlockDialog.this.okButton.isShowing()) {
                    JFrame jFrame = FrameworkUtilities.getMainFrame();
                    try {
                        ScreenToolKit.setComponentCursorBusy(jFrame, true);
                        UnlockDialog.this.okButton_actionPerformed();
                    }
                    catch (Throwable throwable) {
                        logger.trace("Error on Ok-action:", throwable);
                    }
                    finally {
                        ScreenToolKit.setComponentCursorBusy(jFrame, false);
                    }
                } else {
                    logger.trace("Unlock Dialog not visible:OK button clicked");
                }
            }
        });
        this.cancelButton.setText(IdleTimeSetting.res.getString("UnlockDialog_Cancel"));
        this.cancelButton.setName("UnlockDialog_cancelButton");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UnlockDialog.this.cancelButton_actionPerformed();
            }
        });
        ScreenToolKit.setDefaultButtons(this.okButton, this.cancelButton);
        JButton[] jButtonArray = new JButton[]{this.okButton, this.cancelButton};
        ScreenToolKit.setPreferredSizeofButtons(jButtonArray, 21);
        ScreenToolKit.setMaxSizeofButtons(jButtonArray, 21);
    }

    public void setUserName(String string) {
        TerminalManager terminalManager = (TerminalManager)this.terminalManager;
        String string2 = terminalManager.getLockDialogMessage();
        this.userNameTextField.setText(string);
        if (string2 != null) {
            string = string2;
        }
        this.userNameTextField.setEnabled(terminalManager.isUsernameEnabled());
        String string3 = ((TerminalManager)this.terminalManager).getUnlockMessage();
        MessageFormat messageFormat = new MessageFormat(this.defaultMessage);
        String string4 = messageFormat.format(new String[]{string});
        if (this.lengthOfText(string4, this.unlockMessageLabel) <= this.unlockMessageLabel.getWidth()) {
            string4 = string4 + System.getProperty("line.separator");
        }
        if (string3 == null) {
            Font font = UIManager.getFont("Label.font");
            string4 = ScreenToolKit.getLineWrapString(string4, 640, font);
            this.unlockMessageLabel.setText(string4, string4, 640);
        } else {
            if (this.lengthOfText(string3, this.unlockMessageLabel) <= this.unlockMessageLabel.getWidth()) {
                string3 = string3 + System.getProperty("line.separator");
            }
            this.unlockMessageLabel.setText(string3, string4, 640);
        }
    }

    public static void setPasswordLength(int n) {
        if (prdLength < 0) {
            throw new IllegalArgumentException();
        }
        prdLength = n;
    }

    protected void okButton_actionPerformed() {
        logger.debug("come in action. processingJustNow=" + this.processingJustNow);
        if (this.processingJustNow || ScreenLocker.getInstance().getScreenState() != 2 || !this.unlockPanel.isVisible()) {
            logger.debug("return okButton_actionPerformed. processingJustNow=" + this.processingJustNow + "  visible=" + this.unlockPanel.isVisible() + " ScreenState=" + ScreenLocker.getInstance().getScreenState());
            return;
        }
        this.processingJustNow = true;
        if (this.terminalManager != null && this.terminalManager instanceof TerminalManager) {
            ((TerminalManager)this.terminalManager).setUnlockUsername(this.userNameTextField.getText());
            char[] cArray = this.passwordField.getPassword();
            if (((TerminalManager)this.terminalManager).validateUser(this.userNameTextField.getText(), cArray)) {
                InternalFrame internalFrame;
                this.passwordField.setText("keep smilling");
                this.passwordField.setText("");
                this.presetPanelVisible(false);
                ScreenLocker.getInstance().setScreenState(0);
                ((TerminalManager)this.terminalManager).restart();
                ((TerminalManager)this.terminalManager).setIdleTimeLeft(1);
                logger.debug(" validateUser() return true!");
                if (FrameworkUtilities.getMainFrame().getState() == 1) {
                    FrameworkUtilities.getMainFrame().setState(0);
                }
                if (FrameworkCommandProcessor.getInstance().isAppStyle() && !((TerminalManager)this.terminalManager).isMainwindowVisibleOnLock() && null != (internalFrame = (InternalFrame)FrameworkUtilities.getWindowManager().getActiveWindow()) && internalFrame.isVisible()) {
                    ApplicationLauncher.getAppLauncher().updateMDIFrame(internalFrame.getAppID());
                    ((MDIFrame)FrameworkUtilities.getMainFrame()).updateCoolbar(internalFrame.getWindowId(), internalFrame.isMaximum());
                    logger.debug("client is unlocked and MDIFrame is updated ");
                }
            } else {
                this.passwordField.setText("keep smilling");
                this.passwordField.setText("");
                this.passwordField.requestFocus();
                logger.debug(" validateUser() return false!");
            }
            if (null != cArray) {
                for (int i = 0; i < cArray.length; ++i) {
                    cArray[i] = '\u0000';
                }
            }
            this.processingJustNow = false;
            ToolTipManager.sharedInstance().setEnabled(false);
            ToolTipManager.sharedInstance().setEnabled(true);
        }
    }

    protected void cancelButton_actionPerformed() {
        if (this.processingJustNow || ScreenLocker.getInstance().getScreenState() != 2) {
            return;
        }
        this.passwordField.setText("");
        this.presetPanelVisible(false);
        this.terminalManager.lockTerminal();
        ToolTipManager.sharedInstance().setEnabled(false);
        ToolTipManager.sharedInstance().setEnabled(true);
    }

    private void prdField_focusGained() {
        this.passwordField.selectAll();
    }

    @Override
    public void dispose() {
        this.processingJustNow = false;
        super.dispose();
    }

    void setUserNameLength(int n) {
        this.userNameTextField.setLengthRange(0, n);
    }

    @Override
    public void setVisible(boolean bl) {
        this.presetPanelVisible(bl);
        super.setVisible(bl);
    }

    protected void presetPanelVisible(boolean bl) {
        if (bl) {
            String string;
            LockDialog lockDialog = ((TerminalManager)this.terminalManager).theLockDialog;
            if (lockDialog != null && !ResourceUtil.areEquals(string = lockDialog.lockTipLabel.getText(), this.lockTipLabel1.getText())) {
                String string2 = ((TerminalManager)this.terminalManager).getTerminalIsLockedString();
                if (null != string2) {
                    if (!ResourceUtil.areEquals(string2 = ScreenToolKit.getLineWrapString(string2, 330, this.lockTipLabel1.getFont(), true), string)) {
                        this.lockTipLabel1.setToolTipText(string2);
                    } else {
                        this.lockTipLabel1.setToolTipText(null);
                    }
                } else {
                    this.lockTipLabel1.setToolTipText(this.lockTipLabel1.getText());
                }
                this.lockTipLabel1.setText(string);
            }
            this.setTitle(unlockDialogTitle);
            CommonUtil.hideShowTooltip();
        }
    }

    boolean isPanelShowing() {
        if (this.unlockPanel != null) {
            return this.unlockPanel.isShowing();
        }
        return false;
    }

    static String getUnlockDialogTitle() {
        return unlockDialogTitle;
    }

    static void setUnlockDialogTitle(String string) {
        unlockDialogTitle = string;
    }

    Component getUnlockFocusOwner() {
        return this.passwordField;
    }

    JPanel getUnlockPanel() {
        return this.unlockPanel;
    }

    private int lengthOfText(String string, JComponent jComponent) {
        return SwingUtilities.computeStringWidth(jComponent.getFontMetrics(jComponent.getFont()), string);
    }

    public void setFocusOnUserName() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnlockDialog.this.userNameTextField.requestFocus();
                UnlockDialog.this.userNameTextField.selectAll();
            }
        });
    }

    public void setFocusOnPasswordField() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UnlockDialog.this.passwordField.requestFocus();
            }
        });
    }

    static void setCapsLockTipEnabled(boolean bl) {
        capsLockTipEnabled = bl;
    }

    static void setRelativeCapsTipPos(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("The pos value should lie between 0 and 1");
        }
        relativeCapsTipPos = d;
    }

    public void cleanupWhileOSGIExit() {
        int n;
        ActionListener[] actionListenerArray = this.okButton.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.okButton.removeActionListener(actionListenerArray[n]);
            actionListenerArray[n] = null;
        }
        actionListenerArray = this.cancelButton.getActionListeners();
        for (n = 0; n < actionListenerArray.length; ++n) {
            this.cancelButton.removeActionListener(actionListenerArray[n]);
            actionListenerArray[n] = null;
        }
        FocusListener[] focusListenerArray = this.passwordField.getFocusListeners();
        for (int i = 0; i < focusListenerArray.length; ++i) {
            this.passwordField.removeFocusListener(focusListenerArray[i]);
            focusListenerArray[i] = null;
        }
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
            windowListenerArray[i] = null;
        }
        ComponentListener[] componentListenerArray = this.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            this.removeComponentListener(componentListenerArray[i]);
            componentListenerArray[i] = null;
        }
        this.unlockMessageLabel.removeAll();
        this.unlockMessageLabel.setToolTipText(null);
        this.unlockMessageLabel = null;
        this.lockTipLabel1.removeAll();
        this.lockTipLabel1.setToolTipText(null);
        this.lockTipLabel1 = null;
    }

    private Window getWindowForComponent(Component component) throws HeadlessException {
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return this.getWindowForComponent(component.getParent());
    }
}

