/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.commstyle.commandmng.CommandManager;
import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.InternalLocalMsg;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.terminalmanagement.EventMonitor;
import com.swimap.iview.framework.terminalmanagement.FullScrnPasswdDialog;
import com.swimap.iview.framework.terminalmanagement.ITerminalManager;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSetting;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSettingPanel;
import com.swimap.iview.framework.terminalmanagement.LockDialog;
import com.swimap.iview.framework.terminalmanagement.ScreenLocker;
import com.swimap.iview.framework.terminalmanagement.ScreenStateChangeListener;
import com.swimap.iview.framework.terminalmanagement.UnlockDialog;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.windowmanagement.InternalFrame;
import com.swimap.iview.templates.textfield.IntegerDocument;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Window;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omg.CORBA.ORB;

public class TerminalManager
extends BaseModule
implements ITerminalManager {
    private static IviewLogger logger = IviewLogger.getLogger(TerminalManager.class, "IVIEW");
    private int suspendID = 0;
    public EventMonitor theEventMonitor = null;
    public LockDialog theLockDialog = null;
    public UnlockDialog theUnlockDialog = null;
    private FullScrnPasswdDialog fullScrnPasswdDlg = null;
    private Vector suspendIDVct = new Vector(10);
    public IdleTimeSetting theIdleTimeSetting;
    private boolean autoLockFlg = true;
    private int terminalSettingkey = -1;
    private boolean usernameEnabled = false;
    private String username = null;
    private static final String CLIENT_SETTING_CLASSNAME = "com.swimap.iview.framework.terminalmanagement.IdleTimeSetting";
    private static final String CLIENT_SETTING_SEQUENCEID = "6110";
    private static final int NO_TIME_LEFT = 0;
    private CommStyleInfo commStyleInfo = null;
    private int idleTime = 0;
    private int idleTimeLeft = 0;
    private String lockMessage = null;
    private static final int MAX_LOCK_MESSAGE_LENGTH = 80;
    private String terminalIsLockedString = null;
    private String unlockMessage = null;
    private int userNameLengh = 0;
    private boolean pauseFlag = false;
    private ScreenStateChangeListener screenStateListener = null;
    private boolean mainwindowvisibleOnLock = false;
    private boolean fullScreenEnabled = false;
    private InternalFrame iFrmWhichWasinFullScreenMode = null;
    public static boolean isFailed = false;
    private char passwrdEchoChar = '\u0000';
    private boolean isLockSettingEnable = true;
    private static final int DEFAULT_IDLE_TIME = 3;
    private static final String LOCK_COMMAND_ID = "mainframe:lockterminal";
    private static final String GLOBAL_SETTING_STYLE_FILE = "conf/mainfrm/globalIdleTimeSetting";
    private static final String GLOBAL_SETTING_DESC_NAME = "globalIdleTimesetting";
    private static final String GLOBAL_SETTING_PARA_ENABLE_NAME = "isEnabled";
    private static final String GLOBAL_SETTING_IDLE_TIME = "idleTime";
    private boolean isGlobalAutoLockEnabled = false;
    private ThreadLocal<Boolean> globalThreadLocal = new ThreadLocal();
    private boolean disableSaveToFile = false;

    public TerminalManager(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.register(this);
        this.terminalSettingkey = FrameworkUtilities.getSystemSettingsManager().addClientModuleSettingsWithSequence(CLIENT_SETTING_SEQUENCEID, CLIENT_SETTING_CLASSNAME, this.getModuleName());
        this.theIdleTimeSetting = (IdleTimeSetting)FrameworkUtilities.getSystemSettingsManager().find(IdleTimeSetting.res.getString("Lock_Settings"));
    }

    public TerminalManager(ModuleManager moduleManager) throws ModuleManagementException {
        this(moduleManager, null, null, null);
    }

    @Override
    public String getModuleName() {
        return "mainterminalmanager";
    }

    public void setMainWindowVisibleOnLock(boolean bl) {
        this.mainwindowvisibleOnLock = bl;
        IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel();
        if (idleTimeSettingPanel.mainWindowVisibilityCheckBox.isSelected() == bl) {
            return;
        }
        idleTimeSettingPanel.setMainWindowVisibility(this.mainwindowvisibleOnLock);
        this.saveMainWindowVisibilityToConfingure(this.mainwindowvisibleOnLock);
    }

    public boolean isMainwindowVisibleOnLock() {
        return this.mainwindowvisibleOnLock;
    }

    @Override
    public void lockTerminal() {
        if (this.pauseFlag) {
            return;
        }
        CommonUtil.hideShowTooltip();
        String string = "start to lock Terminal.";
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        if (null != stackTraceElementArray && stackTraceElementArray.length > 2) {
            string = string + " Calling class: " + stackTraceElementArray[2];
        }
        logger.debug(string);
        if (!FrameworkCommandProcessor.getInstance().isLogin()) {
            logger.debug("Has not login, return.");
            return;
        }
        this.theEventMonitor.stopTimer();
        this.setIdleTimeLeft(0);
        if (this.theLockDialog == null) {
            this.theLockDialog = new LockDialog(this);
        }
        if (this.theUnlockDialog == null) {
            this.theUnlockDialog = new UnlockDialog(this);
            if (this.userNameLengh != 0) {
                this.theUnlockDialog.setUserNameLength(this.userNameLengh);
            }
        }
        JFrame jFrame = null;
        jFrame = ScreenToolKit.getFullScreenFlg() ? ScreenToolKit.getMDIFrame() : FrameworkUtilities.getMainFrame();
        this.addScreenStateListener(jFrame, this.theLockDialog, this.theUnlockDialog);
        logger.trace("-----broadcast lock event-----");
        try {
            this.broadcastEvent(new InternalLocalMsg(this.getModuleName(), 201));
        }
        catch (Throwable throwable) {
            logger.trace("Exception while brodcasting the lock terminal.");
            logger.error(throwable.getMessage(), throwable);
        }
        ScreenToolKit.centerLocateToScreen(this.theLockDialog);
        if (ScreenToolKit.getFullScreenFlg()) {
            this.fullScreenEnabled = true;
            this.iFrmWhichWasinFullScreenMode = (InternalFrame)FrameworkUtilities.getWindowManager().getDesktopPane().getSelectedFrame();
            if (!this.isMainwindowVisibleOnLock()) {
                ScreenToolKit.closeFullScreenFrame(true);
            }
        } else {
            this.fullScreenEnabled = false;
        }
        this.theLockDialog.presetPanelVisible(true);
        this.theLockDialog.addUnlockListener();
        if (this.isMainwindowVisibleOnLock()) {
            if (jFrame.getState() == 1) {
                jFrame.setState(0);
            }
            if (SwingUtilities.isEventDispatchThread()) {
                if (this.theUnlockDialog != null && this.theUnlockDialog.isVisible()) {
                    this.theUnlockDialog.setVisible(false);
                }
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (TerminalManager.this.theUnlockDialog != null && TerminalManager.this.theUnlockDialog.isVisible()) {
                            TerminalManager.this.theUnlockDialog.setVisible(false);
                        }
                    }
                });
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenLocker.getInstance().setScreenState(1);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenLocker.getInstance().setScreenState(1);
                }
            });
        }
    }

    @Override
    public void enableIdleTimer(boolean bl) {
        if (this.theEventMonitor != null) {
            if (bl) {
                logger.trace("enable timer " + bl);
                this.theEventMonitor.startTimer();
            } else {
                logger.trace("stop timer " + bl);
                this.theEventMonitor.stopTimer();
            }
        }
    }

    @Override
    public void unlockTerminal() {
        logger.debug("start to unlock Terminal");
        if (!FrameworkCommandProcessor.getInstance().isLogin()) {
            logger.debug("Has not login, return.");
            return;
        }
        if (ScreenLocker.getInstance().getScreenState() != 1) {
            logger.trace("Invalid screen state to unlock.");
            return;
        }
        if (this.theLockDialog != null) {
            this.theLockDialog.presetPanelVisible(false);
            this.theLockDialog.removeUnlockListener();
        }
        this.setUserDetails(this.theUnlockDialog);
        ScreenToolKit.centerLocateToScreen(this.theUnlockDialog);
        this.theUnlockDialog.presetPanelVisible(true);
        if (SwingUtilities.isEventDispatchThread()) {
            if (null != this.theLockDialog && this.theLockDialog.isVisible()) {
                this.theLockDialog.setVisible(false);
            }
            ScreenLocker.getInstance().setScreenState(2);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != TerminalManager.this.theLockDialog && TerminalManager.this.theLockDialog.isVisible()) {
                        TerminalManager.this.theLockDialog.setVisible(false);
                    }
                    ScreenLocker.getInstance().setScreenState(2);
                }
            });
        }
    }

    private void setUserDetails(UnlockDialog unlockDialog) {
        try {
            SecurityService securityService = (SecurityService)this.getReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, "");
            String string = securityService.getUsername();
            unlockDialog.setUserName(string);
            unlockDialog.passwordField.setText("");
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    @Override
    public int getIdleTime() {
        return this.idleTime;
    }

    @Override
    public void restart() {
        if (this.theEventMonitor == null) {
            logger.trace("The Event Monitor is null, but executed restart()");
            return;
        }
        if (ScreenLocker.getInstance().getScreenState() == 0) {
            this.theEventMonitor.restartTimer();
        }
    }

    public void pauseLockWindow() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.pauseLockTimer();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    TerminalManager.this.pauseLockTimer();
                }
            });
        }
    }

    private void pauseLockTimer() {
        logger.trace("pause lock window called.");
        Thread.dumpStack();
        this.stopTimer();
        this.cancelLockWindow();
        this.setIdleTimeLeft(1);
        this.pauseFlag = true;
        ((IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel()).lockCheckBox.setSelected(false);
        ((IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel()).lockCheckBox.setEnabled(false);
        ((IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel()).mainWindowVisibilityCheckBox.setSelected(false);
        ((IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel()).mainWindowVisibilityCheckBox.setEnabled(false);
        this.enableFullScreenToolBarButton(false);
    }

    public void resumeLockWindow() {
        logger.trace("resume lock window called.");
        Thread.dumpStack();
        int n = this.getIdleTime();
        if (n > 0 && this.isLockSettingEnable() && this.theEventMonitor != null) {
            logger.trace("Event Monitor is not null, & terminal lock time is: " + n);
            this.restart();
        }
        this.pauseFlag = false;
        this.theIdleTimeSetting.reinitialize();
        this.enableFullScreenToolBarButton(true);
    }

    private synchronized void cancelLockWindow() {
        int n;
        Window[] windowArray;
        if (this.theLockDialog != null && this.theLockDialog.isPanelShowing()) {
            logger.debug("invoke the EventMonitor's cancelLockWindow method to close LockDialog.");
            windowArray = this.theLockDialog.getOwnedWindows();
            for (n = 0; n < windowArray.length; ++n) {
                windowArray[n].dispose();
            }
            this.theLockDialog.dispose();
            ScreenLocker.getInstance().setScreenState(0);
        }
        if (this.theUnlockDialog != null && this.theUnlockDialog.isPanelShowing()) {
            logger.debug("invoke the EventMonitor's cancelLockWindow method to close UnlockDialog.");
            windowArray = this.theUnlockDialog.getOwnedWindows();
            for (n = 0; n < windowArray.length; ++n) {
                windowArray[n].dispose();
            }
            this.theUnlockDialog.presetPanelVisible(false);
            ScreenLocker.getInstance().setScreenState(0);
        }
    }

    @Override
    public void clear() {
        if (this.theEventMonitor != null) {
            this.theEventMonitor.clear();
            this.theEventMonitor = null;
        }
        if (this.theLockDialog != null) {
            this.theLockDialog.dispose();
        }
        if (this.theUnlockDialog != null) {
            this.theUnlockDialog.dispose();
        }
        this.pauseFlag = false;
        ScreenLocker.getInstance().setScreenState(0);
        this.removeScreenStateListener();
    }

    @Override
    public void stop() {
        this.clear();
    }

    @Override
    public synchronized void reinitialize() {
        this.globalThreadLocal.set(true);
        if (FrameworkUtilities.isFullScreenMode()) {
            this.setIdleTime(0);
        }
        this.idleTime = this.getIdleTimeFromConfigure();
        if (this.getLockSettingFromConfigure()) {
            this.isLockSettingEnable = true;
            if (this.idleTime == 0) {
                this.isLockSettingEnable = false;
                this.setIdleTime(0);
            }
        } else {
            this.isLockSettingEnable = false;
        }
        if (this.idleTime <= 0) {
            this.isLockSettingEnable = false;
            this.idleTime = 3;
            this.setIdleTime(this.idleTime);
        }
        if (this.readGlobalAutoLockSetting()) {
            this.idleTime = this.getGloabalIdleTimeFromConfig();
            JPanel jPanel = this.theIdleTimeSetting.getSettingsPanel();
            if (jPanel instanceof IdleTimeSettingPanel) {
                IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)jPanel;
                idleTimeSettingPanel.enableLockSettingPanel(false);
                this.isGlobalAutoLockEnabled = true;
            }
        }
        if (this.theEventMonitor == null) {
            this.theEventMonitor = new EventMonitor(this);
        } else {
            logger.trace("Reinitialize method, theEventMonitor is not renewed.");
        }
        this.globalThreadLocal.set(false);
    }

    @Override
    public void setIdleTime(int n) {
        if (!this.isProcessSetApi()) {
            logger.trace("Global auto lock is enabled hence operation is denied!");
            return;
        }
        if (!this.isValidTime(n)) {
            logger.trace("Idle time :" + n + " is not a valid time!");
            return;
        }
        logger.trace("Idle time set to " + n);
        this.idleTime = n;
        IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)this.theIdleTimeSetting.getSettingsPanel();
        idleTimeSettingPanel.setIdleTime(this.idleTime);
        this.saveIdleTimeToConfingure(this.idleTime);
        if (!isFailed) {
            this.startLockTimerWithCheck();
        }
        if (this.isGlobalAutoLockEnabled) {
            this.saveGlobalAutoLockSetting();
        }
    }

    private void startLockTimerWithCheck() {
        if (this.theEventMonitor != null) {
            logger.trace("Stopping EventMonitor ");
            this.theEventMonitor.setEnable(false);
            this.theEventMonitor.stopTimer();
            if (this.isLockSettingEnable && FrameworkCommandProcessor.getInstance().getProgressDialog(true) == null) {
                this.theEventMonitor.doStartTimer();
            }
        }
    }

    public void stopTimer() {
        if (this.theEventMonitor != null) {
            logger.debug("invoke the EventMonitor's stopTimer method.");
            this.theEventMonitor.stopTimer();
        }
    }

    public void setIdleTimeTemp(int n) {
        if (!this.isProcessSetApi()) {
            logger.trace("Global auto lock is enabled hence operation is denied!");
            return;
        }
        this.idleTime = n;
        this.theEventMonitor.setEnable(false);
        this.theEventMonitor.stopTimer();
        this.theEventMonitor.doStartTimer();
    }

    public boolean validateUser(String string, char[] cArray) {
        SecurityService securityService = null;
        try {
            securityService = (SecurityService)this.getReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, "");
        }
        catch (ModuleManagementException moduleManagementException) {
            logger.trace(moduleManagementException.getMessage(), moduleManagementException);
            return false;
        }
        try {
            logger.debug("Begin invoke verifyPassword.");
            if (securityService.verifyPassword(cArray)) {
                logger.debug("END invoke verifyPassword and return true.");
                logger.trace("-----broadcast unlock event-----");
                this.broadcastEvent(new InternalLocalMsg(this.getModuleName(), 202));
                return true;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            logger.debug("END invoke verifyPassword and return false.");
            return false;
        }
        logger.debug("END invoke verifyPassword and return false.");
        return false;
    }

    public int suspend() {
        int n = this.suspendID++;
        this.suspendIDVct.add(String.valueOf(n));
        this.theEventMonitor.setBusy(true);
        return n;
    }

    public void resume(int n) {
        this.suspendIDVct.remove(String.valueOf(n));
        if (this.suspendIDVct.isEmpty()) {
            this.theEventMonitor.setBusy(false);
        }
    }

    int getIdleTimeFromConfigure() {
        int n = 0;
        try {
            this.commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/terminalmanager");
            DescContainer descContainer = this.commStyleInfo.getAreaDescContainer(0).getDescContainer("idleTimeSetting");
            n = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue(GLOBAL_SETTING_IDLE_TIME), Integer.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return n;
    }

    int getGloabalIdleTimeFromConfig() {
        int n = 3;
        try {
            AreaDescContainer areaDescContainer;
            DescContainer descContainer;
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAllUsersCommonStyleFile(GLOBAL_SETTING_STYLE_FILE);
            if (null != commStyleInfo && !this.isValidTime(n = ((Integer)TypeConverter.getParameter((descContainer = (areaDescContainer = commStyleInfo.getAreaDescContainer()[0]).getDescContainer(GLOBAL_SETTING_DESC_NAME)).getParasItemValue(GLOBAL_SETTING_IDLE_TIME), Integer.class)).intValue())) {
                n = 3;
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return n;
    }

    boolean getLockSettingFromConfigure() {
        boolean bl = true;
        try {
            this.commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/terminalmanager");
            DescContainer descContainer = this.commStyleInfo.getAreaDescContainer(0).getDescContainer("idleTimeSetting");
            if (descContainer.getParasItemValue("isLockSettingEnable") == null) {
                return bl;
            }
            bl = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("isLockSettingEnable"), Boolean.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return bl;
    }

    private synchronized void saveIdleTimeToConfingure(int n) {
        try {
            DescContainer descContainer;
            PARA pARA;
            isFailed = false;
            if (this.commStyleInfo == null) {
                this.commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/terminalmanager");
            }
            String string = (pARA = (descContainer = this.commStyleInfo.getAreaDescContainer(0).getDescContainer("idleTimeSetting")).getParasItem(GLOBAL_SETTING_IDLE_TIME)) == null ? "" : pARA.getValue();
            PARA pARA2 = descContainer.getParasItem("isLockSettingEnable");
            String string2 = pARA2 == null ? "" : pARA2.getValue();
            String string3 = String.valueOf(n);
            String string4 = String.valueOf(this.isLockSettingEnable);
            if (string4.equals(string2) && string3.equals(string)) {
                return;
            }
            logger.trace("Save IdleTime " + n);
            descContainer.setParasItem(GLOBAL_SETTING_IDLE_TIME, String.valueOf(n), true);
            descContainer.setParasItem("isLockSettingEnable", String.valueOf(this.isLockSettingEnable), true);
            try {
                if (!this.disableSaveToFile) {
                    CommStyleManager.getInstance().writeToServer(this.commStyleInfo);
                }
            }
            catch (IOException iOException) {
                isFailed = true;
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    void setDisableSaveToFile(boolean bl) {
        this.disableSaveToFile = bl;
    }

    void saveFileNoCheck() {
        try {
            if (this.commStyleInfo == null) {
                this.commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile("conf/mainfrm/terminalmanager");
            }
            CommStyleManager.getInstance().writeToServer(this.commStyleInfo);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    void saveMainWindowVisibilityToConfingure(boolean bl) {
        isFailed = false;
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        if (null == this.commStyleInfo) {
            this.commStyleInfo = commStyleManager.getCommonStyleFile("conf/mainfrm/terminalmanager");
        }
        DescContainer descContainer = this.commStyleInfo.getAreaDescContainer(1).getDescContainer("mainWindowVisibilitySetting");
        descContainer.setParasItem("mainWindowVisible", String.valueOf(bl), true);
        try {
            if (!this.disableSaveToFile) {
                commStyleManager.writeToServer(this.commStyleInfo);
            }
        }
        catch (IOException iOException) {
            isFailed = true;
        }
    }

    private void saveGlobalAutoLockSetting() {
        Object object;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAllUsersCommonStyleFile(GLOBAL_SETTING_STYLE_FILE);
        DescContainer descContainer = null;
        if (null == commStyleInfo) {
            commStyleInfo = new CommStyleInfo();
            object = new AreaDescContainer();
            descContainer = new DescContainer(GLOBAL_SETTING_DESC_NAME);
            ((AreaDescContainer)object).addDescContainer(descContainer);
            commStyleInfo.addAreaDescContainer((AreaDescContainer)object);
        } else {
            object = commStyleInfo.getAreaDescContainer()[0];
            descContainer = ((AreaDescContainer)object).getDescContainer(GLOBAL_SETTING_DESC_NAME);
        }
        descContainer.setParasItem(GLOBAL_SETTING_PARA_ENABLE_NAME, String.valueOf(this.isGlobalAutoLockEnabled), true);
        descContainer.setParasItem(GLOBAL_SETTING_IDLE_TIME, String.valueOf(this.idleTime), true);
        object = "style/all users/conf/mainfrm/globalIdleTimeSetting.xml";
        commStyleInfo.setFileName((String)object);
        commStyleInfo.writeToAllUsers();
    }

    boolean readGlobalAutoLockSetting() {
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAllUsersCommonStyleFile(GLOBAL_SETTING_STYLE_FILE);
            if (null != commStyleInfo) {
                AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer()[0];
                DescContainer descContainer = areaDescContainer.getDescContainer(GLOBAL_SETTING_DESC_NAME);
                String string = descContainer.getParasItemValue(GLOBAL_SETTING_PARA_ENABLE_NAME);
                return Boolean.valueOf(string);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return false;
    }

    @Override
    public int getIdleTimeLeft() {
        if (!this.theEventMonitor.isTimerRunning()) {
            return -1;
        }
        return this.idleTimeLeft;
    }

    public boolean isTerminalLocked() {
        return this.idleTimeLeft == 0;
    }

    @Override
    public void setIdleTimeLeft(int n) {
        this.idleTimeLeft = n;
    }

    @Override
    protected void postSystemLoadingFinished() {
        if (this.autoLockFlg && !this.pauseFlag) {
            FrameworkUtilities.getSystemSettingsManager().setSettingEnable(this.terminalSettingkey, this.autoLockFlg);
        }
    }

    public void setLockDialogMessage(String string) {
        if (null != string) {
            if (string.length() <= 80) {
                this.lockMessage = string;
            } else {
                logger.debug("Message length must be less than or equal to 80 ");
            }
        } else {
            logger.debug("setLockDialogMessage input param lockMsg is null ");
        }
    }

    public String getLockDialogMessage() {
        return this.lockMessage;
    }

    public void setUsernameEnabled(boolean bl) {
        this.usernameEnabled = bl;
    }

    final boolean isUsernameEnabled() {
        return this.usernameEnabled;
    }

    final void setUnlockUsername(String string) {
        this.username = string;
    }

    public String getUnlockUsername() {
        return this.username;
    }

    public void setAutoLockEnabled(boolean bl) {
        if (!this.isProcessSetApi()) {
            logger.trace("Global auto lock is enabled hence operation is denied!");
            return;
        }
        this.autoLockFlg = bl;
        FrameworkUtilities.getSystemSettingsManager().setSettingEnable(this.terminalSettingkey, this.autoLockFlg);
        this.enableIdleTimer(this.autoLockFlg);
    }

    public void setUnlockMessage(String string) {
        this.unlockMessage = string;
    }

    public String getUnlockMessage() {
        return this.unlockMessage;
    }

    public void setIdleTimeRange(int n, int n2) {
        logger.debug("set idle time with params:min=" + n + ";max=" + n2);
        if (n < 1 || n2 < 1 || n >= n2) {
            throw new IllegalArgumentException("The parameters min < 1 or max < 1 or min >= max.");
        }
        if (this.theIdleTimeSetting == null) {
            logger.debug("theIdleTimeSetting is null.");
            return;
        }
        this.theIdleTimeSetting.setIdleTimeRange(n, n2);
    }

    public void setUserNameLength(int n) {
        logger.debug("set username field's max length =" + n);
        if (n <= 0) {
            throw new IllegalArgumentException("The parameter 'length' <= 0.");
        }
        this.userNameLengh = n;
    }

    public void setLockDialogTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null.");
        }
        LockDialog.setLockDialogTitle(string);
        logger.debug("Set lock dialog title to: " + string);
    }

    public void setUnlockDialogTitle(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Title cannot be null.");
        }
        UnlockDialog.setUnlockDialogTitle(string);
        logger.debug("Set unlock dialog title to: " + string);
    }

    public String getLockDialogTitle() {
        String string = LockDialog.getLockDialogTitle();
        logger.debug("return lock dialog title is: " + string);
        return string;
    }

    public String getUnlockDialogTitle() {
        String string = UnlockDialog.getUnlockDialogTitle();
        logger.debug("return unlock dialog title is: " + string);
        return string;
    }

    public void setTerminalIsLockedString(String string) {
        this.terminalIsLockedString = string;
    }

    String getTerminalIsLockedString() {
        return this.terminalIsLockedString;
    }

    private void addScreenStateListener(JFrame jFrame, LockDialog lockDialog, UnlockDialog unlockDialog) {
        if (this.screenStateListener == null) {
            this.screenStateListener = new ScreenStateChangeListener(jFrame, lockDialog, unlockDialog);
            ScreenLocker.getInstance().addScreenStateChangeListener("ScreenState", this.screenStateListener);
        }
    }

    private void removeScreenStateListener() {
        if (this.screenStateListener != null) {
            ScreenLocker.getInstance().removeScreenStateChangeListener("ScreenState", this.screenStateListener);
            this.screenStateListener = null;
        }
    }

    public boolean removeTerminalSetting() {
        if (!this.isProcessSetApi()) {
            logger.trace("Global auto lock is enabled hence operation is denied!");
            return false;
        }
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        if (systemSettingsManager == null || this.terminalSettingkey < 0) {
            return false;
        }
        return systemSettingsManager.removeSetting(this.terminalSettingkey);
    }

    public void setFocusOnUserName() {
        if (null == this.theUnlockDialog) {
            logger.debug(" Unlock dialog is null");
            return;
        }
        if (!this.isUsernameEnabled()) {
            logger.debug(" UserName Field is not Enabled to set the focus");
            return;
        }
        this.theUnlockDialog.setFocusOnUserName();
    }

    public void setFocusOnPasswordField() {
        if (null == this.theUnlockDialog) {
            logger.debug(" Unlock dialog is null");
            return;
        }
        this.theUnlockDialog.setFocusOnPasswordField();
    }

    public void setCapsLockTipEnabled(boolean bl) {
        UnlockDialog.setCapsLockTipEnabled(bl);
        if (null != this.theUnlockDialog) {
            this.theUnlockDialog.passwordField.setCapsLockTipEnabled(bl);
        }
    }

    public void setRelativeCapsTipPosition(double d) {
        UnlockDialog.setRelativeCapsTipPos(d);
        if (null != this.theUnlockDialog) {
            this.theUnlockDialog.passwordField.setRelativeCapsTipPosition(d);
        }
    }

    public boolean validatePassword() {
        if (null == this.fullScrnPasswdDlg || !this.fullScrnPasswdDlg.isValid()) {
            this.fullScrnPasswdDlg = new FullScrnPasswdDialog(this);
        }
        this.setUserDetails(this.fullScrnPasswdDlg);
        if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled() && ScreenToolKit.getGlassPane().isVisible()) {
            ScreenToolKit.getGlassPane().deactivate();
        }
        this.fullScrnPasswdDlg.setVisible(true);
        return this.fullScrnPasswdDlg.isValidUser();
    }

    public InternalFrame getFullScreenEnabledInternalFrame() {
        return this.iFrmWhichWasinFullScreenMode;
    }

    public boolean isFullScreenEnabledForInternalFrame() {
        return this.fullScreenEnabled;
    }

    public char getPasswordEchoChar() {
        return this.passwrdEchoChar;
    }

    public void setPasswordEchoChar(char c) {
        this.passwrdEchoChar = c;
    }

    public boolean isFullScrnPasswdDialogShow() {
        if (this.fullScrnPasswdDlg != null) {
            return this.fullScrnPasswdDlg.isFullScrnPasswdDialogShow();
        }
        return false;
    }

    public boolean isPauseFlag() {
        return this.pauseFlag;
    }

    private void enableFullScreenToolBarButton(boolean bl) {
        ArrayList arrayList = CommandManager.getInstance().getAbstractButton(LOCK_COMMAND_ID);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            AbstractButton abstractButton = (AbstractButton)arrayList.get(i);
            if (abstractButton == null) continue;
            abstractButton.setEnabled(bl);
        }
    }

    public boolean isLockOrUnLockDialogshown() {
        boolean bl = false;
        int n = ScreenLocker.getInstance().getScreenState();
        if (1 == n || 2 == n) {
            bl = true;
        }
        return bl;
    }

    public void hideOwnedVisibleWindows(JFrame jFrame) {
        if (null == jFrame) {
            return;
        }
        ScreenLocker.getInstance().hideOwnedVisibleWindows(jFrame);
    }

    public void showOwnedVisibleWindows(JFrame jFrame) {
        if (null == jFrame || null == jFrame.getPeer()) {
            return;
        }
        ScreenLocker.getInstance().showOwnedVisibleWindows(jFrame);
        jFrame.getPeer().setVisible(true);
        jFrame.setState(0);
        jFrame.toFront();
    }

    public void setLockSettingEnable(boolean bl) {
        if (!this.isProcessSetApi()) {
            logger.trace("Global auto lock is enabled hence operation is denied!");
            return;
        }
        this.isLockSettingEnable = bl;
        this.theIdleTimeSetting.enableChangedSetting();
    }

    @Override
    public boolean isLockSettingEnable() {
        return this.isLockSettingEnable;
    }

    public EventMonitor getEventMonitor() {
        return this.theEventMonitor;
    }

    public synchronized void setGlobalAutoLock(int n, boolean bl) {
        logger.trace("Begin setting global auto lock");
        this.setGlobalAutoLockWithCheck(n, bl, true);
        logger.trace("End setting global auto lock");
    }

    void setGlobalAutoLockWithCheck(int n, boolean bl, boolean bl2) {
        if (this.pauseFlag) {
            logger.trace("Operation denied since pause lock is enabled!");
            return;
        }
        logger.trace("Setting global auto lock, idle time = " + n + ", setting enabled = " + bl + " visibility check = " + bl2);
        this.globalThreadLocal.set(true);
        JPanel jPanel = this.theIdleTimeSetting.getSettingsPanel();
        if (jPanel instanceof IdleTimeSettingPanel) {
            IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)jPanel;
            this.isGlobalAutoLockEnabled = bl;
            if (bl2 && this.theIdleTimeSetting.isTimeSettingShown()) {
                if (this.isGlobalAutoLockEnabled) {
                    this.isLockSettingEnable = true;
                    this.theIdleTimeSetting.enableChangedSettingforGlobal();
                    if (this.isValidTime(n)) {
                        this.idleTime = n;
                    }
                    this.saveIdleTimeToConfingure(this.idleTime);
                    this.theEventMonitor.stopTimer();
                    this.theEventMonitor.doStartTimer();
                }
            } else {
                idleTimeSettingPanel.enableLockSettingPanel(!bl);
                if (this.isGlobalAutoLockEnabled) {
                    idleTimeSettingPanel.setIdleTime(n);
                    if (idleTimeSettingPanel.lockTimeTextField.isValid()) {
                        this.isLockSettingEnable = true;
                    }
                }
                this.theIdleTimeSetting.enableChangedSetting();
                this.startLockTimerWithCheck();
            }
            this.saveGlobalAutoLockSetting();
        }
        this.globalThreadLocal.set(false);
    }

    public boolean isGlobalAutoLockEnabled() {
        return this.isGlobalAutoLockEnabled;
    }

    private boolean isProcessSetApi() {
        if (this.isGlobalAutoLockEnabled) {
            return null != this.globalThreadLocal.get() && this.globalThreadLocal.get() != false;
        }
        return true;
    }

    private boolean isValidTime(int n) {
        JPanel jPanel = this.theIdleTimeSetting.getSettingsPanel();
        IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)jPanel;
        IntegerDocument integerDocument = (IntegerDocument)idleTimeSettingPanel.lockTimeTextField.getDocument();
        return n >= integerDocument.getMin() && n <= integerDocument.getMax();
    }

    public void activateStyleSettings() {
        this.globalThreadLocal.set(true);
        if (this.readGlobalAutoLockSetting()) {
            this.idleTime = this.getGloabalIdleTimeFromConfig();
            this.setGlobalAutoLock(this.idleTime, true);
        } else {
            this.isGlobalAutoLockEnabled = false;
            this.startLockTimerWithCheck();
            this.updateStyleSetting();
        }
        this.globalThreadLocal.set(false);
    }

    private void updateStyleSetting() {
        JPanel jPanel = this.theIdleTimeSetting.getSettingsPanel();
        if (jPanel instanceof IdleTimeSettingPanel) {
            IdleTimeSettingPanel idleTimeSettingPanel = (IdleTimeSettingPanel)jPanel;
            idleTimeSettingPanel.enableLockSettingPanel(true);
            idleTimeSettingPanel.setIdleTime(this.idleTime);
            idleTimeSettingPanel.lockCheckBox.setSelected(this.isLockSettingEnable);
        }
    }

    void setGlobalAutoLockFlag(boolean bl) {
        this.isGlobalAutoLockEnabled = bl;
    }
}

