/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.framework.applicationmanagement.gui.FloatingAppPanel;
import com.swimap.iview.framework.mainframe.MDIFrame;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingHandler;
import com.swimap.iview.framework.terminalmanagement.LockDialog;
import com.swimap.iview.framework.terminalmanagement.ScreenStateChangeListener;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.terminalmanagement.UnlockDialog;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;

class ScreenLocker {
    private static IviewLogger logger = IviewLogger.getLogger(ScreenLocker.class, "IVIEW");
    private static ScreenLocker instance = new ScreenLocker();
    private int screenSate = 0;
    private Container frameContent = null;
    private String frameTitle = null;
    private int frameState = 6;
    private Rectangle frameBounds = null;
    private Component frameFocusOwner = null;
    private WindowListener[] frameWindowListeners = null;
    private WindowListener[] lockWindowListeners = null;
    private WindowListener[] unlockWindowListeners = null;
    private ArrayList visibleWindowsList = new ArrayList(5);
    private boolean isFloatingPanelVisible = false;
    private Dialog mainFrmBlocker = null;
    private boolean locking = false;
    private PropertyChangeSupport changeSupport = null;
    private List<Window> hiddenWindowList = new ArrayList<Window>();
    private MDIFrame lockFrame = null;
    private JDialog tempDialog = null;
    private boolean breachDetected = false;
    private boolean enableBreachCheck = false;
    private Window activeHiddenWindow = null;
    private long activeWinEventMask = 8192L;
    private ArrayList<Window> safeWindowList = new ArrayList();
    private WindowListener byPassWL = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            if (ScreenLocker.this.isCheckApplicable()) {
                Window window = (Window)windowEvent.getSource();
                logger.error("Security Warning: Hidden window activated: " + window.toString());
                ScreenLocker.this.activeHiddenWindow = window;
            }
        }
    };
    private AWTEventListener activeAWTListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Object object = aWTEvent.getSource();
            if (object instanceof Window) {
                Window window = (Window)object;
                if (null != ScreenLocker.this.activeHiddenWindow && window == ScreenLocker.this.activeHiddenWindow && ScreenLocker.this.safeWindowList.contains(window) && ScreenLocker.this.isCheckApplicable()) {
                    logger.error("Security Viaolation Handled: Window closed: " + window.toString());
                    ScreenLocker.this.breachDetected = true;
                    ScreenLocker.this.activeHiddenWindow = null;
                    window.removeNotify();
                }
            }
        }
    };

    private ScreenLocker() {
    }

    static ScreenLocker getInstance() {
        return instance;
    }

    private void registerSafeWindow(Window window) {
        if (null != window && !this.safeWindowList.contains(window)) {
            logger.trace("Registering for safty: " + window);
            this.safeWindowList.add(window);
            this.addCheck(window);
        }
    }

    private void clearSafeWindowList() {
        for (int i = 0; i < this.safeWindowList.size(); ++i) {
            logger.trace("Deregistering: " + this.safeWindowList.get(i));
            this.removeCheck(this.safeWindowList.get(i));
        }
        this.safeWindowList.clear();
    }

    private boolean isCheckApplicable() {
        TerminalManager terminalManager = FrameworkUtilities.getTerminalManager();
        FrameworkCommandProcessor frameworkCommandProcessor = FrameworkCommandProcessor.getInstance();
        return null != terminalManager && null != frameworkCommandProcessor && this.enableBreachCheck && terminalManager.isLockOrUnLockDialogshown() && frameworkCommandProcessor.isLogin() && !frameworkCommandProcessor.isLoggingOut();
    }

    private void setBreachCheck(boolean bl) {
        try {
            this.activeHiddenWindow = null;
            this.enableBreachCheck = bl;
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.removeAWTEventListener(this.activeAWTListener);
            if (bl) {
                toolkit.addAWTEventListener(this.activeAWTListener, this.activeWinEventMask);
            } else {
                this.clearSafeWindowList();
            }
        }
        catch (Exception exception) {
            logger.error("Security Warning: ", exception);
        }
    }

    private void addCheck(Window window) {
        window.addWindowListener(this.byPassWL);
    }

    private void removeCheck(Window window) {
        window.removeWindowListener(this.byPassWL);
    }

    private void resetFrame(JFrame jFrame) {
        jFrame.addNotify();
    }

    void setScreenState(int n) {
        if (n != 0 && n != 1 && n != 2) {
            throw new IllegalStateException("ScreenLocker.setScreenState, Illegal state: " + n);
        }
        int n2 = this.screenSate;
        this.screenSate = n;
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange("ScreenState", n2, n);
        }
    }

    int getScreenState() {
        return this.screenSate;
    }

    void addScreenStateChangeListener(String string, ScreenStateChangeListener screenStateChangeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(string, screenStateChangeListener);
    }

    void removeScreenStateChangeListener(String string, ScreenStateChangeListener screenStateChangeListener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(string, screenStateChangeListener);
        }
    }

    void lock(final JFrame jFrame, final LockDialog lockDialog) {
        this.enableBreachCheck = false;
        this.breachDetected = false;
        if (FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (null != lockDialog && FrameworkUtilities.getTerminalManager().isPauseFlag()) {
                        logger.trace("---Not able to lock client as pause lock is enabled");
                        lockDialog.presetPanelVisible(false);
                        lockDialog.removeUnlockListener();
                        ScreenLocker.this.screenSate = 0;
                        return;
                    }
                    if (!lockDialog.isPanelShowing()) {
                        lockDialog.setContentPane(lockDialog.getLockPanel());
                    }
                    if (ScreenToolKit.getFullScreenFlg()) {
                        ScreenToolKit.getCloseFullScreenDialog().setVisible(false);
                        ScreenToolKit.getCloseFullScreenDialog().setModalExclusionType(Dialog.ModalExclusionType.NO_EXCLUDE);
                        ScreenToolKit.getCloseFullScreenDialog().setVisible(true);
                    }
                    if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled() && null != ScreenToolKit.getGlassPane()) {
                        ScreenToolKit.getGlassPane().deactivate();
                    }
                    lockDialog.setVisible(true);
                    ScreenToolKit.setComponentCursorBusy(jFrame, false);
                }
            });
            return;
        }
        this.frameTitle = jFrame.getTitle();
        this.frameState = jFrame.getExtendedState();
        if ((this.frameState & 6) == 6) {
            this.frameState = 6;
        }
        if (this.frameState == 6 && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jFrame.setExtendedState(0);
        }
        this.frameBounds = jFrame.getBounds();
        this.frameFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        this.frameWindowListeners = jFrame.getWindowListeners();
        this.lockWindowListeners = lockDialog.getWindowListeners();
        if (jFrame instanceof MDIFrame) {
            ((MDIFrame)jFrame).hidePopupMenu();
        }
        if (null == this.lockFrame) {
            this.lockFrame = new MDIFrame("");
            this.lockFrame.setResizable(false);
            this.lockFrame.jbInit();
            this.lockFrame.setDefaultCloseOperation(0);
            this.lockFrame.setIconImage(jFrame.getIconImage());
            if (jFrame instanceof MDIFrame) {
                ScreenLocker.updateTitleOnLock((MDIFrame)jFrame, this.lockFrame);
            }
        }
        this.hideFrameAndItsChildren(jFrame);
        this.lockFrame.setVisible(true);
        FrameworkUtilities.setMainFrame(this.lockFrame);
        if (FrameworkUtilities.getWindowManager().isFullScreenLockEnabled() && null != ScreenToolKit.getGlassPane() && !ScreenToolKit.getGlassPane().isVisible()) {
            ScreenToolKit.getGlassPane().deactivate();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenLocker.this.breachDetected = false;
                if (jFrame instanceof MDIFrame) {
                    JDialog jDialog;
                    ScreenLocker.this.registerSafeWindow(jFrame);
                    SettingHandler settingHandler = FrameworkUtilities.getPreferenceManager().getSettingHandler();
                    if (null != settingHandler && null != (jDialog = settingHandler.getSettingDialog()) && ScreenLocker.this.hiddenWindowList.contains(jDialog)) {
                        ScreenLocker.this.registerSafeWindow(jDialog);
                    }
                    ScreenLocker.this.setBreachCheck(true);
                }
            }
        });
        if (FrameworkCommandProcessor.getInstance().isAppStyle() && FloatingAppPanel.getInstance().isVisible()) {
            this.isFloatingPanelVisible = true;
            logger.trace("Floating panel listeners are removed duringlock");
            FloatingAppPanel.getInstance().removeCloseListeners();
        }
        this.toLocking(jFrame, lockDialog);
    }

    void toLocking(JFrame jFrame, LockDialog lockDialog) {
        if (FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
            lockDialog.setVisible(true);
            return;
        }
        this.stopDispatchEvent();
        jFrame = this.lockFrame;
        jFrame.setContentPane(lockDialog.getLockPanel());
        jFrame.setTitle(this.frameTitle);
        jFrame.setIconImage(jFrame.getIconImage());
        jFrame.setBounds(lockDialog.getBounds());
        ScreenToolKit.setComponentCursorBusy(jFrame, false);
        this.changeWindowListeners(jFrame, this.lockWindowListeners);
        jFrame.getRootPane().requestFocus(true);
        HelpManager.getInstance().enableHelpKey(FrameworkUtilities.getMainFrame().getRootPane(), "topics_getting_start_task_p_manual_lock");
        jFrame.validate();
        jFrame.pack();
        jFrame.repaint();
        this.startDispatchEvent();
    }

    void toUnlocking(JFrame jFrame, UnlockDialog unlockDialog) {
        if (FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
            if (!unlockDialog.isPanelShowing()) {
                unlockDialog.setContentPane(unlockDialog.getUnlockPanel());
            }
            unlockDialog.setVisible(true);
            return;
        }
        jFrame = this.lockFrame;
        this.unlockWindowListeners = unlockDialog.getWindowListeners();
        jFrame.setContentPane(unlockDialog.getUnlockPanel());
        jFrame.setTitle(this.frameTitle);
        jFrame.setBounds(unlockDialog.getBounds());
        this.changeWindowListeners(jFrame, this.unlockWindowListeners);
        unlockDialog.getUnlockFocusOwner().requestFocus();
        jFrame.validate();
        jFrame.pack();
        jFrame.repaint();
        this.startDispatchEvent();
    }

    void unlock(final JFrame jFrame) {
        this.setBreachCheck(false);
        if (FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
            FrameworkUtilities.getTerminalManager().theUnlockDialog.setVisible(false);
            if (3 == ((MDIFrame)jFrame).getCursorState()) {
                ScreenLocker.setComponentCursorBusy(jFrame, true);
            }
            if (ScreenToolKit.getGlassPane() != null && !ScreenToolKit.getGlassPane().isVisible() && ScreenToolKit.getFullScreenFlg()) {
                if (FrameworkUtilities.getWindowManager().isFullScreenPasswordProtected()) {
                    if (!FrameworkUtilities.getTerminalManager().isFullScrnPasswdDialogShow()) {
                        ScreenToolKit.getGlassPane().activate();
                    }
                } else {
                    ScreenToolKit.getGlassPane().activate();
                }
            }
            return;
        }
        this.stopDispatchEvent();
        ScreenToolKit.setToolBarButtonBorderPainted("mainframe:lockterminal", false);
        jFrame.setBounds(this.frameBounds);
        if (this.frameState == 6 && Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            jFrame.setExtendedState(6);
        } else {
            jFrame.setBounds(this.frameBounds);
        }
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            HelpManager.getInstance().enableHelpKey(FrameworkUtilities.getMainFrame().getRootPane(), "topics_welcome_p_portal");
        } else {
            HelpManager.getInstance().enableHelpKey(FrameworkUtilities.getMainFrame().getRootPane(), "topics_welcome_p_welcome");
        }
        this.changeWindowListeners(jFrame, this.frameWindowListeners);
        ScreenLocker.updateTitleOnLock(this.lockFrame, (MDIFrame)jFrame);
        this.lockFrame.dispose();
        this.lockFrame = null;
        FrameworkUtilities.setMainFrame(jFrame);
        this.showFrameAndItsChildren(jFrame);
        if (this.frameFocusOwner != null) {
            this.frameFocusOwner.requestFocus();
            this.frameFocusOwner = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ScreenLocker.this.breachDetected) {
                    logger.error("Security breach detected!");
                    ScreenLocker.this.resetFrame(jFrame);
                    ScreenLocker.this.breachDetected = false;
                }
                ScreenLocker.this.setBreachCheck(false);
            }
        });
        if (3 == ((MDIFrame)jFrame).getCursorState()) {
            ScreenLocker.setComponentCursorBusy(jFrame, true);
        }
        if (ScreenToolKit.isLockedWhenFullScreen()) {
            ScreenToolKit.showFullScreen(FrameworkUtilities.getMainFrame(), FrameworkUtilities.getTerminalManager().getFullScreenEnabledInternalFrame());
        }
        if (this.isFloatingPanelVisible && FrameworkCommandProcessor.getInstance().isAppStyle()) {
            logger.trace("Floating panel listeners are added after unlock");
            FloatingAppPanel.getInstance().addCloseListeners();
        }
        jFrame.validate();
        jFrame.repaint();
    }

    public void hideOwnedVisibleWindows(JFrame jFrame) {
        Window[] windowArray = jFrame.getOwnedWindows();
        if (windowArray == null || windowArray.length == 0) {
            return;
        }
        try {
            Dialog dialog = (Dialog)this.getModalBlocker(jFrame);
            if (null != dialog) {
                this.mainFrmBlocker = dialog;
                this.changeModalExclusion(jFrame, Dialog.ModalExclusionType.TOOLKIT_EXCLUDE);
            }
        }
        catch (SecurityException securityException) {
            logger.trace(securityException.getMessage(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.trace(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.trace(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.trace(invocationTargetException.getMessage(), invocationTargetException);
        }
        for (int i = 0; i < windowArray.length; ++i) {
            if (windowArray[i] == null || this.visibleWindowsList.contains(windowArray[i]) || !windowArray[i].isVisible()) continue;
            this.visibleWindowsList.add(windowArray[i]);
            this.setDisplayable(windowArray[i], false);
            this.hideOwnedVisibleWindows(windowArray[i].getOwnedWindows());
        }
    }

    private void showFrameAndItsChildren(JFrame jFrame) {
        if (jFrame.getPeer() != null) {
            jFrame.getPeer().setVisible(true);
        }
        for (Window window : this.hiddenWindowList) {
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                ((Dialog)window).setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            }
            if (window.getPeer() == null) continue;
            window.getPeer().setVisible(true);
        }
        this.hiddenWindowList.clear();
    }

    private void hideFrameAndItsChildren(JFrame jFrame) {
        this.hiddenWindowList.clear();
        Window[] windowArray = jFrame.getOwnedWindows();
        if (windowArray == null || windowArray.length == 0 && jFrame.getPeer() != null) {
            jFrame.getPeer().setVisible(false);
            return;
        }
        for (int i = 0; i < windowArray.length; ++i) {
            Window window = windowArray[i];
            if (window == null || !window.isVisible() || window.getPeer() == null) continue;
            this.hideWindowAndItsChildren(window);
        }
        this.hideOwnerlessWindows();
        if (jFrame.getPeer() != null) {
            jFrame.getPeer().setVisible(false);
        }
    }

    private void hideOwnerlessWindows() {
        Window[] windowArray;
        if (null == this.tempDialog) {
            this.tempDialog = new JDialog();
        }
        if ((windowArray = this.tempDialog.getOwner().getOwnedWindows()).length > 1) {
            for (int i = 0; i < windowArray.length; ++i) {
                Window window = windowArray[i];
                if (window == null || !window.isVisible() || window.getPeer() == null) continue;
                this.hideWindowAndItsChildren(window);
            }
        }
    }

    private void hideWindowAndItsChildren(Window window) {
        Window[] windowArray = window.getOwnedWindows();
        if (windowArray == null || windowArray.length == 0) {
            if (window instanceof Dialog && ((Dialog)window).isModal()) {
                ((Dialog)window).setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            }
            if (null != window.getPeer()) {
                window.getPeer().setVisible(false);
            }
            this.hiddenWindowList.add(window);
            return;
        }
        Window window2 = null;
        for (int i = 0; i < windowArray.length; ++i) {
            window2 = windowArray[i];
            if (window2 == null || window2.getPeer() == null || !window2.isVisible()) continue;
            this.hideWindowAndItsChildren(window2);
        }
        if (window instanceof Dialog && ((Dialog)window).isModal()) {
            ((Dialog)window).setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        }
        if (null != window.getPeer()) {
            window.getPeer().setVisible(false);
        }
        this.hiddenWindowList.add(window);
    }

    private Window getModalBlocker(Window window) {
        if (window == null) {
            return null;
        }
        try {
            Class[] classArray = new Class[]{};
            Class<Window> clazz = Window.class;
            Method method = clazz.getDeclaredMethod("getModalBlocker", classArray);
            method.setAccessible(true);
            return (Dialog)method.invoke((Object)window, new Object[0]);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            return null;
        }
    }

    private void hideOwnedVisibleWindows(Window[] windowArray) {
        if (windowArray == null || windowArray.length == 0) {
            return;
        }
        try {
            for (int i = 0; i < windowArray.length; ++i) {
                if (windowArray[i] == null || this.visibleWindowsList.contains(windowArray[i]) || !windowArray[i].isVisible()) continue;
                this.visibleWindowsList.add(windowArray[i]);
                this.setDisplayable(windowArray[i], false);
                this.hideOwnedVisibleWindows(windowArray[i].getOwnedWindows());
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void showOwnedVisibleWindows(Frame frame) {
        if (this.visibleWindowsList.size() <= 0) {
            return;
        }
        Object[] objectArray = this.visibleWindowsList.toArray();
        if (objectArray != null && objectArray.length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!(objectArray[i] instanceof Component)) continue;
                this.setDisplayable((Component)objectArray[i], true);
            }
        }
        try {
            if (null != this.mainFrmBlocker) {
                this.changeModalExclusion(frame, Dialog.ModalExclusionType.NO_EXCLUDE);
            }
        }
        catch (SecurityException securityException) {
            logger.trace(securityException.getMessage(), securityException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            logger.trace(noSuchMethodException.getMessage(), noSuchMethodException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.trace(illegalArgumentException.getMessage(), illegalArgumentException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.trace(illegalAccessException.getMessage(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            logger.trace(invocationTargetException.getMessage(), invocationTargetException);
        }
        Window window = (Window)this.visibleWindowsList.get(this.visibleWindowsList.size() - 1);
        window.toFront();
        this.visibleWindowsList.clear();
        this.mainFrmBlocker = null;
    }

    private void setDisplayable(final Component component, final boolean bl) {
        if (component != null && component.getPeer() != null) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.changeModalBlocker(bl, component);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ScreenLocker.this.changeModalBlocker(bl, component);
                    }
                });
            }
        }
    }

    private void changeModalBlocker(boolean bl, Component component) {
        Window window;
        boolean bl2 = true;
        String string = System.getProperty("os.name");
        if (0 <= string.indexOf("Solaris") || 0 <= string.indexOf("SunOS")) {
            bl2 = false;
        }
        if (!bl2 && bl && component.getPeer() instanceof WindowPeer && null != (window = this.getModalBlocker((Dialog)component))) {
            ((WindowPeer)component.getPeer()).setModalBlocked((Dialog)window, true);
        }
        component.getPeer().setVisible(bl);
    }

    private void startDispatchEvent() {
        this.locking = true;
        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
        while (this.locking) {
            try {
                Object object;
                AWTEvent aWTEvent = eventQueue.getNextEvent();
                Object object2 = aWTEvent.getSource();
                if (aWTEvent instanceof ActiveEvent) {
                    ((ActiveEvent)((Object)aWTEvent)).dispatch();
                    continue;
                }
                if (object2 instanceof Component) {
                    if (this.screenSate == 1 && object2 instanceof Frame) {
                        object = (Frame)object2;
                        ((Window)object).pack();
                        this.centerWhenOutOfScreen((Frame)object);
                    }
                    if (101 == aWTEvent.getID()) continue;
                    ((Component)object2).dispatchEvent(aWTEvent);
                    continue;
                }
                if (!(object2 instanceof TrayIcon)) continue;
                object = TrayIcon.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                ((Method)object).setAccessible(true);
                ((Method)object).invoke(object2, aWTEvent);
            }
            catch (InterruptedException interruptedException) {
                logger.trace(interruptedException.getMessage(), interruptedException);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    private void stopDispatchEvent() {
        this.locking = false;
    }

    private void centerWhenOutOfScreen(Frame frame) {
        if (frame.getX() + frame.getWidth() <= 0 || (double)frame.getX() >= Toolkit.getDefaultToolkit().getScreenSize().getWidth()) {
            ScreenToolKit.centerLocateToScreen(frame);
        }
    }

    private void changeWindowListeners(JFrame jFrame, WindowListener[] windowListenerArray) {
        int n;
        WindowListener[] windowListenerArray2 = jFrame.getWindowListeners();
        for (n = 0; n < windowListenerArray2.length; ++n) {
            jFrame.removeWindowListener(windowListenerArray2[n]);
        }
        for (n = 0; n < windowListenerArray.length; ++n) {
            jFrame.addWindowListener(windowListenerArray[n]);
        }
    }

    private void changeModalExclusion(Frame frame, Dialog.ModalExclusionType modalExclusionType) throws SecurityException, IllegalArgumentException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (null == modalExclusionType) {
            modalExclusionType = Dialog.ModalExclusionType.NO_EXCLUDE;
        }
        if (modalExclusionType == frame.getModalExclusionType()) {
            return;
        }
        frame.setModalExclusionType(modalExclusionType);
        if (Dialog.ModalExclusionType.NO_EXCLUDE != modalExclusionType) {
            this.unblockWindow(frame, this.mainFrmBlocker);
        } else {
            this.checkShouldBeBlocked(frame);
            this.updateChildrenBlocking(frame);
        }
    }

    private void unblockWindow(Window window, Dialog dialog) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<Dialog> clazz = Dialog.class;
        Method method = clazz.getDeclaredMethod("unblockWindow", Window.class);
        method.setAccessible(true);
        method.invoke((Object)dialog, window);
    }

    private void checkShouldBeBlocked(Window window) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<Dialog> clazz = Dialog.class;
        Method method = clazz.getDeclaredMethod("checkShouldBeBlocked", Window.class);
        method.setAccessible(true);
        method.invoke(clazz, window);
    }

    private void updateChildrenBlocking(Window window) throws SecurityException, NoSuchMethodException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Class<Window> clazz = Window.class;
        Method method = clazz.getDeclaredMethod("updateChildrenBlocking", new Class[0]);
        method.setAccessible(true);
        method.invoke((Object)window, new Object[0]);
    }

    private static void updateTitleOnLock(MDIFrame mDIFrame, MDIFrame mDIFrame2) {
        mDIFrame2.setBaseTitle(mDIFrame.getBasetitle());
        mDIFrame2.setExtendtitle(mDIFrame.getExtendtitle());
        mDIFrame2.setIViewTitle(mDIFrame.getPrefixTitle(), true);
        mDIFrame2.setIViewTitle(mDIFrame.getSuffixTitle(), false);
        mDIFrame2.setMDITitle(mDIFrame.getMDITitle());
        mDIFrame2.setTitle(mDIFrame.getTitle());
    }

    private static void setComponentCursorBusy(final RootPaneContainer rootPaneContainer, final boolean bl) {
        if (rootPaneContainer == null) {
            logger.warn("The RootPaneContainer is null, the call of setComponentCursorBusy is ignored.");
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            ScreenLocker.setComponentCursorBusyEx(rootPaneContainer, bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ScreenLocker.setComponentCursorBusyEx(rootPaneContainer, bl);
                }
            });
        }
    }

    private static void setComponentCursorBusyEx(RootPaneContainer rootPaneContainer, boolean bl) {
        if (bl) {
            rootPaneContainer.getRootPane().setCursor(Cursor.getPredefinedCursor(3));
        } else {
            rootPaneContainer.getRootPane().setCursor(Cursor.getPredefinedCursor(0));
        }
    }
}

