/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.framework.securitymanagement.SecurityService;
import com.swimap.iview.framework.terminalmanagement.ITerminalManager;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSetting;
import com.swimap.iview.framework.terminalmanagement.MultilineLabel;
import com.swimap.iview.framework.terminalmanagement.ScreenLocker;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.util.FrameworkGlobalInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.templates.utils.MultiRowToolTip;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.SystemTray;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.text.BadLocationException;

public class LockDialog
extends JDialog {
    private static IviewLogger logger = IviewLogger.getLogger(LockDialog.class, "IVIEW");
    private ITerminalManager terminalManager = null;
    private String defaultMessage = IdleTimeSetting.res.getString("LockDialog_Terminal_Unlock");
    private String terminalIsLockedString = IdleTimeSetting.res.getString("LockDialog_Terminal_Is_In_Use");
    MultilineLabel lockTipLabel = new MultilineLabel(){

        @Override
        public JToolTip createToolTip() {
            MultiRowToolTip multiRowToolTip = new MultiRowToolTip();
            multiRowToolTip.setComponent(this);
            return multiRowToolTip;
        }
    };
    private MultilineLabel unlockMessageLabel = new MultilineLabel();
    private MultilineLabel unlockTipLabel = new MultilineLabel();
    static final int MAX_LABEL_WIDTH = 330;
    private static int LABEL_WIDTH = 360;
    static final int MAX_UNLOCKMSG_LENGTH = 640;
    static final int LOCK_DIALOG_WIDTH = 439;
    private static final int LOCK_DIALOG_HEIGHT = 201;
    private static final int LABEL_HEIGHT = 36;
    static final int LOCK_ICON_HEIGHT = 65;
    private static String lockDlgTitle = IdleTimeSetting.res.getString("LockDialog_Terminal_Locked");
    private JPanel lockPanel = null;
    private KeyEventDispatcher unlockEventDispatcher = null;

    public LockDialog(ITerminalManager iTerminalManager) {
        super((Frame)FrameworkUtilities.getMainFrame(), true);
        if (this.getOwner() == null) {
            logger.error("The main frame is null, lock will not take effect!");
        }
        this.terminalManager = iTerminalManager;
        this.jbInit();
        this.addUnlockListener();
    }

    private void jbInit() {
        this.setSize(new Dimension(439, 201));
        this.setResizable(false);
        ScreenToolKit.centerLocateToScreen(this);
        this.setDefaultCloseOperation(0);
        this.setName("LockDialog");
        this.unlockTipLabel.setText(IdleTimeSetting.res.getString("LockDialog_Press_Ctrl_Alt_U_to"));
        this.unlockTipLabel.setSize(LABEL_WIDTH, 36);
        this.unlockTipLabel.setMaximumSize(new Dimension(LABEL_WIDTH, 36));
        this.unlockTipLabel.setPreferredSize(new Dimension(LABEL_WIDTH, 36));
        this.unlockMessageLabel.setSize(330, 36);
        this.unlockMessageLabel.setMaximumSize(new Dimension(330, 36));
        this.unlockMessageLabel.setPreferredSize(new Dimension(330, 36));
        this.lockPanel = new JPanel();
        this.lockPanel.setSize(new Dimension(439, 201));
        this.lockPanel.setMaximumSize(new Dimension(439, 201));
        this.lockPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)this.lockPanel, "Center");
        Icon icon = ResourceAdapter.getLockIcon();
        JLabel jLabel = new JLabel(icon);
        int n = icon.getIconHeight();
        n = n > 65 ? 65 : n;
        jLabel.setMaximumSize(new Dimension(439, n));
        jLabel.setPreferredSize(new Dimension(439, n));
        jLabel.setMinimumSize(new Dimension(439, n));
        this.lockPanel.add((Component)jLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel jLabel2 = new JLabel(new ImageIcon(this.getClass().getResource("lockTerminal.gif")));
        this.lockPanel.add((Component)jLabel2, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 18, 0, new Insets(20, 20, 0, 20), 0, 0));
        this.lockTipLabel.setSize(330, 36);
        this.lockTipLabel.setMaximumSize(new Dimension(330, 36));
        this.lockTipLabel.setPreferredSize(new Dimension(330, 36));
        this.lockTipLabel.setText(this.terminalIsLockedString);
        this.lockPanel.add((Component)this.lockTipLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.lockPanel.add((Component)this.unlockMessageLabel, new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(8, 0, 0, 0), 0, 0));
        this.lockPanel.add((Component)this.unlockTipLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 0, 8, 0), 0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                LockDialog.this.unlockTipLabel.requestFocusInWindow();
                LockDialog.this.lockPanel.validate();
                LockDialog.this.lockPanel.repaint();
                if (FrameworkUtilities.getTerminalManager().isMainwindowVisibleOnLock()) {
                    LockDialog.this.pack();
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                LockDialog.this.changedToUnlock();
            }
        });
        if (Boolean.getBoolean("enabletrayicon") && SystemTray.isSupported()) {
            this.addWindowListener(FrameworkUtilities.getIconifyWindowListener());
        }
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = LockDialog.this.getSize();
                if (dimension.width > 439 || dimension.height > 201) {
                    LockDialog.this.lockPanel.setPreferredSize(new Dimension(439, 201));
                    LockDialog.this.setSize(new Dimension(445, 232));
                }
                ScreenToolKit.centerLocateToScreen(LockDialog.this);
            }
        });
        this.pack();
    }

    @Override
    public void setVisible(boolean bl) {
        this.presetPanelVisible(bl);
        super.setVisible(bl);
    }

    void presetPanelVisible(boolean bl) {
        if (bl) {
            try {
                SecurityService securityService = (SecurityService)((TerminalManager)this.terminalManager).getReference(FrameworkGlobalInfo.ModuleName.SECURITY_MANAGER_NAME, "");
                String string = securityService.getUsername();
                String string2 = ((TerminalManager)this.terminalManager).getLockDialogMessage();
                if (string2 != null) {
                    string = string2;
                }
                String string3 = ((TerminalManager)this.terminalManager).getUnlockMessage();
                MessageFormat messageFormat = new MessageFormat(this.defaultMessage);
                String string4 = messageFormat.format(new String[]{string});
                if (string3 == null) {
                    this.unlockMessageLabel.setText(string4, string4, 640);
                } else {
                    this.unlockMessageLabel.setText(string3, string4, 640);
                }
                this.setTerminalIsLockedMessage();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
            this.setTitle(lockDlgTitle);
        }
    }

    boolean isPanelShowing() {
        if (this.lockPanel != null) {
            return this.lockPanel.isShowing();
        }
        return false;
    }

    private void setTerminalIsLockedMessage() {
        String string = ((TerminalManager)this.terminalManager).getTerminalIsLockedString();
        if (string != null) {
            this.terminalIsLockedString = string;
        }
        this.terminalIsLockedString = ScreenToolKit.getLineWrapString(this.terminalIsLockedString, 330, this.lockTipLabel.getFont(), true);
        this.lockTipLabel.setText(this.terminalIsLockedString);
        String string2 = "";
        String string3 = "";
        if (this.lockTipLabel.getLineCount() > 2) {
            this.lockTipLabel.setToolTipText(this.terminalIsLockedString);
            try {
                string2 = this.terminalIsLockedString.substring(0, this.lockTipLabel.getLineEndOffset(0));
                string3 = this.terminalIsLockedString.substring(this.lockTipLabel.getLineEndOffset(0), this.lockTipLabel.getLineEndOffset(1));
                string3 = string3.substring(0, string3.length() - 2);
                string3 = this.getStringPixLength(string3, this.lockTipLabel.getFont()) > 320 ? ScreenToolKit.getAbbreviatoryString(string3, 320, this.lockTipLabel.getFont()) : ScreenToolKit.getAbbreviatoryString(string3, this.getStringPixLength(string3, this.lockTipLabel.getFont()) - 1, this.lockTipLabel.getFont());
            }
            catch (BadLocationException badLocationException) {
                logger.trace(badLocationException.getMessage(), badLocationException);
            }
            String string4 = string2 + string3.trim();
            this.lockTipLabel.setText(string4);
        } else {
            this.lockTipLabel.setToolTipText(null);
        }
    }

    private int getStringPixLength(String string, Font font) {
        Graphics2D graphics2D = new BufferedImage(10, 10, 2).createGraphics();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        return fontMetrics.stringWidth(string);
    }

    static void setLockDialogTitle(String string) {
        lockDlgTitle = string;
    }

    static String getLockDialogTitle() {
        return lockDlgTitle;
    }

    JPanel getLockPanel() {
        return this.lockPanel;
    }

    private void changedToUnlock() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow();
        if (window instanceof JDialog && !(window instanceof LockDialog) && ((JDialog)window).isModal()) {
            return;
        }
        this.presetPanelVisible(false);
        if (this.terminalManager != null && this.terminalManager instanceof TerminalManager) {
            ((TerminalManager)this.terminalManager).unlockTerminal();
        }
    }

    public void addUnlockListener() {
        if (this.unlockEventDispatcher == null) {
            this.unlockEventDispatcher = new KeyEventDispatcher(){

                @Override
                public boolean dispatchKeyEvent(KeyEvent keyEvent) {
                    if (ScreenLocker.getInstance().getScreenState() == 1 && 0 != (keyEvent.getModifiers() & 8) && 0 != (keyEvent.getModifiers() & 2) && 85 == keyEvent.getKeyCode()) {
                        logger.trace("Pressed ctrl+alt+u to unlock.");
                        LockDialog.this.changedToUnlock();
                    }
                    return false;
                }
            };
            KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.unlockEventDispatcher);
        }
    }

    public void removeUnlockListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.unlockEventDispatcher);
        this.unlockEventDispatcher = null;
    }

    public void cleanupWhileOSGIExit() {
        ComponentListener[] componentListenerArray = this.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            this.removeComponentListener(componentListenerArray[i]);
            componentListenerArray[i] = null;
        }
        WindowListener[] windowListenerArray = this.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.removeWindowListener(windowListenerArray[i]);
            windowListenerArray[i] = null;
        }
        this.lockTipLabel.removeAll();
        this.lockTipLabel = null;
        this.unlockMessageLabel.removeAll();
        this.unlockMessageLabel = null;
    }
}

