/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSetting;
import com.swimap.iview.framework.terminalmanagement.MultilineLabel;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.textfield.IntegerTextField;
import com.swimap.iview.util.TypeConverter;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class IdleTimeSettingPanel
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(IdleTimeSettingPanel.class, "IVIEW");
    private JPanel showContainer = new JPanel();
    private JPanel lockSettingPanel1 = new JPanel();
    private JPanel lockCheckBoxPanel = new JPanel();
    private JPanel lockTimeTextFieldPanel = new JPanel();
    private JPanel mainWindowVisibilityPanel = new JPanel();
    JCheckBox lockCheckBox = new JCheckBox();
    JCheckBox mainWindowVisibilityCheckBox = new JCheckBox();
    IntegerTextField lockTimeTextField = null;
    JLabel unitLabel = new JLabel();
    private IdleTimeSetting idleTimeSetting = null;
    private static final int DEFAULT_IDLE_TIME = 3;
    private static final boolean DEFAULT_MAINWINDOW_VISIBILITY = false;
    private static final int LOCK_TEXTFIELD_LEN = 60;
    private final String DEFAULT_PATH = "conf/mainfrm/terminalmanager";
    private boolean windowGUIupdate = true;
    private JPanel globalInfoPanel = null;

    public IdleTimeSettingPanel(IdleTimeSetting idleTimeSetting) {
        this.idleTimeSetting = idleTimeSetting;
        this.lockTimeTextField = idleTimeSetting != null ? new IntegerTextField(idleTimeSetting.getMinIdleTime(), idleTimeSetting.getMaxIdleTime()) : new IntegerTextField(1, 35000);
        this.jbInit();
    }

    protected void initMainWindowVisibility() {
        boolean bl = this.getMainWindowVisibilityStatusFromConfigure();
        this.mainWindowVisibilityCheckBox.setSelected(bl);
        this.mainWindowVisibilityCheckBox.setEnabled(true);
        FrameworkUtilities.getTerminalManager().setMainWindowVisibleOnLock(bl);
    }

    protected void initLockTime() {
        int n;
        int n2 = n = this.getIdleTimeFromConfigure();
        if (this.idleTimeSetting.getTerminalMananger() != null) {
            n2 = this.idleTimeSetting.getTerminalMananger().getIdleTime();
        }
        this.lockCheckBox.setEnabled(true);
        if (!this.getLockSettingFromConfigure()) {
            this.lockCheckBox.setSelected(false);
            this.lockTimeTextField.setText(String.valueOf(n));
            this.lockTimeTextField.setEnabled(false);
        } else {
            this.lockCheckBox.setSelected(true);
            this.lockTimeTextField.setText(String.valueOf(n2));
            this.lockTimeTextField.setEnabled(true);
        }
    }

    private void jbInit() {
        JComponent jComponent;
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(12, 12, 12, 12));
        FlowLayout flowLayout = new FlowLayout(0);
        flowLayout.setHgap(2);
        this.lockCheckBoxPanel.setLayout(flowLayout);
        this.lockTimeTextFieldPanel.setLayout(flowLayout);
        this.lockTimeTextFieldPanel.setBorder(new EmptyBorder(0, 4, 0, 0));
        this.lockSettingPanel1.setLayout(new BoxLayout(this.lockSettingPanel1, 1));
        this.lockCheckBox.setText(IdleTimeSetting.res.getString("IdleTimeSettingPanel_Auto_Locking"));
        this.lockCheckBox.setName("JDialog_lockCheckBox");
        this.lockCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IdleTimeSettingPanel.this.lockCheckBox_actionPerformed();
                IdleTimeSettingPanel.this.checkModified();
            }
        });
        this.lockCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                IdleTimeSettingPanel.this.lockCheckBox_actionPerformed();
            }
        });
        this.initLockTime();
        this.lockTimeTextField.setName("JDialog_lockTimeTextField");
        this.lockTimeTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                IdleTimeSettingPanel.this.checkModified();
            }
        });
        this.lockCheckBoxPanel.add(this.lockCheckBox);
        this.lockTimeTextField.setMinimumSize(new Dimension(60, this.lockTimeTextField.getPreferredSize().height));
        this.lockTimeTextField.setPreferredSize(new Dimension(60, this.lockTimeTextField.getPreferredSize().height));
        String string = IdleTimeSetting.res.getString("IdleTimeSettingPanel_Main_Frame_Minutes");
        String string2 = "";
        String string3 = "";
        if (string.indexOf("{0}") != -1) {
            string2 = string.substring(0, string.indexOf("{0}")).trim();
            string3 = string.substring(string.indexOf("{0}") + 3).trim();
        }
        if (string2 != null && string2.length() > 0) {
            jComponent = new JLabel();
            jComponent.setName("IdleTimeSettingPanel_preLabel");
            ((JLabel)jComponent).setText(string2);
            this.lockTimeTextFieldPanel.add(jComponent);
            jComponent.setEnabled(true);
        }
        this.lockTimeTextFieldPanel.add(this.lockTimeTextField);
        if (string3 != null && string3.length() > 0) {
            jComponent = new JLabel();
            jComponent.setName("IdleTimeSettingPanel_postLabel");
            ((JLabel)jComponent).setText(string3);
            jComponent.setEnabled(true);
            this.lockTimeTextFieldPanel.add(jComponent);
        }
        this.lockSettingPanel1.add(this.lockCheckBoxPanel);
        this.lockSettingPanel1.add(this.lockTimeTextFieldPanel);
        jComponent = new JPanel();
        jComponent.setLayout(new BorderLayout());
        jComponent.setName("globalLockpanel");
        this.globalInfoPanel = new JPanel();
        this.globalInfoPanel.setLayout(new GridBagLayout());
        this.globalInfoPanel.setName("GlobalInfopanel");
        final MultilineLabel multilineLabel = new MultilineLabel();
        multilineLabel.setName("GlobalInfopanel_Label");
        multilineLabel.setMinimumSize(new Dimension(100, 20));
        this.globalInfoPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = componentEvent.getComponent().getSize();
                multilineLabel.setSize(dimension.width - 20, dimension.height);
            }
        });
        multilineLabel.setText(IdleTimeSetting.res.getString("GloballockMessage"));
        this.globalInfoPanel.add((Component)multilineLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(6, 6, 6, 0), 0, 0));
        this.globalInfoPanel.setVisible(false);
        jComponent.add((Component)this.lockSettingPanel1, "North");
        jComponent.add((Component)this.globalInfoPanel, "Center");
        this.add((Component)jComponent, "Center");
        this.getMainWindowVisibilityStatusFromConfigure();
        if (this.windowGUIupdate) {
            this.showContainer.setLayout(new BorderLayout());
            this.mainWindowVisibilityPanel.setLayout(new GridBagLayout());
            this.mainWindowVisibilityCheckBox.setText(IdleTimeSetting.res.getString("MainWindow_Visible_OnLock_panel"));
            this.mainWindowVisibilityCheckBox.setName("JDialog_mainWindowVisibleCheckBox");
            this.mainWindowVisibilityCheckBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    IdleTimeSettingPanel.this.mainWindowVisibilityCheckBox_actionPerformed();
                }
            });
            this.mainWindowVisibilityPanel.add((Component)this.mainWindowVisibilityCheckBox, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 2, 8, 12), 0, 0));
            this.showContainer.add((Component)this.mainWindowVisibilityPanel, "North");
            this.add((Component)this.showContainer, "North");
        }
        this.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.terminal");
        HelpManager.getInstance().enableHelpKey(this, "iVIEW.systemsetting.terminal");
    }

    private void mainWindowVisibilityCheckBox_actionPerformed() {
        this.checkModified();
    }

    private void lockCheckBox_actionPerformed() {
        logger.trace("lock checkbox Action started");
        TerminalManager terminalManager = FrameworkUtilities.getTerminalManager();
        if (this.lockCheckBox.isSelected()) {
            boolean bl = null != terminalManager ? terminalManager.isGlobalAutoLockEnabled() : false;
            this.lockTimeTextField.setEnabled(!bl);
        } else {
            this.lockTimeTextField.setEnabled(false);
        }
        logger.trace("lock checkbox Action ended successfully");
    }

    public void checkModified() {
        this.idleTimeSetting.setChanged(true);
    }

    private int getIdleTimeFromConfigure() {
        int n = 3;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile("conf/mainfrm/terminalmanager");
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("idleTimeSetting");
            n = (Integer)TypeConverter.getParameter(descContainer.getParasItemValue("idleTime"), Integer.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return n;
    }

    protected boolean getLockSettingFromConfigure() {
        boolean bl = true;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserProductDefaultCommonStyleFile("conf/mainfrm/terminalmanager");
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer("idleTimeSetting");
            if (descContainer.getParasItemValue("isLockSettingEnable") == null) {
                return bl;
            }
            bl = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("isLockSettingEnable"), Boolean.class);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return bl;
    }

    protected boolean getMainWindowVisibilityStatusFromConfigure() {
        boolean bl = false;
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        CommStyleInfo commStyleInfo = null;
        try {
            commStyleInfo = commStyleManager.getCommonStyleFile("conf/mainfrm/terminalmanager");
            if (null == commStyleInfo) {
                logger.debug("commStyleInfo instance is null");
                return false;
            }
            DescContainer descContainer = commStyleInfo.getAreaDescContainer(1).getDescContainer("mainWindowVisibilitySetting");
            bl = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("mainWindowVisible"), Boolean.class);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.trace("If the syle folder doesnot contain area description for'mainWindowVisibilitySetting', update the user style folder with default/product style folder");
            String string = "style/defaultstyle/conf/mainfrm/terminalmanager";
            String string2 = "style/productstyle/conf/mainfrm/terminalmanager";
            CommStyleInfo commStyleInfo2 = commStyleManager.getCommonStyleFileByPath(string);
            CommStyleInfo commStyleInfo3 = commStyleManager.getCommonStyleFileByPath(string2);
            CommStyleInfo commStyleInfo4 = commStyleManager.mergeCommStyleInfo(commStyleInfo2, commStyleInfo3);
            CommStyleInfo commStyleInfo5 = commStyleManager.mergeCommStyleInfo(commStyleInfo4, commStyleInfo);
            DescContainer descContainer = null;
            try {
                descContainer = commStyleInfo5.getAreaDescContainer(1).getDescContainer("mainWindowVisibilitySetting");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException2) {
                logger.trace("Client doesnot supprt main window visibilityfeature");
                this.windowGUIupdate = false;
                return false;
            }
            bl = (Boolean)TypeConverter.getParameter(descContainer.getParasItemValue("mainWindowVisible"), Boolean.class);
            commStyleManager.writeToUser(commStyleInfo5);
            return bl;
        }
        return bl;
    }

    public boolean isWindowGUIupdate() {
        return this.windowGUIupdate;
    }

    void enableLockSettingPanel(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            Component[] componentArray;
            for (Component component : componentArray = this.lockCheckBoxPanel.getComponents()) {
                component.setEnabled(bl);
            }
            for (Component component : componentArray = this.lockTimeTextFieldPanel.getComponents()) {
                component.setEnabled(bl);
            }
            if (bl && !this.lockCheckBox.isSelected()) {
                this.lockTimeTextField.setEnabled(false);
            }
            this.globalInfoPanel.setVisible(!bl);
            this.globalInfoPanel.updateUI();
            this.lockSettingPanel1.updateUI();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IdleTimeSettingPanel.this.enableLockSettingPanel(bl);
                }
            });
        }
    }

    void setAutoLockEnabled(boolean bl) {
        this.lockCheckBox.setSelected(bl);
    }

    void setIdleTime(int n) {
        this.lockTimeTextField.setText("" + n);
    }

    void setMainWindowVisibility(boolean bl) {
        this.mainWindowVisibilityCheckBox.setSelected(bl);
    }
}

