/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.terminalmanagement.IdleTimeSettingPanel;
import com.swimap.iview.framework.terminalmanagement.TerminalManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.OptionPane;
import com.swimap.iview.util.log.IviewLogger;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.omg.CORBA.ORB;

public class IdleTimeSetting
extends BaseClientSettings {
    private static IviewLogger logger = IviewLogger.getLogger(IdleTimeSetting.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/terminalmanagement/Res");
    private IdleTimeSettingPanel settingPanel = null;
    private boolean bChanged = false;
    static final int DEFAULT_IDLE_TIME_MIN = 1;
    static final int DEFAULT_IDLE_TIME_MAX = 35000;
    private int minIdleTime = 1;
    private int maxIdleTime = 35000;

    public IdleTimeSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
    }

    public IdleTimeSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    @Override
    public void reinitialize() {
        super.reinitialize();
        this.settingPanel.initLockTime();
        if (this.settingPanel.isWindowGUIupdate()) {
            this.settingPanel.initMainWindowVisibility();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean apply() {
        TerminalManager terminalManager = this.getTerminalMananger();
        boolean bl = false;
        if (terminalManager == null) {
            return false;
        }
        TerminalManager terminalManager2 = terminalManager;
        synchronized (terminalManager2) {
            terminalManager.setDisableSaveToFile(true);
            try {
                bl = this.performApply(terminalManager);
                terminalManager.saveFileNoCheck();
            }
            finally {
                terminalManager.setDisableSaveToFile(false);
            }
            return bl;
        }
    }

    private boolean performApply(TerminalManager terminalManager) {
        int n;
        int n2 = terminalManager.getIdleTime();
        boolean bl = terminalManager.isLockSettingEnable();
        boolean bl2 = terminalManager.isMainwindowVisibleOnLock();
        boolean bl3 = false;
        if (terminalManager.readGlobalAutoLockSetting()) {
            n = terminalManager.getGloabalIdleTimeFromConfig();
            if (!terminalManager.isGlobalAutoLockEnabled() || n != Integer.valueOf(this.settingPanel.lockTimeTextField.getText())) {
                bl3 = true;
            }
            terminalManager.setGlobalAutoLockWithCheck(n, true, false);
        } else {
            n = terminalManager.getIdleTime();
            ((IdleTimeSettingPanel)this.getSettingsPanel()).enableLockSettingPanel(true);
            terminalManager.setGlobalAutoLockFlag(false);
            logger.trace("Lock check box value : " + this.settingPanel.lockCheckBox.isSelected());
            if (!this.settingPanel.lockCheckBox.isSelected()) {
                terminalManager.setLockSettingEnable(false);
                if (!this.settingPanel.lockTimeTextField.isValid()) {
                    this.settingPanel.lockTimeTextField.setText("" + n);
                    FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
                    this.bChanged = false;
                }
                if (this.settingPanel.lockTimeTextField.getValue() != 0) {
                    terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
                    if (TerminalManager.isFailed) {
                        logger.trace("lock settings failed idle time set to 0");
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
                    } else {
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
                        this.bChanged = false;
                    }
                }
            } else {
                terminalManager.setLockSettingEnable(true);
                if (!this.settingPanel.lockTimeTextField.isValid()) {
                    logger.trace("lock settings is invalid");
                    FrameworkUtilities.getSystemSettingsManager().activateSetting(this);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ((IdleTimeSetting)IdleTimeSetting.this).settingPanel.lockTimeTextField.requestFocus();
                            ((IdleTimeSetting)IdleTimeSetting.this).settingPanel.lockTimeTextField.selectAll();
                            OptionPane.showMessageDialog(FrameworkUtilities.getMainFrame(), IdleTimeSetting.this.getRangeInvalidRes());
                        }
                    });
                    return false;
                }
                logger.trace("lock settings are valid");
                if (terminalManager.getIdleTime() != this.settingPanel.lockTimeTextField.getValue()) {
                    terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
                    if (TerminalManager.isFailed) {
                        logger.trace("lock settings failed");
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
                    } else {
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
                        this.bChanged = false;
                    }
                } else {
                    terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
                }
            }
        }
        if (this.settingPanel.isWindowGUIupdate()) {
            n = this.settingPanel.mainWindowVisibilityCheckBox.isSelected() ? 1 : 0;
            terminalManager.setMainWindowVisibleOnLock(n != 0);
            terminalManager.saveMainWindowVisibilityToConfingure(n != 0);
            if (this.isChanged()) {
                if (TerminalManager.isFailed) {
                    logger.trace("lock settings failed data changed");
                    terminalManager.setIdleTime(n2);
                    terminalManager.setMainWindowVisibleOnLock(bl2);
                    terminalManager.setLockSettingEnable(bl);
                    FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
                } else {
                    if (bl3) {
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg_due_to_global_lock"));
                    } else {
                        FrameworkUtilities.getSystemSettingsManager().setSystemSettingStatus(this.getTabLabel(), true, "");
                    }
                    this.bChanged = false;
                }
            }
        }
        return true;
    }

    @Override
    public boolean exit() {
        TerminalManager terminalManager = this.getTerminalMananger();
        if (terminalManager == null) {
            return false;
        }
        if (terminalManager.isPauseFlag()) {
            return true;
        }
        int n = terminalManager.getIdleTime();
        boolean bl = terminalManager.isLockSettingEnable();
        this.settingPanel.lockCheckBox.setSelected(bl);
        this.settingPanel.lockTimeTextField.setText("" + n);
        this.settingPanel.lockTimeTextField.setEnabled(bl && !terminalManager.isGlobalAutoLockEnabled());
        if (this.settingPanel.isWindowGUIupdate()) {
            boolean bl2 = terminalManager.isMainwindowVisibleOnLock();
            this.settingPanel.mainWindowVisibilityCheckBox.setSelected(bl2);
        }
        return true;
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.settingPanel == null) {
            this.settingPanel = new IdleTimeSettingPanel(this);
        }
        return this.settingPanel;
    }

    @Override
    public boolean isChanged() {
        return this.bChanged;
    }

    public void setChanged(boolean bl) {
        this.bChanged = bl;
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged(this.getModuleName(), this.isChanged());
    }

    @Override
    public String getTabLabel() {
        return res.getString("Lock_Settings");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getModuleName() {
        return "idle";
    }

    final TerminalManager getTerminalMananger() {
        return FrameworkUtilities.getTerminalManager();
    }

    final void setIdleTimeRange(int n, int n2) {
        String string;
        if (n == this.minIdleTime && n2 == this.maxIdleTime) {
            logger.debug("current range is same as the setting range,do not change.");
            return;
        }
        this.maxIdleTime = n2;
        this.minIdleTime = n;
        int n3 = this.getTerminalMananger().getIdleTime();
        if (n3 > this.maxIdleTime) {
            string = new StringBuffer(50).append("Current idle time is bigger than the max value").append(", set it to max value:[oldvalue=").append(n3).append("; max=").append(this.maxIdleTime).append(']').toString();
            logger.debug(string);
            this.getTerminalMananger().setIdleTime(this.maxIdleTime);
            this.settingPanel.lockTimeTextField.setText(Integer.toString(this.maxIdleTime));
        }
        if (n3 < this.minIdleTime && n3 != 0) {
            string = new StringBuffer(50).append("Current idle time is smaller than the min value").append(", set it to min value:[oldvalue=").append(n3).append("; min=").append(this.minIdleTime).append(']').toString();
            logger.debug(string);
            this.getTerminalMananger().setIdleTime(this.minIdleTime);
            this.settingPanel.lockTimeTextField.setText(Integer.toString(this.minIdleTime));
        }
        this.settingPanel.lockTimeTextField.setRange(this.minIdleTime, this.maxIdleTime);
    }

    final String getRangeInvalidRes() {
        String string = res.getString("IdleTimeSettingPanel_Idletiem_Valid");
        MessageFormat messageFormat = new MessageFormat(string);
        string = messageFormat.format(new String[]{Integer.toString(this.minIdleTime), Integer.toString(this.maxIdleTime)});
        return string;
    }

    final int getMinIdleTime() {
        return this.minIdleTime;
    }

    final int getMaxIdleTime() {
        return this.maxIdleTime;
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    void enableChangedSetting() {
        TerminalManager terminalManager = this.getTerminalMananger();
        if (terminalManager == null) {
            return;
        }
        int n = terminalManager.getIdleTime();
        if (!terminalManager.isLockSettingEnable()) {
            this.settingPanel.lockCheckBox.setSelected(false);
            if (!this.settingPanel.lockTimeTextField.isValid()) {
                this.settingPanel.lockTimeTextField.setText("" + n);
            }
            if (this.settingPanel.lockTimeTextField.getValue() != 0) {
                terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
            }
        } else {
            this.settingPanel.lockCheckBox.setSelected(true);
            if (!this.settingPanel.lockTimeTextField.isValid()) {
                this.settingPanel.lockTimeTextField.setText("" + n);
            } else {
                terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
            }
        }
    }

    void enableChangedSettingforGlobal() {
        TerminalManager terminalManager = this.getTerminalMananger();
        if (terminalManager == null) {
            return;
        }
        int n = terminalManager.getIdleTime();
        if (!this.settingPanel.lockTimeTextField.isValid()) {
            this.settingPanel.lockTimeTextField.setText("" + n);
        } else {
            terminalManager.setIdleTime(this.settingPanel.lockTimeTextField.getValue());
        }
    }

    boolean isTimeSettingShown() {
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        BaseClientSettings baseClientSettings = systemSettingsManager.getActiveClientSetting();
        if (null != baseClientSettings) {
            return this.getModuleName().equals(baseClientSettings.getModuleName()) && systemSettingsManager.isSettingDialogVisible();
        }
        return false;
    }
}

