/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.terminalmanagement;

import com.swimap.iview.framework.terminalmanagement.ITerminalManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.utils.timer.IviewSwingTimer;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.FocusManager;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class EventMonitor {
    private static IviewLogger logger = IviewLogger.getLogger(EventMonitor.class, "IVIEW");
    private boolean isBusy = false;
    private boolean hookEnable = true;
    private ITerminalManager terminalManager = null;
    private IviewSwingTimer timer = null;
    private static final int INTERVAL_TIME = 60000;
    private boolean bAllSubTerminalTimeUp = true;
    public static final int POLL_SUBTERMINAL_INTERVAL = 30000;
    private AWTEventListener awtListener = new AWTEventListener(){

        @Override
        public void eventDispatched(AWTEvent aWTEvent) {
            Window window = FocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
            if (EventMonitor.this.timer != null && EventMonitor.this.timer.isRunning() && window != null) {
                EventMonitor.this.restartTimer();
                EventMonitor.this.terminalManager.setIdleTimeLeft(1);
            }
        }
    };

    public EventMonitor(ITerminalManager iTerminalManager) {
        this.terminalManager = iTerminalManager;
    }

    public void doStartTimer() {
        if (null == FrameworkCommandProcessor.getInstance().loadProgressDialog) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    EventMonitor.this.newAndBeginTimer();
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void newAndBeginTimer() {
        if (SwingUtilities.isEventDispatchThread()) {
            int n;
            if (this.timer != null) {
                this.timer.stop();
            }
            if (0 < (n = this.terminalManager.getIdleTime()) && this.terminalManager.isLockSettingEnable()) {
                if (this.timer != null) {
                    logger.trace("Timer delay set " + n * 60000);
                    this.timer.setDelay(n * 60000);
                    this.timer.setInitialDelay(n * 60000);
                } else {
                    logger.trace("New Timer created in time interval " + n * 60000);
                    this.timer = new IviewSwingTimer(n * 60000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            if (EventMonitor.this.bAllSubTerminalTimeUp) {
                                EventMonitor.this.stopTimer();
                                Toolkit.getDefaultToolkit().getSystemEventQueue().postEvent(new IviewLockEvent());
                            }
                        }
                    });
                }
            } else {
                return;
            }
            this.timer.startLockTimer();
            this.setEnable(true);
            this.hookUserEvent();
        }
    }

    private void hookUserEvent() {
        if (SwingUtilities.isEventDispatchThread()) {
            Toolkit.getDefaultToolkit().addAWTEventListener(this.awtListener, 56L);
        }
    }

    public void restartTimer() {
        if (this.terminalManager.getIdleTime() > 0 && this.terminalManager.isLockSettingEnable() && null != this.timer) {
            this.timer.restartLockTimer();
        }
    }

    public void stopTimer() {
        if (null != this.timer) {
            this.timer.stop();
        }
    }

    public void startTimer() {
        if (null != this.timer) {
            this.timer.startLockTimer();
        }
    }

    public void setBusy(boolean bl) {
        if (this.isBusy != bl) {
            this.isBusy = bl;
            JFrame jFrame = FrameworkUtilities.getMainFrame();
            if (jFrame != null) {
                ScreenToolKit.setComponentCursorBusy(jFrame, this.isBusy);
            }
        }
    }

    public void setEnable(boolean bl) {
        this.hookEnable = bl;
    }

    public boolean getBusy() {
        return this.isBusy;
    }

    public boolean getEnable() {
        return this.hookEnable;
    }

    public boolean isTimerRunning() {
        return this.timer.isRunning();
    }

    public int getIdleTimeLeft() {
        return this.terminalManager.getIdleTimeLeft();
    }

    final void clear() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.awtListener);
        this.awtListener = null;
        if (null != this.timer) {
            this.timer.stop();
            this.timer = null;
        }
        this.terminalManager = null;
    }

    private class IviewLockEvent
    extends InvocationEvent {
        public IviewLockEvent() {
            super((Object)Toolkit.getDefaultToolkit(), new Runnable(){

                @Override
                public void run() {
                    EventMonitor.this.terminalManager.lockTerminal();
                }
            });
        }

        @Override
        public String paramString() {
            return "iview_terminal_event";
        }
    }

    public class LoggingQueue
    extends EventQueue {
        @Override
        protected void dispatchEvent(AWTEvent aWTEvent) {
            if ((aWTEvent instanceof MouseEvent || aWTEvent instanceof KeyEvent) && EventMonitor.this.timer != null && EventMonitor.this.timer.isRunning()) {
                EventMonitor.this.restartTimer();
                EventMonitor.this.terminalManager.setIdleTimeLeft(1);
            }
            if (EventMonitor.this.getBusy()) {
                return;
            }
            super.dispatchEvent(aWTEvent);
        }
    }
}

