/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.systemsettingsmanagement.treetype;

import com.swimap.iview.framework.systemsettingsmanagement.treetype.ISettingAction;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingDialog;
import com.swimap.iview.util.log.IviewLogger;
import javax.swing.Icon;
import javax.swing.JPanel;

public class SettingInfo {
    private static IviewLogger logger = IviewLogger.getLogger(SettingInfo.class, "IVIEW");
    private JPanel settingPanel = null;
    private JPanel panelWithDescription = null;
    private String name = null;
    private String parentClassName = null;
    private Icon icon = null;
    private ISettingAction action = null;
    private String keyValue = null;
    private boolean enableNode = true;
    private String pluginName = "";
    private String titleDescription = "";

    public SettingInfo() {
    }

    public SettingInfo(JPanel jPanel, String string, String string2, Icon icon, ISettingAction iSettingAction) {
        this.settingPanel = jPanel;
        this.name = string;
        this.parentClassName = string2;
        this.icon = icon;
        this.action = iSettingAction;
    }

    public ISettingAction getAction() {
        return this.action;
    }

    public void setAction(ISettingAction iSettingAction) {
        this.action = iSettingAction;
    }

    public String getActionClassName() {
        if (this.action == null) {
            throw new IllegalStateException("Must specify the ISettingAction.");
        }
        return this.action.getClass().getName();
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getTitleDescription() {
        return this.titleDescription;
    }

    public void setTitleDescription(int n) {
        this.titleDescription = SettingDialog.getTitleDescription(n);
    }

    public String getParentClassName() {
        return this.parentClassName;
    }

    public void setParentClassName(String string) {
        this.parentClassName = string;
    }

    public JPanel getSettingPanel() {
        return this.settingPanel;
    }

    public void setSettingPanel(JPanel jPanel) {
        this.settingPanel = jPanel;
    }

    public JPanel getPanelWithDescription() {
        return null == this.panelWithDescription ? this.getSettingPanel() : this.panelWithDescription;
    }

    public void setSettingDescription(String string) {
        this.panelWithDescription = SettingDialog.getSettingPanelWithDescr(this.settingPanel, string);
    }

    public String toString() {
        return this.getName();
    }

    public String getKeyValue() {
        return this.keyValue;
    }

    public void setKeyValue(String string) {
        this.keyValue = string;
    }

    public int getSerialNumber(String string) {
        if (string == null || string.trim().length() == 0) {
            return -1;
        }
        int n = string.lastIndexOf("-");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            logger.error("sSerialNumber=" + string);
            logger.trace(exception.getMessage(), exception);
            return -1;
        }
    }

    public boolean isDisabled() {
        return this.enableNode;
    }

    public void setEnabled(boolean bl) {
        this.enableNode = bl;
    }

    public String getPluginName() {
        return this.pluginName;
    }

    public void setPluginName(String string) {
        this.pluginName = string;
    }
}

