/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.systemsettingsmanagement.treetype;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.regionconfig.ui.DateSetting;
import com.swimap.iview.framework.regionconfig.ui.TimeSetting;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.IRestartNotifier;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.ISettingAction;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingDialog;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.Collator;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class SettingHandler {
    private static IviewLogger logger = IviewLogger.getLogger(SettingHandler.class, "IVIEW");
    private ConcurrentHashMap classnameSettinginfoMap = new ConcurrentHashMap(10);
    private ConcurrentHashMap classnameNodeMap = new ConcurrentHashMap(10);
    private SettingDialog settingDialog = null;
    private DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
    private DefaultTreeModel treeModel = new DefaultTreeModel(this.rootNode);
    private IRestartNotifier restartNotifier = null;
    private LinkedHashSet<SettingInfo> changedSettingInfoSet = new LinkedHashSet(5);
    SettingInfo activeSettingInfo = null;
    private String REGION_DATE_SETTING = "com.swimap.iview.framework.regionconfig.RegionDateSetting";
    private String REGION_TIME_SETTING = "com.swimap.iview.framework.regionconfig.RegionTimeSetting";
    private ActionListener okListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingHandler.this.settingDialog.getOKButton().requestFocus();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (SettingHandler.this.notifyApply()) {
                        logger.trace("Client settings got applied.");
                        if (FrameworkUtilities.getSystemSettingsManager().notifySettingItemsAboutClose()) {
                            logger.trace("Making the system setting dialog invisible.");
                            SettingHandler.this.settingDialog.setVisible(false);
                            SettingHandler.this.settingDialog.removeWindowListener(SettingHandler.this.settingWindowListener);
                            SettingHandler.this.settingDialog.removeComponentListener(SettingHandler.this.settingComponentListener);
                        }
                    }
                }
            });
        }
    };
    private ActionListener applyListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SettingHandler.this.notifyApply();
        }
    };
    private ActionListener cancelListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FrameworkUtilities.getSystemSettingsManager().notifySettingItemsAboutClose()) {
                SettingHandler.this.notifyExit();
                SettingHandler.this.settingDialog.setVisible(false);
                SettingHandler.this.settingDialog.removeWindowListener(SettingHandler.this.settingWindowListener);
                SettingHandler.this.settingDialog.removeComponentListener(SettingHandler.this.settingComponentListener);
            }
        }
    };
    WindowListener settingWindowListener = new WindowAdapter(){

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (FrameworkUtilities.getSystemSettingsManager().notifySettingItemsAboutClose()) {
                SettingHandler.this.notifyExit();
                SettingHandler.this.settingDialog.setVisible(false);
                SettingHandler.this.settingDialog.removeWindowListener(this);
                SettingHandler.this.settingDialog.removeComponentListener(SettingHandler.this.settingComponentListener);
            }
        }
    };
    ComponentListener settingComponentListener = new ComponentAdapter(){

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
            SettingHandler.this.settingDialog.setSize(FrameworkUtilities.getSystemSettingsManager().getWidth(), FrameworkUtilities.getSystemSettingsManager().getHeight());
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            ((SettingHandler)SettingHandler.this).settingDialog.jsp.setDividerLocation(180);
            SettingHandler.this.settingDialog.getTree().requestFocus();
        }
    };

    public SettingHandler(SettingDialog settingDialog) {
        if (settingDialog == null) {
            throw new IllegalArgumentException("Parameter settingdialog cannot be null");
        }
        this.settingDialog = settingDialog;
        this.setupSettingDialog();
    }

    private void setupSettingDialog() {
        this.settingDialog.getTree().setModel(this.treeModel);
        this.settingDialog.getTree().getSelectionModel().setSelectionMode(1);
        this.settingDialog.getTree().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                SettingInfo settingInfo;
                if (treeSelectionEvent.getNewLeadSelectionPath() == null) {
                    return;
                }
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent();
                SettingHandler.this.activeSettingInfo = settingInfo = (SettingInfo)defaultMutableTreeNode.getUserObject();
                if (settingInfo != null) {
                    Object object;
                    if (!settingInfo.isDisabled()) {
                        SettingHandler.this.settingDialog.getTree().setSelectionPath(treeSelectionEvent.getOldLeadSelectionPath());
                        return;
                    }
                    JPanel jPanel = settingInfo.getSettingPanel();
                    if (null != jPanel && logger.isDebugEnabled()) {
                        logger.debug("Componets in setting panel" + jPanel.getComponents());
                    }
                    SettingHandler.this.settingDialog.setDescription(settingInfo.getName() + settingInfo.getTitleDescription());
                    SettingHandler.this.settingDialog.refreshSettingPanel(settingInfo.getPanelWithDescription());
                    ISettingAction iSettingAction = settingInfo.getAction();
                    if (iSettingAction instanceof BaseClientSettings) {
                        FrameworkUtilities.getSystemSettingsManager().setActiveClientSetting((BaseClientSettings)settingInfo.getAction());
                    } else {
                        FrameworkUtilities.getSystemSettingsManager().setActiveClientSetting(null);
                    }
                    settingInfo.getAction().actived();
                    if (SettingHandler.this.REGION_TIME_SETTING.equals(settingInfo.getActionClassName())) {
                        object = (TimeSetting)settingInfo.getSettingPanel();
                        ((TimeSetting)object).initZoneOffset();
                        ((TimeSetting)object).startRefreshThread();
                        object = null;
                    }
                    if (SettingHandler.this.REGION_DATE_SETTING.equals(settingInfo.getActionClassName())) {
                        object = (DateSetting)settingInfo.getSettingPanel();
                        ((DateSetting)object).startRefreshThread();
                        object = null;
                    }
                    if ((object = (String)settingInfo.getSettingPanel().getClientProperty("HELP_ID_PROPERTY")) == null) {
                        object = (String)settingInfo.getSettingPanel().getClientProperty("HelpID");
                    }
                    if (object != null) {
                        HelpManager.getInstance().enableHelpKey(SettingHandler.this.settingDialog.getTree(), (String)object);
                    } else {
                        HelpManager.getInstance().enableHelpKey(SettingHandler.this.settingDialog.getTree(), "iVIEW.systemsetting");
                    }
                }
            }
        });
        this.settingDialog.getOKButton().addActionListener(this.okListener);
        this.settingDialog.getCancelButton().addActionListener(this.cancelListener);
        this.settingDialog.getApplyButton().addActionListener(this.applyListener);
    }

    public void setDisableNode(String string) {
        Collection collection = this.classnameSettinginfoMap.values();
        for (SettingInfo settingInfo : collection) {
            logger.trace("Collection Values:" + settingInfo.getName());
            if (!ResourceUtil.areEquals(settingInfo.getName(), string)) continue;
            settingInfo.setEnabled(false);
        }
    }

    public final JDialog getSettingDialog() {
        return this.settingDialog;
    }

    public void registerSetting(final SettingInfo settingInfo) {
        if (null == settingInfo) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SettingHandler.this.addToTree(settingInfo);
                }
            });
        } else {
            this.addToTree(settingInfo);
        }
    }

    private void addToTree(SettingInfo settingInfo) {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        String string = settingInfo.getParentClassName();
        DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(settingInfo);
        if (string != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.classnameNodeMap.get(string);
            if (defaultMutableTreeNode == null) {
                logger.warn(settingInfo.getName() + "'s parent node has not registered!");
                defaultMutableTreeNode = this.rootNode;
            }
        } else {
            defaultMutableTreeNode = this.rootNode;
        }
        int n = this.treeModel.getChildCount(defaultMutableTreeNode);
        Object[] objectArray = new Object[n + 1];
        int n2 = 0;
        int n3 = 0;
        Object object = null;
        String string2 = null;
        if (SystemSettingsManager.isAlphabeticalSorting()) {
            for (n2 = 0; n2 < n; ++n2) {
                object = ((DefaultMutableTreeNode)this.treeModel.getChild(defaultMutableTreeNode, n2)).getUserObject();
                objectArray[n2] = ((SettingInfo)object).getName();
            }
            objectArray[n2] = settingInfo.getName();
        } else {
            for (n2 = 0; n2 < n; ++n2) {
                object = ((DefaultMutableTreeNode)this.treeModel.getChild(defaultMutableTreeNode, n2)).getUserObject();
                string2 = ((SettingInfo)object).getKeyValue();
                objectArray[n2] = settingInfo.getSerialNumber(string2);
            }
            if (null == settingInfo.getKeyValue()) {
                objectArray[n2] = n2 - 1 < 0 || objectArray[n2 - 1] == null ? "0" : objectArray[n2 - 1];
                settingInfo.setKeyValue(objectArray[n2].toString());
            } else {
                objectArray[n2] = settingInfo.getSerialNumber(settingInfo.getKeyValue());
            }
        }
        Object object2 = objectArray[n2];
        if (SystemSettingsManager.isAlphabeticalSorting()) {
            Locale locale = ResourceMng.getInstance().getLocale();
            Arrays.sort(objectArray, Collator.getInstance(new Locale(locale.getLanguage(), locale.getCountry())));
        } else {
            Arrays.sort(objectArray);
        }
        n3 = SystemSettingsManager.Search(objectArray, object2);
        if (n3 == -1 || n3 > this.treeModel.getChildCount(defaultMutableTreeNode)) {
            n3 = this.treeModel.getChildCount(defaultMutableTreeNode);
        }
        logger.debug("Prefrence node is added :" + defaultMutableTreeNode2 + "Position is :" + n3);
        this.treeModel.insertNodeInto(defaultMutableTreeNode2, defaultMutableTreeNode, n3);
        this.treeModel.nodeStructureChanged(defaultMutableTreeNode2);
        if (this.classnameSettinginfoMap.isEmpty()) {
            this.settingDialog.getTree().expandRow(0);
            this.settingDialog.getTree().setRootVisible(false);
            this.settingDialog.getTree().setShowsRootHandles(true);
        }
        if (null != defaultMutableTreeNode2) {
            this.classnameNodeMap.put(settingInfo.getActionClassName(), defaultMutableTreeNode2);
        }
        this.classnameSettinginfoMap.put(settingInfo.getActionClassName(), settingInfo);
    }

    void unregisterSetting(String string) {
        Iterator iterator = new HashMap(this.classnameSettinginfoMap).values().iterator();
        SettingInfo settingInfo = null;
        boolean bl = iterator.hasNext();
        while (bl) {
            settingInfo = (SettingInfo)iterator.next();
            if (string.equals(settingInfo.getPluginName())) {
                this.unregisterSetting(settingInfo);
            }
            bl = iterator.hasNext();
        }
    }

    public void unregisterSetting(SettingInfo settingInfo) {
        ISettingAction iSettingAction = settingInfo.getAction();
        this.unregisterSetting(iSettingAction);
    }

    public void unregisterSetting(ISettingAction iSettingAction) {
        String string = iSettingAction.getClass().getName();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.classnameNodeMap.get(string);
        if (defaultMutableTreeNode == null) {
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode2 = defaultMutableTreeNode;
        SettingInfo settingInfo = null;
        if (defaultMutableTreeNode2.getParent().getChildCount() == 1) {
            DefaultMutableTreeNode defaultMutableTreeNode3 = (DefaultMutableTreeNode)defaultMutableTreeNode2.getParent();
            settingInfo = (SettingInfo)defaultMutableTreeNode3.getUserObject();
        }
        this.treeModel.removeNodeFromParent(defaultMutableTreeNode);
        this.classnameNodeMap.remove(string);
        this.classnameSettinginfoMap.remove(string);
        if (settingInfo != null) {
            this.unregisterSetting(settingInfo);
        }
    }

    public void setRestartNotifier(IRestartNotifier iRestartNotifier) {
        this.restartNotifier = iRestartNotifier;
    }

    private void notifyExit() {
        ISettingAction iSettingAction = null;
        SettingInfo settingInfo = null;
        String string = null;
        this.changedSettingInfoSet.clear();
        Iterator iterator = this.classnameSettinginfoMap.keySet().iterator();
        while (iterator.hasNext()) {
            string = iterator.next().toString();
            settingInfo = (SettingInfo)this.classnameSettinginfoMap.get(string);
            iSettingAction = settingInfo.getAction();
            try {
                iSettingAction.exit();
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        this.activeSettingInfo = null;
        this.settingDialog.getApplyButton().setEnabled(false);
    }

    private boolean notifyApply() {
        logger.trace("Enter NotifyApply");
        ISettingAction iSettingAction = null;
        SettingInfo settingInfo = null;
        Iterator iterator = this.changedSettingInfoSet.iterator();
        while (iterator.hasNext() && null != (settingInfo = (SettingInfo)iterator.next())) {
            iSettingAction = settingInfo.getAction();
            try {
                if (iSettingAction.apply()) continue;
                logger.trace("Apply of the system Setting failed : " + settingInfo.getName());
                return false;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        this.changedSettingInfoSet.clear();
        if (this.restartNotifier != null) {
            try {
                if (this.settingDialog.getApplyButton().isEnabled()) {
                    this.restartNotifier.notifyRestartSystem();
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
        this.settingDialog.getApplyButton().setEnabled(false);
        logger.trace("Exit NotifyApply");
        return true;
    }

    public void notifyChanged() {
        if (null != this.activeSettingInfo) {
            this.settingDialog.getApplyButton().setEnabled(true);
            this.changedSettingInfoSet.add(this.activeSettingInfo);
        }
    }

    public void launchDialog() {
        TreePath treePath;
        if (this.settingDialog.getTree().getSelectionPath() == null && this.rootNode.getChildCount() > 0) {
            treePath = new TreePath(this.treeModel.getPathToRoot(this.rootNode.getFirstChild()));
            this.settingDialog.getTree().setSelectionPath(treePath);
        } else {
            treePath = this.settingDialog.getTree().getSelectionPath();
            this.settingDialog.getTree().clearSelection();
            this.settingDialog.getTree().setSelectionPath(treePath);
        }
        if (FrameworkUtilities.getSystemSettingsManager().isChangeSize()) {
            int n = FrameworkUtilities.getSystemSettingsManager().getHeight();
            int n2 = FrameworkUtilities.getSystemSettingsManager().getWidth();
            int n3 = n;
            int n4 = n2;
            GraphicsConfiguration graphicsConfiguration = FrameworkUtilities.getMainFrame().getGraphicsConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
            if (n >= ScreenToolKit.getScreenHeight() - (insets.top + insets.bottom)) {
                n3 = ScreenToolKit.getScreenHeight() - (insets.top + insets.bottom);
            }
            if (n2 >= ScreenToolKit.getScreenWidth() - (insets.left + insets.right)) {
                n4 = ScreenToolKit.getScreenWidth() - (insets.left + insets.right);
            }
            this.settingDialog.setPreferredSize(new Dimension(n4, n3));
            this.settingDialog.setSize(n4, n3);
            FrameworkUtilities.getPreferenceManager().centerLocateToScreen(this.settingDialog);
        }
        if (null != this.changedSettingInfoSet) {
            this.changedSettingInfoSet.clear();
        }
        this.settingDialog.addWindowListener(this.settingWindowListener);
        this.settingDialog.addComponentListener(this.settingComponentListener);
        this.settingDialog.setVisible(true);
    }

    public void activeNode(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.classnameNodeMap.get(string);
        if (defaultMutableTreeNode != null) {
            TreePath treePath = new TreePath(this.treeModel.getPathToRoot(defaultMutableTreeNode));
            this.settingDialog.getTree().setSelectionPath(treePath);
        }
    }

    public void clear() {
        this.notifyExit();
        this.settingDialog.dispose();
    }

    public void cleanupWhileOSGIExit() {
        this.notifyExit();
        TreeSelectionListener[] treeSelectionListenerArray = this.settingDialog.getTree().getTreeSelectionListeners();
        for (int i = 0; i < treeSelectionListenerArray.length; ++i) {
            this.settingDialog.getTree().removeTreeSelectionListener(treeSelectionListenerArray[i]);
            treeSelectionListenerArray[i] = null;
        }
        this.classnameSettinginfoMap.clear();
        this.classnameSettinginfoMap = null;
        this.classnameNodeMap.clear();
        this.classnameNodeMap = null;
        this.changedSettingInfoSet.clear();
        this.changedSettingInfoSet = null;
        this.settingDialog.getOKButton().removeActionListener(this.okListener);
        this.okListener = null;
        this.settingDialog.getCancelButton().removeActionListener(this.cancelListener);
        this.cancelListener = null;
        this.settingDialog.getApplyButton().removeActionListener(this.applyListener);
        this.applyListener = null;
        WindowListener[] windowListenerArray = this.settingDialog.getWindowListeners();
        for (int i = 0; i < windowListenerArray.length; ++i) {
            this.settingDialog.removeWindowListener(windowListenerArray[i]);
            windowListenerArray[i] = null;
        }
        this.settingDialog.cleanupWhileOSGIExit();
        this.settingDialog.removeAll();
        this.settingDialog.dispose();
        this.settingDialog = null;
        this.rootNode = null;
        this.treeModel = null;
        this.activeSettingInfo = null;
    }
}

