/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.systemsettingsmanagement.treetype;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.LineEtchedBorder;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

public class SettingDialog
extends JDialog {
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/systemsettingsmanagement/Res");
    private JButton btnApply = new JButton(res.getString("SystemSettingsManager_Apply"));
    private JButton btnOK = new JButton(res.getString("SystemSettingsManager_Ok"));
    private JButton btnCancel = new JButton(res.getString("SystemSettingsManager_Cancel"));
    private JTree tree = new JTree();
    private JLabel activeSettingLabel = new JLabel("Untitled");
    private JPanel activeSettingPanel = new JPanel();
    private static final Dimension DEFAULT_BUTTON_SIZE = new Dimension(80, 21);
    static final int SPLIT_POSITION = 180;
    private static final int TITLEPANEL_HIGHT = 35;
    private static final int TITLEPANEL_SPACE = 20;
    private static final int TITLELABLE_LEFT_SPACE = 12;
    private String componentName = "SettingDialog";
    JSplitPane jsp = new JSplitPane(1);
    static Map<JPanel, JPanel> settingPnlMap = new HashMap<JPanel, JPanel>(10);
    private static JPanel descrPnl = null;

    public SettingDialog(JFrame jFrame) {
        super(jFrame);
        this.setupDialog();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        this.activeSettingLabel.setName(string + "_activeSettingLabel");
        this.btnApply.setName(string + "_btnApply");
        this.btnOK.setName(string + "_btnOK");
        this.btnCancel.setName(string + "_btnCancel");
        this.jsp.setName(string + "_jsp");
        this.tree.setName(string + "_tree");
    }

    private void setupDialog() {
        this.setSize(680, 510);
        this.setDefaultCloseOperation(1);
        this.setName(this.componentName);
        this.tree.setRowHeight(18);
        this.jsp.setResizeWeight(0.0);
        this.jsp.setDividerSize(2);
        this.jsp.setDividerLocation(180);
        this.setResizable(false);
        JPanel jPanel = this.createMainPanel();
        this.getContentPane().add((Component)jPanel, "Center");
        JPanel jPanel2 = this.createButtonPanel();
        this.getContentPane().add((Component)jPanel2, "South");
    }

    private JPanel createMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.createTitlePanel(), "North");
        jPanel2.add((Component)this.activeSettingPanel, "Center");
        this.activeSettingPanel.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(null);
        defaultTreeCellRenderer.setOpenIcon(null);
        defaultTreeCellRenderer.setClosedIcon(null);
        this.tree.setCellRenderer(defaultTreeCellRenderer);
        jScrollPane.setBorder(null);
        this.jsp.setLeftComponent(jScrollPane);
        this.jsp.setRightComponent(jPanel2);
        jPanel.setBorder(new LineEtchedBorder());
        jPanel.add((Component)this.jsp, "Center");
        return jPanel;
    }

    private JPanel createTitlePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(this.getWidth() - 180 - 20, 35));
        jPanel.setBorder(new LineEtchedBorder());
        this.activeSettingLabel.setFont(new Font(this.activeSettingLabel.getFont().getName(), 1, this.activeSettingLabel.getFont().getSize() + 1));
        this.activeSettingLabel.setBorder(new EmptyBorder(0, 12, 0, 0));
        jPanel.add(this.activeSettingLabel);
        return jPanel;
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 4, 12));
        jPanel.add(this.btnOK);
        jPanel.add(this.btnCancel);
        jPanel.add(this.btnApply);
        this.btnApply.setEnabled(false);
        JPanel jPanel2 = new JPanel();
        jPanel2.setSize(8, 0);
        jPanel.add(jPanel2);
        this.btnOK.setPreferredSize(DEFAULT_BUTTON_SIZE);
        this.btnCancel.setPreferredSize(DEFAULT_BUTTON_SIZE);
        this.btnApply.setPreferredSize(DEFAULT_BUTTON_SIZE);
        this.btnApply.setMnemonic('A');
        ScreenToolKit.setDefaultButtons(this.btnOK, this.btnCancel);
        return jPanel;
    }

    public void setDescription(String string) {
        this.activeSettingLabel.setText(string);
    }

    public String getDescription() {
        return this.activeSettingLabel.getText();
    }

    public void refreshSettingPanel(JComponent jComponent) {
        CommonUtil.hideShowTooltip();
        this.activeSettingPanel.removeAll();
        if (FrameworkUtilities.getSystemSettingsManager().isChangeSize()) {
            this.activeSettingPanel.add((Component)new JScrollPane(jComponent), "Center");
        } else {
            this.activeSettingPanel.add((Component)jComponent, "Center");
        }
        this.activeSettingPanel.revalidate();
        this.activeSettingPanel.repaint();
    }

    public JTree getTree() {
        return this.tree;
    }

    public JButton getOKButton() {
        return this.btnOK;
    }

    public JButton getApplyButton() {
        return this.btnApply;
    }

    public JButton getCancelButton() {
        return this.btnCancel;
    }

    public static final JPanel getSettingPanelWithDescr(JPanel jPanel, String string) {
        if (null == string) {
            return jPanel;
        }
        JPanel jPanel2 = settingPnlMap.get(jPanel);
        if (null != jPanel2) {
            return jPanel2;
        }
        jPanel2 = new JPanel(new BorderLayout());
        settingPnlMap.put(jPanel, jPanel2);
        descrPnl = new JPanel(new GridBagLayout());
        final JTextArea jTextArea = new JTextArea();
        jTextArea.setName("PreferenceSettings_SettingsDescr_LBL");
        jTextArea.setMinimumSize(new Dimension(100, 20));
        descrPnl.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                Dimension dimension = componentEvent.getComponent().getSize();
                jTextArea.setSize(dimension.width - 40, dimension.height);
            }
        });
        jTextArea.setFont(UIManager.getFont("Label.font"));
        jTextArea.setEditable(false);
        jTextArea.setOpaque(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setFocusable(false);
        jTextArea.setText(string);
        descrPnl.add((Component)jTextArea, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 25, 12, 15), 0, 0));
        jPanel2.add((Component)descrPnl, "North");
        jPanel2.add((Component)jPanel, "Center");
        return jPanel2;
    }

    public static final String getTitleDescription(int n) {
        switch (n) {
            case 1: {
                return " (" + res.getString("user_setting") + ')';
            }
            case 2: {
                return " (" + res.getString("client_setting") + ')';
            }
            case 3: {
                return " (" + res.getString("server_setting") + ')';
            }
        }
        return "";
    }

    public void cleanupWhileOSGIExit() {
        ComponentListener[] componentListenerArray = descrPnl.getComponentListeners();
        for (int i = 0; i < componentListenerArray.length; ++i) {
            descrPnl.removeComponentListener(componentListenerArray[i]);
            componentListenerArray[i] = null;
        }
        ComponentListener[] componentListenerArray2 = this.getComponentListeners();
        for (int i = 0; i < componentListenerArray2.length; ++i) {
            this.removeComponentListener(componentListenerArray2[i]);
            componentListenerArray2[i] = null;
        }
    }
}

