/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.systemsettingsmanagement.treetype;

import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.IRestartNotifier;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingDialog;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingHandler;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingInfo;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.ScreenToolKit;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class PreferenceManager
extends BaseModule {
    private String moduleName = "";
    private SettingHandler handler = null;

    public PreferenceManager(ModuleManager moduleManager, String string) throws ModuleManagementException {
        super(moduleManager, null, null, null);
        this.moduleName = string;
        this.register(this);
        SettingDialog settingDialog = new SettingDialog(FrameworkUtilities.getMainFrame());
        ScreenToolKit.centerLocateToScreen(settingDialog);
        this.handler = new SettingHandler(settingDialog);
    }

    @Override
    public String getModuleName() {
        return this.moduleName;
    }

    public void launchDialog() {
        if (SwingUtilities.isEventDispatchThread()) {
            FrameworkUtilities.getTerminalManager().activateStyleSettings();
            this.handler.launchDialog();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PreferenceManager.this.launchDialog();
                }
            });
        }
    }

    public void customizeSettingsDialog(String string, boolean bl) {
        if (string != null) {
            this.handler.getSettingDialog().setTitle(string);
        }
        this.handler.getSettingDialog().setModal(bl);
    }

    public void customizeSettingsDialogSize(int n, int n2) {
        ((JPanel)this.handler.getSettingDialog().getContentPane()).setPreferredSize(new Dimension(n, n2));
    }

    public void notifyChanged() {
        this.handler.notifyChanged();
    }

    public void activeNode(String string) {
        this.handler.activeNode(string);
    }

    public void registerSetting(SettingInfo settingInfo) {
        this.handler.registerSetting(settingInfo);
    }

    public void registerSetting(BaseClientSettings baseClientSettings) {
        this.registerSetting(null, baseClientSettings);
    }

    public void registerSetting(String string, String string2, BaseClientSettings baseClientSettings) {
        if (baseClientSettings == null) {
            throw new IllegalArgumentException("The client setting cannot be null");
        }
        SettingInfo settingInfo = new SettingInfo();
        settingInfo.setAction(baseClientSettings);
        settingInfo.setName(baseClientSettings.getTabLabel());
        settingInfo.setTitleDescription(baseClientSettings.getTitleDescription());
        JPanel jPanel = baseClientSettings.getSettingsPanel();
        settingInfo.setSettingPanel(jPanel);
        settingInfo.setSettingDescription(baseClientSettings.getSettingDescription());
        settingInfo.setIcon(baseClientSettings.getTabIcon());
        settingInfo.setParentClassName(string2);
        settingInfo.setKeyValue(string);
        this.registerSetting(settingInfo);
    }

    public void registerSetting(String string, BaseClientSettings baseClientSettings) {
        this.registerSetting(null, string, baseClientSettings);
    }

    public void unregisterSetting(String string) {
        this.handler.unregisterSetting(string);
    }

    public void unregisterSetting(SettingInfo settingInfo) {
        this.handler.unregisterSetting(settingInfo);
    }

    public void unregisterSetting(BaseClientSettings baseClientSettings) {
        this.handler.unregisterSetting(baseClientSettings);
    }

    public void setRestartNotifier(IRestartNotifier iRestartNotifier) {
        this.handler.setRestartNotifier(iRestartNotifier);
    }

    @Override
    public void clear() {
        if (null != this.handler) {
            this.handler.clear();
        }
    }

    @Override
    public void reinitialize() {
        this.handler.getSettingDialog().setSize(FrameworkUtilities.getSystemSettingsManager().getWidth(), FrameworkUtilities.getSystemSettingsManager().getHeight());
        ScreenToolKit.centerLocateToScreen(this.handler.getSettingDialog());
    }

    public void centerLocateToScreen(Component component) {
        if (component == null) {
            return;
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = component.getSize();
        Point point = new Point();
        GraphicsConfiguration graphicsConfiguration = FrameworkUtilities.getMainFrame().getGraphicsConfiguration();
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(graphicsConfiguration);
        point.x = (int)((dimension.getWidth() - (double)(insets.right - insets.left)) / 2.0 - dimension2.getWidth() / 2.0);
        point.y = (int)((dimension.getHeight() - (double)(insets.bottom - insets.top)) / 2.0 - dimension2.getHeight() / 2.0);
        component.setLocation(point);
    }

    public void setDisabledNode(String string) {
        this.handler.setDisableNode(string);
    }

    @Override
    public void stop() {
        super.stop();
    }

    public SettingHandler getSettingHandler() {
        return this.handler;
    }
}

