/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.systemsettingsmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.StartupXMLReader;
import com.swimap.iview.framework.applicationmanagement.Application;
import com.swimap.iview.framework.applicationmanagement.ApplicationLauncher;
import com.swimap.iview.framework.applicationmanagement.ApplicationManager;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.regionconfig.ui.DateSetting;
import com.swimap.iview.framework.regionconfig.ui.TimeSetting;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.ISystemSettingsManager;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.IRestartNotifier;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingDialog;
import com.swimap.iview.framework.systemsettingsmanagement.treetype.SettingHandler;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.templates.dialog.DetailMessageDlg;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.ScreenToolKit;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.omg.CORBA.ORB;

public class SystemSettingsManager
extends BaseModule
implements ISystemSettingsManager {
    private static IviewLogger logger = IviewLogger.getLogger(SystemSettingsManager.class, "IVIEW");
    private static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/systemsettingsmanagement/Res");
    protected JDialog systemSettingsDialog = null;
    private JButton applyButton = new JButton(res.getString("SystemSettingsManager_Apply"));
    protected Hashtable clientSettingsStore = new Hashtable(15);
    protected Hashtable clientKeyStore = new Hashtable(15);
    private Hashtable clientKeyStoreLeaf = new Hashtable(15);
    protected JTabbedPane clientSettingsTabbedPane = new JTabbedPane();
    protected int key = 0;
    public static final int CLIENT_SETTING_ADD_ERROR = -1;
    private BaseClientSettings currentClientSetting = null;
    private boolean dialogFirstOpened = false;
    private boolean isOpenFirst = false;
    protected int hideAction = 0;
    public static final int NOTHING_HIDE = 0;
    public static final int OK_HIDE = 1;
    public static final int CANCEL_HIDE = 2;
    private boolean needRestartSystem = false;
    public String activeWindow = null;
    private static final String DEFAULT_CLIENTSETTINGS_FILE = "conf/mainfrm/clientsettingslist";
    private static final String CLIENTSETTINGS_CONFIG_FILE = "conf/mainfrm/clientsettingsconfig";
    public static final int DEFAULT_DIALOG_WIDTH = 680;
    public static final int DEFAULT_DIALOG_HEIGHT = 510;
    private static int dialogWidth = 680;
    private static int dialogHeight = 510;
    private static final int HORIZONTAL_GAP = 4;
    private static final int VERTICAL_GAP = 12;
    private static final int BUTTON_HEIGHT = 21;
    private static final String CLIENT_PROPERTY_KEY = "settingModule";
    private static final String SETTING_CLIENT_PROPERTY = "SettingPnlWithDescr";
    private static final String PARA_CLASS_ID = "clientSettingClassId";
    private static final String PARA_MODULE_ID = "moduleId";
    private static final String DESC_TAB_LAYOUT = "TabLayout";
    private static final String PARA_LAYOUT = "layout";
    private static final String DESC_DIALOG_SIZE = "DialogSize";
    private static final String PARA_DIALOG_WIDTH = "width";
    private static final String PARA_DIALOG_HEIGHT = "height";
    private static final int FIRST_TAB_INDEX = 0;
    private static int tabLayout = 1;
    private static final String PARA_VIEW_TYPE = "viewtype";
    private static final String PARA_DISPALY_TYPE = "displayType";
    private static boolean isAlphabeticalSorting = true;
    public static final int VIEW_TYPE_TABBEDPANE = 0;
    public static final int VIEW_TYPE_TREE = 1;
    private static final String SYSSETTING = "SysSetting";
    private static final String APPID = "SysSetting";
    private static final String APP_BASE = "application_base";
    private static final String ID = "id";
    private static final String APPLICATION_INFO = "applicationInfo";
    private int settingsViewType = 0;
    private HashMap<String, String[]> statusMap = new HashMap(16);
    private String parentKey = null;
    private static final String PARA_SEQUENCE_ID = "sequenceId";
    private final int BUTTON_PANEL_HEIGHT = 300;
    private final int BUTTON_PANEL_WIDTH = 300;
    private boolean changeSize = false;
    private ModuleManager moduleManager = null;
    private String activeModuleID = null;
    private BaseClientSettings activeClientSetting = null;

    public SystemSettingsManager(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        this.moduleManager = moduleManager;
        this.setupDialog(FrameworkUtilities.getMainFrame());
        this.register(this);
        if (this.settingsViewType == 1) {
            this.registerRestartNotifier();
        }
    }

    public SystemSettingsManager(ModuleManager moduleManager) throws ModuleManagementException {
        this(moduleManager, null, null, null);
        this.moduleManager = moduleManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void launchSystemSettingsDialog() {
        Object object;
        ArrayList<String> arrayList;
        Object object2;
        if (FrameworkCommandProcessor.getInstance().isAppStyle()) {
            Object object3;
            Object object4;
            Object object5;
            object2 = "SysSetting";
            arrayList = System.getProperty("user.dir");
            String string = (String)((Object)arrayList) + File.separator + "applications" + File.separator + "SysSetting";
            object = new File((String)((Object)arrayList) + File.separator + "applications" + File.separator + "SysSetting");
            if (((File)object).exists()) {
                object5 = string + File.separator + APP_BASE;
                object4 = CommStyleManager.getInstance().getCommonStyleFileByPath((String)object5);
                try {
                    object3 = ((CommStyleInfo)object4).getAreaDescContainer(0);
                    DescContainer descContainer = ((AreaDescContainer)object3).getDescContainer(APPLICATION_INFO);
                    object2 = descContainer.getParasItemValue(ID);
                }
                catch (Exception exception) {
                    object2 = "SysSetting";
                }
            }
            object5 = ApplicationManager.getInstance().getApplications();
            object4 = object5.iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                if (!((Application)object3).getId().equals(object2) || ApplicationManager.getInstance().isApplcationLaunched(((Application)object3).getId())) continue;
                try {
                    ((Application)object3).setShowApplication(false);
                    ApplicationLauncher.getAppLauncher().launchApplication(((Application)object3).getId(), true, null);
                    break;
                }
                finally {
                    ((Application)object3).setShowApplication(true);
                }
            }
        }
        object2 = FrameworkCommandProcessor.getInstance().getFailedModules();
        arrayList = this.moduleManager.getNonOperationalModules();
        if (null != arrayList) {
            object2.addAll(arrayList);
        }
        int n = object2.size();
        object = "";
        for (int i = 0; i < n; ++i) {
            object = (String)object2.get(i);
            if (null == object) continue;
            this.removeSetting((String)object);
        }
        this.launchSystemSettingsDialog(this.activeWindow);
        this.activeWindow = null;
    }

    @Override
    public void launchSystemSettingsDialog(String string) {
        if (this.settingsViewType == 1) {
            this.launchTreeTypeDialog(string);
        } else {
            FrameworkUtilities.getTerminalManager().activateStyleSettings();
            this.launchTabbedPaneTypeDialog(string);
        }
    }

    private void launchTabbedPaneTypeDialog(String string) {
        Object object;
        BaseClientSettings baseClientSettings;
        if (tabLayout == 1) {
            this.systemSettingsDialog.pack();
        }
        if (this.activeModuleID != null && !this.isOpenFirst) {
            string = this.activeModuleID;
        }
        this.dialogFirstOpened = true;
        if (string != null) {
            baseClientSettings = null;
            Vector vector = (Vector)this.clientKeyStore.get(string);
            if (vector != null && !vector.isEmpty()) {
                baseClientSettings = vector.firstElement();
            }
            if (baseClientSettings != null) {
                object = (BaseClientSettings)this.clientSettingsStore.get(baseClientSettings);
                int n = this.clientSettingsTabbedPane.indexOfTab(object.getTabLabel());
                this.clientSettingsTabbedPane.setSelectedIndex(n);
            }
        } else {
            this.isOpenFirst = false;
            baseClientSettings = this.find(this.clientSettingsTabbedPane.getTitleAt(0));
            this.clientSettingsTabbedPane.setSelectedIndex(0);
            if (baseClientSettings != null) {
                baseClientSettings.actived();
                logger.trace(baseClientSettings.getTabLabel() + " is activated");
            }
        }
        this.systemSettingsDialog.pack();
        if (this.isChangeSize()) {
            int n = dialogHeight;
            int n2 = dialogWidth;
            object = FrameworkUtilities.getMainFrame().getGraphicsConfiguration();
            Insets insets = Toolkit.getDefaultToolkit().getScreenInsets((GraphicsConfiguration)object);
            if (dialogHeight >= ScreenToolKit.getScreenHeight() - (insets.top + insets.bottom)) {
                n = ScreenToolKit.getScreenHeight() - (insets.top + insets.bottom);
            }
            if (dialogWidth >= ScreenToolKit.getScreenWidth() - (insets.left + insets.right)) {
                n2 = ScreenToolKit.getScreenWidth() - (insets.left + insets.right);
            }
            this.systemSettingsDialog.getContentPane().setPreferredSize(new Dimension(n2, n));
            this.systemSettingsDialog.setSize(n2, n);
            FrameworkUtilities.getPreferenceManager().centerLocateToScreen(this.systemSettingsDialog);
        } else {
            ScreenToolKit.centerLocateToScreen(this.systemSettingsDialog);
        }
        this.hideAction = 0;
        this.systemSettingsDialog.show();
        if (this.hideAction == 0) {
            this.notifySettingItemsAboutExit();
        }
    }

    private void launchTreeTypeDialog(String string) {
        if (string != null) {
            BaseClientSettings baseClientSettings;
            Object var2_2 = null;
            Vector vector = (Vector)this.clientKeyStore.get(string);
            if (vector != null && !vector.isEmpty()) {
                var2_2 = vector.firstElement();
            }
            if (var2_2 != null && null != (baseClientSettings = (BaseClientSettings)this.clientSettingsStore.get(var2_2))) {
                FrameworkUtilities.getPreferenceManager().activeNode(baseClientSettings.getClass().getName());
            }
        }
        FrameworkUtilities.getPreferenceManager().launchDialog();
    }

    private int addClientModuleSettingsWithSequence(String string, String string2, String string3, String string4) {
        BaseClientSettings baseClientSettings = null;
        try {
            baseClientSettings = (BaseClientSettings)FrameworkUtilities.loadModule(string2, this.getModuleManager(), this.getModuleManager().getORB(), this.getModuleManager().getTerminalId(), this.getModuleManager().getInstanceId());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (baseClientSettings != null) {
            return this.addClientModuleSettingsWithSequence(string, baseClientSettings, string3, string4);
        }
        logger.error("Failed to instantiate the client settings module: " + string2);
        return -1;
    }

    public int addClientModuleSettings(String string, String string2, String string3) {
        BaseClientSettings baseClientSettings = null;
        try {
            baseClientSettings = (BaseClientSettings)FrameworkUtilities.loadModule(string, this.getModuleManager(), this.getModuleManager().getORB(), this.getModuleManager().getTerminalId(), this.getModuleManager().getInstanceId());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        if (baseClientSettings != null) {
            return this.addClientModuleSettings(baseClientSettings, string2, string3);
        }
        logger.error("Failed to instantiate the client settings module: " + string);
        return -1;
    }

    public int addClientModuleSettingsWithSequence(String string, String string2, String string3) {
        return this.addClientModuleSettingsWithSequence(string, string2, string3, null);
    }

    public int addClientModuleSettings(String string, String string2) {
        return this.addClientModuleSettings(string, string2, null);
    }

    public void clientSettingChanged(String string, boolean bl) {
        if (bl) {
            if (this.settingsViewType == 1) {
                FrameworkUtilities.getPreferenceManager().notifyChanged();
            } else {
                this.applyButton.setEnabled(true);
            }
        }
    }

    public void setSettingEnable(int n, boolean bl) {
        Integer n2 = n;
        BaseClientSettings baseClientSettings = (BaseClientSettings)this.clientSettingsStore.get(n2);
        if (this.settingsViewType == 1) {
            if (!bl) {
                FrameworkUtilities.getPreferenceManager().setDisabledNode(baseClientSettings.getTabLabel());
            }
            return;
        }
        if (baseClientSettings != null) {
            int n3 = this.clientSettingsTabbedPane.indexOfTab(baseClientSettings.getTabLabel());
            this.clientSettingsTabbedPane.setEnabledAt(n3, bl);
        }
    }

    public boolean removeSetting(int n) {
        boolean bl = false;
        Integer n2 = n;
        BaseClientSettings baseClientSettings = (BaseClientSettings)this.clientSettingsStore.get(n2);
        if (baseClientSettings != null) {
            if (this.settingsViewType == 1) {
                FrameworkUtilities.getPreferenceManager().unregisterSetting(baseClientSettings);
            } else {
                int n3 = this.clientSettingsTabbedPane.indexOfTab(baseClientSettings.getTabLabel());
                if (n3 == this.clientSettingsTabbedPane.getSelectedIndex()) {
                    this.clientSettingsTabbedPane.setSelectedIndex(0);
                }
                this.clientSettingsTabbedPane.removeTabAt(n3);
            }
            this.clientSettingChanged(baseClientSettings.getModuleName(), false);
            baseClientSettings.stop();
            this.clientSettingsStore.remove(n2);
            Vector vector = null;
            boolean bl2 = false;
            Enumeration enumeration = this.clientKeyStore.elements();
            while (enumeration.hasMoreElements()) {
                vector = (Vector)enumeration.nextElement();
                if (vector != null) {
                    for (int i = vector.size() - 1; i >= 0; --i) {
                        if (!n2.equals(vector.elementAt(i))) continue;
                        vector.removeElementAt(i);
                        bl2 = true;
                        if (vector.size() != 0) break;
                        this.processModuleExpiry(baseClientSettings.getModuleName());
                        break;
                    }
                }
                if (!bl2) continue;
            }
            baseClientSettings.unregister(3);
            bl = true;
            logger.debug("Unregistered setting successfully..." + baseClientSettings.getModuleName() + "key " + n);
        }
        return bl;
    }

    public void processModuleExpiry(String string) {
        Vector vector = (Vector)this.clientKeyStore.get(string);
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.removeSetting((Integer)enumeration.nextElement());
            }
            this.clientKeyStore.remove(string);
            this.clientKeyStoreLeaf.remove(string);
        }
    }

    @Override
    public void customizeSettingsDialog(String string, boolean bl) {
        if (this.settingsViewType == 1) {
            FrameworkUtilities.getPreferenceManager().customizeSettingsDialog(string, bl);
            FrameworkUtilities.getPreferenceManager().customizeSettingsDialogSize(dialogWidth, dialogHeight);
        } else {
            if (string != null) {
                this.systemSettingsDialog.setTitle(string);
            }
            this.systemSettingsDialog.setModal(bl);
        }
    }

    protected void setupDialog(JFrame jFrame) {
        this.systemSettingsDialog = new JDialog(jFrame);
        this.systemSettingsDialog.setName("SystemSettingsManager_systemSettingsDialog");
        this.loadClientSettingsConfigFile();
        this.clientSettingsTabbedPane.setTabLayoutPolicy(tabLayout);
        this.clientSettingsTabbedPane.setName("SystemSettingsManager_clientSettingsTabbedPane");
        if (this.clientSettingsTabbedPane.getSelectedIndex() == -1) {
            this.isOpenFirst = true;
        }
        this.systemSettingsDialog.setResizable(false);
        this.clientSettingsTabbedPane.setBorder(new EmptyBorder(5, 4, 5, 4));
        this.clientSettingsTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                SystemSettingsManager.this.tabbedPane_stateChanged();
            }
        });
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2, 4, 12));
        final JButton jButton = new JButton(res.getString("SystemSettingsManager_Ok"));
        jButton.setName("JDialog_okButton");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SystemSettingsManager.this.notifySettingItemsAboutApply() && SystemSettingsManager.this.notifySettingItemsAboutClose()) {
                    SystemSettingsManager.this.hideAction = 1;
                    SystemSettingsManager.this.systemSettingsDialog.hide();
                }
            }
        });
        JButton jButton2 = new JButton(res.getString("SystemSettingsManager_Cancel"));
        jButton2.setName("JDialog_cancelButton");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SystemSettingsManager.this.notifySettingItemsAboutClose()) {
                    SystemSettingsManager.this.notifySettingItemsAboutExit();
                    SystemSettingsManager.this.hideAction = 2;
                    SystemSettingsManager.this.systemSettingsDialog.dispose();
                }
            }
        });
        this.applyButton.setName("JDialog_applyButton");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SystemSettingsManager.this.notifySettingItemsAboutApply();
            }
        });
        this.applyButton.setEnabled(false);
        ScreenToolKit.setDefaultButtons(jButton, jButton2);
        this.applyButton.setMnemonic('A');
        JButton[] jButtonArray = new JButton[]{jButton, jButton2, this.applyButton};
        ScreenToolKit.setPreferredSizeofButtons(jButtonArray, 21);
        jPanel.add(jButton);
        jPanel.add(jButton2);
        jPanel.add(this.applyButton);
        this.systemSettingsDialog.getContentPane().setLayout(new BorderLayout());
        this.systemSettingsDialog.getContentPane().add((Component)this.clientSettingsTabbedPane, "Center");
        this.systemSettingsDialog.getContentPane().add((Component)jPanel, "South");
        this.systemSettingsDialog.setDefaultCloseOperation(0);
        this.systemSettingsDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (SystemSettingsManager.this.dialogFirstOpened) {
                    jButton.requestFocus();
                    SystemSettingsManager.this.dialogFirstOpened = false;
                }
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (SystemSettingsManager.this.notifySettingItemsAboutClose()) {
                    SystemSettingsManager.this.notifySettingItemsAboutExit();
                    SystemSettingsManager.this.systemSettingsDialog.setVisible(false);
                }
            }
        });
    }

    private void tabbedPane_stateChanged() {
        Component component = this.clientSettingsTabbedPane.getSelectedComponent();
        if (component instanceof JComponent) {
            JComponent jComponent;
            Object object;
            JComponent jComponent2 = (JComponent)component;
            if (this.isChangeSize() && jComponent2 instanceof JScrollPane) {
                object = (JScrollPane)jComponent2;
                jComponent = ((JScrollPane)object).getViewport();
                jComponent2 = (JComponent)((JViewport)jComponent).getView();
            }
            CommonUtil.hideShowTooltip();
            try {
                jComponent2 = (JComponent)jComponent2.getClientProperty(SETTING_CLIENT_PROPERTY);
                HelpManager.getInstance().enableHelpKey(this.systemSettingsDialog.getRootPane(), (String)jComponent2.getClientProperty("HELP_ID_PROPERTY"));
                this.currentClientSetting = object = (BaseClientSettings)jComponent2.getClientProperty(CLIENT_PROPERTY_KEY);
                this.setActiveClientSetting(this.currentClientSetting);
                ((BaseClientSettings)object).actived();
                this.activeModuleID = ((BaseModule)object).getModuleName();
                logger.trace(object.getTabLabel() + " is activated");
                if (ResourceUtil.areEquals(res.getString("Time").trim(), object.getTabLabel().trim())) {
                    jComponent = (TimeSetting)object.getSettingsPanel();
                    ((TimeSetting)jComponent).initZoneOffset();
                    ((TimeSetting)jComponent).startRefreshThread();
                    jComponent = null;
                }
                if (ResourceUtil.areEquals(res.getString("Date").trim(), object.getTabLabel().trim())) {
                    jComponent = (DateSetting)object.getSettingsPanel();
                    ((DateSetting)jComponent).startRefreshThread();
                    jComponent = null;
                }
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.clientSettingsTabbedPane.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.clientSettingsTabbedPane.removeChangeListener(changeListener);
    }

    public boolean notifySettingItemsAboutClose() {
        boolean bl = true;
        Enumeration enumeration = this.clientSettingsStore.elements();
        BaseClientSettings baseClientSettings = null;
        while (enumeration.hasMoreElements()) {
            baseClientSettings = (BaseClientSettings)enumeration.nextElement();
            if (baseClientSettings.notifyClose()) continue;
            logger.trace(baseClientSettings.getModuleName() + " is returning false for notifyPreferences()");
            bl = false;
            break;
        }
        return bl;
    }

    protected boolean notifySettingItemsAboutApply() {
        Enumeration enumeration = this.clientSettingsStore.elements();
        BaseClientSettings baseClientSettings = null;
        if (this.currentClientSetting != null && this.currentClientSetting.isChanged() && !(baseClientSettings = this.currentClientSetting).apply()) {
            return false;
        }
        while (enumeration.hasMoreElements()) {
            baseClientSettings = (BaseClientSettings)enumeration.nextElement();
            if (baseClientSettings == this.currentClientSetting || !baseClientSettings.isChanged()) continue;
            if (!baseClientSettings.apply()) {
                return false;
            }
            this.clientSettingChanged(baseClientSettings.getModuleName(), false);
        }
        if (this.applyButton.isEnabled()) {
            this.promptRestartSystem();
        }
        this.applyButton.setEnabled(false);
        return true;
    }

    protected void notifySettingItemsAboutExit() {
        Enumeration enumeration = this.clientSettingsStore.elements();
        BaseClientSettings baseClientSettings = null;
        while (enumeration.hasMoreElements()) {
            baseClientSettings = (BaseClientSettings)enumeration.nextElement();
            baseClientSettings.exit();
        }
        if (this.statusMap.size() > 0) {
            this.promptRestartSystem();
        }
        this.applyButton.setEnabled(false);
        logger.debug("End notifySettingItemsAboutExit");
    }

    @Override
    public String getModuleName() {
        return "mainsystemsettingmanager";
    }

    public int addClientModuleSettingsWithSequence(String string, BaseClientSettings baseClientSettings, String string2, String string3) {
        int n = this.key;
        if (baseClientSettings != null) {
            Vector vector;
            JPanel jPanel;
            if (null != string2 && null != string3 && null != string) {
                logger.debug("Started to add the panel  which has SequenceId:" + string + "moduleId:" + string2 + "parentClassName:" + string3);
            }
            if ((jPanel = baseClientSettings.getSettingsPanel()) == null) {
                logger.error("Failed to get the client settings panel");
                return -1;
            }
            jPanel.setName(baseClientSettings.getModuleName());
            if (null == string2 || string2.trim().length() == 0) {
                string2 = baseClientSettings.getModuleName();
            }
            n = this.getKey();
            Integer n2 = n;
            String string4 = null;
            string4 = null != this.parentKey ? this.parentKey + '-' + string : string;
            this.clientSettingsStore.put(n2, baseClientSettings);
            jPanel.putClientProperty(CLIENT_PROPERTY_KEY, baseClientSettings);
            if (this.clientKeyStore.get(string2) == null) {
                vector = new Vector(15);
                this.clientKeyStore.put(string2, vector);
            }
            if (this.clientKeyStoreLeaf.get(string2) == null && !baseClientSettings.isParentNodeInTree()) {
                this.clientKeyStoreLeaf.put(string2, new Vector(15));
            }
            ((Vector)this.clientKeyStore.get(string2)).add(n2);
            if (!baseClientSettings.isParentNodeInTree()) {
                ((Vector)this.clientKeyStoreLeaf.get(string2)).add(string4);
            }
            if (this.settingsViewType == 1) {
                this.setDialogSize((int)jPanel.getPreferredSize().getWidth() + 300, (int)jPanel.getPreferredSize().getHeight() + 300);
                FrameworkUtilities.getPreferenceManager().registerSetting(string, string3, baseClientSettings);
                FrameworkUtilities.getPreferenceManager().customizeSettingsDialogSize(this.getWidth(), this.getHeight());
            } else {
                vector = new Vector();
                Vector vector2 = null;
                Object e = null;
                Icon icon = baseClientSettings.getTabIcon();
                if (!baseClientSettings.isParentNodeInTree()) {
                    Object object;
                    int n3 = -1;
                    if (!SystemSettingsManager.isAlphabeticalSorting()) {
                        object = this.clientKeyStoreLeaf.elements();
                        while (object.hasMoreElements()) {
                            vector2 = (Vector)object.nextElement();
                            if (vector2 == null || vector2.isEmpty()) continue;
                            e = vector2.firstElement();
                            vector.add(e);
                        }
                        Object[] objectArray = vector.toArray();
                        Arrays.sort(objectArray);
                        n3 = SystemSettingsManager.Search(objectArray, string4);
                    } else {
                        int n4 = this.clientSettingsTabbedPane.getTabCount();
                        Object[] objectArray = new Object[n4 + 1];
                        for (int i = 0; i < n4; ++i) {
                            objectArray[i] = this.clientSettingsTabbedPane.getTitleAt(i);
                        }
                        objectArray[n4] = baseClientSettings.getTabLabel();
                        Locale locale = ResourceMng.getInstance().getLocale();
                        Arrays.sort(objectArray, Collator.getInstance(new Locale(locale.getLanguage(), locale.getCountry())));
                        n3 = SystemSettingsManager.Search(objectArray, baseClientSettings.getTabLabel());
                    }
                    if (n3 == -1 || n3 > this.clientSettingsTabbedPane.getTabCount()) {
                        n3 = this.clientSettingsTabbedPane.getTabCount();
                    }
                    object = SettingDialog.getSettingPanelWithDescr(jPanel, baseClientSettings.getSettingDescription());
                    ((JComponent)object).putClientProperty(SETTING_CLIENT_PROPERTY, jPanel);
                    this.setDialogSize((int)((JComponent)object).getPreferredSize().getWidth() + 300, (int)((JComponent)object).getPreferredSize().getHeight() + 300);
                    this.systemSettingsDialog.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
                    if (this.isChangeSize()) {
                        this.clientSettingsTabbedPane.insertTab(baseClientSettings.getTabLabel(), icon, new JScrollPane((Component)object), null, n3);
                    } else {
                        this.clientSettingsTabbedPane.insertTab(baseClientSettings.getTabLabel(), icon, (Component)object, null, n3);
                    }
                }
            }
        } else {
            logger.error("client settings IS NULL");
            return -1;
        }
        this.clientSettingChanged(string2, false);
        logger.debug("completed  adding the panel  which has moduleId:" + string2 + "keyvalue is:" + n);
        return n;
    }

    public static int Search(Object[] objectArray, Object object) {
        int n = -1;
        for (int i = 0; i < objectArray.length; ++i) {
            if (object != objectArray[i]) continue;
            n = i;
        }
        return n;
    }

    public int addClientModuleSettings(BaseClientSettings baseClientSettings, String string, String string2) {
        int n = this.key;
        if (baseClientSettings != null) {
            Object object;
            if (null != string && null != string2) {
                logger.debug("Started to add the panel which hasmoduleId:" + string + "parentClassName:" + string2);
            }
            JPanel jPanel = baseClientSettings.getSettingsPanel();
            String string3 = null;
            if (jPanel == null) {
                logger.error("Failed to get the client settings panel");
                return -1;
            }
            jPanel.setName(baseClientSettings.getModuleName());
            if (null == string || string.trim().length() == 0) {
                string = baseClientSettings.getModuleName();
            }
            n = this.getKey();
            Integer n2 = n;
            Vector vector = new Vector();
            Vector vector2 = null;
            Object e = null;
            if (!baseClientSettings.isParentNodeInTree()) {
                object = this.clientKeyStoreLeaf.elements();
                while (object.hasMoreElements()) {
                    vector2 = (Vector)object.nextElement();
                    if (vector2 == null || vector2.isEmpty()) continue;
                    e = vector2.firstElement();
                    vector.add(e);
                }
                string3 = vector.size() == 0 || vector.get(vector.size() - 1) == null ? "0" : vector.get(vector.size() - 1).toString();
            }
            this.clientSettingsStore.put(n2, baseClientSettings);
            jPanel.putClientProperty(CLIENT_PROPERTY_KEY, baseClientSettings);
            if (this.clientKeyStore.get(string) == null) {
                object = new Vector(15);
                this.clientKeyStore.put(string, object);
                if (!baseClientSettings.isParentNodeInTree()) {
                    this.clientKeyStoreLeaf.put(string, new Vector(15));
                }
            }
            ((Vector)this.clientKeyStore.get(string)).add(n2);
            if (!baseClientSettings.isParentNodeInTree()) {
                ((Vector)this.clientKeyStoreLeaf.get(string)).add(string3);
            }
            if (this.settingsViewType == 1) {
                this.setDialogSize((int)jPanel.getPreferredSize().getWidth() + 300, (int)jPanel.getPreferredSize().getHeight() + 300);
                FrameworkUtilities.getPreferenceManager().registerSetting(string2, baseClientSettings);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        FrameworkUtilities.getPreferenceManager().customizeSettingsDialogSize(SystemSettingsManager.this.getWidth(), SystemSettingsManager.this.getHeight());
                    }
                });
            } else {
                object = baseClientSettings.getTabIcon();
                if (!baseClientSettings.isParentNodeInTree()) {
                    int n3 = 0;
                    if (SystemSettingsManager.isAlphabeticalSorting()) {
                        int n4 = this.clientSettingsTabbedPane.getTabCount();
                        Object[] objectArray = new Object[n4 + 1];
                        for (int i = 0; i < n4; ++i) {
                            objectArray[i] = this.clientSettingsTabbedPane.getTitleAt(i);
                        }
                        objectArray[n4] = baseClientSettings.getTabLabel();
                        Locale locale = ResourceMng.getInstance().getLocale();
                        Arrays.sort(objectArray, Collator.getInstance(new Locale(locale.getLanguage(), locale.getCountry())));
                        n3 = SystemSettingsManager.Search(objectArray, baseClientSettings.getTabLabel());
                    } else {
                        n3 = this.clientSettingsTabbedPane.getTabCount();
                    }
                    JPanel jPanel2 = SettingDialog.getSettingPanelWithDescr(jPanel, baseClientSettings.getSettingDescription());
                    jPanel2.putClientProperty(SETTING_CLIENT_PROPERTY, jPanel);
                    this.setDialogSize((int)jPanel2.getPreferredSize().getWidth() + 300, (int)jPanel2.getPreferredSize().getHeight() + 300);
                    this.systemSettingsDialog.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
                    if (this.isChangeSize()) {
                        this.clientSettingsTabbedPane.insertTab(baseClientSettings.getTabLabel(), (Icon)object, new JScrollPane(jPanel2), null, n3);
                    } else {
                        this.clientSettingsTabbedPane.insertTab(baseClientSettings.getTabLabel(), (Icon)object, jPanel2, null, n3);
                    }
                }
            }
        } else {
            logger.error("client settings IS NULL");
            return -1;
        }
        this.clientSettingChanged(string, false);
        logger.debug("Started to add the panel which hasmoduleId:" + string + "keyValue" + n);
        return n;
    }

    public int addClientModuleSettings(BaseClientSettings baseClientSettings, String string) {
        return this.addClientModuleSettings(baseClientSettings, string, null);
    }

    public void loadClientSettingsFromStyleFile(String string) {
        try {
            DescContainer descContainer = CommStyleManager.getInstance().getCommonStyleFile(string).getAreaDescContainer(0).getDescContainer(0);
            this.loadClientSettings(descContainer);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    public void updateDisplayStyleSetting() {
        BaseModule baseModule = Main.instance().getModuleManager().getLocalModule("DisplayStyleSetting", false);
        if (this.isHideClientDisplayStyleSettings() && null != baseModule) {
            this.removeSetting("DisplayStyleSetting");
        } else if (!this.isHideClientDisplayStyleSettings() && null == baseModule) {
            this.addDisplayStyleSettings();
        }
    }

    private void addDisplayStyleSettings() {
        logger.trace("Loading display style settings");
        try {
            DescContainer descContainer = CommStyleManager.getInstance().getCommonStyleFile(DEFAULT_CLIENTSETTINGS_FILE).getAreaDescContainer(0).getDescContainer(0);
            int n = descContainer.getDescContainerCount();
            for (int i = 0; i < n; ++i) {
                DescContainer descContainer2 = descContainer.getDescContainer(i);
                if (!descContainer2.getParasItemValue(PARA_MODULE_ID).equals("DisplayStyleSetting")) continue;
                this.loadClientSettings(descContainer, descContainer2, i);
            }
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void loadClientSettings(DescContainer descContainer) {
        int n = descContainer.getDescContainerCount();
        for (int i = 0; i < n; ++i) {
            DescContainer descContainer2 = descContainer.getDescContainer(i);
            this.loadClientSettings(descContainer, descContainer2, i);
        }
    }

    private void loadClientSettings(DescContainer descContainer, DescContainer descContainer2, int n) {
        int n2 = 0;
        String string = null;
        try {
            string = descContainer2.getParasItemValue(PARA_SEQUENCE_ID);
            if (descContainer2.getParasItemValue(PARA_MODULE_ID).equals("DisplayStyleSetting") && this.isHideClientDisplayStyleSettings()) {
                logger.debug("Display StyleSetting should not add Either is singlesubsystem or startup.xml Not exists or PortalPlugins Not mentioned in Starup.xml or Emergency Client launch");
                return;
            }
            if (null == string) {
                n2 = this.addClientModuleSettings(descContainer2.getParasItemValue(PARA_CLASS_ID), descContainer2.getParasItemValue(PARA_MODULE_ID), descContainer.getParasItemValue(PARA_CLASS_ID));
                if (n2 == -1) {
                    logger.debug("Add client settings failed.");
                } else {
                    this.loadClientSettings(descContainer2);
                }
            } else {
                this.parentKey = descContainer.getParasItemValue(PARA_SEQUENCE_ID);
                n2 = this.addClientModuleSettingsWithSequence(descContainer2.getParasItemValue(PARA_SEQUENCE_ID), descContainer2.getParasItemValue(PARA_CLASS_ID), descContainer2.getParasItemValue(PARA_MODULE_ID), descContainer.getParasItemValue(PARA_CLASS_ID));
                if (n2 == -1) {
                    logger.debug("Add client settings failed.");
                } else {
                    this.loadClientSettings(descContainer2);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            logger.trace("exception as there is no sequence id in xml" + numberFormatException);
        }
        catch (Throwable throwable) {
            logger.trace("exception as there is error in loading" + n + ":" + throwable);
        }
    }

    private void loadClientSettingsConfigFile() {
        DescContainer[] descContainerArray;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(CLIENTSETTINGS_CONFIG_FILE);
        if (null == commStyleInfo) {
            logger.debug(" CommStyleInfo object is null.");
            return;
        }
        DescContainer descContainer = commStyleInfo.getAreaDescContainer(0).getDescContainer(0);
        try {
            descContainerArray = descContainer.getParasItemValue(PARA_VIEW_TYPE);
            if (descContainerArray != null) {
                this.settingsViewType = Integer.parseInt(descContainerArray.trim());
            }
        }
        catch (Exception exception) {
            logger.debug("\"viewtype\" configured error, please check the xml file: conf/mainfrm/clientsettingsconfig");
        }
        this.getDisplayTypeValue(descContainer);
        descContainerArray = descContainer.getDescContainer();
        for (int i = 0; i < descContainerArray.length; ++i) {
            String string;
            if (DESC_TAB_LAYOUT.equals(descContainerArray[i].getDescName())) {
                try {
                    string = descContainerArray[i].getParasItemValue(PARA_LAYOUT);
                    if (string != null) {
                        this.setTabLayout(Integer.parseInt(string.trim()));
                    }
                }
                catch (Exception exception) {
                    logger.debug("\"layout\" configured error, please check the xml file: conf/mainfrm/clientsettingsconfig");
                }
            }
            if (!DESC_DIALOG_SIZE.equals(descContainerArray[i].getDescName())) continue;
            try {
                this.changeSize = Boolean.valueOf(descContainerArray[i].getParasItemValue("changeSize"));
                string = descContainerArray[i].getParasItemValue(PARA_DIALOG_WIDTH);
                String string2 = descContainerArray[i].getParasItemValue(PARA_DIALOG_HEIGHT);
                if (string == null || string2 == null) continue;
                this.setDialogSize(Integer.parseInt(string.trim()), Integer.parseInt(string2.trim()));
                continue;
            }
            catch (Exception exception) {
                logger.debug("\"width\" or \"height\" configured error, please check the xml file: conf/mainfrm/clientsettingsconfig");
            }
        }
    }

    private void getDisplayTypeValue(DescContainer descContainer) {
        try {
            String string = descContainer.getParasItemValue(PARA_DISPALY_TYPE);
            isAlphabeticalSorting = null == string || !string.trim().equalsIgnoreCase("SERIAL");
        }
        catch (Exception exception) {
            logger.debug("\"displayType\" configured error, please check the xml file: conf/mainfrm/clientsettingsconfig");
        }
    }

    public boolean isChangeSize() {
        return this.changeSize;
    }

    private void setTabLayout(int n) {
        if (n == 0 || n == 1) {
            tabLayout = n;
        } else {
            logger.error("Configed tab layout is not a valid layout: " + n);
        }
    }

    private void setDialogSize(int n, int n2) {
        int n3;
        if (this.isChangeSize()) {
            dialogWidth = n >= dialogWidth ? n : dialogWidth;
            dialogHeight = n2 >= dialogHeight ? n2 : dialogHeight;
        } else {
            dialogWidth = n >= 680 ? n : 680;
            int n4 = dialogHeight = n2 >= 510 ? n2 : 510;
        }
        if (dialogWidth == n) {
            n3 = ScreenToolKit.getScreenWidth();
            int n5 = dialogWidth = n <= n3 ? n : n3;
        }
        if (dialogHeight == n2) {
            n3 = ScreenToolKit.getScreenHeight();
            dialogHeight = n2 <= n3 ? n2 : n3;
        }
    }

    public BaseClientSettings find(String string) {
        for (BaseClientSettings baseClientSettings : this.clientSettingsStore.values()) {
            if (!ResourceUtil.areEquals(baseClientSettings.getTabLabel(), string)) continue;
            return baseClientSettings;
        }
        return null;
    }

    public void loadClientSettingsFromStyleFile() {
        this.loadClientSettingsFromStyleFile(DEFAULT_CLIENTSETTINGS_FILE);
    }

    public void activateSetting(BaseClientSettings baseClientSettings) {
        if (this.settingsViewType == 1) {
            FrameworkUtilities.getPreferenceManager().activeNode(baseClientSettings.getClass().getName());
        } else {
            JPanel jPanel = SettingDialog.getSettingPanelWithDescr(baseClientSettings.getSettingsPanel(), baseClientSettings.getSettingDescription());
            this.clientSettingsTabbedPane.setSelectedComponent(jPanel);
        }
    }

    public void setNeedRestartSystem(boolean bl) {
        this.needRestartSystem = bl;
    }

    public boolean isNeedRestartSystem() {
        return this.needRestartSystem;
    }

    private void promptRestartSystem() {
        if (this.isSettingDialogVisible()) {
            Object object;
            String string = res.getString("Successfully_saved");
            Iterator<String> iterator = this.statusMap.keySet().iterator();
            String[][] stringArray = new String[this.statusMap.size() + 1][3];
            String[] stringArray2 = new String[]{res.getString("Item"), res.getString("Status"), res.getString("Details")};
            stringArray[0] = stringArray2;
            int n = 1;
            while (iterator.hasNext()) {
                object = iterator.next();
                String[] stringArray3 = this.statusMap.get(object);
                stringArray[n][0] = object;
                for (int i = 0; i < stringArray3.length; ++i) {
                    if (i == 0) {
                        if ("false".equals(stringArray3[i])) {
                            stringArray3[i] = res.getString("fail");
                            string = res.getString("Failed_save");
                        } else {
                            stringArray3[i] = res.getString("success");
                        }
                    }
                    stringArray[n][i + 1] = stringArray3[i];
                }
                ++n;
            }
            this.statusMap.clear();
            object = new DetailMessageDlg(FrameworkUtilities.getMainFrame(), res.getString("Info"), (Object)string, 1, 0, (Object)stringArray, false);
            ((Window)object).pack();
            ((DetailMessageDlg)object).show();
        }
    }

    private void registerRestartNotifier() {
        IRestartNotifier iRestartNotifier = new IRestartNotifier(){

            @Override
            public void notifyRestartSystem() {
                SystemSettingsManager.this.promptRestartSystem();
            }
        };
        FrameworkUtilities.getPreferenceManager().setRestartNotifier(iRestartNotifier);
    }

    @Override
    public void clear() {
        if (this.systemSettingsDialog != null) {
            this.notifySettingItemsAboutExit();
            this.hideAction = 2;
            this.systemSettingsDialog.dispose();
        }
    }

    public int getWidth() {
        if (!this.isChangeSize() && dialogWidth > 680) {
            return 680;
        }
        return dialogWidth;
    }

    public int getHeight() {
        if (!this.isChangeSize() && dialogHeight > 510) {
            return 510;
        }
        return dialogHeight;
    }

    public void setSystemSettingStatus(String string, Boolean bl, String string2) {
        String[] stringArray = new String[]{null != bl ? bl.toString() : "false", string2};
        this.statusMap.put(string, stringArray);
    }

    public HashMap<String, String[]> getSystemSettingStatusMap() {
        return this.statusMap;
    }

    public String getRestartMessage() {
        return res.getString("Restart_the_system_to");
    }

    public String getReloginMessage() {
        return res.getString("Relogin_the_system_to");
    }

    public boolean removeSetting(String string) {
        Vector vector = (Vector)this.clientKeyStore.get(string);
        if (vector != null) {
            Integer n = null;
            BaseClientSettings baseClientSettings = null;
            for (int i = vector.size() - 1; i >= 0; --i) {
                n = (Integer)vector.elementAt(i);
                baseClientSettings = (BaseClientSettings)this.clientSettingsStore.get(n);
                if (baseClientSettings == null) continue;
                if (this.settingsViewType == 1) {
                    FrameworkUtilities.getPreferenceManager().unregisterSetting(baseClientSettings);
                } else {
                    int n2 = this.clientSettingsTabbedPane.indexOfTab(baseClientSettings.getTabLabel());
                    if (n2 == this.clientSettingsTabbedPane.getSelectedIndex()) {
                        this.clientSettingsTabbedPane.setSelectedIndex(0);
                    }
                    this.clientSettingsTabbedPane.removeTabAt(n2);
                }
                this.clientSettingChanged(baseClientSettings.getModuleName(), false);
                baseClientSettings.stop();
                this.clientSettingsStore.remove(n);
                baseClientSettings.unregister(3);
            }
            this.clientKeyStore.remove(string);
            this.clientKeyStoreLeaf.remove(string);
            logger.debug("unregistered client Settings module " + baseClientSettings.getModuleName() + "successfully");
        } else {
            FrameworkUtilities.getPreferenceManager().unregisterSetting(string);
            logger.debug("unregistered module " + string + "successfully");
        }
        return true;
    }

    public BaseClientSettings getActiveClientSetting() {
        return this.activeClientSetting;
    }

    public void setActiveClientSetting(BaseClientSettings baseClientSettings) {
        this.activeClientSetting = baseClientSettings;
    }

    public boolean isSettingDialogVisible() {
        SettingHandler settingHandler;
        JDialog jDialog;
        boolean bl = false;
        boolean bl2 = false;
        if (null != this.systemSettingsDialog) {
            bl = this.systemSettingsDialog.isVisible();
        }
        if (null != (jDialog = (settingHandler = FrameworkUtilities.getPreferenceManager().getSettingHandler()).getSettingDialog())) {
            bl2 = jDialog.isVisible();
        }
        return bl || bl2;
    }

    public static boolean isAlphabeticalSorting() {
        return isAlphabeticalSorting;
    }

    private boolean isHideClientDisplayStyleSettings() {
        if (SubsystemManager.getInstance().getClientLoadMode().equals((Object)SubsystemManager.LoadMode.single)) {
            return true;
        }
        String string = System.getProperty("SpecificLoadingState");
        logger.debug("Specific Loading State has configured " + string);
        if (null != string) {
            return true;
        }
        if (!StartupXMLReader.checkStartupXMLExists()) {
            return true;
        }
        List<String> list = StartupXMLReader.getPortalPlugins();
        return list == null || list.isEmpty();
    }

    private synchronized int getKey() {
        return ++this.key;
    }
}

