/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.subsystemmanagement;

import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.subsystemmanagement.SubsystemHandler;
import com.swimap.iview.framework.subsystemmanagement.SubsystemInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class SubsystemManager {
    private static SubsystemManager instance = null;
    static final String SUBSYSTEM_NAME = "subsystem";
    private SubsystemHandler subsysHandler = new SubsystemHandler();
    private static final String COMPLEX_PATH = "complex";
    private static final String SINGLE_PATH = "single";
    private List<String> loadPluginLst = null;

    private SubsystemManager() {
    }

    public static SubsystemManager getInstance() {
        if (null == instance) {
            instance = new SubsystemManager();
        }
        return instance;
    }

    public void setSubsystemLoaded(List<String> list, boolean bl) {
        this.subsysHandler.setSubsystemLoaded(list, bl);
    }

    public Collection<SubsystemInfo> getSubsystemList() {
        return this.subsysHandler.getSubsystemList();
    }

    public int getLoadedSubsystemCount() {
        return this.subsysHandler.getLoadedSubsystemCount();
    }

    public LoadMode getClientLoadMode() {
        String string;
        boolean bl;
        int n = this.getLoadedSubsystemCount();
        String string2 = System.getProperty(SUBSYSTEM_NAME);
        if (n == 1 && null != string2 && string2.length() != 0 && (bl = PluginSubsystemUtilities.isExist(string = "features/" + string2))) {
            return LoadMode.single;
        }
        return LoadMode.complex;
    }

    public String getIntegratePath() {
        if (this.getClientLoadMode() == LoadMode.single) {
            return SINGLE_PATH;
        }
        return COMPLEX_PATH;
    }

    public List<String> getSubsystemAllPluginList(String string) {
        return this.subsysHandler.getLoadedSubsystemAllPluginList(string);
    }

    public List<String> getLoadedSubsystemAllPluginList() {
        if (this.loadPluginLst == null) {
            this.loadPluginLst = new ArrayList<String>();
            this.loadPluginLst.addAll(this.subsysHandler.getLoadedSubsystemAllPluginList());
        }
        return this.loadPluginLst;
    }

    public List<String> getLoadedSubsystemPluginList() {
        return this.subsysHandler.getLoadedSubsystemPluginList();
    }

    public List<String> getLoadedSubsystemRequiredPluginList() {
        return this.subsysHandler.getLoadedSubsystemRequiredPluginList();
    }

    public List<SubsystemInfo> getLoadedSubsystem() {
        return this.subsysHandler.getLoadedSubsystem();
    }

    public void cleanUp() {
        this.subsysHandler.cleanUp();
    }

    public List<SubsystemInfo> getAllSubsystem() {
        return this.subsysHandler.getAllSubsystem();
    }

    public boolean isHideTabbedbar() {
        return this.subsysHandler.isHideTabbedbar();
    }

    public void createAndRegisterSubsystem(String string) {
        this.subsysHandler.createAndRegisterSubsystem(string);
    }

    public List<String> getLoadedSubsystemRequiredPluginList(String string) {
        return this.subsysHandler.getLoadedSubsystemRequiredPluginList(string);
    }

    public List<String> getLoadedSubsystemPluginList(String string) {
        return this.subsysHandler.getLoadedSubsystemPluginList(string);
    }

    public void clearAndReinitialize() {
        if (null != this.loadPluginLst) {
            this.loadPluginLst.clear();
            this.loadPluginLst = null;
        }
    }

    public static enum LoadMode {
        single,
        complex;

    }
}

