/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.subsystemmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.resource.i18n.UnicodeInputStream;
import com.swimap.iview.framework.Main;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.subsystemmanagement.SubsystemConfigException;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class SubsystemInfo {
    private static IviewLogger logger = IviewLogger.getLogger(SubsystemInfo.class, "IVIEW");
    private static final String PROPERTIES_FILE_NAME = "res.properties";
    private static final String XML_NAME = "feature.xml";
    private static int LOADED_SUBSYSTEMS = 0;
    private String id = null;
    private List<String> pluginList = null;
    private List<String> requiredPluginList = null;
    private ResourceBundle res = null;
    private URL featureURL = null;
    private String resourcePath = "";
    private boolean var_isLoad = false;
    private DescContainer featureContainer = null;
    private DescContainer extraContainer = null;
    private static final String FEATURE_DESC_KEY = "feature";
    private static final String EXTRA_DESC_KEY = "extra";
    private static final String PLUGINS_DESC_KEY = "plugins";
    private static final String REQUIRED_PLUGINS_DESC_KEY = "required-plugins";
    private static final String ID_KEY = "id";
    private static final String LABEL_KEY = "label";
    private static final String IMAGE_KEY = "image";
    private static final String LOADING_IMAGE_KEY = "image.loading";
    private static final String LOCK_IMAGE_KEY = "image.lock";
    private static final String TASK_IMAGE_KEY = "TaskbarIcon";
    private static final String EXIT_IMAGE_KEY = "image.exit";
    private static final String SPLASH_IMAGE_KEY = "image.splash";
    private static final String VERSION_KEY = "about.version";
    private static final String DESC_KEY = "about.desc";
    private static final String ABOUT_TITLE_IMAGE_KEY = "about.image.title";
    private static final String ABOUT_BANNAER_IMAGE_KEY = "about.image.banner";
    private static final String HIDE_TABBEDBAR_FLAG = "ishidetabbedbar";
    private static final int DEFAULT_SIZE = 10;
    private static final String IMAGE_WELCOME = "image.welcome";
    private static final String ABOUT_SHOW = "about.show";
    private static final String ONLY_INDEPENDENT = "OnlyIndependent";
    private List<String> requiredFeatureList = null;
    private String encoding;
    private static final String REQUIRED_FEATURE_DESC_KEY = "required-features";
    private static final String FEATURES_FOLDER = "features";
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final ResourceBundle PRODUCT_RES = Main.getProductResourceBundle();

    public static int getLoadedSubsystemCount() {
        return LOADED_SUBSYSTEMS;
    }

    public SubsystemInfo(URL uRL) throws SubsystemConfigException, MalformedURLException {
        this.featureURL = new URL(uRL + XML_NAME);
        this.resourcePath = uRL.toExternalForm() + System.getProperty("file.separator") + ResourceMng.getInstance().getLocaleString() + System.getProperty("file.separator");
        this.initialize();
    }

    public SubsystemInfo(String string) throws SubsystemConfigException, MalformedURLException {
        String string2 = FEATURES_FOLDER + SEPARATOR + string + SEPARATOR + XML_NAME;
        this.featureURL = PluginSubsystemUtilities.getURLFromJarOrDir(string2);
        if (null == this.featureURL) {
            throw new SubsystemConfigException(string2 + " is invalid, please check it. : " + this.featureURL);
        }
        this.resourcePath = FEATURES_FOLDER + SEPARATOR + string + SEPARATOR + ResourceMng.getInstance().getLocaleString() + SEPARATOR;
        this.initialize();
    }

    private void initialize() throws SubsystemConfigException {
        this.initResource();
        this.initField();
    }

    private void initField() throws SubsystemConfigException {
        DescContainer descContainer;
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(this.featureURL);
        if (null == commStyleInfo) {
            throw new SubsystemConfigException("feature.xml is invalid, please check it. : " + this.featureURL);
        }
        if (0 == commStyleInfo.getAreaDescContainerCount()) {
            throw new SubsystemConfigException("The AreaDescContainer doesn't exist in feature.xml");
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        this.featureContainer = areaDescContainer.getDescContainer(FEATURE_DESC_KEY);
        if (null == this.featureContainer) {
            throw new SubsystemConfigException("feature DescContainer doesn't exist in feature.xml");
        }
        this.id = this.featureContainer.getParasItemValue(ID_KEY);
        if (null == this.id) {
            throw new SubsystemConfigException("id doesn't exist in feature.xml");
        }
        this.extraContainer = areaDescContainer.getDescContainer(EXTRA_DESC_KEY);
        if (null == this.extraContainer) {
            throw new SubsystemConfigException("extra DescContainer doesn't exist in feature.xml");
        }
        DescContainer descContainer2 = areaDescContainer.getDescContainer(PLUGINS_DESC_KEY);
        if (null == descContainer2) {
            throw new SubsystemConfigException("plugins DescContainer doesn't exist in feature.xml");
        }
        int n = descContainer2.getParasItemCount();
        this.pluginList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            this.pluginList.add(descContainer2.getParasItem(i).getName());
        }
        DescContainer descContainer3 = areaDescContainer.getDescContainer(REQUIRED_PLUGINS_DESC_KEY);
        this.requiredPluginList = new ArrayList<String>(10);
        if (null != descContainer3) {
            n = descContainer3.getParasItemCount();
            for (int i = 0; i < n; ++i) {
                this.requiredPluginList.add(descContainer3.getParasItem(i).getName());
            }
        }
        if (null != (descContainer = areaDescContainer.getDescContainer(REQUIRED_FEATURE_DESC_KEY))) {
            n = descContainer.getParasItemCount();
            this.requiredFeatureList = new ArrayList<String>(n);
            for (int i = 0; i < n; ++i) {
                this.requiredFeatureList.add(descContainer.getParasItem(i).getName());
            }
        }
    }

    public Icon getLoadingIcon() {
        return this.getResourceIcon(this.extraContainer, LOADING_IMAGE_KEY);
    }

    public Icon getSplashIcon() {
        return this.getResourceIcon(this.extraContainer, SPLASH_IMAGE_KEY);
    }

    public Icon getAboutBannerIcon() {
        return this.getResourceIcon(this.extraContainer, ABOUT_BANNAER_IMAGE_KEY);
    }

    public Icon getAboutTitleIcon() {
        return this.getResourceIcon(this.extraContainer, ABOUT_TITLE_IMAGE_KEY);
    }

    public Icon getLockIcon() {
        return this.getResourceIcon(this.extraContainer, LOCK_IMAGE_KEY);
    }

    public Icon getTaskbarIcon() {
        Icon icon = this.getResourceIcon(this.extraContainer, TASK_IMAGE_KEY);
        if (icon.getIconHeight() > -1 && icon.getIconWidth() > -1) {
            return icon;
        }
        return null;
    }

    public Icon getExitIcon() {
        return this.getResourceIcon(this.extraContainer, EXIT_IMAGE_KEY);
    }

    public String getVersion() {
        String string = this.getResourceString(this.extraContainer, VERSION_KEY);
        if (string != null && string.startsWith("$")) {
            string = CommonUtil.getResString(PRODUCT_RES, string.substring(1));
        }
        return string;
    }

    public String getDescription() {
        return this.getResourceString(this.extraContainer, DESC_KEY);
    }

    public Icon getIcon() {
        return this.getResourceIcon(this.featureContainer, IMAGE_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initResource() throws SubsystemConfigException {
        URLConnection uRLConnection = null;
        Properties properties = new Properties();
        URL uRL = this.getResourceEntry(PROPERTIES_FILE_NAME);
        if (null == uRL) {
            return;
        }
        InputStream inputStream = null;
        try {
            if (CommonUtil.IS_MENUTOOL) {
                uRLConnection = uRL.openConnection();
                uRLConnection.setUseCaches(false);
                inputStream = uRLConnection.getInputStream();
            } else {
                inputStream = uRL.openStream();
            }
            UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, null);
            String string = unicodeInputStream.getEncoding();
            InputStreamReader inputStreamReader = null;
            if (null == string) {
                this.encoding = ResourceUtil.CLIENT_ENCODING;
                inputStreamReader = new InputStreamReader((InputStream)unicodeInputStream, this.encoding);
            } else {
                inputStreamReader = new InputStreamReader((InputStream)unicodeInputStream, string);
            }
            properties.load(inputStreamReader);
            this.res = new PropertyResourceBundleEx(properties);
            ((PropertyResourceBundleEx)this.res).setEncoding(this.encoding);
        }
        catch (IOException iOException) {
            try {
                logger.trace(iOException.getMessage(), iOException);
                logger.warn("The resource file might be missing. Please check the resource file.");
            }
            catch (Throwable throwable) {
                FrameworkUtilities.close(inputStream);
                throw throwable;
            }
            FrameworkUtilities.close(inputStream);
        }
        FrameworkUtilities.close(inputStream);
    }

    private URL getResourceEntry(String string) {
        try {
            return PluginSubsystemUtilities.getURLFromJarOrDir(this.resourcePath + string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage(), malformedURLException);
            return null;
        }
    }

    private Icon getResourceIcon(DescContainer descContainer, String string) {
        URL uRL;
        String string2 = descContainer.getParasItemValue(string);
        if (null != string2 && null != (uRL = this.getResourceEntry(string2))) {
            return new ImageIcon(uRL);
        }
        return new ImageIcon();
    }

    private String getResourceString(DescContainer descContainer, String string) {
        String string2;
        String string3 = string2 = descContainer.getParasItemValue(string);
        if (null != this.res && null != string2) {
            try {
                string3 = this.res.getString(string2);
            }
            catch (MissingResourceException missingResourceException) {
                logger.trace("resource value not found for " + string2);
            }
        }
        return string3;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.getResourceString(this.featureContainer, LABEL_KEY);
    }

    public List<String> getRequiredPluginList() {
        return this.requiredPluginList;
    }

    public List<String> getPluginList() {
        return this.pluginList;
    }

    public boolean isLoad() {
        return this.var_isLoad;
    }

    public void setLoad(boolean bl) {
        if (this.var_isLoad != bl) {
            LOADED_SUBSYSTEMS = bl ? ++LOADED_SUBSYSTEMS : --LOADED_SUBSYSTEMS;
            this.var_isLoad = bl;
        }
    }

    public String toString() {
        return "[ID=" + this.id + ",Label=" + this.getLabel() + ']';
    }

    public boolean equals(Object object) {
        if (null != object && object instanceof SubsystemInfo) {
            SubsystemInfo subsystemInfo = (SubsystemInfo)object;
            return ResourceUtil.areEquals(this.getId(), subsystemInfo.getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public List<String> getRequiredFeatureList() {
        return this.requiredFeatureList;
    }

    public ImageIcon getWelcomeIcon() {
        String string = this.extraContainer.getParasItemValue(IMAGE_WELCOME);
        ImageIcon imageIcon = new ImageIcon();
        if (null != string) {
            ResourceMng resourceMng = ResourceMng.getInstance();
            ImageIcon imageIcon2 = resourceMng.getSkinImage(string);
            if (null == imageIcon2) {
                URL uRL = this.getResourceEntry(string);
                if (null != uRL) {
                    imageIcon = new ImageIcon(uRL);
                }
            } else {
                imageIcon = resourceMng.getSkinImage(string);
            }
        }
        return imageIcon;
    }

    public boolean isShowInfo() {
        boolean bl = true;
        String string = this.getResourceString(this.extraContainer, ABOUT_SHOW);
        if (string != null && ("false".equalsIgnoreCase(string) || "true".equalsIgnoreCase(string))) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public boolean isHideTabbedbar() {
        boolean bl = false;
        String string = this.getResourceString(this.extraContainer, HIDE_TABBEDBAR_FLAG);
        if (null != string) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }

    public boolean isOnlyIndependent() {
        boolean bl = false;
        String string = this.getResourceString(this.extraContainer, ONLY_INDEPENDENT);
        if (string != null) {
            bl = Boolean.valueOf(string);
        }
        return bl;
    }
}

