/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.subsystemmanagement;

import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.subsystemmanagement.SubsystemConfigException;
import com.swimap.iview.framework.subsystemmanagement.SubsystemInfo;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.subsystemmanagement.SubsystemUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SubsystemHandler {
    private static IviewLogger logger = IviewLogger.getLogger(SubsystemHandler.class, "IVIEW");
    public static final String FEATURES_FOLDER = "features";
    private static final int DEFAULT_SIZE = 10;
    private Map<String, SubsystemInfo> subSystemMap = new HashMap<String, SubsystemInfo>(10);
    private List<String> pluginList = new ArrayList<String>(10);
    private List<String> subsystemList = null;
    private List<SubsystemInfo> requiredSystemList = new ArrayList<SubsystemInfo>(10);
    private boolean isLoadAllSubsystem = false;
    private static final String WELCOME_PLUGIN = "WelcomePage";
    private Map<String, SubsystemInfo> requiredSystemMap = new HashMap<String, SubsystemInfo>(10);
    private static final String SEPARATOR = System.getProperty("file.separator");
    private static final String USEWORKBENCH_NAME = "useWorkbench";

    public void setSubsystemLoaded(List<String> list, boolean bl) {
        this.subsystemList = list;
        this.initSubsystemMap();
        this.loadSubsystemFromRequiredFeature();
    }

    private Map<String, SubsystemInfo> getSubsystemMap() {
        return this.subSystemMap;
    }

    private void initSubsystemMap() {
        String string;
        List<String> list;
        String[] stringArray = PluginSubsystemUtilities.getSubFolderFromAllPaths(FEATURES_FOLDER);
        if ((null == this.subsystemList || this.subsystemList.size() == 0) && null != (list = SubsystemUtilities.getSubsystemList(string = System.getProperty("exsubsystem"))) && list.size() > 0 && null != stringArray) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            arrayList.removeAll(list);
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        if (null != stringArray) {
            int n = stringArray.length;
            boolean bl = false;
            if (null != this.subsystemList) {
                for (int i = 0; i < n; ++i) {
                    if (!this.subsystemList.contains(stringArray[i])) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    this.isLoadAllSubsystem = true;
                }
            } else {
                this.isLoadAllSubsystem = true;
            }
            for (int i = 0; i < n; ++i) {
                if (!this.isLoadAllSubsystem && !this.subsystemList.contains(stringArray[i])) continue;
                this.createAndRegisterSubsystem(stringArray[i]);
            }
        }
    }

    private boolean isStopLoadingSubsystem(SubsystemInfo subsystemInfo) {
        String string;
        boolean bl;
        int n = this.getLoadedSubsystemCount();
        String string2 = System.getProperty("subsystem");
        if (n == 0 && null != string2 && string2.length() != 0 && (bl = PluginSubsystemUtilities.isExist(string = "features/" + string2))) {
            return false;
        }
        return subsystemInfo.isOnlyIndependent();
    }

    private void register(String string, SubsystemInfo subsystemInfo) {
        if (!this.subSystemMap.containsKey(string)) {
            this.subSystemMap.put(string, subsystemInfo);
        }
    }

    public List<String> getLoadedSubsystemAllPluginList() {
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>(10);
        SubsystemInfo subsystemInfo2 = null;
        for (SubsystemInfo subsystemInfo2 : this.getAllSubsystem()) {
            if (!subsystemInfo2.isLoad()) continue;
            arrayList.addAll(subsystemInfo2.getPluginList());
            arrayList.addAll(subsystemInfo2.getRequiredPluginList());
        }
        if (arrayList.contains("")) {
            object = new ArrayList<String>();
            object.add("");
            arrayList.removeAll((Collection<?>)object);
        }
        if (SubsystemManager.getInstance().getClientLoadMode() == SubsystemManager.LoadMode.complex && !arrayList.contains(WELCOME_PLUGIN)) {
            arrayList.add(WELCOME_PLUGIN);
        }
        if (null != (object = System.getProperty(USEWORKBENCH_NAME)) && !Boolean.parseBoolean((String)object)) {
            boolean bl = arrayList.contains(WELCOME_PLUGIN);
            while (bl) {
                arrayList.remove(WELCOME_PLUGIN);
                bl = arrayList.contains(WELCOME_PLUGIN);
            }
        }
        this.removeDupliate(arrayList);
        return arrayList;
    }

    private void removeDupliate(List<String> list) {
        HashSet<String> hashSet = new HashSet<String>(list);
        list.clear();
        list.addAll(hashSet);
    }

    public List<String> getLoadedSubsystemAllPluginList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        SubsystemInfo subsystemInfo2 = null;
        for (SubsystemInfo subsystemInfo2 : this.getSubsystemList()) {
            if (!ResourceUtil.areEquals(subsystemInfo2.getId(), string) || !subsystemInfo2.isLoad()) continue;
            arrayList.addAll(subsystemInfo2.getPluginList());
            arrayList.addAll(subsystemInfo2.getRequiredPluginList());
            return arrayList;
        }
        return arrayList;
    }

    public List<String> getLoadedSubsystemRequiredPluginList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        SubsystemInfo subsystemInfo2 = null;
        for (SubsystemInfo subsystemInfo2 : this.getSubsystemList()) {
            if (!ResourceUtil.areEquals(subsystemInfo2.getId(), string) || !subsystemInfo2.isLoad()) continue;
            arrayList.addAll(subsystemInfo2.getRequiredPluginList());
            return arrayList;
        }
        return arrayList;
    }

    public List<String> getLoadedSubsystemPluginList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        SubsystemInfo subsystemInfo2 = null;
        for (SubsystemInfo subsystemInfo2 : this.getSubsystemList()) {
            if (!ResourceUtil.areEquals(subsystemInfo2.getId(), string) || !subsystemInfo2.isLoad()) continue;
            arrayList.addAll(subsystemInfo2.getPluginList());
            return arrayList;
        }
        return arrayList;
    }

    public List<String> getLoadedSubsystemPluginList() {
        ArrayList<String> arrayList = new ArrayList<String>(10);
        List<SubsystemInfo> list = this.getAllSubsystem();
        Object object = list.iterator();
        while (object.hasNext()) {
            SubsystemInfo subsystemInfo = (SubsystemInfo)object.next();
            if (this.requiredSystemList.contains(subsystemInfo) || !subsystemInfo.isLoad()) continue;
            arrayList.addAll(subsystemInfo.getPluginList());
        }
        if (SubsystemManager.getInstance().getClientLoadMode() == SubsystemManager.LoadMode.complex && !arrayList.contains(WELCOME_PLUGIN)) {
            arrayList.add(WELCOME_PLUGIN);
        }
        if (null != (object = System.getProperty(USEWORKBENCH_NAME)) && !Boolean.parseBoolean((String)object)) {
            boolean bl = arrayList.contains(WELCOME_PLUGIN);
            while (bl) {
                arrayList.remove(WELCOME_PLUGIN);
                bl = arrayList.contains(WELCOME_PLUGIN);
            }
        }
        this.removeDupliate(arrayList);
        return arrayList;
    }

    public List<String> getLoadedSubsystemRequiredPluginList() {
        List<String> list = this.getLoadedSubsystemAllPluginList();
        list.removeAll(this.getLoadedSubsystemPluginList());
        return list;
    }

    public int getLoadedSubsystemCount() {
        int n = 0;
        Iterator<SubsystemInfo> iterator = this.getSubsystemList().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isLoad()) continue;
            ++n;
        }
        return n;
    }

    public Collection<SubsystemInfo> getSubsystemList() {
        return this.getSubsystemMap().values();
    }

    protected File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public List<SubsystemInfo> getLoadedSubsystem() {
        ArrayList<SubsystemInfo> arrayList = new ArrayList<SubsystemInfo>(10);
        for (SubsystemInfo subsystemInfo : this.getSubsystemList()) {
            if (!subsystemInfo.isLoad()) continue;
            arrayList.add(subsystemInfo);
        }
        return arrayList;
    }

    public void cleanUp() {
        this.subsystemList = null;
        this.pluginList.clear();
        this.subSystemMap.clear();
        this.requiredSystemMap.clear();
        this.requiredSystemList.clear();
    }

    private void loadSubsystemFromRequiredFeature() {
        if (this.isLoadAllSubsystem) {
            return;
        }
        Collection<SubsystemInfo> collection = this.getSubsystemList();
        Iterator<SubsystemInfo> iterator = collection.iterator();
        SubsystemInfo subsystemInfo = null;
        List<String> list = null;
        Iterator<String> iterator2 = null;
        String string2 = null;
        while (iterator.hasNext()) {
            collection = new ArrayList<SubsystemInfo>(collection);
            subsystemInfo = iterator.next();
            list = subsystemInfo.getRequiredFeatureList();
            collection.remove(subsystemInfo);
            if (null == list) continue;
            for (String string2 : list) {
                if (this.subsystemList.contains(string2) || this.requiredSystemMap.containsKey(string2)) continue;
                this.loadSubsystemIfPresent(string2, collection);
            }
            iterator = collection.iterator();
        }
    }

    private void loadSubsystemIfPresent(String string, Collection<SubsystemInfo> collection) {
        String string2 = FEATURES_FOLDER + SEPARATOR + string;
        if (PluginSubsystemUtilities.isExist(string2)) {
            SubsystemInfo subsystemInfo = null;
            try {
                subsystemInfo = new SubsystemInfo(string);
                if (this.isStopLoadingSubsystem(subsystemInfo)) {
                    return;
                }
                collection.add(subsystemInfo);
                this.requiredSystemMap.put(string, subsystemInfo);
                subsystemInfo.setLoad(true);
                this.requiredSystemList.add(subsystemInfo);
            }
            catch (MalformedURLException malformedURLException) {
                logger.error(malformedURLException.getMessage(), malformedURLException);
                logger.error("SubSystem initialization failed. " + string);
            }
            catch (SubsystemConfigException subsystemConfigException) {
                logger.error("SubSystem initialization failed. " + string);
                logger.error(subsystemConfigException.getMessage(), subsystemConfigException);
            }
        }
    }

    private Collection<SubsystemInfo> getRequiredSubsystemList() {
        return this.requiredSystemMap.values();
    }

    private List<SubsystemInfo> getRequiredSubsystem() {
        ArrayList<SubsystemInfo> arrayList = new ArrayList<SubsystemInfo>(10);
        for (SubsystemInfo subsystemInfo : this.getRequiredSubsystemList()) {
            if (!subsystemInfo.isLoad()) continue;
            arrayList.add(subsystemInfo);
        }
        return arrayList;
    }

    private void removeDupliateSubsystemInfo(List<SubsystemInfo> list) {
        HashSet<SubsystemInfo> hashSet = new HashSet<SubsystemInfo>(list);
        list.clear();
        list.addAll(hashSet);
    }

    public List<SubsystemInfo> getAllSubsystem() {
        List<SubsystemInfo> list = this.getRequiredSubsystem();
        list.addAll(this.getSubsystemList());
        this.removeDupliateSubsystemInfo(list);
        return list;
    }

    public boolean isHideTabbedbar() {
        boolean bl = false;
        for (SubsystemInfo subsystemInfo : this.getAllSubsystem()) {
            bl = true;
            if (null == subsystemInfo || subsystemInfo.isHideTabbedbar()) continue;
            return false;
        }
        return bl;
    }

    public void cleanupWhileOSGIExit() {
        this.cleanUp();
        this.pluginList = null;
        this.subSystemMap = null;
        this.requiredSystemMap = null;
        this.requiredSystemList = null;
    }

    public void createAndRegisterSubsystem(String string) {
        SubsystemInfo subsystemInfo = null;
        try {
            subsystemInfo = new SubsystemInfo(string);
            if (this.isStopLoadingSubsystem(subsystemInfo)) {
                return;
            }
            this.register(subsystemInfo.getId(), subsystemInfo);
            subsystemInfo.setLoad(true);
            if (subsystemInfo != null) {
                logger.info("FeatureInfo --- featureId:" + subsystemInfo.getId() + ",plugins:" + subsystemInfo.getPluginList() + ",reqPlugins:" + subsystemInfo.getRequiredPluginList());
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error(malformedURLException.getMessage(), malformedURLException);
            logger.error("SubSystem initialization failed. " + string);
        }
        catch (SubsystemConfigException subsystemConfigException) {
            logger.error("SubSystem initialization failed. " + string);
            logger.error(subsystemConfigException.getMessage(), subsystemConfigException);
        }
    }
}

