/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.subsystemmanagement;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.TabInterface;
import com.swimap.iview.framework.subsystemmanagement.SubsystemInfo;
import com.swimap.iview.framework.subsystemmanagement.SubsystemListTable;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.ResourceAdapter;
import com.swimap.iview.util.helpmanagement.HelpManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class SubsystemAboutPage
extends JPanel
implements TabInterface {
    static final ResourceBundle RES = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/subsystemmanagement/Res");
    private static final String TITLE = RES.getString("Subsystem_About_Page_Title");
    private static final int DEFAULT_SIZE = 10;
    private SubsystemListTable table = null;
    private JLabel imageLbl = null;

    public SubsystemAboutPage() {
        this.createPageGUI();
    }

    private void createPageGUI() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getImagePanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, new Insets(0, 0, 10, 0), 0, 0));
        this.add((Component)new JScrollPane(this.getTable()), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.putClientProperty("HELP_ID_PROPERTY", "IVIEW.about.Component");
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.enableHelpKey(this, "IVIEW.about.Component");
    }

    private SubsystemListTable getTable() {
        if (this.table == null) {
            SubsystemManager subsystemManager = SubsystemManager.getInstance();
            this.table = new SubsystemListTable();
            this.table.setName("subsystemTable");
            List<SubsystemInfo> list = null;
            switch (subsystemManager.getClientLoadMode()) {
                case single: {
                    list = subsystemManager.getAllSubsystem();
                    break;
                }
                case complex: {
                    list = subsystemManager.getAllSubsystem();
                    break;
                }
                default: {
                    throw new IllegalStateException("invalid status");
                }
            }
            for (SubsystemInfo subsystemInfo : list) {
                this.table.addRow(subsystemInfo);
            }
        }
        return this.table;
    }

    private JLabel getImagePanel() {
        if (this.imageLbl == null) {
            this.imageLbl = new JLabel();
            this.imageLbl.setIcon(ResourceAdapter.getAboutBannerIcon());
        }
        return this.imageLbl;
    }

    @Override
    public JPanel getPage() {
        return this;
    }

    @Override
    public String getTitle() {
        return TITLE;
    }
}

