/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.statusbarmanagement;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginDefinitionHandler;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.statusbarmanagement.IStatusBarManager;
import com.swimap.iview.framework.statusbarmanagement.ProgressChangeListener;
import com.swimap.iview.framework.statusbarmanagement.StatusBarItemInfo;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.templates.statusbar.BubbleStatusBarItem;
import com.swimap.iview.templates.statusbar.IModelChangeListener;
import com.swimap.iview.templates.statusbar.MessageStyleInfo;
import com.swimap.iview.templates.statusbar.ProgressStatusBarItem;
import com.swimap.iview.templates.statusbar.StatusBar;
import com.swimap.iview.templates.statusbar.StatusBarItem;
import com.swimap.iview.templates.statusbar.TimerDisplayStatusBarItem;
import com.swimap.iview.util.SerializableTool;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.swing.BoundedRangeModel;
import javax.swing.JPanel;
import org.omg.CORBA.ORB;

public class StatusBarManager
extends BaseModule
implements IStatusBarManager {
    private static IviewLogger logger = IviewLogger.getLogger(StatusBarManager.class, "IVIEW");
    private static final String AREA_NAME = "statusbar";
    private static final String DESC_NAME = "statusbar";
    private StatusBar statusBar = null;
    protected static String moduleName = "statusbar module(undefined)";
    private Vector<CommStyleInfo> infoVector = new Vector(10);
    private HashMap<String, StatusBarItemInfo> statusBarItemInfoMap = new HashMap(10);
    private ModuleManager moduleManager = null;

    public StatusBarManager(ModuleManager moduleManager, ORB oRB, String string, String string2, String string3) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
        moduleName = string3;
        this.register(this);
        this.moduleManager = moduleManager;
        this.init();
    }

    public StatusBarManager(ModuleManager moduleManager, String string) throws ModuleManagementException {
        super(moduleManager);
        moduleName = string;
        this.register(this);
        this.moduleManager = moduleManager;
        this.init();
    }

    public void init() {
    }

    @Override
    public void clear() {
        int n = this.statusBar.getStatusBarItemCount();
        StatusBarItem statusBarItem = null;
        for (int i = 0; i < n; ++i) {
            statusBarItem = this.statusBar.getStatusBarItem(i);
            if (statusBarItem instanceof TimerDisplayStatusBarItem) {
                ((TimerDisplayStatusBarItem)statusBarItem).stop();
            }
            statusBarItem.refreshItem("");
        }
        this.clearStatusBar();
    }

    @Override
    public void reinitialize() {
        this.filterModuleStatusBar();
        int n = this.statusBar.getStatusBarItemCount();
        StatusBarItem statusBarItem = null;
        for (int i = 0; i < n; ++i) {
            statusBarItem = this.statusBar.getStatusBarItem(i);
            if (statusBarItem instanceof TimerDisplayStatusBarItem) {
                ((TimerDisplayStatusBarItem)statusBarItem).start();
            }
            if (!(statusBarItem instanceof BubbleStatusBarItem)) continue;
            BubbleStatusBarItem bubbleStatusBarItem = (BubbleStatusBarItem)statusBarItem;
            bubbleStatusBarItem.setBubbleEnabledFromUser();
        }
    }

    private void filterModuleStatusBar() {
        Iterator<Map.Entry<String, StatusBarItemInfo>> iterator = this.statusBarItemInfoMap.entrySet().iterator();
        String string = null;
        StatusBarItemInfo statusBarItemInfo = null;
        ModuleInformation moduleInformation = null;
        Map.Entry<String, StatusBarItemInfo> entry = null;
        boolean bl = iterator.hasNext();
        while (bl) {
            entry = iterator.next();
            string = entry.getKey();
            statusBarItemInfo = entry.getValue();
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(statusBarItemInfo.getPluginName());
            if (null != plugin && null != (moduleInformation = plugin.getModuleInfomation()) && this.moduleManager.getNonOperationalModules().contains(moduleInformation.getModuleName())) {
                this.statusBar.removeStatusBarItem(this.getStatusBarItem(string));
            }
            bl = iterator.hasNext();
        }
    }

    public boolean loadStatusBar(String string) {
        return this.loadStatusBar(string, "statusbar", "statusbar");
    }

    public StatusBarItem getStatusBarItem(String string) {
        return this.statusBar.getStatusBarItem(string);
    }

    public boolean loadStatusBar(String string, String string2, String string3) {
        boolean bl = false;
        try {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(string);
            if (null != commStyleInfo) {
                this.statusBar = new StatusBar(commStyleInfo.getAreaDescContainer(string2).getDescContainer(string3));
                this.infoVector.add(commStyleInfo);
            }
            bl = true;
            final ProgressStatusBarItem progressStatusBarItem = (ProgressStatusBarItem)this.getStatusBarItem("ProgressStatusBar");
            BoundedRangeModel boundedRangeModel = progressStatusBarItem.getModel();
            IModelChangeListener iModelChangeListener = new IModelChangeListener(){

                @Override
                public void modelChanged() {
                    BoundedRangeModel boundedRangeModel = progressStatusBarItem.getModel();
                    boundedRangeModel.addChangeListener(new ProgressChangeListener(boundedRangeModel, progressStatusBarItem));
                }
            };
            progressStatusBarItem.addModelChangeListener(iModelChangeListener);
            boundedRangeModel.addChangeListener(new ProgressChangeListener(boundedRangeModel, progressStatusBarItem));
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean loadStatusBar(CommStyleInfo commStyleInfo) {
        return this.loadStatusBar(commStyleInfo, "statusbar", "statusbar");
    }

    public boolean loadStatusBar(CommStyleInfo commStyleInfo, String string, String string2) {
        boolean bl = true;
        if (null == commStyleInfo || null == string || null == string2) {
            logger.debug("argument is null, pls check it.");
            return !bl;
        }
        if (null == this.statusBar) {
            logger.debug("StatusBar is null, init it.");
            try {
                this.statusBar = new StatusBar(commStyleInfo.getAreaDescContainer(string).getDescContainer(string2));
            }
            catch (Exception exception) {
                bl = false;
            }
            return bl;
        }
        try {
            this.statusBar.addStatusBar(commStyleInfo, string, string2);
        }
        catch (Exception exception) {
            logger.debug("exception occured while adding StatusBar.");
            logger.trace(exception.getMessage(), exception);
            bl = false;
        }
        return bl;
    }

    public boolean unloadStatusBar(CommStyleInfo commStyleInfo) {
        boolean bl = false;
        if (null == commStyleInfo) {
            logger.debug("styleInfo is null, pls check it.");
            return bl;
        }
        bl = this.statusBar.removeStatusBar(commStyleInfo);
        return bl;
    }

    public boolean updateStatusBar(String string) {
        return this.updateStatusBar(string, false);
    }

    public boolean updateStatusBar(String string, boolean bl) {
        return this.updateStatusBar(string, bl, "statusbar", "statusbar");
    }

    public boolean updateStatusBar(String string, boolean bl, String string2, String string3) {
        boolean bl2 = true;
        if (this.statusBar == null) {
            logger.debug("StatusBar is null, init it.");
            try {
                this.loadStatusBarFromPlugin();
            }
            catch (Exception exception) {
                return false;
            }
            return this.loadStatusBar(string, string2, string3);
        }
        List list = this.statusBar.saveItemInfo();
        JPanel jPanel = (JPanel)this.statusBar.getParent();
        jPanel.remove(this.statusBar);
        StatusBar statusBar = this.statusBar;
        try {
            CommStyleInfo commStyleInfo = null;
            commStyleInfo = bl ? CommStyleManager.getInstance().getAbsCommStyleFile(string) : CommStyleManager.getInstance().getCommonStyleFile(string);
            if (null != commStyleInfo) {
                this.statusBar = new StatusBar(commStyleInfo.getAreaDescContainer(string2).getDescContainer(string3));
            }
        }
        catch (Exception exception) {
            logger.debug("Happpend exception when construct StatusBar.");
            logger.trace(exception.getMessage(), exception);
            this.statusBar = statusBar;
            bl2 = false;
        }
        try {
            this.statusBar.recoverStatusBar(list);
            jPanel.add((Component)this.statusBar, "South");
            jPanel.validate();
            jPanel.repaint();
        }
        catch (Exception exception) {
            logger.debug("Happpend exception when recover infomation.");
            logger.trace(exception.getMessage(), exception);
            bl2 = false;
        }
        return bl2;
    }

    @Override
    public JPanel getStatusBarPanel() {
        return this.statusBar;
    }

    @Override
    public boolean refreshItem(String string, String string2) {
        if (null == string) {
            return false;
        }
        if (this.statusBar == null) {
            return false;
        }
        this.statusBar.refreshItem(string, string2);
        return true;
    }

    @Override
    public boolean refreshItem(String string, MessageStyleInfo messageStyleInfo) {
        if (null == string) {
            return false;
        }
        if (this.statusBar == null) {
            return false;
        }
        this.statusBar.refreshItemStyle(string, messageStyleInfo);
        return true;
    }

    @Override
    public boolean refreshItem(String string, String string2, MessageStyleInfo messageStyleInfo) {
        if (null == string) {
            return false;
        }
        if (this.statusBar == null) {
            return false;
        }
        this.statusBar.refreshItem(string, string2, messageStyleInfo);
        return true;
    }

    @Override
    public String getModuleName() {
        return moduleName;
    }

    public void loadPostLoginStatusBarFromPlugin() {
        this.loadStatusBarFromPlugin();
    }

    public void loadPostLoginStatusBarFromPlugin(String string) {
        this.loadStatusBarFromPlugin(string);
    }

    private void clearStatusBar() {
        Set<Map.Entry<String, StatusBarItemInfo>> set = this.statusBarItemInfoMap.entrySet();
        for (Map.Entry<String, StatusBarItemInfo> entry : set) {
            String string = entry.getValue().getItemId();
            this.statusBar.removeStatusBarItem(this.statusBar.getStatusBarItem(string));
        }
    }

    private void loadStatusBarFromPlugin() {
        logger.trace("Begin to load status bar items");
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList();
        this.loadAndWriteStatusbarInfo(list);
    }

    private void loadStatusBarFromPlugin(String string) {
        logger.trace("Begin to load status bar items");
        List<Plugin> list = PluginManager.getInstance().getStartupPluginList(string);
        this.loadAndWriteStatusbarInfo(list);
        logger.debug("Completed to load statusbar items");
    }

    public void loadStatusBarFromPlugin_FromPortal() {
        logger.debug("Begin to load status bar items");
        List<Plugin> list = PluginManager.getInstance().getStartupLoadedPluginList();
        this.loadAndWriteStatusbarInfo(list);
        logger.debug("Completed to load statusbar items");
    }

    private void loadAndWriteStatusbarInfo(List<Plugin> list) {
        if (null != list) {
            if (this.readStatusBar()) {
                return;
            }
            Plugin plugin2 = null;
            for (Plugin plugin2 : list) {
                CommStyleInfo commStyleInfo = plugin2.getIntegrateCommStyleReader().getCommStyleInfo("statusbar.xml");
                if (null == commStyleInfo) continue;
                this.getStatusInfo(commStyleInfo, this.statusBarItemInfoMap);
            }
            this.loadStatusBarFromMap(this.statusBarItemInfoMap);
            this.writeStatusBar();
        }
    }

    private void writeStatusBar() {
        if (SerializationHandler.isEnableSerialization()) {
            logger.trace("Begin to load status bar items");
            String string = SerializableTool.getFileName("statusbar");
            SerializableTool.writeData(string, this.statusBarItemInfoMap);
        }
    }

    private void getStatusInfo(CommStyleInfo commStyleInfo, HashMap<String, StatusBarItemInfo> hashMap) {
        if (null == commStyleInfo || null == hashMap) {
            return;
        }
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer(0);
        Iterator iterator = areaDescContainer.getDescContainerList().iterator();
        StatusBarItemInfo statusBarItemInfo = null;
        while (iterator.hasNext()) {
            DescContainer descContainer = (DescContainer)iterator.next();
            for (DescContainer descContainer2 : descContainer.getDescContainerList()) {
                if (null != this.statusBar.getStatusBarItem(descContainer2.getDescName())) continue;
                statusBarItemInfo = new StatusBarItemInfo();
                statusBarItemInfo.setPluginId(commStyleInfo.getPluginName());
                statusBarItemInfo.setItemId(descContainer2.getDescName());
                int n = descContainer2.getParasItemCount();
                for (int i = 0; i < n; ++i) {
                    String string = descContainer2.getParasItem(i).getName();
                    String string2 = descContainer2.getParasItem(i).getValue();
                    if (null == string2) continue;
                    statusBarItemInfo.setOtherParaList(string, string2);
                }
                hashMap.put(statusBarItemInfo.getItemId(), statusBarItemInfo);
            }
        }
    }

    private void removeStatusItemFromMap(List<String> list, HashMap<String, StatusBarItemInfo> hashMap) {
        HashSet<String> hashSet = new HashSet<String>(hashMap.keySet());
        for (String string : hashSet) {
            String string2 = hashMap.get(string).getPluginName();
            if (!list.contains(string2)) continue;
            hashMap.remove(string);
        }
    }

    private boolean readStatusBar() {
        Object object;
        HashMap hashMap = null;
        if (SerializationHandler.isEnableSerialization() && PluginDefinitionHandler.getPluginDefinitionHandler().isConfigurationPresent()) {
            object = SerializableTool.getFileName("statusbar");
            hashMap = (HashMap)SerializableTool.readData((String)object);
        }
        if (null == hashMap) {
            return false;
        }
        object = new ArrayList();
        List<Plugin> list = null;
        list = FrameworkCommandProcessor.getInstance().isAppStyle() ? ApplicationUtilities.getAllStartupPluginsList() : PluginManager.getInstance().getStartupPluginList();
        Iterator<Plugin> iterator = list.iterator();
        while (iterator.hasNext()) {
            object.add(iterator.next().getPluginName());
        }
        boolean bl = false;
        Collection collection = hashMap.values();
        Iterator iterator2 = collection.iterator();
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator2.hasNext()) {
            hashSet.add(((StatusBarItemInfo)iterator2.next()).getPluginName());
        }
        ArrayList arrayList = new ArrayList(hashSet);
        ArrayList arrayList2 = new ArrayList(object);
        arrayList2.removeAll(arrayList);
        ArrayList<String> arrayList3 = new ArrayList<String>(arrayList);
        arrayList3.removeAll((Collection<?>)object);
        if (0 != arrayList3.size()) {
            this.removeStatusItemFromMap(arrayList3, hashMap);
            bl = true;
        }
        Iterator iterator3 = arrayList2.iterator();
        while (iterator3.hasNext()) {
            CommStyleInfo commStyleInfo;
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder((String)iterator3.next());
            if (null == plugin || null == (commStyleInfo = plugin.getIntegrateCommStyleReader().getCommStyleInfo("statusbar.xml"))) continue;
            this.getStatusInfo(commStyleInfo, hashMap);
            bl = true;
        }
        this.loadStatusBarFromMap(hashMap);
        this.statusBarItemInfoMap.clear();
        this.statusBarItemInfoMap.putAll(hashMap);
        if (bl) {
            this.writeStatusBar();
        }
        return true;
    }

    private void loadStatusBarFromMap(HashMap<String, StatusBarItemInfo> hashMap) {
        DescContainer descContainer = null;
        CommStyleInfo commStyleInfo = null;
        Plugin plugin = null;
        for (StatusBarItemInfo statusBarItemInfo : hashMap.values()) {
            String string = statusBarItemInfo.getItemId();
            descContainer = new DescContainer(string);
            HashMap<String, String> hashMap2 = statusBarItemInfo.getOtherParaList();
            for (Map.Entry<String, String> entry : hashMap2.entrySet()) {
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                descContainer.setParasItem(string2, string3, true);
            }
            commStyleInfo = new CommStyleInfo();
            String string4 = statusBarItemInfo.getPluginName();
            commStyleInfo.setPluginName(string4);
            plugin = PluginManager.getInstance().getPluginFromFolder(string4);
            if (null != plugin) {
                commStyleInfo.setPluginResource(plugin.getResource());
            }
            descContainer._setParent(commStyleInfo);
            try {
                StatusBarItem statusBarItem = this.statusBar.createItem(descContainer.getParasItemValue("classPath"), descContainer.getParasItemValue("itemType"), descContainer);
                if ("false".equalsIgnoreCase(descContainer.getParasItemValue("initialVisible"))) {
                    statusBarItem.setVisible(false);
                }
                this.statusBar.setItemSize(statusBarItem, descContainer);
                this.statusBar.addStatusBarItem(statusBarItem);
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
            }
        }
    }

    @Override
    public void stop() {
        super.stop();
    }
}

