/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.registry;

import com.swimap.iview.framework.modulemanagement.BaseModule;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.registry.HierarchyTracer;
import com.swimap.iview.framework.registry.ModuleRegistryStrategy;
import com.swimap.iview.framework.registry.RegistryFactory;
import com.swimap.iview.framework.registry.RegistryProvider;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

public class RegistryPluginActivator
extends BaseModule {
    private static IviewLogger logger = IviewLogger.getLogger(RegistryPluginActivator.class, "IVIEW");
    private static final String STORAGE_DIR = "com.swimap.iview.registry";
    private static final String CONFIGURATION = "configuration/setting";
    private IExtensionRegistry defaultRegistry = null;

    public RegistryPluginActivator(ModuleManager moduleManager) {
        super(moduleManager);
    }

    @Override
    public void initialize() {
        String string = System.getProperty("user.dir") + '/' + CONFIGURATION + '/' + STORAGE_DIR;
        File file = new File(string);
        File[] fileArray = new File[]{file};
        boolean[] blArray = new boolean[]{false};
        ModuleRegistryStrategy moduleRegistryStrategy = new ModuleRegistryStrategy(fileArray, blArray);
        try {
            this.defaultRegistry = RegistryFactory.createRegistry(moduleRegistryStrategy, null, null);
        }
        catch (NullPointerException nullPointerException) {
            boolean bl = moduleRegistryStrategy.cacheUse();
            if (bl) {
                if (!CommonUtil.deleteDir(file)) {
                    logger.error(nullPointerException.getMessage(), nullPointerException);
                    System.setProperty("ExtesionRegistry.cacheUse", "false");
                    this.defaultRegistry = RegistryFactory.createRegistry(moduleRegistryStrategy, null, null);
                    System.setProperty("ExtesionRegistry.cacheUse", "true");
                    logger.error("registry recreated");
                } else {
                    this.defaultRegistry = RegistryFactory.createRegistry(moduleRegistryStrategy, null, null);
                }
            }
            logger.trace("Exception while creating the registry isCacheuse = " + bl + nullPointerException);
        }
        RegistryProvider.setRegistry(this.defaultRegistry);
        if (moduleRegistryStrategy.debug()) {
            String[] stringArray;
            for (String string2 : stringArray = this.defaultRegistry.getNamespaces()) {
                this.debug(string2);
            }
        }
    }

    @Override
    public void stop() {
        if (null != this.defaultRegistry) {
            this.defaultRegistry.stop(null);
        }
    }

    private void debug(String string) {
        IExtensionPoint[] iExtensionPointArray;
        HierarchyTracer hierarchyTracer = new HierarchyTracer("\t");
        hierarchyTracer.out("<Plugin.xml: " + string + '>');
        for (IExtensionPoint iExtensionPoint : iExtensionPointArray = this.defaultRegistry.getExtensionPoints(string)) {
            IExtension[] iExtensionArray;
            hierarchyTracer.pushOut("<ExtesionPoint: " + iExtensionPoint.getSimpleIdentifier() + '>');
            hierarchyTracer.pushOut("NamespaceIdentifier = " + iExtensionPoint.getNamespaceIdentifier());
            hierarchyTracer.out("SimpleIdentifier = " + iExtensionPoint.getSimpleIdentifier());
            hierarchyTracer.out("SchemaReference = " + iExtensionPoint.getSchemaReference());
            hierarchyTracer.out("<Extensions: >");
            for (IExtension iExtension : iExtensionArray = iExtensionPoint.getExtensions()) {
                hierarchyTracer.pushOut("<");
                hierarchyTracer.out("id = " + iExtension.getSimpleIdentifier());
                hierarchyTracer.out("Contributor = " + iExtension.getContributor().getName());
                hierarchyTracer.popOut("/>");
            }
            hierarchyTracer.popOut("</Extensions:>");
            hierarchyTracer.popOut("</ExtesionPoint:  " + iExtensionPoint.getSimpleIdentifier() + '>');
        }
        IExtensionPoint[] iExtensionPointArray2 = this.defaultRegistry.getExtensions(string);
        hierarchyTracer.pushOut("<Extensions: " + string + '>');
        for (IExtensionPoint iExtensionPoint : iExtensionPointArray2) {
            hierarchyTracer.pushOut('<' + iExtensionPoint.getSimpleIdentifier());
            hierarchyTracer.pushOut("id = " + iExtensionPoint.getSimpleIdentifier());
            hierarchyTracer.popOut("Contributor = " + iExtensionPoint.getContributor().getName());
            hierarchyTracer.popOut('<' + iExtensionPoint.getSimpleIdentifier());
        }
        hierarchyTracer.popOut("</Extensions: " + string + '>');
        hierarchyTracer.out("</Plugin.xml: " + string + '>');
    }
}

