/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.registry;

import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.registry.ContributionFactory;
import com.swimap.iview.framework.registry.ResourceTranslator;
import com.swimap.iview.util.log.IviewLogger;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.internal.registry.ExtensionHandle;
import org.eclipse.core.internal.registry.ExtensionPointHandle;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.IContributor;

public class RegistryLoader {
    private static IviewLogger logger = IviewLogger.getLogger(RegistryLoader.class, "IVIEW");
    private ExtensionRegistry registry = null;
    private static final String PLUGIN_MANIFEST = "plugin.xml";

    public RegistryLoader(ExtensionRegistry extensionRegistry) {
        this.registry = extensionRegistry;
    }

    public void removeBundle(Plugin plugin) {
        if (null != plugin) {
            this.registry.remove(plugin.getId());
        }
    }

    public void addPlugin(Plugin plugin) {
        if (null != plugin) {
            Object object;
            ExtensionHandle[] extensionHandleArray;
            Object object2;
            String string = plugin.getId();
            if (this.registry.hasContributor(string)) {
                object2 = this.registry.getObjectManager().getExtensionPointsFromContributor(string);
                if (object2 != null && ((ExtensionPointHandle[])object2).length != 0) {
                    return;
                }
                extensionHandleArray = this.registry.getObjectManager().getExtensionsFromContributor(string);
                if (null != extensionHandleArray && 0 != extensionHandleArray.length) {
                    return;
                }
                this.registry.remove(string);
                logger.debug("ExtensionPoints or extensions of plugin:" + plugin.getId() + "are not exist in registry");
            }
            object2 = null;
            extensionHandleArray = "plugin.xml";
            try {
                object = plugin.getEntry((String)extensionHandleArray);
                if (null != object) {
                    object2 = ((URL)object).openStream();
                }
            }
            catch (IOException iOException) {
                logger.debug("IO Exception occured reading the plugin.xml for the plugin:" + plugin.getId());
                object2 = null;
            }
            if (null == object2) {
                return;
            }
            object = null;
            try {
                object = ResourceTranslator.getResourceBundle(plugin);
            }
            catch (MissingResourceException missingResourceException) {
                logger.trace(missingResourceException.getMessage(), missingResourceException);
            }
            IContributor iContributor = ContributionFactory.createContributor(plugin);
            boolean bl = this.registry.addContribution((InputStream)object2, iContributor, true, (String)extensionHandleArray, (ResourceBundle)object, null);
            if (!bl) {
                logger.debug("addContributor to the registry for the plugin:" + plugin.getId() + " has failed");
            }
        }
    }
}

