/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.registry;

import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.registry.RegistryLoader;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;

public class ModuleRegistryStrategy
extends RegistryStrategy {
    private static IviewLogger logger = IviewLogger.getLogger(ModuleRegistryStrategy.class, "IVIEW");
    private static final String EXTENSIONREGISTRY_CACHEUSE = "ExtesionRegistry.cacheUse";
    private static final String EXTENSIONREGISTRY_CACHE_LAZYLOADING = "ExtesionRegistry.cacheLazyLoading";
    private static final String EXTENSIONREGISTRY_DEBUG = "ExtesnionRigestry.debug";

    public ModuleRegistryStrategy(File[] fileArray, boolean[] blArray) {
        super(fileArray, blArray);
    }

    public void onStart(IExtensionRegistry iExtensionRegistry) {
        PluginManager pluginManager = PluginManager.getInstance();
        List<Plugin> list = pluginManager.getAllLoadedPlugins();
        RegistryLoader registryLoader = this.createRegistryLoader((ExtensionRegistry)iExtensionRegistry);
        ModuleInformation moduleInformation = null;
        for (Plugin plugin : list) {
            if (null == plugin || null != (moduleInformation = plugin.getModuleInfomation()) && !FrameworkUtilities.isInState(moduleInformation.getStates())) continue;
            registryLoader.addPlugin(plugin);
        }
    }

    private RegistryLoader createRegistryLoader(ExtensionRegistry extensionRegistry) {
        RegistryLoader registryLoader = new RegistryLoader(extensionRegistry);
        return registryLoader;
    }

    public void onStop(IExtensionRegistry iExtensionRegistry) {
    }

    public Object createExecutableExtension(RegistryContributor registryContributor, String string, String string2) throws CoreException {
        String string3 = registryContributor.getId();
        Plugin plugin = PluginManager.getInstance().getPlugin(string3);
        Object var6_6 = null;
        try {
            if (null != plugin) {
                Class clazz = plugin.loadClass(string);
                var6_6 = clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.trace(classNotFoundException.getMessage(), classNotFoundException);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        return var6_6;
    }

    public boolean cacheUse() {
        return Boolean.valueOf(System.getProperty(EXTENSIONREGISTRY_CACHEUSE));
    }

    public boolean cacheLazyLoading() {
        return Boolean.valueOf(System.getProperty(EXTENSIONREGISTRY_CACHE_LAZYLOADING));
    }

    public long getContainerTimestamp() {
        return 0L;
    }

    public long getContributionsTimestamp() {
        List<Plugin> list = PluginManager.getInstance().getAllLoadedPlugins();
        long l = 0L;
        ModuleInformation moduleInformation = null;
        URL uRL = null;
        URLConnection uRLConnection = null;
        try {
            for (Plugin plugin : list) {
                moduleInformation = plugin.getModuleInfomation();
                if (null != moduleInformation && !FrameworkUtilities.isInState(moduleInformation.getStates()) || null == (uRL = plugin.getEntry("plugin.xml"))) continue;
                uRLConnection = uRL.openConnection();
                l ^= uRLConnection.getLastModified();
            }
        }
        catch (IOException iOException) {
            return 0L;
        }
        return l;
    }

    public boolean debug() {
        return Boolean.valueOf(System.getProperty(EXTENSIONREGISTRY_DEBUG));
    }
}

