/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig.util;

import com.swimap.imap12.util.dateChooser.InmDateDocument;
import com.swimap.iview.framework.regionconfig.datasource.DataSource;
import com.swimap.iview.framework.regionconfig.datasource.XMLConfig;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.ZoneDSTUtil;

public class TimeDateFormat {
    public static void dateSettingInit() {
        XMLConfig xMLConfig = DataSource.getInstance().getUserSettingXMLConfig();
        TimeDateFormat.setDateSetting(xMLConfig);
    }

    private static void setDateSetting(XMLConfig xMLConfig) {
        if (XMLConfig.isValid(xMLConfig.getCurDateSeparateSymbol())) {
            TimeDateFormatUtil.setCurDateSeparatorSymbol(xMLConfig.getCurDateSeparateSymbol());
            InmDateDocument.dateSeparator = xMLConfig.getCurDateSeparateSymbol().toString();
        }
        if (XMLConfig.isValid(xMLConfig.getCurDateShowFormat())) {
            TimeDateFormatUtil.setCurDateFormat(xMLConfig.getCurDateShowFormat());
        }
        InmDateDocument.defaultType = TimeDateFormatUtil.getFormatTimeDateType();
    }

    public static void timeSettingInit() {
        XMLConfig xMLConfig = DataSource.getInstance().getUserSettingXMLConfig();
        TimeDateFormat.setTimeSetting(xMLConfig);
    }

    private static void setTimeSetting(XMLConfig xMLConfig) {
        TimeDateFormatUtil.setCurTimeSeparatorSymbol(TimeDateFormatUtil.DEFAULT_TIME_SEPARATOR_SYMBOL);
        InmDateDocument.timeSeparator = TimeDateFormatUtil.DEFAULT_TIME_SEPARATOR_SYMBOL.toString();
        if (XMLConfig.isValid(xMLConfig.getCurTimeFormat())) {
            TimeDateFormatUtil.setCurTimeFormat(xMLConfig.getCurTimeFormat());
        }
        if (XMLConfig.isValid(xMLConfig.getCurTimeAmFormat())) {
            TimeDateFormatUtil.setCurAmFormatSymbol(xMLConfig.getCurTimeAmFormat());
        }
        if (XMLConfig.isValid(xMLConfig.getCurTimePmFormat())) {
            TimeDateFormatUtil.setCurPmFormatSymbol(xMLConfig.getCurTimePmFormat());
        }
        if (DataSource.getInstance().isSupportZone() && XMLConfig.isValid(xMLConfig.getCurShowZone())) {
            ZoneDSTUtil.initShowZone(xMLConfig.getCurShowZone().getValue() == 1);
        }
        if (DataSource.getInstance().isSupportDST() && XMLConfig.isValid(xMLConfig.getCurShowDST())) {
            ZoneDSTUtil.initShowDST(xMLConfig.getCurShowDST().getValue() == 1);
        }
        InmDateDocument.time_AM_PM_symbols = TimeDateFormatUtil.getTime_AM_PM_Symbols();
        InmDateDocument.defaultType = TimeDateFormatUtil.getFormatTimeDateType();
        InmDateDocument.isAM_PMEnable = TimeDateFormatUtil.isAM_PMEnable();
    }

    public static XMLConfig getXMLConfig() {
        return DataSource.getInstance().getUserSettingXMLConfig();
    }

    public static void setXMLConfig(XMLConfig xMLConfig) {
        TimeDateFormat.setDateSetting(xMLConfig);
        TimeDateFormat.setTimeSetting(xMLConfig);
    }
}

