/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig.ui;

import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.regionconfig.datasource.DataSource;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;

public class TimeSetting
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(TimeSetting.class, "IVIEW");
    static ResourceBundle res = ResourceMng.getInstance().getResourceBundleFromPropertyFile("mainfrm/iview/framework/regionconfig/Res");
    private Thread refreshThread = null;
    private static final int REFRESH_INTERVAL = 1000;
    private boolean isChanged = false;
    private DataSource dataSource = null;
    private String zoneOffsetString = null;
    private boolean isExitThread = false;
    private JComboBox ampmCombo = new JComboBox();
    private JComboBox formatCombo = new JComboBox();
    private JTextField txtTimeShowExample = new JTextField();
    private JCheckBox timeZoneCBox = new JCheckBox(res.getString("ShowZone"));
    private JCheckBox DSTCBox = new JCheckBox(res.getString("ShowDST"));
    private JPanel timeConfigPanel = new JPanel();
    private JPanel timeZonePanel = new JPanel();
    boolean isFirstTimeShowing = true;
    public static boolean failedFailed = false;
    private transient ItemListener itemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TimeSetting.this.notifyChanged();
        }
    };
    private transient ItemListener formatItemListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            TimeSetting.this.notifyChanged();
            if ("TimeFormat0".equals(((ValueNamePair)TimeSetting.this.formatCombo.getSelectedItem()).getName())) {
                TimeSetting.this.setAmPmEnabled(false);
            } else {
                TimeSetting.this.setAmPmEnabled(true);
            }
        }
    };
    private static final Dimension COMPONENT_SIZE = new Dimension(285, 21);
    private static final Dimension LABEL_SIZE = new Dimension(140, 21);
    private static final Dimension PANEL_MIN_SIZE = new Dimension(50, 21);
    private static final Dimension PANEL_PEREFER_SIZE = new Dimension(435, 21);
    private static final Dimension PANEL_MAX_SIZE = new Dimension(3000, 21);
    private final Dimension HGAP12 = new Dimension(12, 1);
    private final Dimension HGAP13 = new Dimension(13, 1);
    private final Dimension VGAP8 = new Dimension(1, 8);
    private final Dimension VGAP12 = new Dimension(1, 12);
    JPanel timeExamplePanel = new JPanel();

    public TimeSetting() {
        this.jbInit();
    }

    public boolean isSupportDST() {
        return this.dataSource.isSupportDST();
    }

    public boolean isSupportZone() {
        return this.dataSource.isSupportZone();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        JLabel jLabel4 = new JLabel();
        jLabel.setMinimumSize(LABEL_SIZE);
        jLabel.setPreferredSize(LABEL_SIZE);
        jLabel2.setMinimumSize(LABEL_SIZE);
        jLabel2.setPreferredSize(LABEL_SIZE);
        this.ampmCombo.setPreferredSize(COMPONENT_SIZE);
        this.ampmCombo.setName("TimeSetting_ampmCombo");
        this.formatCombo.setPreferredSize(COMPONENT_SIZE);
        this.formatCombo.setName("TimeSetting_formatCombo");
        this.txtTimeShowExample.setPreferredSize(COMPONENT_SIZE);
        this.txtTimeShowExample.setName("TimeSetting_txtTimeShowExample");
        this.timeZoneCBox.setName("TimeSetting_timeZoneCBox");
        this.DSTCBox.setName("TimeSetting_DSTCBox");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), res.getString("TimeFormatSign"));
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 20, 6, 10));
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.setBorder(border);
        this.setLayout(new BorderLayout(0, 2));
        this.timeConfigPanel.setLayout(new BoxLayout(this.timeConfigPanel, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.timeZonePanel.setLayout(new FlowLayout(0, 17, 4));
        jPanel.setMinimumSize(PANEL_MIN_SIZE);
        jPanel.setPreferredSize(PANEL_PEREFER_SIZE);
        jPanel.setMaximumSize(PANEL_MAX_SIZE);
        jPanel2.setMinimumSize(PANEL_MIN_SIZE);
        jPanel2.setPreferredSize(PANEL_PEREFER_SIZE);
        jPanel2.setMaximumSize(PANEL_MAX_SIZE);
        JLabel jLabel5 = new JLabel();
        jLabel5.setMinimumSize(LABEL_SIZE);
        jLabel5.setPreferredSize(LABEL_SIZE);
        jLabel5.setText(res.getString("TimeShowExample"));
        this.timeExamplePanel.setLayout(new BoxLayout(this.timeExamplePanel, 0));
        this.timeExamplePanel.setMinimumSize(PANEL_MIN_SIZE);
        this.timeExamplePanel.setPreferredSize(PANEL_PEREFER_SIZE);
        this.timeExamplePanel.setMaximumSize(PANEL_MAX_SIZE);
        this.timeExamplePanel.add(Box.createRigidArea(this.HGAP13));
        this.timeExamplePanel.add(jLabel5);
        this.timeExamplePanel.add(this.txtTimeShowExample);
        this.timeExamplePanel.add(Box.createRigidArea(this.HGAP12));
        this.txtTimeShowExample.setEnabled(true);
        this.txtTimeShowExample.setEditable(false);
        jLabel.setText(res.getString("TimeFormat"));
        jLabel2.setText(res.getString("AmFormat"));
        jPanel3.setBorder(compoundBorder);
        jPanel3.setLayout(new GridLayout(2, 1, 10, 6));
        jPanel3.add(jLabel3);
        jPanel3.add(jLabel4);
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 2));
        jPanel4.add((Component)this.timeConfigPanel, "North");
        this.add((Component)jPanel4, "Center");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel3, "North");
        jPanel4.add((Component)jPanel5, "Center");
        jPanel.add(Box.createRigidArea(this.HGAP13));
        jPanel.add(jLabel);
        jPanel.add(this.formatCombo);
        jPanel.add(Box.createRigidArea(this.HGAP12));
        jPanel2.add(Box.createRigidArea(this.HGAP13));
        jPanel2.add(jLabel2);
        jPanel2.add(this.ampmCombo);
        jPanel2.add(Box.createRigidArea(this.HGAP12));
        this.timeConfigPanel.add(jPanel);
        this.timeConfigPanel.add(Box.createRigidArea(this.VGAP8));
        this.timeConfigPanel.add(jPanel2);
        try {
            StringBuffer stringBuffer = new StringBuffer(20).append("hh = ").append(res.getString("Hour")).append("  mm = ").append(res.getString("Minute")).append("  ss = ").append(res.getString("Second")).append("  tt = ").append(res.getString("AMOrPM"));
            StringBuffer stringBuffer2 = new StringBuffer(20).append(res.getString("hhOrHH_Descr"));
            jLabel3.setText(stringBuffer.toString());
            jLabel4.setText(stringBuffer2.toString());
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
        this.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.time");
        HelpManager.getInstance().enableHelpKey(this, "iVIEW.systemsetting.time");
    }

    private void initCombo(ValueNamePair[] valueNamePairArray, ValueNamePair valueNamePair, JComboBox jComboBox) {
        for (int i = 0; i < valueNamePairArray.length; ++i) {
            jComboBox.addItem(valueNamePairArray[i]);
        }
        jComboBox.setSelectedItem(valueNamePair);
    }

    private void notifyChanged() {
        this.refreshExampleShow();
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged("RegionTimeSetting", true);
    }

    private void refreshExampleShow() {
        this.txtTimeShowExample.setText(this.getExampleStr());
    }

    public void initData() {
        this.dataSource = DataSource.getInstance();
        this.initFormatCombo();
        this.initAmPmComboCombo();
        this.initShowZone();
        this.initShowDST();
        if ("TimeFormat0".equals(((ValueNamePair)this.formatCombo.getSelectedItem()).getName())) {
            this.setAmPmEnabled(false);
        } else {
            this.setAmPmEnabled(true);
        }
        this.setXMLDataFromUI();
        this.initZoneOffset();
        if (this.isSupportZone() || this.isSupportDST()) {
            this.timeConfigPanel.add(this.timeZonePanel);
        } else {
            this.timeConfigPanel.add(Box.createRigidArea(this.VGAP12));
        }
        this.timeConfigPanel.add(this.timeExamplePanel);
        this.addItemListener();
        this.isFirstTimeShowing = true;
    }

    private void addItemListener() {
        this.ampmCombo.addItemListener(this.itemListener);
        this.timeZoneCBox.addItemListener(this.itemListener);
        this.DSTCBox.addItemListener(this.itemListener);
        this.formatCombo.addItemListener(this.formatItemListener);
    }

    private void initFormatCombo() {
        if (this.formatCombo.getItemCount() != 0) {
            this.formatCombo.removeAllItems();
        }
        this.initCombo(this.dataSource.getRegionXMLConfig().getTimeFormats(), this.dataSource.getUserSettingXMLConfig().getCurTimeFormat(), this.formatCombo);
    }

    private void initAmPmComboCombo() {
        ValueNamePair[] valueNamePairArray;
        ValueNamePair[] valueNamePairArray2;
        if (this.ampmCombo.getItemCount() != 0) {
            this.ampmCombo.removeAllItems();
        }
        if ((valueNamePairArray2 = this.dataSource.getRegionXMLConfig().getTimeAmFormats()).length == (valueNamePairArray = this.dataSource.getRegionXMLConfig().getTimePmFormats()).length) {
            for (int i = 0; i < valueNamePairArray2.length; ++i) {
                String string = valueNamePairArray2[i].toString();
                String string2 = valueNamePairArray[i].toString();
                String string3 = string + '/' + string2;
                this.ampmCombo.addItem(string3);
            }
        }
        ValueNamePair valueNamePair = this.dataSource.getUserSettingXMLConfig().getCurTimeAmFormat();
        int n = this.ampmCombo.getComponentCount();
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int j = 0; j < valueNamePairArray2.length; ++j) {
                if (!valueNamePairArray2[j].equals(valueNamePair)) continue;
                bl = true;
                break;
            }
            if (!bl || !this.ampmCombo.getItemAt(i).toString().startsWith(valueNamePair.toString())) continue;
            this.ampmCombo.setSelectedIndex(i);
            break;
        }
    }

    private void initShowDST() {
        if (this.isSupportDST()) {
            this.timeZonePanel.add(this.DSTCBox);
            if (this.dataSource.getUserSettingXMLConfig().getCurShowDST().getValue() == 0) {
                this.DSTCBox.setSelected(false);
            } else {
                this.DSTCBox.setSelected(true);
            }
        }
    }

    private void initShowZone() {
        if (this.dataSource.isSupportZone()) {
            this.timeZonePanel.add(this.timeZoneCBox);
            if (this.dataSource.getUserSettingXMLConfig().getCurShowZone().getValue() == 0) {
                this.timeZoneCBox.setSelected(false);
            } else {
                this.timeZoneCBox.setSelected(true);
            }
        }
    }

    private void setAmPmEnabled(boolean bl) {
        this.ampmCombo.setEnabled(bl);
    }

    private String getExampleStr() {
        if (null == this.ampmCombo.getSelectedItem()) {
            return "";
        }
        String string = ":";
        String string2 = this.ampmCombo.getSelectedItem().toString();
        String string3 = string2.substring(0, string2.indexOf("/"));
        String string4 = string2.substring(string2.indexOf("/") + 1);
        int n = ((ValueNamePair)this.formatCombo.getSelectedItem()).getValue();
        String string5 = TimeDateFormatUtil.getFormatTime(new GregorianCalendar(), string, string3, string4, n);
        if (this.dataSource.isSupportZone() && this.timeZoneCBox.isSelected()) {
            string5 = string5 + this.zoneOffsetString;
        }
        if (this.isSupportDST() && this.DSTCBox.isSelected()) {
            string5 = string5 + " DST";
        }
        return string5;
    }

    public void initZoneOffset() {
        this.zoneOffsetString = TimeDateFormatUtil.getZoneOffset();
    }

    private ValueNamePair getSelectedAmPair() {
        String string = this.ampmCombo.getSelectedItem().toString();
        ValueNamePair[] valueNamePairArray = this.dataSource.getRegionXMLConfig().getTimeAmFormats();
        for (int i = 0; i < valueNamePairArray.length; ++i) {
            ValueNamePair valueNamePair = valueNamePairArray[i];
            if (string.indexOf(valueNamePair.toString()) < 0) continue;
            return valueNamePair;
        }
        return null;
    }

    private ValueNamePair getSelectedPmPair() {
        String string = this.ampmCombo.getSelectedItem().toString();
        ValueNamePair[] valueNamePairArray = this.dataSource.getRegionXMLConfig().getTimePmFormats();
        for (int i = 0; i < valueNamePairArray.length; ++i) {
            ValueNamePair valueNamePair = valueNamePairArray[i];
            if (string.indexOf(valueNamePair.toString()) < 0) continue;
            return valueNamePair;
        }
        return null;
    }

    public boolean apply() {
        if (null != this.dataSource) {
            ValueNamePair valueNamePair = this.dataSource.getUserSettingXMLConfig().getCurTimeFormat();
            ValueNamePair valueNamePair2 = this.dataSource.getUserSettingXMLConfig().getCurTimeAmFormat();
            boolean bl = this.dataSource.getUserSettingXMLConfig().getCurShowDST().getValue() != 0;
            boolean bl2 = this.dataSource.getUserSettingXMLConfig().getCurShowZone().getValue() != 0;
            this.setXMLDataFromUI();
            this.dataSource.writeFile();
            if (failedFailed) {
                this.formatCombo.setSelectedItem(valueNamePair);
                int n = this.ampmCombo.getItemCount();
                for (int i = 0; i < n; ++i) {
                    String string = this.ampmCombo.getItemAt(i).toString();
                    if (string.indexOf(valueNamePair2.toString()) < 0) continue;
                    this.ampmCombo.setSelectedIndex(i);
                    break;
                }
                this.DSTCBox.setSelected(bl);
                this.timeZoneCBox.setSelected(bl2);
                this.setXMLDataFromUI();
            }
        }
        return true;
    }

    public boolean isChanged() {
        boolean bl;
        this.isChanged = false;
        ValueNamePair valueNamePair = (ValueNamePair)this.formatCombo.getSelectedItem();
        String string = this.ampmCombo.getSelectedItem().toString();
        ValueNamePair valueNamePair2 = this.dataSource.getUserSettingXMLConfig().getCurTimeFormat();
        ValueNamePair valueNamePair3 = this.dataSource.getUserSettingXMLConfig().getCurTimeAmFormat();
        if (!valueNamePair.equals(valueNamePair2) || !string.startsWith(valueNamePair3.toString())) {
            this.isChanged = true;
        }
        if (!this.isChanged && this.isSupportDST()) {
            boolean bl2 = bl = this.dataSource.getUserSettingXMLConfig().getCurShowDST().getValue() != 0;
            if (this.DSTCBox.isSelected() != bl) {
                this.isChanged = true;
            }
        }
        if (!this.isChanged && this.isSupportZone()) {
            boolean bl3 = bl = this.dataSource.getUserSettingXMLConfig().getCurShowZone().getValue() != 0;
            if (this.timeZoneCBox.isSelected() != bl) {
                this.isChanged = true;
            }
        }
        return this.isChanged;
    }

    public void resetSelectedItems() {
        if (null != this.dataSource) {
            this.formatCombo.setSelectedItem(this.dataSource.getUserSettingXMLConfig().getCurTimeFormat());
            ValueNamePair valueNamePair = this.dataSource.getUserSettingXMLConfig().getCurTimeAmFormat();
            int n = this.ampmCombo.getItemCount();
            for (int i = 0; i < n; ++i) {
                String string = this.ampmCombo.getItemAt(i).toString();
                if (string.indexOf(valueNamePair.toString()) < 0) continue;
                this.ampmCombo.setSelectedIndex(i);
                break;
            }
            this.DSTCBox.setSelected(this.dataSource.getUserSettingXMLConfig().getCurShowDST().getValue() != 0);
            this.timeZoneCBox.setSelected(this.dataSource.getUserSettingXMLConfig().getCurShowZone().getValue() != 0);
        } else {
            logger.trace("Data source is null in time settings.");
        }
    }

    private void setXMLDataFromUI() {
        this.dataSource.getUserSettingXMLConfig().setCurTimeAmFormat(this.getSelectedAmPair());
        this.dataSource.getUserSettingXMLConfig().setCurTimePmFormat(this.getSelectedPmPair());
        this.dataSource.getUserSettingXMLConfig().setCurTimeFormat((ValueNamePair)this.formatCombo.getSelectedItem());
        if (this.isSupportZone()) {
            this.dataSource.getUserSettingXMLConfig().setCurShowZone(this.timeZoneCBox.isSelected());
        }
        if (this.isSupportDST()) {
            this.dataSource.getUserSettingXMLConfig().setCurShowDST(this.DSTCBox.isSelected());
        }
    }

    public void disposeData() {
        this.formatCombo.removeItemListener(this.formatItemListener);
        this.ampmCombo.removeItemListener(this.itemListener);
        this.DSTCBox.removeItemListener(this.itemListener);
        this.timeZoneCBox.removeItemListener(this.itemListener);
        this.isExitThread = true;
        this.formatCombo.removeAllItems();
        this.ampmCombo.removeAllItems();
    }

    public void startRefreshThread() {
        if (this.isFirstTimeShowing) {
            this.refreshThread = new RefreshExampleDataThread();
            this.isExitThread = false;
            this.refreshThread.start();
            this.isFirstTimeShowing = false;
        }
    }

    public void cleanupWhileOSGIExit() {
        this.disposeData();
        this.formatItemListener = null;
        this.itemListener = null;
        this.formatCombo = null;
        this.ampmCombo = null;
    }

    private class RefreshExampleDataThread
    extends Thread {
        private RefreshExampleDataThread() {
        }

        @Override
        public void run() {
            while (!TimeSetting.this.isExitThread) {
                try {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (!TimeSetting.this.isExitThread) {
                                TimeSetting.this.txtTimeShowExample.setText(TimeSetting.this.getExampleStr());
                            }
                        }
                    });
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("refresh example data threadstopped because exception");
                }
            }
        }
    }
}

