/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig.ui;

import com.swimap.iview.framework.regionconfig.datasource.DataSource;
import com.swimap.iview.framework.regionconfig.ui.TimeSetting;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.format.TimeDateFormatUtil;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.helpmanagement.HelpManager;
import com.swimap.iview.util.log.IviewLogger;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.GregorianCalendar;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class DateSetting
extends JPanel {
    private static IviewLogger logger = IviewLogger.getLogger(DateSetting.class, "IVIEW");
    private static ResourceBundle res = TimeSetting.res;
    private JComboBox formatCombo = new JComboBox();
    private JComboBox separatorCombo = new JComboBox();
    private JTextField dateExampleTextField = new JTextField();
    private static String curDate;
    private Thread refreshThread = null;
    private boolean isExitThread = false;
    private final int REFRESH_INTERVAL = 1000;
    private DataSource dataSource = null;
    private ItemListener itemListener = null;
    boolean isFirstTimeShowing = true;
    private static final Dimension CONFIG_PANEL_SIZE;
    private static final Dimension COMPONENT_SIZE;
    private static final Dimension LABEL_SIZE;
    private static final Dimension PANEL_MIN_SIZE;
    private static final Dimension PANEL_PEREFER_SIZE;
    private static final Dimension PANEL_MAX_SIZE;
    private final Dimension HGAP12 = new Dimension(12, 1);
    private final Dimension HGAP13 = new Dimension(13, 1);
    private final Dimension VGAP8 = new Dimension(1, 8);

    public DateSetting() {
        this.jbInit();
    }

    private void jbInit() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JLabel jLabel = new JLabel();
        JLabel jLabel2 = new JLabel();
        JLabel jLabel3 = new JLabel();
        jLabel.setMinimumSize(LABEL_SIZE);
        jLabel.setPreferredSize(LABEL_SIZE);
        jLabel2.setMinimumSize(LABEL_SIZE);
        jLabel2.setPreferredSize(LABEL_SIZE);
        jLabel3.setMinimumSize(LABEL_SIZE);
        jLabel3.setPreferredSize(LABEL_SIZE);
        this.formatCombo.setPreferredSize(COMPONENT_SIZE);
        this.formatCombo.setName("DateSetting_formatCombo");
        this.separatorCombo.setPreferredSize(COMPONENT_SIZE);
        this.separatorCombo.setName("DateSetting_separatorCombo");
        this.dateExampleTextField.setPreferredSize(COMPONENT_SIZE);
        this.dateExampleTextField.setName("DateSetting_dateExampleTextField");
        Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
        this.setBorder(border);
        this.setLayout(new BorderLayout(0, 2));
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        jLabel.setText(res.getString("DateShowExample"));
        this.dateExampleTextField.setEnabled(true);
        this.dateExampleTextField.setEditable(false);
        jLabel2.setText(res.getString("DateSeparator"));
        jLabel3.setText(res.getString("DateFormat"));
        jPanel2.setMinimumSize(PANEL_MIN_SIZE);
        jPanel2.setPreferredSize(PANEL_PEREFER_SIZE);
        jPanel2.setMaximumSize(PANEL_MAX_SIZE);
        jPanel3.setMinimumSize(PANEL_MIN_SIZE);
        jPanel3.setPreferredSize(PANEL_PEREFER_SIZE);
        jPanel3.setMaximumSize(PANEL_MAX_SIZE);
        jPanel4.setMinimumSize(PANEL_MIN_SIZE);
        jPanel4.setPreferredSize(PANEL_PEREFER_SIZE);
        jPanel4.setMaximumSize(PANEL_MAX_SIZE);
        jPanel.setMinimumSize(CONFIG_PANEL_SIZE);
        jPanel.setPreferredSize(CONFIG_PANEL_SIZE);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)jPanel, "North");
        this.add((Component)jPanel5, "Center");
        jPanel2.add(Box.createRigidArea(this.HGAP13));
        jPanel2.add(jLabel);
        jPanel2.add(this.dateExampleTextField);
        jPanel2.add(Box.createRigidArea(this.HGAP12));
        jPanel3.add(Box.createRigidArea(this.HGAP13));
        jPanel3.add(jLabel2);
        jPanel3.add(this.separatorCombo);
        jPanel3.add(Box.createRigidArea(this.HGAP12));
        jPanel4.add(Box.createRigidArea(this.HGAP13));
        jPanel4.add(jLabel3);
        jPanel4.add(this.formatCombo);
        jPanel4.add(Box.createRigidArea(this.HGAP12));
        jPanel.add(jPanel3);
        jPanel.add(Box.createRigidArea(this.VGAP8));
        jPanel.add(jPanel4);
        jPanel.add(Box.createRigidArea(this.VGAP8));
        jPanel.add(jPanel2);
        jPanel.add(Box.createRigidArea(this.VGAP8));
        this.putClientProperty("HELP_ID_PROPERTY", "iVIEW.systemsetting.date");
        HelpManager.getInstance().enableHelpKey(this, "iVIEW.systemsetting.date");
    }

    private String getExampleStr() {
        String string = ((ValueNamePair)this.separatorCombo.getSelectedItem()).toString();
        int n = ((ValueNamePair)this.formatCombo.getSelectedItem()).getValue();
        return TimeDateFormatUtil.getFormatDate(new GregorianCalendar(), string, n);
    }

    private void initCombo(ValueNamePair[] valueNamePairArray, ValueNamePair valueNamePair, JComboBox jComboBox) {
        for (int i = 0; i < valueNamePairArray.length; ++i) {
            jComboBox.addItem(valueNamePairArray[i]);
        }
        jComboBox.setSelectedItem(valueNamePair);
    }

    public boolean isChanged() {
        ValueNamePair valueNamePair = (ValueNamePair)this.formatCombo.getSelectedItem();
        ValueNamePair valueNamePair2 = (ValueNamePair)this.separatorCombo.getSelectedItem();
        ValueNamePair valueNamePair3 = this.dataSource.getUserSettingXMLConfig().getCurDateShowFormat();
        ValueNamePair valueNamePair4 = this.dataSource.getUserSettingXMLConfig().getCurDateSeparateSymbol();
        return !valueNamePair.equals(valueNamePair3) || !valueNamePair2.equals(valueNamePair4);
    }

    public void initData() {
        this.dataSource = DataSource.getInstance();
        this.initSeperaterCombo();
        this.dataSource.getUserSettingXMLConfig().setDateSeparator(((ValueNamePair)this.separatorCombo.getSelectedItem()).toString());
        this.initFormatCombo();
        this.setXMLDataFromUI();
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                DateSetting.this.notifyChanged();
            }
        };
        this.formatCombo.addItemListener(this.itemListener);
        this.separatorCombo.addItemListener(this.itemListener);
        curDate = this.getExampleStr();
        this.dateExampleTextField.setText(curDate);
        this.isFirstTimeShowing = true;
    }

    private void initFormatCombo() {
        if (this.formatCombo.getItemCount() != 0) {
            this.formatCombo.removeAllItems();
        }
        this.initCombo(this.dataSource.getRegionXMLConfig().getDateShowFormats(), this.dataSource.getUserSettingXMLConfig().getCurDateShowFormat(), this.formatCombo);
    }

    private void initSeperaterCombo() {
        if (this.separatorCombo.getItemCount() != 0) {
            this.separatorCombo.removeAllItems();
        }
        this.initCombo(this.dataSource.getRegionXMLConfig().getDateSeparateSymbols(), this.dataSource.getUserSettingXMLConfig().getCurDateSeparateSymbol(), this.separatorCombo);
        this.dataSource.getUserSettingXMLConfig().setDateSeparator(((ValueNamePair)this.separatorCombo.getSelectedItem()).toString());
    }

    private void refreshExampleShow() {
        this.dateExampleTextField.setText(this.getExampleStr());
        this.dataSource.getUserSettingXMLConfig().setDateSeparator(((ValueNamePair)this.separatorCombo.getSelectedItem()).toString());
        this.formatCombo.revalidate();
    }

    private void notifyChanged() {
        this.refreshExampleShow();
        FrameworkUtilities.getSystemSettingsManager().clientSettingChanged("RegionDateSetting", true);
    }

    public void resetSelectedItems() {
        if (null != this.dataSource) {
            this.formatCombo.setSelectedItem(this.dataSource.getUserSettingXMLConfig().getCurDateShowFormat());
            this.separatorCombo.setSelectedItem(this.dataSource.getUserSettingXMLConfig().getCurDateSeparateSymbol());
        } else {
            logger.trace("Data source is null in date settings.");
        }
    }

    public boolean apply() {
        if (null != this.dataSource) {
            ValueNamePair valueNamePair = this.dataSource.getUserSettingXMLConfig().getCurDateShowFormat();
            ValueNamePair valueNamePair2 = this.dataSource.getUserSettingXMLConfig().getCurDateSeparateSymbol();
            this.setXMLDataFromUI();
            this.dataSource.writeFile();
            if (TimeSetting.failedFailed) {
                this.separatorCombo.setSelectedItem(valueNamePair2);
                this.formatCombo.setSelectedItem(valueNamePair);
                this.formatCombo.setEnabled(true);
                this.setXMLDataFromUI();
            }
        }
        return true;
    }

    private void setXMLDataFromUI() {
        this.dataSource.getUserSettingXMLConfig().setCurDateSeparateSymbol((ValueNamePair)this.separatorCombo.getSelectedItem());
        this.dataSource.getUserSettingXMLConfig().setCurDateShowFormat((ValueNamePair)this.formatCombo.getSelectedItem());
    }

    public void disposeData() {
        this.formatCombo.removeItemListener(this.itemListener);
        this.separatorCombo.removeItemListener(this.itemListener);
        this.isExitThread = true;
        this.formatCombo.removeAllItems();
        this.separatorCombo.removeAllItems();
    }

    public void startRefreshThread() {
        if (this.isFirstTimeShowing) {
            this.refreshThread = new RefreshExampleDataThread();
            this.isExitThread = false;
            this.refreshThread.start();
            this.isFirstTimeShowing = false;
        }
    }

    public void cleanupWhileOSGIExit() {
        this.formatCombo.removeItemListener(this.itemListener);
        this.separatorCombo.removeItemListener(this.itemListener);
        this.itemListener = null;
        this.isExitThread = true;
        this.formatCombo.removeAllItems();
        if (null != this.dataSource) {
            this.dataSource.cleanupWhileOSGIExit();
            this.dataSource = null;
        }
        this.separatorCombo.removeAllItems();
        this.separatorCombo = null;
        this.formatCombo = null;
        this.removeAll();
    }

    static {
        CONFIG_PANEL_SIZE = new Dimension(435, 95);
        COMPONENT_SIZE = new Dimension(285, 21);
        LABEL_SIZE = new Dimension(140, 21);
        PANEL_MIN_SIZE = new Dimension(50, 21);
        PANEL_PEREFER_SIZE = new Dimension(435, 21);
        PANEL_MAX_SIZE = new Dimension(3000, 21);
    }

    private class RefreshExampleDataThread
    extends Thread {
        private RefreshExampleDataThread() {
        }

        @Override
        public void run() {
            while (!DateSetting.this.isExitThread) {
                try {
                    if (!curDate.equals(DateSetting.this.getExampleStr())) {
                        curDate = DateSetting.this.getExampleStr();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                DateSetting.this.dateExampleTextField.setText(DateSetting.this.getExampleStr());
                            }
                        });
                    }
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    logger.error("refresh example data threadstopped because exception");
                }
            }
        }
    }
}

