/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig.datasource;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.commstyle.commini.xmlbind.PARAS;
import com.swimap.iview.commstyle.commini.xmlimpl.write.XmlUtil;
import com.swimap.iview.util.format.ValueNamePair;
import com.swimap.iview.util.log.IviewLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;

public class XMLConfig {
    private static IviewLogger logger = IviewLogger.getLogger(XMLConfig.class, "IVIEW");
    public static final int INVALIDVALUE = -255;
    private PARA curDateSeparateSymbol = null;
    private PARA curDateShowFormat = null;
    private PARA curShowZone = null;
    private PARA curShowDST = null;
    private PARA curTimeFormat = null;
    private PARA curTimeAmFormat = null;
    private PARA curTimePmFormat = null;
    private ArrayList dateSeparateSymbolList = null;
    private ArrayList dateShowFormatList = null;
    private ArrayList timeFormatList = null;
    private ArrayList timeAmFormatList = null;
    private ArrayList timePmFormatList = null;
    private ArrayList zoneDSTList = null;
    private CommStyleInfo info = null;
    private static final String TIMESETTING = "TimeSetting";
    private static final String TIMEFORMAT = "TimeFormat";
    private static final String TIMEAMFORMAT = "AmFormat";
    private static final String TIMEPMFORMAT = "PmFormat";
    private static final String DATESETTING = "DateSetting";
    private static final String DATESEPARATESYMBOL = "DateSeparateSymbol";
    private static final String DATESHOWFORMAT = "DateShowFormat";
    private static final String ZONEDSTSETTING = "ZoneDSTSetting";
    private static final String SHOWDST = "ShowDST";
    private static final String SHOWZONE = "ShowZone";
    private static final String REGIONCONGISETTING = "RegionConfigSetting";
    private static final String SUPPORTZONEDST = "SupportZoneDST";
    private static final String SUPPORTDST = "SupportDST";
    private static final String SUPPORTZONE = "SupportZone";
    private static final String REGIONDATAACCESS = "RegionDataAccess";
    private static final String CLASS = "Class";
    private boolean isRegionData = true;
    private boolean isSupportZone = false;
    private boolean isSupportDST = false;
    private String regionDataAccessImpl = null;
    private String xmlFileName = "conf/mainfrm/regionusersetting";
    private static String dateSeparator = "-";

    public XMLConfig(CommStyleInfo commStyleInfo, boolean bl) {
        this.isRegionData = bl;
        XmlUtil.setEncoding("UTF-8");
        this.info = commStyleInfo;
        if (commStyleInfo != null) {
            this.xmlFileName = commStyleInfo.getFileName();
        }
        try {
            this.read(commStyleInfo);
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
        }
    }

    private void read(CommStyleInfo commStyleInfo) {
        AreaDescContainer areaDescContainer;
        AreaDescContainer[] areaDescContainerArray;
        block7: {
            Locale locale;
            block6: {
                if (commStyleInfo == null) {
                    this.createDefaultCommInfo();
                    return;
                }
                areaDescContainerArray = commStyleInfo.getAreaDescContainer();
                areaDescContainer = new AreaDescContainer();
                locale = Locale.getDefault();
                if (areaDescContainerArray.length != 1) break block6;
                areaDescContainer = areaDescContainerArray[0];
                if (locale.getLanguage().equals(areaDescContainer.getAreaName().substring(0, 2))) break block7;
                areaDescContainer.setAreaName(locale.getLanguage() + '_' + locale.getCountry());
                break block7;
            }
            for (int i = 0; i < areaDescContainerArray.length; ++i) {
                if (!locale.toString().equals(areaDescContainerArray[i].getAreaName())) continue;
                areaDescContainer = areaDescContainerArray[i];
                break;
            }
        }
        if (areaDescContainer.isNoDescContainer()) {
            areaDescContainer = areaDescContainerArray[0];
            areaDescContainer.setAreaName("en_US");
        }
        DescContainer[] descContainerArray = areaDescContainer.getDescContainer();
        for (int i = 0; i < descContainerArray.length; ++i) {
            if (TIMESETTING.equals(descContainerArray[i].getDescName())) {
                this.readTimeSetting(descContainerArray[i]);
                continue;
            }
            if (DATESETTING.equals(descContainerArray[i].getDescName())) {
                this.readDateSetting(descContainerArray[i]);
                continue;
            }
            if (!ZONEDSTSETTING.equals(descContainerArray[i].getDescName())) continue;
            this.readZoneDSTSetting(descContainerArray[i]);
        }
    }

    void readRegionConfigSetting(CommStyleInfo commStyleInfo) {
        if (commStyleInfo == null) {
            throw new IllegalArgumentException("CommStyleInfo cannot be null.");
        }
        AreaDescContainer[] areaDescContainerArray = commStyleInfo.getAreaDescContainer();
        for (int i = 0; i < areaDescContainerArray.length; ++i) {
            if (!REGIONCONGISETTING.equals(areaDescContainerArray[i].getAreaName())) continue;
            DescContainer descContainer = areaDescContainerArray[i].getDescContainer(SUPPORTZONEDST);
            this.isSupportDST = "true".equals(descContainer.getParasItemValue(SUPPORTDST));
            this.isSupportZone = "true".equals(descContainer.getParasItemValue(SUPPORTZONE));
            DescContainer descContainer2 = areaDescContainerArray[i].getDescContainer(REGIONDATAACCESS);
            this.regionDataAccessImpl = descContainer2.getParasItemValue(CLASS);
        }
    }

    CommStyleInfo getLatestXMLData() {
        if (!this.isRegionData) {
            DescContainer[] descContainerArray = this.info.getAreaDescContainer()[0].getDescContainer();
            for (int i = 0; i < descContainerArray.length; ++i) {
                DescContainer descContainer = descContainerArray[i];
                if (TIMESETTING.equals(descContainer.getDescName())) {
                    descContainer.setParasItem(this.curTimeFormat.getName(), this.curTimeFormat.getValue());
                    descContainer.setParasItem(this.curTimeAmFormat.getName(), this.curTimeAmFormat.getValue());
                    descContainer.setParasItem(this.curTimePmFormat.getName(), this.curTimePmFormat.getValue());
                    continue;
                }
                if (DATESETTING.equals(descContainer.getDescName())) {
                    descContainer.setParasItem(this.curDateSeparateSymbol.getName(), this.curDateSeparateSymbol.getValue());
                    descContainer.setParasItem(this.curDateShowFormat.getName(), this.curDateShowFormat.getValue());
                    continue;
                }
                if (!ZONEDSTSETTING.equals(descContainer.getDescName())) continue;
                descContainer.setParasItem(this.curShowZone.getName(), this.curShowZone.getValue());
                descContainer.setParasItem(this.curShowDST.getName(), this.curShowDST.getValue());
            }
            return this.info;
        }
        return null;
    }

    private void createDefaultCommInfo() {
        this.info = new CommStyleInfo();
        this.info.setFileName("style/defaultstyle/" + this.xmlFileName + ".xml");
        this.info.addAreaDescContainer(this.createNewAreaDescContainer());
    }

    private AreaDescContainer createNewAreaDescContainer() {
        AreaDescContainer areaDescContainer = new AreaDescContainer();
        areaDescContainer.setAreaName("en_US");
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(TIMESETTING);
        DescContainer descContainer2 = this.createNewDescContainer(TIMEFORMAT);
        descContainer.addDescContainer(descContainer2);
        this.timeFormatList = descContainer2.getPARAS().getPARAArrayList();
        this.curTimeFormat = (PARA)this.timeFormatList.get(0);
        descContainer2 = this.createNewDescContainer(TIMEAMFORMAT);
        descContainer.addDescContainer(descContainer2);
        this.timeAmFormatList = descContainer2.getPARAS().getPARAArrayList();
        this.curTimeAmFormat = (PARA)this.timeAmFormatList.get(0);
        descContainer2 = this.createNewDescContainer(TIMEPMFORMAT);
        descContainer.addDescContainer(descContainer2);
        this.timePmFormatList = descContainer2.getPARAS().getPARAArrayList();
        this.curTimePmFormat = (PARA)this.timePmFormatList.get(0);
        areaDescContainer.addDescContainer(descContainer);
        descContainer = new DescContainer();
        descContainer.setDescName(DATESETTING);
        descContainer2 = this.createNewDescContainer(DATESEPARATESYMBOL);
        descContainer.addDescContainer(descContainer2);
        this.dateSeparateSymbolList = descContainer2.getPARAS().getPARAArrayList();
        this.curDateSeparateSymbol = (PARA)this.dateSeparateSymbolList.get(0);
        descContainer2 = this.createNewDescContainer(DATESHOWFORMAT);
        descContainer.addDescContainer(descContainer2);
        this.dateShowFormatList = descContainer2.getPARAS().getPARAArrayList();
        this.curDateShowFormat = (PARA)this.dateShowFormatList.get(0);
        areaDescContainer.addDescContainer(descContainer);
        descContainer = new DescContainer();
        descContainer.setDescName(ZONEDSTSETTING);
        descContainer.setPARAS(this.createPARAS());
        descContainer.getPARAS().addPARA(this.createPARA());
        this.zoneDSTList = descContainer.getPARAS().getPARAArrayList();
        this.curShowZone = (PARA)this.zoneDSTList.get(0);
        this.curShowDST = (PARA)this.zoneDSTList.get(1);
        areaDescContainer.addDescContainer(descContainer);
        return areaDescContainer;
    }

    private DescContainer createNewDescContainer(String string) {
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(string);
        descContainer.setPARAS(this.createPARAS());
        return descContainer;
    }

    private PARAS createPARAS() {
        PARAS pARAS = new PARAS();
        pARAS.addPARA(this.createPARA());
        return pARAS;
    }

    private PARA createPARA() {
        PARA pARA = new PARA();
        pARA.setName("");
        pARA.setValue(String.valueOf(-255));
        return pARA;
    }

    private void readTimeSetting(DescContainer descContainer) {
        DescContainer[] descContainerArray = descContainer.getDescContainer();
        for (int i = 0; i < descContainerArray.length; ++i) {
            if (TIMEFORMAT.equals(descContainerArray[i].getDescName())) {
                this.timeFormatList = descContainerArray[i].getPARAS().getPARAArrayList();
                this.curTimeFormat = (PARA)this.timeFormatList.get(0);
                continue;
            }
            if (TIMEAMFORMAT.equals(descContainerArray[i].getDescName())) {
                this.timeAmFormatList = descContainerArray[i].getPARAS().getPARAArrayList();
                this.curTimeAmFormat = (PARA)this.timeAmFormatList.get(0);
                continue;
            }
            if (!TIMEPMFORMAT.equals(descContainerArray[i].getDescName())) continue;
            this.timePmFormatList = descContainerArray[i].getPARAS().getPARAArrayList();
            this.curTimePmFormat = (PARA)this.timePmFormatList.get(0);
        }
    }

    private void readDateSetting(DescContainer descContainer) {
        DescContainer[] descContainerArray = descContainer.getDescContainer();
        for (int i = 0; i < descContainerArray.length; ++i) {
            if (DATESEPARATESYMBOL.equals(descContainerArray[i].getDescName())) {
                this.dateSeparateSymbolList = descContainerArray[i].getPARAS().getPARAArrayList();
                this.curDateSeparateSymbol = (PARA)this.dateSeparateSymbolList.get(0);
                continue;
            }
            if (!DATESHOWFORMAT.equals(descContainerArray[i].getDescName())) continue;
            this.dateShowFormatList = descContainerArray[i].getPARAS().getPARAArrayList();
            this.curDateShowFormat = (PARA)this.dateShowFormatList.get(0);
        }
    }

    private void readZoneDSTSetting(DescContainer descContainer) {
        PARA[] pARAArray = descContainer.getPARAS().getPARA();
        for (int i = 0; i < pARAArray.length; ++i) {
            if (SHOWZONE.equals(pARAArray[i].getName())) {
                this.curShowZone = pARAArray[i];
                continue;
            }
            if (!SHOWDST.equals(pARAArray[i].getName())) continue;
            this.curShowDST = pARAArray[i];
        }
    }

    private ValueNamePair[] getAll(Collection collection) {
        ValueNamePair[] valueNamePairArray = new ValueNamePairExt[collection.size()];
        int n = 0;
        for (PARA pARA : collection) {
            int n2 = Integer.valueOf(pARA.getValue());
            valueNamePairArray[n++] = new ValueNamePairExt(n2, pARA.getName());
        }
        return valueNamePairArray;
    }

    public ValueNamePair[] getDateSeparateSymbols() {
        return this.getAll(this.dateSeparateSymbolList);
    }

    public ValueNamePair[] getDateShowFormats() {
        return this.getAll(this.dateShowFormatList);
    }

    public ValueNamePair[] getTimeAmFormats() {
        return this.getAll(this.timeAmFormatList);
    }

    public ValueNamePair[] getTimeFormats() {
        return this.getAll(this.timeFormatList);
    }

    public ValueNamePair[] getTimePmFormats() {
        return this.getAll(this.timePmFormatList);
    }

    String getRegionDataAccessImpl() {
        return this.regionDataAccessImpl;
    }

    private ValueNamePair getValueNamePairWithPARA(PARA pARA) {
        try {
            int n = Integer.valueOf(pARA.getValue());
            return new ValueNamePairExt(n, pARA.getName());
        }
        catch (Exception exception) {
            return new ValueNamePairExt(-255, "");
        }
    }

    private void setValueNamePairToPARA(PARA pARA, ValueNamePair valueNamePair) {
        pARA.setName(valueNamePair.getName());
        pARA.setValue(String.valueOf(valueNamePair.getValue()));
    }

    public ValueNamePair getCurDateSeparateSymbol() {
        return this.getValueNamePairWithPARA(this.curDateSeparateSymbol);
    }

    public ValueNamePair getCurDateShowFormat() {
        return this.getValueNamePairWithPARA(this.curDateShowFormat);
    }

    public ValueNamePair getCurTimeAmFormat() {
        return this.getValueNamePairWithPARA(this.curTimeAmFormat);
    }

    public ValueNamePair getCurTimePmFormat() {
        return this.getValueNamePairWithPARA(this.curTimePmFormat);
    }

    public ValueNamePair getCurTimeFormat() {
        return this.getValueNamePairWithPARA(this.curTimeFormat);
    }

    public ValueNamePair getCurShowZone() {
        return this.getValueNamePairWithPARA(this.curShowZone);
    }

    public ValueNamePair getCurShowDST() {
        return this.getValueNamePairWithPARA(this.curShowDST);
    }

    public void setCurTimePmFormat(ValueNamePair valueNamePair) {
        this.setValueNamePairToPARA(this.curTimePmFormat, valueNamePair);
    }

    public void setCurTimeFormat(ValueNamePair valueNamePair) {
        this.setValueNamePairToPARA(this.curTimeFormat, valueNamePair);
    }

    public void setCurTimeAmFormat(ValueNamePair valueNamePair) {
        this.setValueNamePairToPARA(this.curTimeAmFormat, valueNamePair);
    }

    public void setCurDateShowFormat(ValueNamePair valueNamePair) {
        this.setValueNamePairToPARA(this.curDateShowFormat, valueNamePair);
    }

    public void setCurDateSeparateSymbol(ValueNamePair valueNamePair) {
        this.setValueNamePairToPARA(this.curDateSeparateSymbol, valueNamePair);
    }

    public void setCurShowZone(boolean bl) {
        ValueNamePair valueNamePair = new ValueNamePair(bl ? 1 : 0, SHOWZONE);
        this.setValueNamePairToPARA(this.curShowZone, valueNamePair);
    }

    public void setCurShowDST(boolean bl) {
        ValueNamePair valueNamePair = new ValueNamePair(bl ? 1 : 0, SHOWDST);
        this.setValueNamePairToPARA(this.curShowDST, valueNamePair);
    }

    public static boolean isValid(ValueNamePair valueNamePair) {
        boolean bl = false;
        if (valueNamePair != null && valueNamePair.getName() != null && valueNamePair.getValue() != -255) {
            bl = true;
        }
        return bl;
    }

    public String getDateSeparator() {
        return dateSeparator;
    }

    public void setDateSeparator(String string) {
        dateSeparator = string;
    }

    boolean isSupportZone() {
        return this.isSupportZone;
    }

    boolean isSupportDST() {
        return this.isSupportDST;
    }

    public void cleanupWhileOSGIExit() {
        if (null != this.info) {
            this.info.removeAreaDescContainer();
            this.info = null;
        }
    }

    private class ValueNamePairExt
    extends ValueNamePair {
        public ValueNamePairExt(int n, String string) {
            super(n, string);
        }

        @Override
        public String toString() {
            String string = super.toString();
            if (string.indexOf("$") != -1) {
                string = string.replaceAll("[$]", dateSeparator);
            }
            return string;
        }
    }
}

