/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig.datasource;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.framework.regionconfig.datasource.DefaultImpl;
import com.swimap.iview.framework.regionconfig.datasource.IRegionDataAccess;
import com.swimap.iview.framework.regionconfig.datasource.XMLConfig;
import com.swimap.iview.util.log.IviewLogger;

public final class DataSource {
    private static IviewLogger logger = IviewLogger.getLogger(DataSource.class, "IVIEW");
    private IRegionDataAccess dataAccess = null;
    private static XMLConfig regionXMLConfig = null;
    private static XMLConfig userSettingXMLConfig = null;
    public static final String REGION_XML_FILENAME = "conf/mainfrm/regionconfig";
    public static final String REGION_CONFIG_SETTING_FILENAME = "conf/mainfrm/regionconfigsetting";
    private static DataSource instance;

    private DataSource() {
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getCommonStyleFile(REGION_XML_FILENAME);
        regionXMLConfig = new XMLConfig(commStyleInfo, true);
        CommStyleInfo commStyleInfo2 = CommStyleManager.getInstance().getCommonStyleFile(REGION_CONFIG_SETTING_FILENAME);
        regionXMLConfig.readRegionConfigSetting(commStyleInfo2);
        this.initRegionDataAccess();
        this.loadUserData();
    }

    public void loadUserData() {
        CommStyleInfo commStyleInfo = this.dataAccess.read();
        userSettingXMLConfig = new XMLConfig(commStyleInfo, false);
    }

    private void initRegionDataAccess() {
        String string = regionXMLConfig.getRegionDataAccessImpl();
        try {
            Class<?> clazz = Class.forName(string);
            Object obj = clazz.newInstance();
            this.dataAccess = (IRegionDataAccess)obj;
        }
        catch (Exception exception) {
            logger.trace(exception.getMessage(), exception);
            this.dataAccess = new DefaultImpl();
        }
    }

    public void writeFile() {
        CommStyleInfo commStyleInfo = this.getUserSettingXMLConfig().getLatestXMLData();
        this.dataAccess.write(commStyleInfo);
    }

    public XMLConfig getRegionXMLConfig() {
        return regionXMLConfig;
    }

    public XMLConfig getUserSettingXMLConfig() {
        return userSettingXMLConfig;
    }

    public boolean isSupportZone() {
        return regionXMLConfig.isSupportZone();
    }

    public boolean isSupportDST() {
        return regionXMLConfig.isSupportDST();
    }

    public static synchronized DataSource getInstance() {
        if (instance == null) {
            instance = new DataSource();
        }
        return instance;
    }

    public static synchronized void disposeInstance() {
        instance = null;
    }

    public void cleanupWhileOSGIExit() {
        if (null != regionXMLConfig) {
            regionXMLConfig.cleanupWhileOSGIExit();
            regionXMLConfig = null;
        }
        if (null != userSettingXMLConfig) {
            userSettingXMLConfig.cleanupWhileOSGIExit();
            userSettingXMLConfig = null;
        }
        instance = null;
    }
}

