/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.regionconfig;

import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.modulemanagement.ModuleManager;
import com.swimap.iview.framework.regionconfig.RegionDateSetting;
import com.swimap.iview.framework.regionconfig.ui.TimeSetting;
import com.swimap.iview.framework.regionconfig.util.TimeDateFormat;
import com.swimap.iview.framework.systemsettingsmanagement.BaseClientSettings;
import com.swimap.iview.framework.systemsettingsmanagement.SystemSettingsManager;
import com.swimap.iview.framework.util.FrameworkUtilities;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.omg.CORBA.ORB;

public class RegionTimeSetting
extends BaseClientSettings {
    private static ResourceBundle res = RegionDateSetting.res;
    public static final String REGION_TIME_SETTING_NAME = "RegionTimeSetting";
    private TimeSetting timeSettingPanel = null;

    public RegionTimeSetting(ModuleManager moduleManager, ORB oRB, String string, String string2) throws ModuleManagementException {
        super(moduleManager, oRB, string, string2);
    }

    public RegionTimeSetting(ModuleManager moduleManager) throws ModuleManagementException {
        super(moduleManager);
    }

    @Override
    public void reinitialize() {
        this.timeSettingPanel.initData();
        TimeDateFormat.timeSettingInit();
    }

    @Override
    public boolean apply() {
        if (!this.timeSettingPanel.isChanged()) {
            return true;
        }
        TimeSetting.failedFailed = false;
        this.timeSettingPanel.apply();
        SystemSettingsManager systemSettingsManager = FrameworkUtilities.getSystemSettingsManager();
        if (TimeSetting.failedFailed) {
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), false, res.getString("Fail_msg"));
        } else {
            systemSettingsManager.setSystemSettingStatus(this.getTabLabel(), true, systemSettingsManager.getReloginMessage());
        }
        return true;
    }

    @Override
    public boolean exit() {
        this.timeSettingPanel.resetSelectedItems();
        return true;
    }

    @Override
    public void clear() {
        this.timeSettingPanel.disposeData();
    }

    @Override
    public JPanel getSettingsPanel() {
        if (this.timeSettingPanel == null) {
            this.timeSettingPanel = new TimeSetting();
        }
        return this.timeSettingPanel;
    }

    @Override
    public boolean isChanged() {
        return this.timeSettingPanel.isChanged();
    }

    @Override
    public String getTabLabel() {
        return res.getString("Time");
    }

    @Override
    public Icon getTabIcon() {
        return null;
    }

    @Override
    public String getModuleName() {
        return REGION_TIME_SETTING_NAME;
    }

    public boolean isSupportDST() {
        return this.timeSettingPanel.isSupportDST();
    }

    public boolean isSupportZone() {
        return this.timeSettingPanel.isSupportZone();
    }

    @Override
    public int getTitleDescription() {
        return 1;
    }

    @Override
    public String getSettingDescription() {
        return res.getString("Region_timeSetting_Descr");
    }

    @Override
    public void stop() {
        super.stop();
    }
}

