/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.i18n.ResourceUtil;
import com.swimap.iview.commstyle.resource.i18n.UnicodeInputStream;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class ResourceHandler {
    private static IviewLogger logger = IviewLogger.getLogger(ResourceHandler.class, "IVIEW");
    private URL resPath = null;
    private static final String PROPERTY_SUFFIX = ".properties";
    private static final String XML_SUFFIX = ".xml";
    protected String defaultPluginName = "";

    public ResourceHandler(URL uRL) {
        this.resPath = uRL;
    }

    public CommStyleInfo getCommStyleInfo(String string) {
        String string2 = string;
        if (!string2.endsWith(XML_SUFFIX)) {
            string2 = string2 + XML_SUFFIX;
        }
        URL uRL = this.getEntry(string2);
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(uRL);
        if (null != commStyleInfo) {
            commStyleInfo.setFileName(uRL.getFile());
        }
        return commStyleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getProperties(String string) {
        URLConnection uRLConnection = null;
        String string2 = string;
        if (!string2.endsWith(PROPERTY_SUFFIX)) {
            string2 = string2 + PROPERTY_SUFFIX;
        }
        Properties properties = new Properties();
        InputStream inputStream = null;
        try {
            URL uRL = this.getEntryURL(string2);
            if (null != uRL) {
                if (CommonUtil.IS_MENUTOOL) {
                    uRLConnection = uRL.openConnection();
                    uRLConnection.setUseCaches(false);
                    inputStream = uRLConnection.getInputStream();
                } else {
                    inputStream = uRL.openStream();
                }
                UnicodeInputStream unicodeInputStream = new UnicodeInputStream(inputStream, null);
                String string3 = unicodeInputStream.getEncoding();
                InputStreamReader inputStreamReader = null;
                inputStreamReader = null == string3 ? new InputStreamReader((InputStream)unicodeInputStream, ResourceUtil.CLIENT_ENCODING) : new InputStreamReader((InputStream)unicodeInputStream, string3);
                properties.load(inputStreamReader);
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
        finally {
            FrameworkUtilities.close(inputStream);
        }
        return properties;
    }

    public Icon getIcon(String string) {
        URL uRL = this.getEntryURL(string);
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public URL getEntry(String string) {
        URL uRL = null;
        String string2 = this.resPath + string;
        if (null != string && string.trim().length() > 0) {
            URL uRL2;
            try {
                uRL = new URL(this.resPath + string);
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
            if ((string2.contains(".jar") || !FrameworkUtilities.exist(uRL)) && null != (uRL2 = PluginSubsystemUtilities.getURLFromJar(this.resPath.getFile(), string))) {
                return uRL2;
            }
        }
        return uRL;
    }

    public URL getResourceDir() {
        return this.resPath;
    }

    public Icon getIconFromUrl(URL uRL) {
        if (null != uRL) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public URL getIconPath(String string) {
        return this.getEntryURL(string);
    }

    private URL getEntryURL(String string) {
        URL uRL;
        block7: {
            uRL = null;
            try {
                if (null == string || string.trim().length() <= 0) break block7;
                try {
                    File file = new File(this.resPath.toURI().getPath() + string);
                    if (file.exists()) {
                        return file.toURI().toURL();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.trace(uRISyntaxException);
                }
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
        }
        if (PluginUtil.PGN_JAR) {
            uRL = this.getEntry(string);
            if (FrameworkUtilities.exist(uRL)) {
                return uRL;
            }
            return null;
        }
        return uRL;
    }
}

