/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultCommStyleParser;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultResourceReader;
import com.swimap.iview.framework.pluginmanagement.spi.IntegrateCommStyleReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProductHandlerManager {
    private static final String PRODUCT_STYLE_DIR = "style/productstyle/";
    private static final String FILESEPERATOR = System.getProperty("file.separator");
    List<String> pluginNames = new ArrayList<String>();
    static ProductHandlerManager instance = null;
    private Map<String, ArrayList<String>> productPluginsMap = new HashMap<String, ArrayList<String>>(10);

    private ProductHandlerManager() {
        this.populatePluginNamesFromFolders();
    }

    public static ProductHandlerManager getInstance() {
        if (null == instance) {
            instance = new ProductHandlerManager();
        }
        return instance;
    }

    private void populatePluginNamesFromFolders() {
        String string = System.getProperty("user.dir");
        File file = new File(string + FILESEPERATOR + "plugins" + FILESEPERATOR);
        if (file.exists()) {
            File[] fileArray = file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (file.isDirectory()) {
                        ProductHandlerManager.this.pluginNames.add(file.getName());
                    } else if (file.getName().endsWith(".jar")) {
                        ProductHandlerManager.this.pluginNames.add(file.getName());
                        return true;
                    }
                    return false;
                }
            });
        }
    }

    public List<String> getPluginsListOverridedByPlugin(String string) {
        if (!this.productPluginsMap.containsKey(string)) {
            ArrayList<String> arrayList = this.getProductPluginNames(string);
            this.productPluginsMap.put(string, arrayList);
        }
        return this.productPluginsMap.get(string);
    }

    private ArrayList<String> getProductPluginNames(String string) {
        URL uRL = PluginSubsystemUtilities.getPluginURL(string);
        if (PluginUtil.isPluginJar(uRL.toString())) {
            this.getProductPluginsFromJar(string);
        } else {
            URL uRL2 = PluginSubsystemUtilities.getPluginURL(string);
            try {
                File file = new File(uRL2.toURI().getPath() + PRODUCT_STYLE_DIR);
                if (file.exists()) {
                    String[] stringArray = file.list(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return ProductHandlerManager.this.pluginNames.contains(string);
                        }
                    });
                    return new ArrayList<String>(Arrays.asList(stringArray));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return new ArrayList<String>(0);
    }

    private void getProductPluginsFromJar(String string) {
        HashSet<String> hashSet = new HashSet<String>(10);
        try {
            URL uRL = PluginSubsystemUtilities.getURLFromPluginJar(string, PRODUCT_STYLE_DIR);
            if (null != uRL) {
                JarFile jarFile;
                String string2 = uRL.getPath();
                String string3 = string2.substring(string2.indexOf("!") + 2);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection && null != (jarFile = ((JarURLConnection)uRLConnection).getJarFile())) {
                    String string4 = null;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (null != enumeration && enumeration.hasMoreElements()) {
                        string4 = ProductHandlerManager.process(enumeration.nextElement(), string3, hashSet);
                        if (string4 == null) continue;
                        String string5 = string4;
                        hashSet.add(string4);
                    }
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void notifyReadersOfOverridedPlugins(String string) {
        ArrayList<String> arrayList = null;
        arrayList = this.productPluginsMap.get(string);
        arrayList = null == arrayList ? (ArrayList<String>)this.getPluginsListOverridedByPlugin(string) : this.productPluginsMap.get(string);
        Plugin plugin = null;
        if (null != arrayList) {
            for (String string2 : arrayList) {
                plugin = PluginManager.getInstance().getPluginFromFolder(string2);
                if (null == plugin) continue;
                CommStyleParser commStyleParser = plugin.getIntegrateCommStyleReader();
                ((IntegrateCommStyleReader)commStyleParser).addProductHandler(string);
                CommStyleParser commStyleParser2 = plugin.getCommStyleParser();
                ((DefaultCommStyleParser)commStyleParser2).addProductHandler(string);
                Resource resource = plugin.getResource();
                ((DefaultResourceReader)resource).addProductHandler(string);
            }
        }
    }

    public void notifyReadersOfOverridedPluginsForRemove(String string) {
        ArrayList<String> arrayList = null;
        arrayList = this.productPluginsMap.get(string);
        arrayList = null == arrayList ? (ArrayList<String>)this.getPluginsListOverridedByPlugin(string) : this.productPluginsMap.get(string);
        Plugin plugin = null;
        if (null != arrayList) {
            for (String string2 : arrayList) {
                plugin = PluginManager.getInstance().getPluginFromFolder(string2);
                if (null == plugin) continue;
                CommStyleParser commStyleParser = plugin.getIntegrateCommStyleReader();
                ((IntegrateCommStyleReader)commStyleParser).removeProductHandler(string);
                CommStyleParser commStyleParser2 = plugin.getCommStyleParser();
                ((DefaultCommStyleParser)commStyleParser2).removeProductHandler(string);
                Resource resource = plugin.getResource();
                ((DefaultResourceReader)resource).removeProductHandler(string);
            }
        }
    }

    private static String process(JarEntry jarEntry, String string, Set<String> set) {
        String string2 = jarEntry.getName();
        if (string2.startsWith(string) && (string2 = string.charAt(string.length() - 1) == '/' ? string2.substring(string.length()) : string2.substring(string.length() + 1)).indexOf("/") != -1 && string2.length() > 0) {
            String string3 = string2.substring(0, string2.indexOf("/"));
            return string3;
        }
        return null;
    }
}

