/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.framework.pluginmanagement.DuplicateModuleLoadException;
import com.swimap.iview.framework.pluginmanagement.InvalidPluginException;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.spi.SelfClassSpacePlugin;
import com.swimap.iview.framework.pluginmanagement.spi.SharedClassSpacePlugin;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipFile;

public class PluginFactory {
    private static IviewLogger logger = IviewLogger.getLogger(PluginFactory.class, "IVIEW");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isSelfPlugin(URL uRL) {
        InputStream inputStream = null;
        ZipFile zipFile = null;
        FileInputStream fileInputStream = null;
        try {
            Object object;
            if (null != uRL && uRL.toString().endsWith("jar")) {
                object = null;
                object = uRL.toURI().getPath();
                if (null != object) {
                    zipFile = new JarFile((String)object);
                }
                if (null == zipFile) {
                    logger.trace("Exception in isSelfPlugin() of PluginFactory ");
                    boolean bl = false;
                    return bl;
                }
                Enumeration<JarEntry> enumeration = ((JarFile)zipFile).entries();
                boolean bl = enumeration.hasMoreElements();
                JarEntry jarEntry = null;
                String string = null;
                while (bl) {
                    jarEntry = enumeration.nextElement();
                    string = jarEntry.getName();
                    if (string.startsWith("META-INF") && string.endsWith("MANIFEST.MF") && null != (inputStream = ((JarFile)zipFile).getInputStream(jarEntry))) {
                        Manifest manifest = new Manifest(inputStream);
                        Attributes attributes = manifest.getMainAttributes();
                        boolean bl2 = attributes.getValue("Bundle-SymbolicName") != null;
                        return bl2;
                    }
                    bl = enumeration.hasMoreElements();
                }
            } else {
                object = new URL(uRL, "META-INF/MANIFEST.MF");
                File file = new File(((URL)object).toURI());
                if (file.exists()) {
                    fileInputStream = new FileInputStream(file);
                    Manifest manifest = new Manifest(fileInputStream);
                    Attributes attributes = manifest.getMainAttributes();
                    boolean bl = attributes.getValue("Bundle-SymbolicName") != null;
                    return bl;
                }
            }
        }
        catch (Exception exception) {
            logger.trace("Exception in isSelfPlugin() of PluginFactory " + exception.getMessage());
        }
        finally {
            try {
                if (null != inputStream) {
                    inputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
            try {
                if (null != zipFile) {
                    zipFile.close();
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
            try {
                if (null != fileInputStream) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
        }
        return false;
    }

    public Plugin createPlugin(URL uRL) throws MalformedURLException, DuplicateModuleLoadException, InvalidPluginException {
        boolean bl = PluginFactory.isSelfPlugin(uRL);
        if (bl) {
            return new SelfClassSpacePlugin(uRL);
        }
        return new SharedClassSpacePlugin(uRL);
    }
}

