/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlbind.PARA;
import com.swimap.iview.util.MetaDataTool;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class PluginCommStyleHandler {
    private Map<String, Map<String, String>> integrateStyleMap = new ConcurrentHashMap<String, Map<String, String>>(10);
    private Map<String, Map<String, String>> productResURLsMap = new ConcurrentHashMap<String, Map<String, String>>(10);
    private Map<String, Map<String, String>> productCommParserURLsMap = new ConcurrentHashMap<String, Map<String, String>>(10);
    private static PluginCommStyleHandler instance = null;
    private CommStyleInfo metaCommStyleInfo = null;
    private static final String CURR_DIR = System.getProperty("user.dir");
    private static final String INTEGRATESTYLEDESC = "integrateStyleUrlList";
    private static final String RESSTYLEDESC = "resProductStyleUrlList";
    private static final String PARSERSTYLEDESC = "parserProductStyleUrlList";
    public static final String FILENAME = "MetaCommStylePluginInfo";

    public static PluginCommStyleHandler getInstance() {
        if (instance == null) {
            instance = new PluginCommStyleHandler();
        }
        return instance;
    }

    public void saveStyleURL() {
        if (this.metaCommStyleInfo == null) {
            this.metaCommStyleInfo = new CommStyleInfo();
            AreaDescContainer areaDescContainer = new AreaDescContainer();
            areaDescContainer.setAreaName(CURR_DIR);
            this.metaCommStyleInfo.addAreaDescContainer(areaDescContainer);
            DescContainer descContainer = this.createDescContainer(INTEGRATESTYLEDESC, this.integrateStyleMap);
            areaDescContainer.addDescContainer(descContainer);
            descContainer = this.createDescContainer(RESSTYLEDESC, this.productResURLsMap);
            areaDescContainer.addDescContainer(descContainer);
            descContainer = this.createDescContainer(PARSERSTYLEDESC, this.productCommParserURLsMap);
            areaDescContainer.addDescContainer(descContainer);
            String string = MetaDataTool.getFileName(FILENAME);
            MetaDataTool.Write(this.metaCommStyleInfo, string);
        }
    }

    public void populateIntegrateStyleMap(String string, Map<String, String> map) {
        this.integrateStyleMap.put(string, map);
    }

    public void populateProductResURLsMap(String string, Map<String, String> map) {
        this.productResURLsMap.put(string, map);
    }

    public void populateProductCommParserURLsMap(String string, Map<String, String> map) {
        this.productCommParserURLsMap.put(string, map);
    }

    public Map<String, String> searchStyleIntegrateURL(String string) {
        Map<String, String> map = this.integrateStyleMap.get(string);
        return map;
    }

    public Map<String, String> searchStyleResourceURL(String string) {
        Map<String, String> map = this.productResURLsMap.get(string);
        return map;
    }

    public Map<String, String> searchStyleParserURL(String string) {
        Map<String, String> map = this.productCommParserURLsMap.get(string);
        return map;
    }

    public boolean checkPluginExistance(String string) {
        return this.integrateStyleMap.containsKey(string);
    }

    public boolean checkPluginResExistance(String string) {
        return this.productResURLsMap.containsKey(string);
    }

    public boolean checkPluginParserExistance(String string) {
        return this.productCommParserURLsMap.containsKey(string);
    }

    public DescContainer createDescContainer(String string, Map<String, Map<String, String>> map) {
        Set<String> set = map.keySet();
        DescContainer descContainer = new DescContainer();
        descContainer.setDescName(string);
        DescContainer descContainer2 = null;
        Map<String, String> map2 = null;
        Set<String> set2 = null;
        for (String string2 : set) {
            descContainer2 = new DescContainer();
            descContainer2.setDescName(string2);
            map2 = map.get(string2);
            set2 = map2.keySet();
            for (String string3 : set2) {
                PARA pARA = new PARA();
                pARA.setName(map2.get(string3));
                pARA.setValue(string3);
                descContainer2.addParasItem(pARA);
            }
            descContainer.addDescContainer(descContainer2);
        }
        return descContainer;
    }

    public void initialize() {
        String string = MetaDataTool.getFileName(FILENAME);
        this.metaCommStyleInfo = MetaDataTool.getData(string);
        if (this.metaCommStyleInfo != null) {
            AreaDescContainer areaDescContainer = this.metaCommStyleInfo.getAreaDescContainer(CURR_DIR);
            if (areaDescContainer != null) {
                this.integrateStyleMap = this.initializeMap(areaDescContainer, INTEGRATESTYLEDESC);
                this.productResURLsMap = this.initializeMap(areaDescContainer, RESSTYLEDESC);
                this.productCommParserURLsMap = this.initializeMap(areaDescContainer, PARSERSTYLEDESC);
            } else {
                this.metaCommStyleInfo = null;
            }
        }
    }

    private Map<String, Map<String, String>> initializeMap(AreaDescContainer areaDescContainer, String string) {
        ConcurrentHashMap<String, Map<String, String>> concurrentHashMap = new ConcurrentHashMap<String, Map<String, String>>(10);
        DescContainer descContainer = areaDescContainer.getDescContainer(string);
        int n = descContainer.getDescContainerCount();
        int n2 = 0;
        DescContainer descContainer2 = null;
        HashMap<String, String> hashMap = null;
        PARA pARA = null;
        for (int i = 0; i < n; ++i) {
            descContainer2 = descContainer.getDescContainer(i);
            n2 = descContainer2.getParasItemCount();
            hashMap = new HashMap<String, String>(10);
            for (int j = 0; j < n2; ++j) {
                pARA = descContainer2.getParasItem(j);
                hashMap.put(pARA.getValue(), pARA.getName());
            }
            concurrentHashMap.put(descContainer2.getDescName(), hashMap);
        }
        return concurrentHashMap;
    }

    public void clear() {
        this.integrateStyleMap.clear();
        this.productResURLsMap.clear();
        this.productCommParserURLsMap.clear();
        this.metaCommStyleInfo = null;
    }
}

