/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.util.adapter.FrameworkHelper;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.adaptor.EclipseStarter;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import sun.net.www.ParseUtil;

public class OSGIUtil {
    private static IviewLogger logger = IviewLogger.getLogger(OSGIUtil.class, "IVIEW");
    private static BundleContext context = null;
    private static OSGIUtil instance = null;

    private OSGIUtil() {
        System.setProperty("osgi.noShutdown", "true");
        System.setProperty("eclipse.ignoreApp", "true");
        String string = System.getProperty("user.dir");
        File file = new File(string);
        URL uRL = null;
        try {
            uRL = file.toURL();
        }
        catch (MalformedURLException malformedURLException) {
            logger.debug(malformedURLException.getMessage());
        }
        if (null != uRL) {
            System.setProperty("osgi.install.area", uRL.toString());
        } else {
            logger.trace("URL for install area is null");
        }
        String[] stringArray = new String[]{"-console"};
        try {
            context = FrameworkHelper.isOSGIClient() ? (BundleContext)FrameworkHelper.getIviewBundleContext() : EclipseStarter.startup((String[])stringArray, null);
        }
        catch (Exception exception) {
            logger.debug(exception.getMessage());
        }
    }

    public static OSGIUtil getInstance() {
        if (null == instance) {
            instance = new OSGIUtil();
        }
        return instance;
    }

    public static Bundle installBundle(String string, InputStream inputStream) throws BundleException {
        return OSGIUtil.getInstance().installBundleImp(string, inputStream);
    }

    public static Bundle installBundle(String string) throws BundleException {
        return OSGIUtil.getInstance().installBundleImp(string);
    }

    private Bundle installBundleImp(String string, InputStream inputStream) throws BundleException {
        String string2 = ParseUtil.decode(string);
        if (null == context) {
            throw new BundleException("Context for the bundle is null");
        }
        return context.installBundle(string2, inputStream);
    }

    private Bundle installBundleImp(String string) throws BundleException {
        String string2 = ParseUtil.decode(string);
        if (null == context) {
            throw new BundleException("Context for the bundle is null");
        }
        return context.installBundle(string2);
    }
}

