/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.PathManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.pluginmanagement.spi.CommStyleHandler;
import com.swimap.iview.framework.pluginmanagement.spi.PluginCommStyleHandler;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IntegrateCommStyleReader
implements CommStyleParser {
    private static IviewLogger logger = IviewLogger.getLogger(IntegrateCommStyleReader.class, "IVIEW");
    private static final String COMPLEX_PATH = "complex/";
    private static final String SINGLE_PATH = "single/";
    private static final String ALL_USERS_DIR = "./style/all users/";
    private CommStyleHandler defaultHandler = null;
    private String pluginId = null;
    private List<CommStyleHandler> productHandler = new ArrayList<CommStyleHandler>(10);
    private List<CommStyleHandler> remProductHandler = new ArrayList<CommStyleHandler>(10);
    private List<URL> productStyleURLList = new ArrayList<URL>(10);
    private Map<Object, String> urlPluginMap = new HashMap<Object, String>(10);
    private Map<Object, String> handlerPluginMap = new HashMap<Object, String>(10);
    private Map<Object, String> resPluginMap = new HashMap<Object, String>(10);
    private static Map<String, ArrayList<String>> defaultStyleFileList = Collections.synchronizedMap(new HashMap(10));
    private int handlerKey = 0;
    private static final String INT_PATH = IntegrateCommStyleReader.getIntegratePath();
    private static final String integrateDefaultPath = "style/integrate/" + INT_PATH;
    private static final String appIntegrateDefaultPath = "style/integrate/app/";
    private Map<String, String> urlDefaultPluginMap = new HashMap<String, String>(10);

    public IntegrateCommStyleReader(URL uRL, String string) throws MalformedURLException {
        this.pluginId = string;
        PluginCommStyleHandler pluginCommStyleHandler = PluginCommStyleHandler.getInstance();
        boolean bl = SerializationHandler.isEnableSerialization();
        if (bl && pluginCommStyleHandler.checkPluginExistance(string)) {
            this.populateproductStyleURLsFromSerializeFiles();
        } else {
            this.populateProductStyleUrlsFromFolders();
        }
        URL uRL2 = null;
        if (PluginUtil.isPluginJar(uRL.toString())) {
            uRL2 = PluginUtil.jarPathToJarURL(uRL.toString(), this.getIntegrateDefaultPath());
        } else {
            try {
                uRL2 = new File(uRL.toURI().getPath() + this.getIntegrateDefaultPath()).toURI().toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.trace(uRISyntaxException);
            }
        }
        this.defaultHandler = new CommStyleHandler(uRL2, string);
        this.creatingProductHandlersFromProductStyleUrls();
    }

    protected void addProductHandler(String string) {
        URL uRL = null;
        try {
            uRL = this.getProductStyleURL(this.pluginId, string);
        }
        catch (IOException iOException) {
            logger.trace("Unable to get the url " + iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null != string2) {
            return;
        }
        this.productStyleURLList.add(uRL);
        this.urlPluginMap.put(uRL.toString(), this.pluginId);
        this.urlDefaultPluginMap.put(uRL.toString(), string);
        CommStyleHandler commStyleHandler = null;
        String string3 = null;
        String string4 = null;
        string3 = this.urlPluginMap.get(uRL.toString());
        string4 = this.urlDefaultPluginMap.get(uRL.toString());
        commStyleHandler = new CommStyleHandler(uRL, this.pluginId);
        commStyleHandler.defaultPluginName = string4;
        this.productHandler.add(commStyleHandler);
        this.handlerPluginMap.put(commStyleHandler, string3);
        ++this.handlerKey;
        logger.info("STARTUP -- INTEGRATE READER --productStyles configured plugins are:" + string + "of Plugin:" + this.pluginId + "is newly added");
        defaultStyleFileList.clear();
    }

    public void removeProductHandler(String string) {
        URL uRL = null;
        try {
            uRL = this.getProductStyleURL(this.pluginId, string);
        }
        catch (IOException iOException) {
            logger.trace("Unable to get the url " + iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null == string2) {
            return;
        }
        this.productStyleURLList.remove(uRL);
        this.urlPluginMap.remove(uRL.toString());
        this.urlDefaultPluginMap.remove(uRL.toString());
        for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.productHandler)) {
            String string3 = commStyleHandler.defaultPluginName;
            if (PluginUtil.isPluginJar(string3)) {
                int n = string3.lastIndexOf(".jar");
                string3 = string3.substring(0, n);
            }
            if (null == string || !string.equals(string3)) continue;
            this.productHandler.remove(commStyleHandler);
            this.handlerPluginMap.remove(commStyleHandler);
            defaultStyleFileList.clear();
        }
        --this.handlerKey;
        logger.info("STARTUP -- INTEGRATE READER --productStyles configured plugins are:" + string + "of Plugin:" + this.pluginId + "is removed");
    }

    private void populateproductStyleURLsFromSerializeFiles() {
        PluginCommStyleHandler pluginCommStyleHandler = PluginCommStyleHandler.getInstance();
        Map<String, String> map = pluginCommStyleHandler.searchStyleIntegrateURL(this.pluginId);
        Set<String> set = map.keySet();
        URL uRL = null;
        for (String string : set) {
            try {
                uRL = new URL(string);
                this.urlDefaultPluginMap.put(string, map.get(string));
                this.productStyleURLList.add(uRL);
                this.urlPluginMap.put(string, this.pluginId);
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace("Exception occured while creating the url");
            }
        }
    }

    private void creatingProductHandlersFromProductStyleUrls() {
        CommStyleHandler commStyleHandler = null;
        String string = null;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URL uRL : this.productStyleURLList) {
            string = this.urlPluginMap.get(uRL.toString());
            string2 = this.urlDefaultPluginMap.get(uRL.toString());
            commStyleHandler = new CommStyleHandler(uRL, this.pluginId);
            commStyleHandler.defaultPluginName = string2;
            arrayList.add(string2);
            this.productHandler.add(commStyleHandler);
            this.handlerPluginMap.put(commStyleHandler, string);
            ++this.handlerKey;
        }
        logger.info("STARTUP -- INTEGRATE READER --productStyles configured plugins are:" + arrayList + "of Plugin:" + this.pluginId);
    }

    private void populateProductStyleUrlsFromFolders() {
        PluginCommStyleHandler pluginCommStyleHandler = PluginCommStyleHandler.getInstance();
        boolean bl = SerializationHandler.isEnableSerialization();
        String[] stringArray = this.getLoadedSusystemPluginNames();
        if (null != stringArray && 0 < stringArray.length) {
            URL uRL = null;
            for (String string : stringArray) {
                try {
                    uRL = this.getProductStyleURL(this.pluginId, string);
                }
                catch (IOException iOException) {
                    logger.trace("Unable to get the url " + iOException);
                }
                if (null == uRL) continue;
                this.productStyleURLList.add(uRL);
                this.urlPluginMap.put(uRL.toString(), this.pluginId);
                this.urlDefaultPluginMap.put(uRL.toString(), string);
            }
            if (bl) {
                pluginCommStyleHandler.populateIntegrateStyleMap(this.pluginId, this.urlDefaultPluginMap);
            }
        }
    }

    protected URL getProductStyleURL(String string, String string2) throws IOException {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            return PluginSubsystemUtilities.getAppStyleURL(string, string2);
        }
        return PluginSubsystemUtilities.getIntegrateStyleURL(string, string2);
    }

    protected String[] getLoadedSusystemPluginNames() {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            return ApplicationUtilities.getValidPluginNamesFromApps();
        }
        String[] stringArray = PluginSubsystemUtilities.getLoadedPluginNames();
        if (null == stringArray) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    protected String getIntegrateDefaultPath() {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            return appIntegrateDefaultPath;
        }
        return integrateDefaultPath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CommStyleInfo getCommStyleInfo(String string) {
        void var11_14;
        String string2;
        ArrayList<String> arrayList;
        CommStyleInfo commStyleInfo;
        ArrayList<String> arrayList2 = new ArrayList<String>(10);
        String string3 = string;
        if (!string.endsWith(".xml")) {
            string3 = string + ".xml";
        }
        if (null != (commStyleInfo = this.defaultHandler.getCommStyleInfo(string3))) {
            commStyleInfo.setAppID(this.getAppID());
        }
        if (null != (arrayList = defaultStyleFileList.get(string2 = PluginSerializationHandler.getSerializationKey(this.getAppID() + this.pluginId + this.getIntegrateName() + this.handlerKey, string)))) {
            CommStyleInfo commStyleInfo2 = this.getProductStyleInfoFromList(arrayList);
            if (null != commStyleInfo2) {
                commStyleInfo2.setAppID(this.getAppID());
            }
            return this.getMergedResut(commStyleInfo, commStyleInfo2, string3);
        }
        if (defaultStyleFileList.containsKey(string2)) {
            return this.getMergedResut(commStyleInfo, null, string3);
        }
        ArrayList<CommStyleInfo> arrayList3 = new ArrayList<CommStyleInfo>(10);
        String string4 = null;
        CommStyleInfo commStyleInfo3 = null;
        for (CommStyleHandler object2 : this.productHandler) {
            string4 = this.handlerPluginMap.get(object2);
            commStyleInfo3 = object2.getCommStyleInfo(string3);
            if (null != commStyleInfo3) {
                commStyleInfo3.setAppID(this.getAppID());
            }
            arrayList3.add(commStyleInfo3);
            this.resPluginMap.put(commStyleInfo3, string4);
        }
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        Object var11_13 = null;
        List<String> list = this.getLoadedPluginNames();
        for (CommStyleInfo commStyleInfo2 : arrayList3) {
            string4 = this.resPluginMap.get(commStyleInfo2);
            if (!list.contains(string4) || null == commStyleInfo2) continue;
            String string5 = commStyleInfo2.getFileName();
            string5 = string5.indexOf("jar") != -1 ? string5.substring(string5.lastIndexOf("jar!/") + 5) : string5.substring(string5.indexOf("plugins"));
            string5 = string5.replaceAll("%20", " ");
            arrayList2.add(string5);
            CommStyleInfo commStyleInfo4 = commStyleManager.mergeCommStyleInfo((CommStyleInfo)var11_14, commStyleInfo2);
        }
        CommStyleInfo commStyleInfo5 = this.getMergedResut(commStyleInfo, (CommStyleInfo)var11_14, string3);
        if (null != commStyleInfo5) {
            commStyleInfo5.setAppID(this.getAppID());
        }
        if (0 == arrayList2.size()) {
            arrayList2 = null;
        }
        defaultStyleFileList.put(string2, arrayList2);
        return commStyleInfo5;
    }

    protected String getAppID() {
        return "";
    }

    protected List<String> getLoadedPluginNames() {
        return PluginManager.getInstance().getLoadedPluginNames();
    }

    private CommStyleInfo getMergedResut(CommStyleInfo commStyleInfo, CommStyleInfo commStyleInfo2, String string) {
        if (commStyleInfo == null && commStyleInfo2 == null) {
            return null;
        }
        CommStyleInfo commStyleInfo3 = CommStyleManager.getInstance().mergeCommStyleInfo(commStyleInfo, commStyleInfo2);
        if (commStyleInfo3 != null) {
            commStyleInfo3.setRelatFileName(string);
            commStyleInfo3.setFileName(commStyleInfo3.getFileName());
            commStyleInfo3.setPluginName(this.pluginId);
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo3.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo3;
    }

    @Override
    public CommStyleInfo getUserCommStyleInfo(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            stringBuffer.append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append("app/").append(string2);
        } else {
            stringBuffer.append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append(string2);
        }
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserCommonStyleFile(stringBuffer.toString());
        if (null == commStyleInfo) {
            commStyleInfo = this.getCommStyleInfo(string2);
        } else {
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            commStyleInfo.setRelatFileName(string2);
            commStyleInfo.setFileName(System.getProperty("user.dir") + '/' + commStyleInfo.getFileName());
            commStyleInfo.setPluginName(this.pluginId);
            commStyleInfo.setAppID(this.getAppID());
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo;
    }

    @Override
    public CommStyleInfo getAllUserCommStyleInfo(String string) {
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(16);
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            stringBuffer.append(ALL_USERS_DIR).append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append(string2);
        } else {
            stringBuffer.append(ALL_USERS_DIR).append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append(string2);
        }
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAbsCommStyleFile(stringBuffer.toString());
        if (null == commStyleInfo) {
            commStyleInfo = this.getCommStyleInfo(string2);
        } else {
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            commStyleInfo.setRelatFileName(string2);
            commStyleInfo.setFileName(System.getProperty("user.dir") + '/' + commStyleInfo.getFileName());
            commStyleInfo.setPluginName(this.pluginId);
            commStyleInfo.setAppID(this.getAppID());
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo;
    }

    protected String getIntegrateName() {
        return INT_PATH;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToUser(CommStyleInfo commStyleInfo) throws IOException {
        CommStyleParserFactory commStyleParserFactory = CommStyleParserFactory.getInstance();
        IProfileParser iProfileParser = commStyleParserFactory.createProfileParser();
        if (null == commStyleInfo || null == iProfileParser) {
            throw new IllegalArgumentException("CommStyleInfo is null.");
        }
        String string = commStyleInfo.getRelatFileName();
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                commStyleInfo.marshal(byteArrayOutputStream);
                iProfileParser.write(((Object)byteArrayOutputStream).toString(), this.buildUserPath() + "integrate/" + this.getIntegrateName() + this.pluginId + '/' + "app/" + string);
            } else {
                commStyleInfo.marshal(byteArrayOutputStream);
                iProfileParser.write(((Object)byteArrayOutputStream).toString(), this.buildUserPath() + "integrate/" + this.getIntegrateName() + this.pluginId + '/' + string);
            }
        }
        finally {
            if (null != byteArrayOutputStream) {
                ((OutputStream)byteArrayOutputStream).close();
            }
        }
    }

    @Override
    public void writeToAllUsers(CommStyleInfo commStyleInfo) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (null == commStyleInfo) {
            logger.error("write error,Not able to write the user profile information ");
            throw new IllegalArgumentException();
        }
        String string = commStyleInfo.getRelatFileName();
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            stringBuffer.append(ALL_USERS_DIR).append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append("app/").append(string);
        } else {
            stringBuffer.append(ALL_USERS_DIR).append("integrate/").append(this.getIntegrateName()).append(this.pluginId).append('/').append(string);
        }
        File file = CommonUtil.getAbsoluteFile(stringBuffer.toString());
        commStyleInfo.writeStyle(file.getAbsolutePath());
    }

    private String buildUserPath() {
        String string = PathManager.getInstance().getUserInfoPath();
        if (null != string && string.length() > 0) {
            return string;
        }
        return CommStyleManager.getInstance().getUserDir();
    }

    private static String getIntegratePath() {
        SubsystemManager.LoadMode loadMode = SubsystemManager.getInstance().getClientLoadMode();
        if (SubsystemManager.LoadMode.single == loadMode) {
            return SINGLE_PATH;
        }
        return COMPLEX_PATH;
    }

    @Override
    public URL getEntry(String string) {
        return this.defaultHandler.getEntry(string);
    }

    @Override
    public Iterator<URL> getEntryList(String string) {
        return null;
    }

    private CommStyleInfo getProductStyleInfoFromList(ArrayList<String> arrayList) {
        CommStyleInfo commStyleInfo = null;
        CommStyleInfo commStyleInfo2 = null;
        for (String string : arrayList) {
            commStyleInfo2 = CommStyleManager.getInstance().getCommonStyleFileByPath(string, false);
            if (null == commStyleInfo2) continue;
            commStyleInfo = CommStyleManager.getInstance().mergeCommStyleInfo(commStyleInfo, commStyleInfo2);
        }
        return commStyleInfo;
    }

    public void reinitProductHandler(List<String> list, List<String> list2) {
    }

    public void reinitializeIntegrateProductHandlers(List<String> list) {
        if (list != null && !list.isEmpty()) {
            int n;
            String string = null;
            if (!this.remProductHandler.isEmpty()) {
                for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.remProductHandler)) {
                    string = commStyleHandler.defaultPluginName;
                    if (PluginUtil.isPluginJar(string)) {
                        n = string.lastIndexOf(".jar");
                        string = string.substring(0, n);
                    }
                    if (!list.contains(string)) continue;
                    this.productHandler.add(commStyleHandler);
                    this.handlerPluginMap.put(commStyleHandler, this.pluginId);
                    this.remProductHandler.remove(commStyleHandler);
                    defaultStyleFileList.clear();
                }
            }
            for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.productHandler)) {
                string = commStyleHandler.defaultPluginName;
                if (PluginUtil.isPluginJar(string)) {
                    n = string.lastIndexOf(".jar");
                    string = string.substring(0, n);
                }
                if (list.contains(string)) continue;
                this.productHandler.remove(commStyleHandler);
                this.handlerPluginMap.remove(commStyleHandler);
                this.remProductHandler.add(commStyleHandler);
                defaultStyleFileList.clear();
            }
            Collections.sort(this.productHandler, new ProductHandlerComparator(list));
        } else {
            if (!this.remProductHandler.isEmpty()) {
                for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.remProductHandler)) {
                    this.productHandler.add(commStyleHandler);
                    this.handlerPluginMap.put(commStyleHandler, this.pluginId);
                    this.remProductHandler.remove(commStyleHandler);
                    defaultStyleFileList.clear();
                }
                Collections.sort(this.productHandler, new ProductHandlerComparator(null));
            }
            if (Boolean.valueOf(System.getProperty("iView.ServerPlugins.Changed")).booleanValue()) {
                defaultStyleFileList.clear();
            }
        }
    }

    public static void clear() {
        defaultStyleFileList.clear();
    }

    private class ProductHandlerComparator
    implements Comparator<CommStyleHandler> {
        List<String> listOfStartupPlugins = null;

        ProductHandlerComparator(List<String> list) {
            this.listOfStartupPlugins = list;
        }

        @Override
        public int compare(CommStyleHandler commStyleHandler, CommStyleHandler commStyleHandler2) {
            String string = this.getNameWithoutJarExt(commStyleHandler.defaultPluginName);
            String string2 = this.getNameWithoutJarExt(commStyleHandler2.defaultPluginName);
            if (null != this.listOfStartupPlugins && !this.listOfStartupPlugins.isEmpty()) {
                int n;
                int n2 = this.listOfStartupPlugins.indexOf(string);
                return n2 < (n = this.listOfStartupPlugins.indexOf(string2)) ? 1 : (n2 == n ? 0 : -1);
            }
            return string.compareTo(string2);
        }

        private String getNameWithoutJarExt(String string) {
            if (PluginUtil.isPluginJar(string)) {
                int n = string.lastIndexOf(".jar");
                return string.substring(0, n);
            }
            return string;
        }
    }
}

