/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.commini.xmlimpl.read.XmlObject;
import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.XMLResourceBundle;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.pluginmanagement.spi.PluginCommStyleHandler;
import com.swimap.iview.framework.pluginmanagement.spi.ResourceHandler;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.Icon;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class DefaultResourceReader
implements Resource {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultResourceReader.class, "IVIEW");
    private static final String defaultStylePath = "style/locale/" + ResourceMng.getInstance().getLocaleString() + '/';
    private ResourceHandler defaultResHandler = null;
    private List<ResourceHandler> productResHandler = new ArrayList<ResourceHandler>(10);
    private List<ResourceHandler> remProductResHandler = new ArrayList<ResourceHandler>(10);
    private List<URL> productResURLList = new ArrayList<URL>(10);
    private Map<Object, String> urlPluginMap = new HashMap<Object, String>(10);
    private Map<Object, String> handlerPluginMap = new HashMap<Object, String>(10);
    private Map<Object, String> resPluginListMap = new HashMap<Object, String>(10);
    private String _pluginName = null;
    private Map<String, String> urlDefaultPluginMap = new HashMap<String, String>(10);

    public DefaultResourceReader(URL uRL) throws MalformedURLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this._pluginName = PluginUtil.getNameFromPluginURL(uRL);
        PluginCommStyleHandler pluginCommStyleHandler = PluginCommStyleHandler.getInstance();
        String string = PluginUtil.getNameFromPluginURL(uRL);
        boolean bl = SerializationHandler.isEnableSerialization();
        if (bl && pluginCommStyleHandler.checkPluginResExistance(string)) {
            object5 = pluginCommStyleHandler.searchStyleResourceURL(string);
            object4 = object5.keySet();
            object3 = null;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                object3 = new URL((String)object);
                this.urlDefaultPluginMap.put((String)object, (String)object5.get(object));
                this.productResURLList.add((URL)object3);
                this.urlPluginMap.put(object, string);
            }
        } else {
            object5 = this.getLoadedPluginNames();
            if (null != object5 && 0 < ((String[])object5).length) {
                object4 = null;
                for (int i = 0; i < ((Object)object5).length; ++i) {
                    try {
                        object4 = PluginSubsystemUtilities.getResourceURL(string, (String)object5[i]);
                    }
                    catch (IOException iOException) {
                        logger.trace("Unable to read plugins " + object4);
                    }
                    if (null == object4) continue;
                    this.productResURLList.add((URL)object4);
                    this.urlPluginMap.put(((URL)object4).toString(), string);
                    this.urlDefaultPluginMap.put(((URL)object4).toString(), (String)object5[i]);
                }
                if (bl) {
                    pluginCommStyleHandler.populateProductResURLsMap(string, this.urlDefaultPluginMap);
                }
            }
        }
        object5 = null;
        if (PluginUtil.isPluginJar(uRL.toString())) {
            object5 = PluginUtil.jarPathToJarURL(uRL.toString(), defaultStylePath);
        } else {
            try {
                object5 = new File(uRL.toURI().getPath() + defaultStylePath).toURI().toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.trace(uRISyntaxException);
            }
        }
        this.defaultResHandler = new ResourceHandler((URL)object5);
        object4 = null;
        object3 = null;
        object2 = null;
        object = new ArrayList();
        for (URL uRL2 : this.productResURLList) {
            object3 = this.urlPluginMap.get(uRL2.toString());
            object2 = this.urlDefaultPluginMap.get(uRL2.toString());
            object4 = new ResourceHandler(uRL2);
            ((ResourceHandler)object4).defaultPluginName = object2;
            object.add(object2);
            this.productResHandler.add((ResourceHandler)object4);
            this.handlerPluginMap.put(object4, (String)object3);
        }
        logger.info("STARTUP -- RESOURCE READER -- productStyles configured plugins are:" + object + "of Plugin:" + this._pluginName);
    }

    public void addProductHandler(String string) {
        URL uRL = null;
        try {
            uRL = PluginSubsystemUtilities.getResourceURL(this._pluginName, string);
        }
        catch (IOException iOException) {
            logger.trace("Unable to get the url " + iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null != string2) {
            return;
        }
        this.productResURLList.add(uRL);
        this.urlPluginMap.put(uRL.toString(), this._pluginName);
        this.urlDefaultPluginMap.put(uRL.toString(), this._pluginName);
        boolean bl = SerializationHandler.isEnableSerialization();
        ResourceHandler resourceHandler = null;
        String string3 = null;
        String string4 = null;
        string3 = this.urlPluginMap.get(uRL.toString());
        string4 = this.urlDefaultPluginMap.get(uRL.toString());
        resourceHandler = new ResourceHandler(uRL);
        resourceHandler.defaultPluginName = string4;
        this.productResHandler.add(resourceHandler);
        this.handlerPluginMap.put(resourceHandler, string3);
        logger.info("STARTUP -- RESOURCE READER -- productStyles configured plugins are:" + string + "of Plugin:" + this._pluginName + "newly added");
    }

    public void removeProductHandler(String string) {
        if (null == string) {
            return;
        }
        URL uRL = null;
        try {
            uRL = PluginSubsystemUtilities.getResourceURL(this._pluginName, string);
        }
        catch (IOException iOException) {
            logger.trace("Unable to get the url " + iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null == string2) {
            return;
        }
        this.productResURLList.add(uRL);
        this.urlPluginMap.remove(uRL.toString());
        this.urlDefaultPluginMap.remove(uRL.toString());
        for (ResourceHandler resourceHandler : new ArrayList<ResourceHandler>(this.productResHandler)) {
            String string3 = resourceHandler.defaultPluginName;
            if (PluginUtil.isPluginJar(string3)) {
                int n = string3.lastIndexOf(".jar");
                string3 = string3.substring(0, n);
            }
            if (!string.equals(string3)) continue;
            this.productResHandler.remove(resourceHandler);
            this.handlerPluginMap.remove(resourceHandler);
        }
        logger.info("STARTUP -- PARSER READER --productStyles configured plugins are:" + string + "of Plugin:" + this._pluginName + "is removed");
    }

    protected String[] getLoadedPluginNames() {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            return ApplicationUtilities.getValidPluginNamesFromApps();
        }
        String[] stringArray = PluginSubsystemUtilities.getLoadedPluginNames();
        if (null == stringArray) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    public Resource getResource(String string) {
        Resource resource = null;
        Plugin plugin = PluginManager.getInstance().getPlugin(string);
        if (null != plugin) {
            resource = plugin.getResource();
        }
        return resource;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ResourceBundle getResourceBundleFromXmlFile(String string) {
        void var8_10;
        XmlObject xmlObject2;
        Object object2;
        String[] stringArray = string.split(":");
        if (stringArray.length > 1 && null != (object2 = this.getResource(stringArray[0]))) {
            return object2.getResourceBundleFromXmlFile(stringArray[1]);
        }
        object2 = this.defaultResHandler.getCommStyleInfo(string);
        ArrayList<CommStyleInfo> arrayList = new ArrayList<CommStyleInfo>(10);
        String string2 = null;
        CommStyleInfo commStyleInfo = null;
        for (ResourceHandler object3 : this.productResHandler) {
            string2 = this.handlerPluginMap.get(object3);
            commStyleInfo = object3.getCommStyleInfo(string);
            arrayList.add(commStyleInfo);
            this.resPluginListMap.put(commStyleInfo, string2);
        }
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        Object var8_9 = null;
        List<String> list = Arrays.asList(this.getLoadedPluginNames());
        for (XmlObject xmlObject2 : arrayList) {
            string2 = this.resPluginListMap.get(xmlObject2);
            if (!list.contains(string2)) continue;
            CommStyleInfo commStyleInfo2 = commStyleManager.mergeCommStyleInfo((CommStyleInfo)var8_10, (CommStyleInfo)xmlObject2);
        }
        CommStyleInfo commStyleInfo3 = CommStyleManager.getInstance().mergeCommStyleInfo((CommStyleInfo)var8_10, (CommStyleInfo)object2);
        if (null == commStyleInfo3) {
            logger.debug("Resource File not exists or not valid: " + string);
            return null;
        }
        xmlObject2 = commStyleInfo3.getAreaDescContainer(0).getDescContainer(0);
        return new XMLResourceBundle((DescContainer)xmlObject2);
    }

    protected String getAppID() {
        return "";
    }

    @Override
    public ResourceBundle getResourceBundleFromPropertyFile(String string) {
        Object object3;
        String[] stringArray = string.split(":");
        if (stringArray.length > 1 && null != (object3 = this.getResource(stringArray[0]))) {
            return object3.getResourceBundleFromPropertyFile(stringArray[1]);
        }
        logger.log((Priority)Level.ALL, "plugin.ResourceFile.iview=" + this._pluginName + ':' + string);
        object3 = PluginSerializationHandler.getSerializationKey(this.getAppID() + this._pluginName, string);
        if (PluginSerializationHandler.checkResExistance((String)object3)) {
            return new PropertyResourceBundleEx(PluginSerializationHandler.getResource((String)object3));
        }
        ArrayList<Properties> arrayList = new ArrayList<Properties>(10);
        Properties properties = this.defaultResHandler.getProperties(string);
        Properties properties2 = null;
        String string2 = null;
        for (ResourceHandler object22 : this.productResHandler) {
            string2 = this.handlerPluginMap.get(object22);
            properties2 = object22.getProperties(string);
            arrayList.add(properties2);
            this.resPluginListMap.put(properties2, string2);
        }
        Object object4 = null;
        List<String> list = Arrays.asList(this.getLoadedPluginNames());
        for (Properties properties3 : arrayList) {
            string2 = this.resPluginListMap.get(properties3);
            if (!list.contains(string2)) continue;
            object4 = PluginUtil.mergeProperties(object4, properties3);
        }
        Properties properties4 = PluginUtil.mergeProperties(properties, object4);
        PluginSerializationHandler.populateResMap((String)object3, properties4);
        PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties4);
        return propertyResourceBundleEx;
    }

    @Override
    public Icon getIcon(String string) {
        Object object;
        if (string.trim().length() == 0) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (stringArray.length > 1 && null != (object = this.getResource(stringArray[0]))) {
            return object.getIcon(stringArray[1]);
        }
        logger.log((Priority)Level.TRACE, "plugin.IconFile.iview=" + this._pluginName + ':' + string);
        object = PluginSerializationHandler.getSerializationKey(this.getAppID() + this._pluginName, string);
        if (PluginSerializationHandler.checkExistance((String)object)) {
            return PluginSerializationHandler.getIcon((String)object);
        }
        Icon icon = null;
        String string2 = null;
        List<String> list = Arrays.asList(this.getLoadedPluginNames());
        Object object2 = this.productResHandler.iterator();
        while (object2.hasNext()) {
            URL uRL;
            ResourceHandler resourceHandler = object2.next();
            string2 = this.handlerPluginMap.get(resourceHandler);
            if (!list.contains(string2) || null == (icon = resourceHandler.getIconFromUrl(uRL = resourceHandler.getIconPath(string)))) continue;
            PluginSerializationHandler.populateIconPathMap((String)object, icon, uRL);
            break;
        }
        if (null == icon && null != (icon = this.defaultResHandler.getIconFromUrl((URL)(object2 = this.defaultResHandler.getIconPath(string))))) {
            PluginSerializationHandler.populateIconPathMap((String)object, icon, (URL)object2);
        }
        return icon;
    }

    @Override
    public URL getEntry(String string) {
        return this.defaultResHandler.getEntry(string);
    }

    @Override
    public Iterator<URL> getEntryList(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>(2);
        URL uRL = this.defaultResHandler.getEntry(string);
        URL uRL2 = this.defaultResHandler.getEntry(string);
        arrayList.add(uRL);
        arrayList.add(uRL2);
        return arrayList.iterator();
    }

    public CommStyleInfo getCommStyleInfo(String string) {
        return this.defaultResHandler.getCommStyleInfo(string);
    }

    public Properties getProperties(String string) {
        return this.defaultResHandler.getProperties(string);
    }

    public void removeResourceBundle(String string) {
        PluginSerializationHandler.removeResource(string);
    }

    public void reinitProductHandler(List<String> list, List<String> list2) {
    }

    public void reinitializeResourceProductResHandlers(List<String> list) {
        if (list != null && !list.isEmpty()) {
            int n;
            String string = null;
            if (!this.remProductResHandler.isEmpty()) {
                for (ResourceHandler resourceHandler : new ArrayList<ResourceHandler>(this.remProductResHandler)) {
                    string = resourceHandler.defaultPluginName;
                    if (PluginUtil.isPluginJar(string)) {
                        n = string.lastIndexOf(".jar");
                        string = string.substring(0, n);
                    }
                    if (!list.contains(string)) continue;
                    this.productResHandler.add(resourceHandler);
                    this.handlerPluginMap.put(resourceHandler, this._pluginName);
                    this.remProductResHandler.remove(resourceHandler);
                }
            }
            for (ResourceHandler resourceHandler : new ArrayList<ResourceHandler>(this.productResHandler)) {
                string = resourceHandler.defaultPluginName;
                if (PluginUtil.isPluginJar(string)) {
                    n = string.lastIndexOf(".jar");
                    string = string.substring(0, n);
                }
                if (list.contains(string)) continue;
                this.productResHandler.remove(resourceHandler);
                this.handlerPluginMap.remove(resourceHandler);
                this.remProductResHandler.add(resourceHandler);
            }
            Collections.sort(this.productResHandler, new ProductHandlerComparator(list));
        } else if (!this.remProductResHandler.isEmpty()) {
            for (ResourceHandler resourceHandler : new ArrayList<ResourceHandler>(this.remProductResHandler)) {
                this.productResHandler.add(resourceHandler);
                this.handlerPluginMap.put(resourceHandler, this._pluginName);
                this.remProductResHandler.remove(resourceHandler);
            }
            Collections.sort(this.productResHandler, new ProductHandlerComparator(null));
        }
    }

    private class ProductHandlerComparator
    implements Comparator<ResourceHandler> {
        List<String> listOfStartupPlugins = null;

        ProductHandlerComparator(List<String> list) {
            this.listOfStartupPlugins = list;
        }

        @Override
        public int compare(ResourceHandler resourceHandler, ResourceHandler resourceHandler2) {
            String string = this.getNameWithoutJarExt(resourceHandler.defaultPluginName);
            String string2 = this.getNameWithoutJarExt(resourceHandler2.defaultPluginName);
            if (null != this.listOfStartupPlugins && !this.listOfStartupPlugins.isEmpty()) {
                int n;
                int n2 = this.listOfStartupPlugins.indexOf(string);
                return n2 < (n = this.listOfStartupPlugins.indexOf(string2)) ? 1 : (n2 == n ? 0 : -1);
            }
            return string.compareTo(string2);
        }

        private String getNameWithoutJarExt(String string) {
            if (PluginUtil.isPluginJar(string)) {
                int n = string.lastIndexOf(".jar");
                return string.substring(0, n);
            }
            return string;
        }
    }
}

