/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.CommStyleParserFactory;
import com.swimap.iview.commstyle.commini.IProfileParser;
import com.swimap.iview.commstyle.commini.PathManager;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.pluginmanagement.spi.CommStyleHandler;
import com.swimap.iview.framework.pluginmanagement.spi.PluginCommStyleHandler;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.SerializationHandler;
import com.swimap.iview.util.log.IviewLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class DefaultCommStyleParser
implements CommStyleParser {
    private static IviewLogger logger = IviewLogger.getLogger(DefaultCommStyleParser.class, "IVIEW");
    private static final String INTEGRATEDEFAULTPATH = "style/conf/";
    private CommStyleHandler defaultHandler = null;
    private String pluginId = null;
    private static final String ALL_USERS_DIR = "./style/all users/";
    private List<CommStyleHandler> productHandler = new ArrayList<CommStyleHandler>(10);
    private List<CommStyleHandler> remProductHandler = new ArrayList<CommStyleHandler>(10);
    private List<URL> productStyleURLList = new ArrayList<URL>(10);
    private Map<Object, String> urlPluginMap = new HashMap<Object, String>(10);
    private Map<Object, String> handlerPluginMap = new HashMap<Object, String>(10);
    private Map<String, String> urlDefaultPluginMap = new HashMap<String, String>(10);
    private PluginCommStyleHandler pluginCommstyleHandler = PluginCommStyleHandler.getInstance();

    public DefaultCommStyleParser(URL uRL, String string) throws MalformedURLException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.pluginId = string;
        boolean bl = SerializationHandler.isEnableSerialization();
        if (bl && this.pluginCommstyleHandler.checkPluginParserExistance(string)) {
            object5 = this.pluginCommstyleHandler.searchStyleParserURL(string);
            object4 = object5.keySet();
            object3 = null;
            object2 = object4.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                try {
                    object3 = new URL((String)object);
                    this.urlDefaultPluginMap.put((String)object, (String)object5.get(object));
                    this.productStyleURLList.add((URL)object3);
                    this.urlPluginMap.put(object, string);
                }
                catch (MalformedURLException malformedURLException) {
                    logger.trace("Exception occured while creating the url");
                }
            }
        } else {
            object5 = this.getLoadedPluginNames();
            this.searchForProductStyle((String[])object5);
        }
        object5 = null;
        if (PluginUtil.isPluginJar(uRL.toString())) {
            object5 = PluginUtil.jarPathToJarURL(uRL.toString(), INTEGRATEDEFAULTPATH);
        } else {
            try {
                object5 = new File(uRL.toURI().getPath() + INTEGRATEDEFAULTPATH).toURI().toURL();
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.trace(uRISyntaxException);
            }
        }
        this.defaultHandler = new CommStyleHandler((URL)object5, string);
        object4 = null;
        object3 = null;
        object2 = null;
        object = new ArrayList();
        for (URL uRL2 : this.productStyleURLList) {
            object3 = this.urlPluginMap.get(uRL2.toString());
            object2 = this.urlDefaultPluginMap.get(uRL2.toString());
            object4 = new CommStyleHandler(uRL2, string);
            ((CommStyleHandler)object4).defaultPluginName = object2;
            object.add(object2);
            this.productHandler.add((CommStyleHandler)object4);
            this.handlerPluginMap.put(object4, (String)object3);
        }
        logger.info("STARTUP -- PARSER READER --productStyles configured plugins are:" + object + "of Plugin:" + this.pluginId);
    }

    protected String[] getLoadedPluginNames() {
        if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
            return ApplicationUtilities.getValidPluginNamesFromApps();
        }
        String[] stringArray = PluginSubsystemUtilities.getLoadedPluginNames();
        if (null == stringArray) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    protected void addProductHandler(String string) {
        URL uRL = null;
        if (null == string) {
            return;
        }
        try {
            uRL = PluginSubsystemUtilities.getConfStyleURL(this.pluginId, string);
        }
        catch (IOException iOException) {
            logger.trace(iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null != string2) {
            return;
        }
        this.productStyleURLList.add(uRL);
        this.urlPluginMap.put(uRL.toString(), this.pluginId);
        this.urlDefaultPluginMap.put(uRL.toString(), string);
        CommStyleHandler commStyleHandler = null;
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        string3 = this.urlPluginMap.get(uRL.toString());
        string4 = this.urlDefaultPluginMap.get(uRL.toString());
        commStyleHandler = new CommStyleHandler(uRL, this.pluginId);
        commStyleHandler.defaultPluginName = string4;
        arrayList.add(string4);
        this.productHandler.add(commStyleHandler);
        this.handlerPluginMap.put(commStyleHandler, string3);
        logger.info("STARTUP -- PARSER READER --productStyles configured plugins are:" + arrayList + "of Plugin:" + this.pluginId + "is newly added");
    }

    public void removeProductHandler(String string) {
        if (null == string) {
            return;
        }
        URL uRL = null;
        try {
            uRL = PluginSubsystemUtilities.getConfStyleURL(this.pluginId, string);
        }
        catch (IOException iOException) {
            logger.trace("Unable to get the url " + iOException);
        }
        if (null == uRL) {
            return;
        }
        String string2 = this.urlDefaultPluginMap.get(uRL.toString());
        if (null == string2) {
            return;
        }
        this.productStyleURLList.remove(uRL);
        this.urlPluginMap.remove(uRL.toString());
        this.urlDefaultPluginMap.remove(uRL.toString());
        for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.productHandler)) {
            String string3 = commStyleHandler.defaultPluginName;
            if (PluginUtil.isPluginJar(string3)) {
                int n = string3.lastIndexOf(".jar");
                string3 = string3.substring(0, n);
            }
            if (null == string || !string.equals(string3)) continue;
            this.productHandler.remove(commStyleHandler);
            this.handlerPluginMap.remove(commStyleHandler);
        }
        logger.info("STARTUP -- PARSER READER --productStyles configured plugins are:" + string + "of Plugin:" + this.pluginId + "is removed");
    }

    private void searchForProductStyle(String[] stringArray) throws MalformedURLException {
        if (null == stringArray || 0 == stringArray.length) {
            return;
        }
        URL uRL = null;
        boolean bl = SerializationHandler.isEnableSerialization();
        for (String string : stringArray) {
            if (null == string) continue;
            try {
                uRL = PluginSubsystemUtilities.getConfStyleURL(this.pluginId, string);
            }
            catch (IOException iOException) {
                logger.trace(iOException);
            }
            if (null == uRL) continue;
            this.productStyleURLList.add(uRL);
            this.urlPluginMap.put(uRL.toString(), this.pluginId);
            this.urlDefaultPluginMap.put(uRL.toString(), string);
        }
        if (bl) {
            this.pluginCommstyleHandler.populateProductCommParserURLsMap(this.pluginId, this.urlDefaultPluginMap);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CommStyleInfo getCommStyleInfo(String string) {
        void var9_11;
        String string2 = string;
        CommStyleInfo commStyleInfo = this.defaultHandler.getCommStyleInfo(string2);
        if (null != commStyleInfo) {
            commStyleInfo.setAppID(this.getAppID());
        }
        ArrayList<CommStyleInfo> arrayList = new ArrayList<CommStyleInfo>(10);
        HashMap<CommStyleInfo, String> hashMap = new HashMap<CommStyleInfo, String>(10);
        String string3 = null;
        CommStyleInfo commStyleInfo2 = null;
        for (CommStyleHandler object2 : this.productHandler) {
            string3 = this.handlerPluginMap.get(object2);
            commStyleInfo2 = object2.getCommStyleInfo(string2);
            if (null != commStyleInfo2) {
                commStyleInfo2.setAppID(this.getAppID());
            }
            arrayList.add(commStyleInfo2);
            hashMap.put(commStyleInfo2, string3);
        }
        CommStyleManager commStyleManager = CommStyleManager.getInstance();
        Object var9_10 = null;
        List<String> list = PluginManager.getInstance().getLoadedPluginNames();
        for (CommStyleInfo commStyleInfo3 : arrayList) {
            string3 = (String)hashMap.get(commStyleInfo3);
            if (!list.contains(string3)) continue;
            CommStyleInfo commStyleInfo4 = commStyleManager.mergeCommStyleInfo((CommStyleInfo)var9_11, commStyleInfo3);
        }
        CommStyleInfo commStyleInfo5 = CommStyleManager.getInstance().mergeCommStyleInfo(commStyleInfo, (CommStyleInfo)var9_11);
        if (null != commStyleInfo5) {
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            commStyleInfo5.setRelatFileName(string2);
            commStyleInfo5.setFileName(commStyleInfo5.getFileName());
            commStyleInfo5.setAppID(this.getAppID());
            commStyleInfo5.setPluginName(this.pluginId);
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo5.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo5;
    }

    @Override
    public CommStyleInfo getUserCommStyleInfo(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer("conf/").append(this.pluginId).append('/').append(string2);
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getUserCommonStyleFile(stringBuffer.toString());
        if (null == commStyleInfo) {
            commStyleInfo = this.getCommStyleInfo(string2);
        } else {
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            commStyleInfo.setRelatFileName(string2);
            commStyleInfo.setFileName(System.getProperty("user.dir") + '/' + commStyleInfo.getFileName());
            commStyleInfo.setAppID(this.getAppID());
            commStyleInfo.setPluginName(this.pluginId);
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo;
    }

    @Override
    public CommStyleInfo getAllUserCommStyleInfo(String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append("conf/").append(this.pluginId).append('/').append(string2);
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getAllUsersCommonStyleFile(stringBuffer.toString());
        if (null == commStyleInfo) {
            commStyleInfo = this.getCommStyleInfo(string2);
        } else {
            if (!string2.endsWith(".xml")) {
                string2 = string2 + ".xml";
            }
            commStyleInfo.setRelatFileName(string2);
            commStyleInfo.setFileName(System.getProperty("user.dir") + '/' + commStyleInfo.getFileName());
            commStyleInfo.setAppID(this.getAppID());
            commStyleInfo.setPluginName(this.pluginId);
            Plugin plugin = PluginManager.getInstance().getPluginFromFolder(this.pluginId);
            if (null != plugin) {
                commStyleInfo.setPluginResource(plugin.getResource());
            }
        }
        return commStyleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToUser(CommStyleInfo commStyleInfo) throws IOException {
        CommStyleParserFactory commStyleParserFactory = CommStyleParserFactory.getInstance();
        IProfileParser iProfileParser = commStyleParserFactory.createProfileParser();
        if (null == commStyleInfo || null == iProfileParser) {
            throw new IllegalArgumentException("CommStyleInfo is null.");
        }
        String string = commStyleInfo.getRelatFileName();
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            commStyleInfo.marshal(byteArrayOutputStream);
            iProfileParser.write(((Object)byteArrayOutputStream).toString(), this.buildUserPath() + "conf/" + this.pluginId + '/' + string);
        }
        finally {
            if (null != byteArrayOutputStream) {
                ((OutputStream)byteArrayOutputStream).close();
            }
        }
    }

    @Override
    public void writeToAllUsers(CommStyleInfo commStyleInfo) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(16);
        if (null == commStyleInfo) {
            logger.error("write error,Not able to write the user profile information ");
            throw new IllegalArgumentException();
        }
        String string = commStyleInfo.getRelatFileName();
        if (null == string) {
            logger.error("file name is null for CommstyleInfo");
            throw new IllegalArgumentException();
        }
        stringBuffer.append(ALL_USERS_DIR).append("conf/").append(this.pluginId).append('/').append(commStyleInfo.getRelatFileName());
        File file = CommonUtil.getAbsoluteFile(stringBuffer.toString());
        commStyleInfo.writeStyle(file.getAbsolutePath());
    }

    private String buildUserPath() {
        String string = PathManager.getInstance().getUserInfoPath();
        if (null != string && string.length() > 0) {
            return string;
        }
        return CommStyleManager.getInstance().getUserDir();
    }

    @Override
    public URL getEntry(String string) {
        return this.defaultHandler.getEntry(string);
    }

    @Override
    public Iterator<URL> getEntryList(String string) {
        return null;
    }

    public void reinitProductHandler(List<String> list, List<String> list2) {
    }

    Icon getIcon(String string) {
        if (null == string || string.trim().length() == 0) {
            return null;
        }
        logger.log((Priority)Level.TRACE, "plugin.IconFile.iview=" + this.pluginId + ':' + string);
        String string2 = PluginSerializationHandler.getSerializationKey(this.getAppID() + this.pluginId, "conf : " + string);
        if (PluginSerializationHandler.checkExistance(string2)) {
            return PluginSerializationHandler.getIcon(string2);
        }
        ImageIcon imageIcon = null;
        String string3 = null;
        List<String> list = PluginManager.getInstance().getLoadedPluginNames();
        for (CommStyleHandler commStyleHandler : this.productHandler) {
            string3 = this.handlerPluginMap.get(commStyleHandler);
            if (!list.contains(string3)) continue;
            URL uRL = commStyleHandler.getEntryURL(string);
            if (null != uRL) {
                imageIcon = new ImageIcon(uRL);
            }
            if (null == imageIcon) continue;
            PluginSerializationHandler.populateIconPathMap(string2, imageIcon, uRL);
            break;
        }
        if (null == imageIcon) {
            URL uRL = this.defaultHandler.getEntryURL(string);
            if (null != uRL) {
                imageIcon = new ImageIcon(uRL);
            }
            if (null != imageIcon) {
                PluginSerializationHandler.populateIconPathMap(string2, imageIcon, uRL);
            }
        }
        return imageIcon;
    }

    protected String getAppID() {
        return "";
    }

    public void reinitializeParserProductHandlers(List<String> list) {
        if (list != null && !list.isEmpty()) {
            int n;
            String string = null;
            if (!this.remProductHandler.isEmpty()) {
                for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.remProductHandler)) {
                    string = commStyleHandler.defaultPluginName;
                    if (PluginUtil.isPluginJar(string)) {
                        n = string.lastIndexOf(".jar");
                        string = string.substring(0, n);
                    }
                    if (!list.contains(string)) continue;
                    this.productHandler.add(commStyleHandler);
                    this.handlerPluginMap.put(commStyleHandler, this.pluginId);
                    this.remProductHandler.remove(commStyleHandler);
                }
            }
            for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.productHandler)) {
                string = commStyleHandler.defaultPluginName;
                if (PluginUtil.isPluginJar(string)) {
                    n = string.lastIndexOf(".jar");
                    string = string.substring(0, n);
                }
                if (list.contains(string)) continue;
                this.productHandler.remove(commStyleHandler);
                this.handlerPluginMap.remove(commStyleHandler);
                this.remProductHandler.add(commStyleHandler);
            }
            Collections.sort(this.productHandler, new ProductHandlerComparator(list));
        } else if (!this.remProductHandler.isEmpty()) {
            for (CommStyleHandler commStyleHandler : new ArrayList<CommStyleHandler>(this.remProductHandler)) {
                this.productHandler.add(commStyleHandler);
                this.handlerPluginMap.put(commStyleHandler, this.pluginId);
                this.remProductHandler.remove(commStyleHandler);
            }
            Collections.sort(this.productHandler, new ProductHandlerComparator(null));
        }
    }

    private class ProductHandlerComparator
    implements Comparator<CommStyleHandler> {
        List<String> listOfStartupPlugins = null;

        ProductHandlerComparator(List<String> list) {
            this.listOfStartupPlugins = list;
        }

        @Override
        public int compare(CommStyleHandler commStyleHandler, CommStyleHandler commStyleHandler2) {
            String string = this.getNameWithoutJarExt(commStyleHandler.defaultPluginName);
            String string2 = this.getNameWithoutJarExt(commStyleHandler2.defaultPluginName);
            if (null != this.listOfStartupPlugins && !this.listOfStartupPlugins.isEmpty()) {
                int n;
                int n2 = this.listOfStartupPlugins.indexOf(string);
                return n2 < (n = this.listOfStartupPlugins.indexOf(string2)) ? 1 : (n2 == n ? 0 : -1);
            }
            return string.compareTo(string2);
        }

        private String getNameWithoutJarExt(String string) {
            if (PluginUtil.isPluginJar(string)) {
                int n = string.lastIndexOf(".jar");
                return string.substring(0, n);
            }
            return string;
        }
    }
}

