/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import sun.net.www.ParseUtil;

public class CommStyleHandler {
    private static IviewLogger logger = IviewLogger.getLogger(CommStyleHandler.class, "IVIEW");
    private static final String XML_SUFFIX = ".xml";
    private URL path = null;
    private String pluginName = "";
    protected String defaultPluginName = "";

    public CommStyleHandler(URL uRL, String string) {
        this.path = uRL;
        this.pluginName = string;
    }

    public CommStyleInfo getCommStyleInfo(String string) {
        URL uRL;
        String string2 = string;
        if (!string2.endsWith(XML_SUFFIX)) {
            string2 = string2 + XML_SUFFIX;
        }
        if (null != (uRL = this.getEntryURL(string2))) {
            CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(uRL);
            if (null != commStyleInfo) {
                String string3 = ParseUtil.decode(uRL.getFile());
                commStyleInfo.setFileName(string3);
                commStyleInfo.setPluginName(this.pluginName);
            }
            return commStyleInfo;
        }
        return null;
    }

    public URL getEntry(String string) {
        URL uRL;
        URL uRL2 = null;
        String string2 = this.path + string;
        try {
            uRL2 = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage(), malformedURLException);
        }
        if ((string2.contains(".jar") || !FrameworkUtilities.exist(uRL2)) && (uRL = PluginSubsystemUtilities.getURLFromJar(this.path.getFile(), string)) != null) {
            return uRL;
        }
        return uRL2;
    }

    protected URL getEntryURL(String string) {
        URL uRL = null;
        try {
            try {
                File file = new File(this.path.toURI().getPath() + string);
                if (file.exists()) {
                    return file.toURI().toURL();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                logger.trace(uRISyntaxException);
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage(), malformedURLException);
        }
        if (PluginUtil.PGN_JAR) {
            uRL = this.getEntry(string);
            if (FrameworkUtilities.exist(uRL)) {
                return uRL;
            }
            return null;
        }
        return uRL;
    }
}

