/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement.spi;

import com.swimap.iview.commstyle.commini.AreaDescContainer;
import com.swimap.iview.commstyle.commini.CommStyleInfo;
import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.commini.DescContainer;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.modulemanagement.ModuleInformation;
import com.swimap.iview.framework.modulemanagement.ModuleList;
import com.swimap.iview.framework.modulemanagement.ModuleManagementException;
import com.swimap.iview.framework.pluginmanagement.CommStyleParser;
import com.swimap.iview.framework.pluginmanagement.DuplicateModuleLoadException;
import com.swimap.iview.framework.pluginmanagement.InvalidPluginException;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.pluginmanagement.Resource;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultCommStyleParser;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultResourceReader;
import com.swimap.iview.framework.pluginmanagement.spi.IntegrateCommStyleReader;
import com.swimap.iview.framework.util.FrameworkUtilities;
import com.swimap.iview.util.log.IviewLogger;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.Icon;

public abstract class AbstractPlugin
implements Plugin {
    private static final long serialVersionUID = -3309822124035938349L;
    private static IviewLogger logger = IviewLogger.getLogger(AbstractPlugin.class, "IVIEW");
    private String id = null;
    private String pluginName = null;
    private URL rootURL = null;
    private transient Resource resource = null;
    private transient CommStyleParser commStyleParser = null;
    private transient CommStyleParser integrateCommStyleReader = null;
    private ModuleInformation moduleInformation = null;
    private Map<String, Object> pluginPropertyMap = null;

    public boolean isSelfClass() {
        return false;
    }

    public AbstractPlugin(URL uRL) throws MalformedURLException, InvalidPluginException, DuplicateModuleLoadException {
        if (null == uRL) {
            throw new IllegalArgumentException("The pluginURL cannot be null.");
        }
        this.rootURL = uRL;
        this.resource = new DefaultResourceReader(this.rootURL);
        URL uRL2 = this.getEntry("module.xml");
        CommStyleInfo commStyleInfo = CommStyleManager.getInstance().getStyleInfoFromURL(uRL2);
        if (null == commStyleInfo) {
            String string = uRL.toString();
            String string2 = string.substring(0, string.length() - 1);
            string2 = string2.substring(string2.lastIndexOf("/") + 1, string2.length());
            throw new InvalidPluginException("There is no module.xml in root directory of plugin: " + string2);
        }
        ModuleList moduleList = null;
        try {
            moduleList = ModuleList.loadModuleList(commStyleInfo, this.isSelfClass());
        }
        catch (ModuleManagementException moduleManagementException) {
            throw new InvalidPluginException(moduleManagementException);
        }
        if (null == moduleList) {
            String string = this.getModuleIDFromCommStyleInfo(commStyleInfo);
            String string3 = PluginUtil.getNameFromPluginURL(uRL);
            PluginManager.populateFailedPluginModuleMap(string3, string);
            throw new DuplicateModuleLoadException("Module id is all ready exists : ");
        }
        if (moduleList.getModuleList().size() > 0) {
            this.moduleInformation = (ModuleInformation)moduleList.getModuleList().get(0);
            this.id = this.moduleInformation.getModuleName();
            if (null == this.id) {
                throw new InvalidPluginException("Cannot get the module ID from module.xml of plugin: ");
            }
            this.pluginName = PluginUtil.getNameFromPluginURL(uRL);
        }
    }

    @Override
    public Resource getResource() {
        if (this.resource == null) {
            try {
                this.resource = new DefaultResourceReader(this.rootURL);
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException);
            }
        }
        return this.resource;
    }

    @Override
    public CommStyleParser getCommStyleParser() {
        if (null == this.commStyleParser) {
            try {
                this.commStyleParser = new DefaultCommStyleParser(this.rootURL, this.pluginName);
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
        }
        return this.commStyleParser;
    }

    @Override
    public CommStyleParser getIntegrateCommStyleReader() {
        if (null == this.integrateCommStyleReader) {
            try {
                this.integrateCommStyleReader = new IntegrateCommStyleReader(this.rootURL, this.pluginName);
            }
            catch (MalformedURLException malformedURLException) {
                logger.trace(malformedURLException.getMessage(), malformedURLException);
            }
        }
        return this.integrateCommStyleReader;
    }

    public void clearIntegrateReader() {
        this.integrateCommStyleReader = null;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPluginName() {
        return this.pluginName;
    }

    @Override
    public URL getEntry(String string) {
        URL uRL = null;
        try {
            URL uRL2;
            String string2 = this.rootURL.toString();
            if (PluginUtil.isPluginJar(string2)) {
                uRL = PluginSubsystemUtilities.getURLFromJar(this.getAbsoulteURLPath(), string);
                if (null == uRL) {
                    uRL = PluginUtil.jarPathToJarURL(string2, string);
                }
            } else {
                uRL = new URL(this.rootURL + string);
            }
            if (!FrameworkUtilities.exist(uRL) && (uRL2 = PluginSubsystemUtilities.getURLFromJar(this.getAbsoulteURLPath(), string)) != null) {
                return uRL2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    private synchronized Map<String, Object> getPluginProperty() {
        if (null == this.pluginPropertyMap) {
            this.pluginPropertyMap = new HashMap<String, Object>(10);
        }
        return this.pluginPropertyMap;
    }

    @Override
    public final Object getPluginProperty(String string) {
        return this.getPluginProperty().get(string);
    }

    @Override
    public final void putPluginProperty(String string, Object object) {
        if (null == object) {
            this.getPluginProperty().remove(string);
        } else {
            this.getPluginProperty().put(string, object);
        }
    }

    @Override
    public ModuleInformation getModuleInfomation() {
        return this.moduleInformation;
    }

    public String toString() {
        return this.rootURL.toString();
    }

    @Override
    public URL getURL() {
        return this.rootURL;
    }

    public URL getAbsoluteURL() {
        URL uRL = null;
        try {
            String string = this.rootURL.toURI().getPath();
            uRL = new URL("file", null, string);
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.trace(uRISyntaxException);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException);
        }
        return uRL;
    }

    public void setURL(URL uRL) {
        if (null != uRL) {
            this.rootURL = uRL;
        }
        logger.trace("URL " + uRL + " set for plugin " + this.pluginName);
    }

    private String getAbsoulteURLPath() {
        try {
            return this.rootURL.toURI().getPath();
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.trace(uRISyntaxException);
            return null;
        }
    }

    @Override
    public abstract Class loadClass(String var1) throws ClassNotFoundException;

    @Override
    public Icon getConfIcon(String string) {
        return ((DefaultCommStyleParser)this.getCommStyleParser()).getIcon(string);
    }

    private String getModuleIDFromCommStyleInfo(CommStyleInfo commStyleInfo) {
        AreaDescContainer areaDescContainer = commStyleInfo.getAreaDescContainer("modulelist");
        int n = areaDescContainer.getDescCount();
        DescContainer descContainer = null;
        ResourceBundle resourceBundle = null;
        String string = null;
        for (int i = 0; i < n; ++i) {
            String string2;
            descContainer = areaDescContainer.getDescContainer(i);
            string = descContainer.getParasItemValue("type");
            if ("ResourceBundle".equals(string)) {
                string2 = descContainer.getParasItemValue("resourceBundleName");
                try {
                    resourceBundle = ResourceMng.getInstance().getResourceBundleFromPropertyFile(string2);
                    if (null != resourceBundle) continue;
                    resourceBundle = ResourceBundle.getBundle(string2);
                }
                catch (Exception exception) {
                    logger.trace(exception.getMessage(), exception);
                }
                continue;
            }
            try {
                string2 = descContainer.getDescName();
                return string2;
            }
            catch (Exception exception) {
                logger.trace(exception.getMessage(), exception);
                logger.trace(" The module desc in style file is error, the index is : " + i);
            }
        }
        return null;
    }
}

