/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.commstyle.resource.PropertyResourceBundleEx;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.commstyle.resource.i18n.Utils;
import com.swimap.iview.framework.applicationmanagement.ApplicationUtilities;
import com.swimap.iview.framework.pluginmanagement.Plugin;
import com.swimap.iview.framework.pluginmanagement.PluginManager;
import com.swimap.iview.framework.pluginmanagement.PluginSerializationHandler;
import com.swimap.iview.framework.pluginmanagement.PluginSubsystemUtilities;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultCommStyleParser;
import com.swimap.iview.framework.pluginmanagement.spi.DefaultResourceReader;
import com.swimap.iview.framework.pluginmanagement.spi.IntegrateCommStyleReader;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;

public class PluginUtil {
    private static IviewLogger logger = IviewLogger.getLogger(PluginUtil.class, "IVIEW");
    private static final String PLUGINS_FOLDER = "plugins";
    private static final String JAR_SUFFIX = ".jar";
    private static List<String> linkPath = null;
    private static String pathName = "link.properties";
    public static final String LINK_PATH = "path";
    private static List<String> folderList = null;
    private static File[] pluginFileArray = null;
    public static boolean PGN_JAR = PluginSubsystemUtilities.patchPluginExists;

    public static URL jarPathToJarURL(String string, String string2) {
        URL uRL = null;
        try {
            uRL = new URL("jar:" + string + "!/" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.warn(malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    public static URL pluginPathToJarURL(String string, String string2) {
        URL uRL = null;
        try {
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            uRL = new URL("jar:file:/" + string + "!/" + string2);
        }
        catch (MalformedURLException malformedURLException) {
            logger.warn(malformedURLException.getMessage(), malformedURLException);
        }
        return uRL;
    }

    public static boolean isPluginJar(String string) {
        return string.endsWith(JAR_SUFFIX);
    }

    public static File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    public static File[] getAllPluginFile(List list) {
        File[] fileArray = PluginUtil.getPluginFileList();
        if (null != fileArray) {
            ArrayList<File> arrayList = new ArrayList<File>(fileArray.length);
            File file = null;
            String string = null;
            for (int i = 0; i < fileArray.length; ++i) {
                String string2;
                file = fileArray[i];
                string = file.getName();
                if (file.isDirectory() && list.contains(string)) {
                    list.remove(string);
                    arrayList.add(file);
                    continue;
                }
                if (!string.endsWith(JAR_SUFFIX) || !list.contains(string2 = string.substring(0, string.length() - 4))) continue;
                PGN_JAR = true;
                list.remove(string2);
                arrayList.add(file);
            }
            fileArray = arrayList.toArray(new File[arrayList.size()]);
        }
        return fileArray;
    }

    private static File[] getPluginFileList() {
        if (null != pluginFileArray) {
            return pluginFileArray;
        }
        File file = new File(PluginUtil.getUserDir(), PLUGINS_FOLDER);
        if (file.exists()) {
            Object[] objectArray = file.listFiles();
            Arrays.sort(objectArray);
            pluginFileArray = objectArray;
        }
        return pluginFileArray;
    }

    public static String getNameFromPluginURL(URL uRL) {
        String string = null;
        String string2 = uRL.getPath();
        if (PluginUtil.isPluginJar(string2)) {
            string = string2.replaceAll("%20", " ");
            string = string.replaceAll(JAR_SUFFIX, "/");
        } else {
            string = string2.replaceAll("%20", " ");
        }
        string = string.substring(0, string.lastIndexOf("/"));
        string = string.substring(string.lastIndexOf("/") + 1, string.length());
        return string;
    }

    public static String getPath(URL uRL) {
        String string = null;
        if (uRL.toString().startsWith("file")) {
            string = uRL.toString().substring(6);
        }
        return string;
    }

    public static Properties mergeProperties(Properties properties, Properties properties2) {
        Properties properties3 = null;
        if (null == properties && null == properties2) {
            properties3 = new Properties();
        } else if (null == properties || null == properties2) {
            properties3 = null != properties ? properties : properties2;
        } else {
            Enumeration<?> enumeration = properties2.propertyNames();
            boolean bl = enumeration.hasMoreElements();
            String string = null;
            while (bl) {
                string = (String)enumeration.nextElement();
                properties.put(string, properties2.getProperty(string));
                bl = enumeration.hasMoreElements();
            }
            properties3 = properties;
        }
        return properties3;
    }

    public static boolean isPluginExist(String string) {
        String[] stringArray;
        if (null != folderList) {
            return folderList.contains(string);
        }
        File file = new File(PluginUtil.getUserDir(), PLUGINS_FOLDER);
        if (file.exists() && (stringArray = file.list()).length > 0) {
            folderList = Arrays.asList(stringArray);
            return folderList.contains(string);
        }
        return false;
    }

    public static String getPluginPath(String string) {
        if (!PluginUtil.isPluginExist(string)) {
            throw new IllegalArgumentException("Plugin name is not valid.");
        }
        return System.getProperty("user.dir") + System.getProperty("file.separator") + PLUGINS_FOLDER + System.getProperty("file.separator") + string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public static boolean checklinkExists() {
        if (null != linkPath) {
            return true;
        }
        String string = System.getProperty("linkfile");
        File file = null;
        if (null != string) {
            file = CommonUtil.getAbsoluteFile(string);
            if (!file.exists()) {
                string = pathName;
                file = CommonUtil.getAbsoluteFile(string);
            }
        } else {
            string = pathName;
            file = CommonUtil.getAbsoluteFile(string);
        }
        if (file.exists()) {
            InputStream inputStream = null;
            try {
                String string2 = null;
                Properties properties = ResourceMng.getProperties(string);
                PropertyResourceBundleEx propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
                if (null != properties && null != (inputStream = Utils.getInputStream(string))) {
                    string2 = Utils.getEncoding(inputStream);
                }
                propertyResourceBundleEx.setEncoding(string2);
                String string3 = propertyResourceBundleEx.getString(LINK_PATH);
                linkPath = new ArrayList<String>(2);
                for (String string4 : string3.split(";")) {
                    linkPath.add(string4.trim());
                }
                String string5 = System.getProperty("defaultlinkfile");
                File file2 = null;
                if (null != string5) {
                    file2 = CommonUtil.getAbsoluteFile(string5);
                    if (!file2.exists()) {
                        String string6 = "defaultlink.properties";
                        file2 = CommonUtil.getAbsoluteFile(string6);
                    }
                } else {
                    String string7 = "defaultlink.properties";
                    file2 = CommonUtil.getAbsoluteFile(string7);
                }
                if (file2.exists()) {
                    void var7_14;
                    properties = ResourceMng.getProperties((String)var7_14);
                    propertyResourceBundleEx = new PropertyResourceBundleEx(properties);
                    string3 = propertyResourceBundleEx.getString(LINK_PATH);
                    for (String string8 : string3.split(";")) {
                        linkPath.add(string8.trim());
                    }
                }
                int n = 1;
                return n != 0;
            }
            catch (MissingResourceException missingResourceException) {
                logger.warn("Content of property file is incorrect: ");
                boolean bl = false;
                return bl;
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        logger.warn(iOException);
                    }
                }
            }
        }
        return false;
    }

    public static List<String> getLinkPath() {
        return linkPath;
    }

    public static List<String> getPluginFolders() {
        return SubsystemManager.getInstance().getLoadedSubsystemAllPluginList();
    }

    public static void setLinkPath(List<String> list, List<String> list2) {
    }

    public static void reinitalizeProductHandlers(List<String> list) {
        if (Boolean.valueOf(System.getProperty("iView.ServerPlugins.Changed")).booleanValue()) {
            PluginSerializationHandler.clear();
        }
        List<Plugin> list2 = null;
        list2 = FrameworkCommandProcessor.getInstance().isAppStyle() ? ApplicationUtilities.getAllStartupPluginsList() : PluginManager.getInstance().getStartupPluginList();
        if (null != list2 && !list2.isEmpty()) {
            IntegrateCommStyleReader integrateCommStyleReader = null;
            DefaultResourceReader defaultResourceReader = null;
            DefaultCommStyleParser defaultCommStyleParser = null;
            for (Plugin plugin : list2) {
                integrateCommStyleReader = (IntegrateCommStyleReader)plugin.getIntegrateCommStyleReader();
                integrateCommStyleReader.reinitializeIntegrateProductHandlers(list);
                defaultResourceReader = (DefaultResourceReader)plugin.getResource();
                defaultResourceReader.reinitializeResourceProductResHandlers(list);
                defaultCommStyleParser = (DefaultCommStyleParser)plugin.getCommStyleParser();
                defaultCommStyleParser.reinitializeParserProductHandlers(list);
            }
        }
    }

    public static void clearWhileSwitchStyle() {
        PluginSerializationHandler.clear();
        IntegrateCommStyleReader.clear();
    }
}

