/*
 * Decompiled with CFR 0.152.
 */
package com.swimap.iview.framework.pluginmanagement;

import com.swimap.iview.commstyle.commini.CommStyleManager;
import com.swimap.iview.commstyle.resource.ResourceMng;
import com.swimap.iview.framework.StartupXMLReader;
import com.swimap.iview.framework.pluginmanagement.PluginDefinitionHandler;
import com.swimap.iview.framework.pluginmanagement.PluginUtil;
import com.swimap.iview.framework.subsystemmanagement.SubsystemManager;
import com.swimap.iview.framework.util.FrameworkCommandProcessor;
import com.swimap.iview.framework.util.IStartupElement;
import com.swimap.iview.framework.util.StartupFactory;
import com.swimap.iview.util.CommonUtil;
import com.swimap.iview.util.log.IviewLogger;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PluginSubsystemUtilities {
    private static IviewLogger logger = IviewLogger.getLogger(PluginSubsystemUtilities.class, "IVIEW");
    private static URL clientURL = null;
    private static final String PLUGIN_DIR = "plugins/";
    private static final String FEATURES_DIR = "features/";
    private static final String PRODUCT_STYLE_DIR = "style/productstyle/";
    private static final String SINGLE_PATH = "single/";
    private static final String COMPLEX_PATH = "complex/";
    private static final String CONF_DIR = "/conf/";
    private static final int JAR_INDEX = 4;
    private static final int SIZE = 5;
    private static final File userDir = new File(System.getProperty("user.dir"));
    private static List<String> startupPluginNames = null;
    static boolean patchPluginExists = PluginSubsystemUtilities.isInPatch("plugins/");
    public static boolean patchFeatureExists = false;
    private static HashMap<String, File[]> pluginProductStyleDirs = new HashMap();
    private static boolean needToCheckInPatch = PluginSubsystemUtilities.needsToCheckPatchPluginOrFeature();
    private static FileFilter dirFilter = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }
    };
    private static String[] loadedPluginNames = null;

    public static String[] getAllPluginNames(List<String> list) {
        if (null == list || list.size() == 0) {
            return new String[0];
        }
        Object[] objectArray = null;
        ArrayList<String> arrayList = new ArrayList<String>(list);
        String[] stringArray = PluginSubsystemUtilities.getPluginFromFolder(arrayList);
        String[] stringArray2 = new String[]{};
        ArrayList<String> arrayList2 = null;
        String string = null;
        for (String string2 : arrayList) {
            string = PLUGIN_DIR + string2;
            if (!patchPluginExists || !PluginSubsystemUtilities.isInPatch(string)) continue;
            logger.trace("Plugin " + string2 + " got from patch");
            if (null == arrayList2) {
                arrayList2 = new ArrayList<String>(arrayList.size());
            }
            arrayList2.add(string2);
        }
        if (null != arrayList2) {
            stringArray2 = arrayList2.toArray(new String[arrayList2.size()]);
        }
        objectArray = PluginSubsystemUtilities.mergeArrays(stringArray, stringArray2);
        Arrays.sort(objectArray);
        return objectArray;
    }

    public static String[] mergeArrays(String[] stringArray, String[] stringArray2) {
        List<String> list;
        String[] stringArray3;
        int n = 0;
        if (null != stringArray) {
            n = stringArray.length;
        }
        int n2 = 0;
        if (null != stringArray2) {
            n2 = stringArray2.length;
        }
        int n3 = n + n2;
        HashSet<String> hashSet = new HashSet<String>(n3);
        if (null != stringArray) {
            stringArray3 = stringArray;
            list = Arrays.asList(stringArray3);
            hashSet.addAll(list);
        }
        if (null != stringArray2) {
            stringArray3 = stringArray2;
            list = Arrays.asList(stringArray3);
            hashSet.addAll(list);
        }
        stringArray3 = hashSet.toArray(new String[hashSet.size()]);
        return stringArray3;
    }

    private static String[] getPluginFromFolder(final List<String> list) {
        File file = PluginUtil.getUserDir();
        String[] stringArray = new String[]{};
        File file2 = new File(file, PLUGIN_DIR);
        if (file2.exists()) {
            List<String> list2 = PluginDefinitionHandler.getPluginDefinitionHandler().getPluginNamesFromXML();
            boolean bl = FrameworkCommandProcessor.getInstance().isServerPluginsModified();
            if (!(bl || FrameworkCommandProcessor.getInstance().isAppStyle() || list2.isEmpty())) {
                ArrayList<String> arrayList = new ArrayList<String>();
                for (String string : list2) {
                    if (!list.contains(string)) continue;
                    arrayList.add(string);
                }
                stringArray = arrayList.toArray(new String[arrayList.size()]);
            } else {
                FilenameFilter filenameFilter = new FilenameFilter(){

                    @Override
                    public boolean accept(File file, String string) {
                        String string2;
                        if (file.isDirectory() && list.contains(string)) {
                            list.remove(string);
                            return true;
                        }
                        if (string.endsWith(".jar") && list.contains(string2 = string.substring(0, string.length() - 4))) {
                            list.remove(string2);
                            return true;
                        }
                        return false;
                    }
                };
                stringArray = file2.list(filenameFilter);
            }
        }
        return stringArray;
    }

    public static URL getPluginURL(String string) {
        URL uRL = null;
        try {
            if (null == clientURL) {
                clientURL = userDir.toURI().toURL();
            }
            if (PluginUtil.isPluginJar(string)) {
                uRL = new URL(clientURL + PLUGIN_DIR + string);
            } else {
                try {
                    uRL = new File(clientURL.toURI().getPath() + PLUGIN_DIR + string, System.getProperty("file.separator")).toURI().toURL();
                }
                catch (URISyntaxException uRISyntaxException) {
                    logger.trace(uRISyntaxException);
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            logger.error("Unable to create the URL", malformedURLException);
        }
        return uRL;
    }

    public static URL getURLFromJar(String string, String string2) {
        URL uRL = null;
        if (patchPluginExists) {
            String string3 = string.substring(string.lastIndexOf(PLUGIN_DIR), string.length());
            string3 = string3.replaceAll(".jar", "");
            string3 = string3.replaceAll("!", "/");
            String string4 = string3 + '/' + string2;
            string4 = string4.replaceAll("//", "/");
            uRL = CommStyleManager.getURLFromJar(string4);
        }
        return uRL;
    }

    public static URL getIntegrateStyleURL(String string, String string2) throws MalformedURLException, IOException {
        String string3 = PRODUCT_STYLE_DIR + string + "/integrate/" + PluginSubsystemUtilities.getIntegratePath();
        return PluginSubsystemUtilities.getProductStyleURL(string, string2, string3, "integrate");
    }

    public static URL getAppStyleURL(String string, String string2) throws MalformedURLException, IOException {
        String string3 = PRODUCT_STYLE_DIR + string + "/integrate/" + "app/";
        return PluginSubsystemUtilities.getProductStyleURL(string, string2, string3, "app");
    }

    public static URL getConfStyleURL(String string, String string2) throws MalformedURLException, IOException {
        String string3 = PRODUCT_STYLE_DIR + string + CONF_DIR;
        return PluginSubsystemUtilities.getProductStyleURL(string, string2, string3, "conf");
    }

    public static URL getResourceURL(String string, String string2) throws MalformedURLException, IOException {
        String string3 = PRODUCT_STYLE_DIR + string + "/locale" + '/' + ResourceMng.getInstance().getLocaleString() + '/';
        return PluginSubsystemUtilities.getProductStyleURL(string, string2, string3, "locale");
    }

    public static URL getProductStyleURL(String string, String string2, String string3, String string4) throws MalformedURLException, IOException {
        URL uRL = null;
        uRL = PluginUtil.isPluginJar(string2) ? PluginSubsystemUtilities.getURLFromPluginJar(string2, string3) : PluginSubsystemUtilities.getURLFromFolder(string, string2, string4);
        if (null == uRL) {
            String string5 = string2.replaceAll(".jar", "");
            String string6 = PLUGIN_DIR + string5 + '/' + string3;
            if (patchPluginExists && PluginSubsystemUtilities.isInPatch(string6)) {
                logger.trace("Plugin " + string2 + " not exists in plugins folder checking in patch");
                if (PluginUtil.isPluginJar(string2)) {
                    String string7 = userDir.toString() + '/' + PLUGIN_DIR + string2;
                    uRL = PluginUtil.pluginPathToJarURL(string7, string3);
                } else {
                    URL uRL2 = PluginSubsystemUtilities.getPluginURL(string2);
                    uRL = new URL(uRL2 + string3);
                }
            }
        }
        return uRL;
    }

    private static URL getURLFromFolder(String string, String string2, String string3) throws MalformedURLException, IOException {
        URL uRL = null;
        File file = null;
        File[] fileArray = null;
        if (pluginProductStyleDirs.containsKey(string2)) {
            fileArray = pluginProductStyleDirs.get(string2);
        } else {
            try {
                file = new File(PluginUtil.getPluginPath(string2), PRODUCT_STYLE_DIR);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.trace("Plugin " + string2 + " not exsist in the plugins folder " + illegalArgumentException);
                return uRL;
            }
            if (null != file) {
                fileArray = file.listFiles(dirFilter);
            }
            pluginProductStyleDirs.put(string2, fileArray);
        }
        if (null != fileArray) {
            int n = fileArray.length;
            File file2 = null;
            for (int i = 0; i < n; ++i) {
                file2 = fileArray[i];
                if (!file2.getName().equals(string)) continue;
                if ("integrate".equals(string3)) {
                    uRL = new URL(file2.toURI().toURL() + "integrate/" + PluginSubsystemUtilities.getIntegratePath());
                    break;
                }
                if ("conf".equals(string3)) {
                    uRL = new URL(file2.toURI().toURL() + "conf/");
                    break;
                }
                if ("app".equals(string3)) {
                    uRL = new URL(file2.toURI().toURL() + "integrate/app/");
                    break;
                }
                uRL = new URL(file2.toURI().toURL() + "locale" + '/' + ResourceMng.getInstance().getLocaleString() + '/');
                break;
            }
        }
        return uRL;
    }

    public static URL getURLFromPluginJar(String string, String string2) throws IOException {
        URL uRL = null;
        File file = PluginUtil.getUserDir();
        String string3 = file.toString() + '/' + PLUGIN_DIR + string;
        JarFile jarFile = new JarFile(string3);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        JarEntry jarEntry = null;
        String string4 = null;
        if (null != string2) {
            while (enumeration.hasMoreElements()) {
                jarEntry = enumeration.nextElement();
                string4 = jarEntry.getName();
                if (!string2.equals(string4)) continue;
                uRL = PluginUtil.pluginPathToJarURL(string3, string4);
                break;
            }
        }
        try {
            if (null != jarFile) {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            logger.trace(iOException.getMessage(), iOException);
        }
        return uRL;
    }

    private static boolean isInPatch(String string) {
        if (needToCheckInPatch) {
            URL uRL = CommStyleManager.getURLFromJar(string);
            return uRL != null && uRL.getProtocol().equals("jar");
        }
        return false;
    }

    private static String getIntegratePath() {
        SubsystemManager.LoadMode loadMode = SubsystemManager.getInstance().getClientLoadMode();
        if (SubsystemManager.LoadMode.single == loadMode) {
            return SINGLE_PATH;
        }
        return COMPLEX_PATH;
    }

    public static String[] getSubFolderFromAllPaths(String string) {
        Object object;
        if (PluginSubsystemUtilities.isInPatch(FEATURES_DIR)) {
            patchFeatureExists = true;
        }
        if (!PluginSubsystemUtilities.isExist(string)) {
            return new String[0];
        }
        String[] stringArray = new String[]{};
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        String[] stringArray4 = new String[]{};
        URL[] uRLArray = PluginSubsystemUtilities.getAllSubFoldersFromJar(string);
        if (null != uRLArray) {
            object = uRLArray;
            int n = ((URL[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2 = object[i];
                if (null == object2) continue;
                stringArray2 = PluginSubsystemUtilities.getAllFilefromJar((URL)object2);
                stringArray4 = PluginSubsystemUtilities.mergeArrays(stringArray2, stringArray4);
            }
        }
        if (((File)(object = CommonUtil.getAbsoluteFile(string))).exists()) {
            stringArray = PluginSubsystemUtilities.getAllFilesFromFolder((File)object);
        }
        stringArray3 = PluginSubsystemUtilities.mergeArrays(stringArray4, stringArray);
        return stringArray3;
    }

    private static URL[] getAllSubFoldersFromJar(String string) {
        return CommStyleManager.getURLFromAllJar(string);
    }

    private static String[] getAllFilesFromFolder(File file) {
        String[] stringArray = new String[]{};
        File[] fileArray = file.listFiles(dirFilter);
        if (fileArray != null && fileArray.length > 0) {
            ArrayList<String> arrayList = new ArrayList<String>(5);
            for (int i = 0; i < fileArray.length; ++i) {
                arrayList.add(fileArray[i].getName());
            }
            stringArray = arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    private static String[] getAllFilefromJar(URL uRL) {
        Vector<String> vector = new Vector<String>(5);
        if (null != uRL) {
            try {
                JarFile jarFile;
                String string = uRL.getPath();
                String string2 = string.substring(string.indexOf("!") + 2);
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection && null != (jarFile = ((JarURLConnection)uRLConnection).getJarFile())) {
                    String string3 = null;
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (null != enumeration && enumeration.hasMoreElements()) {
                        string3 = PluginSubsystemUtilities.process(enumeration.nextElement(), string2);
                        if (string3 == null) continue;
                        vector.add(string3);
                    }
                }
            }
            catch (IOException iOException) {
                logger.trace(iOException.getMessage(), iOException);
            }
        }
        return vector.toArray(new String[vector.size()]);
    }

    private static String process(JarEntry jarEntry, String string) {
        String string2 = jarEntry.getName();
        if (string2.startsWith(string) && (string2 = string.charAt(string.length() - 1) == '/' ? string2.substring(string.length()) : string2.substring(string.length() + 1)).indexOf("/") != -1 && string2.length() > 0) {
            return string2.substring(0, string2.indexOf("/"));
        }
        return null;
    }

    public static URL getURLFromJarOrDir(String string) throws MalformedURLException {
        URL uRL = null;
        if (null == clientURL) {
            clientURL = userDir.toURI().toURL();
        }
        URL uRL2 = new URL(clientURL, string);
        try {
            File file = new File(uRL2.toURI());
            if (file.exists()) {
                uRL = uRL2;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.trace(uRISyntaxException);
        }
        if (null == uRL && (patchFeatureExists || patchPluginExists)) {
            uRL = CommStyleManager.getURLFromJar(string);
        }
        return uRL;
    }

    public static boolean isExist(String string) {
        try {
            return null != PluginSubsystemUtilities.getURLFromJarOrDir(string);
        }
        catch (MalformedURLException malformedURLException) {
            logger.trace(malformedURLException.getMessage(), malformedURLException);
            return false;
        }
    }

    public static void reinitPatch() {
        patchPluginExists = PluginSubsystemUtilities.isInPatch(PLUGIN_DIR);
        patchFeatureExists = PluginSubsystemUtilities.isInPatch(FEATURES_DIR);
    }

    public static String[] getLoadedPluginNames() {
        List<String> list = null;
        if (null == loadedPluginNames) {
            if (FrameworkCommandProcessor.getInstance().getUserLoadStyle() == FrameworkCommandProcessor.LoadStyle.application) {
                HashSet<String> hashSet = new HashSet<String>();
                List<String> list2 = StartupXMLReader.getNormalAndRequiredPluginList();
                hashSet.addAll(list2);
                List<String> list3 = StartupXMLReader.getPortalPlugins();
                if (null != list3) {
                    hashSet.addAll(list3);
                }
                list = new ArrayList<String>(hashSet);
            } else {
                list = SubsystemManager.getInstance().getLoadedSubsystemAllPluginList();
                if (SubsystemManager.getInstance().getClientLoadMode() == SubsystemManager.LoadMode.complex && null != list && (list.isEmpty() || list.size() <= 1)) {
                    list = StartupXMLReader.getNormalAndRequiredPluginList();
                }
            }
            if (null != list && 0 < list.size()) {
                loadedPluginNames = PluginSubsystemUtilities.getAllPluginNames(list);
            }
        }
        return loadedPluginNames;
    }

    public static void clearAndReinitialize() {
        if (null != loadedPluginNames) {
            loadedPluginNames = null;
        }
        if (startupPluginNames != null) {
            startupPluginNames.clear();
            startupPluginNames = null;
        }
    }

    public static List<String> getStartupPluginNamesList() {
        List<IStartupElement> list = StartupFactory.getStartupElements(1);
        if (null == list) {
            return startupPluginNames;
        }
        if (null == startupPluginNames) {
            startupPluginNames = new ArrayList<String>(10);
            for (IStartupElement iStartupElement : list) {
                try {
                    String string;
                    if (iStartupElement == null || null == (string = iStartupElement.getName())) continue;
                    startupPluginNames.add(string);
                }
                catch (Throwable throwable) {
                    logger.error(throwable);
                }
            }
        }
        return startupPluginNames;
    }

    public static boolean needsToCheckPatchPluginOrFeature() {
        String string = System.getProperty("user.dir") + "/patch";
        File file = new File(string);
        return PluginSubsystemUtilities.searchURL(file);
    }

    private static boolean searchURL(File file) {
        if (null != file) {
            JarFilter jarFilter;
            File[] fileArray;
            return file.exists() && (fileArray = file.listFiles(jarFilter = new JarFilter())).length != 0;
        }
        return false;
    }

    static class JarFilter
    implements FileFilter {
        JarFilter() {
        }

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".jar");
        }
    }
}

